<?php
/**
 * @author : Jegtheme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Theme JNews Option
 */
class JNews_Review_Metabox {
	/**
	 * @var JNews_Review_Metabox
	 */
	private static $instance;

	/**
	 * @return JNews_Review_Metabox
	 */
	public static function getInstance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}
		return static::$instance;
	}

	/**
	 * Method __construct
	 *
	 * @return void
	 */
	private function __construct() {
		\JNews\MetaboxBuilder::set_meta( $this->register_metabox() );
	}

	/**
	 * Method register_metabox
	 *
	 * @param array $metabox $metabox metabox data.
	 *
	 * @return array
	 */
	public function register_metabox() {
		return  array(
			'id'         => 'jnews_review',
			'post_types' => array( 'post' ),
			'label'      => 'Review Setting',
			'priority'   => 'high',
			'mode'		 => 'extract',
			'icon'       => 'ReviewSvg',
			'fields'     => array(
				array(
					'type'   => 'tab',
					'id'     => 'review_setting',
					'label'  => esc_html__( 'Review Setting', 'jnews' ),
					'fields' => array(
						array(
							'type'        => 'jnews-toggle',
							'id'          => 'enable_review',
							'label'       => esc_html__( 'Enable Review', 'jnews' ),
							'description' => esc_html__( 'Check this option to enable review on this post.', 'jnews' ),
						),
						array(
							'type'        => 'jnews-select',
							'id'          => 'type',
							'label'       => esc_html__( 'Review Type', 'jnews' ),
							'description' => esc_html__( 'Choose your review type.', 'jnews' ),
							'default'     => 'percentage',
							'choices'     => array(
								array(
									'value' => 'point',
									'label' => esc_html__( 'Point', 'jnews' ),
								),
								array(
									'value' => 'star',
									'label' => esc_html__( 'Star', 'jnews' ),
								),
								array(
									'value' => 'percentage',
									'label' => esc_html__( 'Percentage', 'jnews' ),
								),
							),
						),
						array(
							'type'        => 'jnews-text',
							'id'          => 'name',
							'label'       => esc_html__( 'Review Product Name', 'jnews' ),
							'description' => esc_html__( 'Your review product name.', 'jnews' ),
						),

						array(
							'type'        => 'jnews-textarea',
							'id'          => 'summary',
							'label'       => esc_html__( 'Review Summary', 'jnews' ),
							'description' => esc_html__( 'Insert your review summary.', 'jnews' ),
						),

						array(
							'type'        => 'jnews-text',
							'id'          => 'brand',
							'label'       => esc_html__( 'Brand Name', 'jnews' ),
							'description' => esc_html__( 'Insert the brand of the product.', 'jnews' ),
						),

						array(
							'type'        => 'jnews-text',
							'id'          => 'sku',
							'label'       => esc_html__( 'SKU', 'jnews' ),
							'description' => esc_html__( 'Insert the SKU of the product.', 'jnews' ),
						),
					),
				),
				array(
					'type'   => 'tab',
					'id'     => 'review_pros_cons',
					'label'  => esc_html__( 'Review Pros and Cons', 'jnews' ),
					'fields' => array(
						array(
							'type'      => 'jnews-repeater',
							'repeating' => true,
							'sortable'  => true,
							'id'        => 'good',
							'label'     => esc_html__( 'What\'s good about this product', 'jnews' ),
							'fields'    => array(
								'good_text' => array(
									'type'        => 'jnews-text',
									'label'       => esc_html__( 'Good', 'jnews' ),
									'description' => esc_html__( 'Insert the good thing about this product.', 'jnews' ),
								),
							),
						),

						array(
							'type'      => 'jnews-repeater',
							'repeating' => true,
							'sortable'  => true,
							'id'        => 'bad',
							'label'     => esc_html__( 'What\'s bad about this product', 'jnews' ),
							'fields'    => array(
								'bad_text' => array(
									'type'        => 'jnews-text',
									'label'       => esc_html__( 'Bad', 'jnews' ),
									'description' => esc_html__( 'Insert the bad thing about this product.', 'jnews' ),
								),
							),
						),

					),
				),
				array(
					'type'   => 'tab',
					'id'     => 'review_rating',
					'label'  => esc_html__( 'Review Rating', 'jnews' ),
					'fields' => array(

						array(
							'type'        => 'jnews-toggle',
							'id'          => 'score_override',
							'label'       => esc_html__( 'Override Score', 'jnews' ),
							'description' => esc_html__( 'Check this option to override score instead using average score on this post.', 'jnews' ),
						),

						array(
							'type'        => 'jnews-text',
							'id'          => 'override_value',
							'label'       => esc_html__( 'Override value', 'jnews' ),
							'description' => esc_html__( 'Insert override value for the review score.', 'jnews' ),
							'dependency'  => array(
								array(
									'field'    => 'score_override',
									'operator' => '==',
									'value'    => '1',
								),
							),
						),

						array(
							'type'      => 'jnews-repeater',
							'repeating' => true,
							'sortable'  => true,
							'id'        => 'rating',
							'label'     => esc_html__( 'Review Rating', 'jnews' ),
							'fields'    => array(
								'rating_text'   => array(
									'type'        => 'jnews-text',
									'label'       => esc_html__( 'Rating Text', 'jnews' ),
									'description' => esc_html__( 'Insert text for rating label.', 'jnews' ),
								),
								'rating_number' => array(
									'type'        => 'jnews-slider',
									'label'       => esc_html__( 'Rating Number', 'jnews' ),
									'description' => esc_html__( 'Set rating value.', 'jnews' ),
									'choices'     => array(
										'min'  => '1',
										'max'  => '10',
										'step' => '1',
									),
									'min'         => '1',
									'max'         => '10',
									'step'        => '1',
									'default'     => '10',
								),
							),
						),
					),
				),
				array(
					'type'   => 'tab',
					'id'     => 'review_price',
					'label'  => esc_html__( 'Product Price', 'jnews' ),
					'fields' => array(
						array(
							'type'      => 'jnews-repeater',
							'repeating' => true,
							'sortable'  => true,
							'id'        => 'price',
							'label'     => esc_html__( 'This Product Price', 'jnews' ),
							'fields'    => array(
								'shop'  => array(
									'type'         => 'jnews-text',
									'label'        => esc_html__( 'Where to Buy', 'jnews' ),
									'description'  => esc_html__( 'Ex : Amazon, Ebay.', 'jnews' ),
									'attach_title' => true,
								),
								'price' => array(
									'type'         => 'jnews-text',
									'label'        => esc_html__( 'Price', 'jnews' ),
									'description'  => esc_html__( 'Insert product price.', 'jnews' ),
									'attach_title' => true,
								),
								'link'  => array(
									'type'        => 'jnews-url',
									'label'       => esc_html__( 'Shop Link', 'jnews' ),
									'description' => esc_html__( 'You can also insert your referral link.', 'jnews' ),
								),
								'icon'  => array(
									'type'        => 'jnews-image',
									'label'       => esc_html__( 'Shop Logo Icon', 'jnews' ),
									'description' => esc_html__( 'Upload this shop logo / icon 16x16 pixel', 'jnews' ),
								),
							),
						),
					),
				),
			 ),
		);
	}
}
