<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;  // Exit if accessed directly.
}

$config = array(
	'widgets'            => array(
		'is_active' => false,
		'elements'  => array(
			'general-elements'   => array(
				'title'     => 'General Widgets',
				'is_active' => false,
				'elements'  => array(
					'image-box'            => array(
						'label'        => 'Image Box',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'setup'        => array( 'basic' ),
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'image card',
							'image with text',
							'image caption box',
							'photo box',
							'picture with title',
							'media box widget',
							'image overlay text',
							'image content block',
							'image showcase',
							'image description section',
						),
						'order'        => 1,
						'icon'         => 'wcf-icon-Image-Box',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-image-box',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/image-box/',
						'youtube_url'  => '',
						'description'  => 'Create graceful image sections with animations, refined content placement, and thoughtful design.',
					),
					'image-box-slider'     => array(
						'label'        => 'Image Box Slider',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'image slider',
							'image carousel',
							'photo slider',
							'picture slideshow',
							'media slider widget',
							'rotating images',
							'gallery slider',
							'image showcase carousel',
							'product image slider',
							'scrolling image banner',
						),
						'order'        => 2,
						'icon'         => 'wcf-icon-Image-Box-Slider',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-image-box-slider',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/image-box-slider/',
						'youtube_url'  => '',
						'description'  => 'Craft graceful image sliders with custom styles, animations, and smooth transitions for a polished presentation.',
					),
					'image-hotspot'        => array(
						'label'        => 'Image Hotspot',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'clickable image points',
							'image map',
							'image with hotspots',
							'interactive image',
							'image markers',
							'clickable photo spots',
							'hotspot widget',
							'image point links',
							'hover hotspots',
							'image click points',
						),
						'order'        => 94,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => 'https://animation-addons.com/widgets/image-hotspot/',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/image-hotspot/',
						'youtube_url'  => '',
						'description'  => '',
					),
					'social-icons'         => array(
						'label'        => 'Social Icons',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'social media icons',
							'social links',
							'social follow icons',
							'social network icons',
							'icon links',
							'social buttons',
							'connect icons',
							'share icons',
							'social bar',
							'social profile icons',
						),
						'order'        => 23,
						'icon'         => 'wcf-icon-Social-Icons',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-social-icons',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/social-icons/',
						'youtube_url'  => '',
						'description'  => 'Link your social accounts and customize the look to perfectly match your branding.',
					),
					'image'                => array(
						'label'        => 'Image',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'image embed',
							'image insert',
							'picture widget',
							'media element',
							'add photo',
							'display image',
							'single image block',
							'upload image',
							'media placeholder',
							'picture display',
						),
						'order'        => 3,
						'icon'         => 'wcf-icon-Image',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-image',
						'doc_url'      => 'https://animation-addons.com/docs/docs/general/image-widget/',
						'youtube_url'  => '',
						'description'  => 'Use this widget to display and animate images with precise control and styling options.',
					),
					'image-gallery'        => array(
						'label'        => 'Image Gallery',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'photo gallery',
							'image collection',
							'gallery widget',
							'picture album',
							'media gallery',
							'image showcase',
							'photo grid',
							'image lightbox',
							'gallery slider',
							'portfolio gallery',
						),
						'order'        => 25,
						'icon'         => 'wcf-icon-Image-Gallery',
						'demo_url'     => 'https://animation-addons.com/widgets/image-gallery-widget',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/image-gallery/',
						'youtube_url'  => '',
						'description'  => 'Create an engaging image gallery that fits perfectly with your site’s design and style.',
					),
					'text-hover-image'     => array(
						'label'        => 'Text Hover Image',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'image on hover',
							'hover reveal image',
							'text to image effect',
							'hover image overlay',
							'mouseover image',
							'hover transition',
							'text hover effect',
							'hover to show picture',
							'interactive image hover',
							'hover reveal photo',
						),
						'order'        => 11,
						'icon'         => 'wcf-icon-Text-Hover-Image',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-text-hover-image',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/text-hover-image/',
						'youtube_url'  => '',
						'description'  => 'Hover over text and reveal images for an interactive, engaging visual surprise!',
					),
					'brand-slider'         => array(
						'label'        => 'Brand Slider',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'logo carousel',
							'brand showcase',
							'partner logo slider',
							'client logo slider',
							'sponsor logos',
							'logo scrolling',
							'brand carousel',
							'company logos',
							'rotating brand logos',
							'logo showcase slider',
						),
						'order'        => 13,
						'icon'         => 'wcf-icon-Brand-Slider',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-brand-slider',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/brand-slider/',
						'youtube_url'  => '',
						'description'  => 'Boost credibility and visibility by highlighting trusted logos with a smooth, auto-scrolling slider.',
					),
					'counter'              => array(
						'label'        => 'Counter',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'number counter',
							'animated counter',
							'stats counter',
							'milestone counter',
							'counting numbers',
							'fun facts counter',
							'counter animation',
							'numeric counter',
							'counter up',
							'number animation',
						),
						'order'        => 28,
						'icon'         => 'wcf-icon-Counter',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-counter',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/counter/',
						'youtube_url'  => '',
						'description'  => 'Impress visitors with live stats and milestones using fully animated number counters.',
					),
					'icon-box'             => array(
						'label'        => 'Icon Box',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'icon with text',
							'feature box',
							'service icon box',
							'icon title description',
							'icon content block',
							'info box',
							'icon highlight',
							'icon description widget',
							'icon showcase',
							'icon text block',
						),
						'order'        => 12,
						'icon'         => 'wcf-icon-Icon-Box',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-icon-box',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/icon-box/',
						'youtube_url'  => '',
						'description'  => 'Refine your content presentation with flexible icon styling, typography, and layout options.',
					),
					'testimonial'          => array(
						'label'        => 'Testimonial',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'testimonial block',
							'client review',
							'customer feedback',
							'testimonial section',
							'testimonial slider',
							'review widget',
							'client comment',
							'customer opinion',
							'feedback carousel',
							'testimonial display',
						),
						'order'        => 40,
						'icon'         => 'wcf-icon-Testimonial',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-testimonial',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/testimonial/',
						'youtube_url'  => '',
						'description'  => 'Share real stories and success quotes using animated testimonial sliders and flexible content settings.',
					),
					'testimonial2'         => array(
						'label'        => 'Classic Testimonial',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'simple testimonial',
							'basic testimonial widget',
							'client review section',
							'traditional testimonial',
							'feedback block',
							'customer opinion',
							'classic review slider',
							'client comment block',
							'basic testimonial slider',
							'review display',
						),
						'order'        => 57,
						'icon'         => 'wcf-icon-Testimonial-2',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-classic-testimonial',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/classic-testimonial/',
						'youtube_url'  => '',
						'description'  => 'Showcase real stories and client praise with a sleek, responsive testimonial carousel.',
					),
					'testimonial3'         => array(
						'label'        => 'Modern Testimonial',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'testimonial slider',
							'client feedback',
							'customer review',
							'testimonial showcase',
							'modern testimonial design',
							'testimonial carousel',
							'review block',
							'client testimonial section',
							'stylish testimonials',
							'feedback widget',
						),
						'order'        => 31,
						'icon'         => 'wcf-icon-Testimonial-3',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-modern-testimonial',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/modern-testimonial/',
						'youtube_url'  => '',
						'description'  => 'Highlight customer feedback with modern layouts, smooth sliders, and customizable design elements.',
					),
					'advanced-testimonial' => array(
						'label'        => 'Advanced Testimonial',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'testimonial animation',
							'interactive testimonial',
							'advanced review widget',
							'animated client feedback',
							'testimonial effects',
							'customer opinion slider',
							'creative testimonial block',
							'review animation',
							'testimonial filter',
							'stylish feedback section',
						),
						'order'        => 36,
						'icon'         => 'wcf-icon-Testimonial-3',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-advanced-testimonial',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Create a stunning, responsive testimonial section with smooth transitions and customization options.',
					),
					'button'               => array(
						'label'        => 'Button',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'clickable button',
							'call-to-action button',
							'cta widget',
							'animated button',
							'hover button effect',
							'custom button',
							'link button',
							'stylish button',
							'website button',
							'action button widget',
						),
						'order'        => 17,
						'icon'         => 'wcf-icon-Button',
						'demo_url'     => 'https://animation-addons.com/aae-button',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/button/',
						'youtube_url'  => '',
						'description'  => 'Create bold, clickable buttons with text, icons, alignment, and hover animation options.',
					),
					'button-pro'           => array(
						'label'        => 'Advanced Button',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'animated cta button',
							'custom button design',
							'stylish button',
							'hover button animation',
							'advanced link button',
							'gradient button',
							'3d button effect',
							'icon button',
							'creative button',
							'clickable cta widget',
						),
						'order'        => 29,
						'icon'         => 'wcf-icon-Button-Pro',
						'demo_url'     => 'https://animation-addons.com/aae-advanced-button',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/advanced-button/',
						'youtube_url'  => '',
						'description'  => 'Advanced Button lets you tweak padding, border radius, typography, and interactive hover styles',
					),
					'image-compare'        => array(
						'label'        => 'Image Comparison',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'before and after image',
							'image compare slider',
							'photo comparison',
							'image difference',
							'compare two images',
							'image overlay compare',
							'side by side image comparison',
							'image compare widget',
							'visual comparison',
							'before after slider',
						),
						'order'        => 51,
						'icon'         => 'wcf-icon-Image-Compare',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-image-comparison',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/image-comparison/',
						'youtube_url'  => '',
						'description'  => 'This widget renders two images with synchronized alignment, interactive drag, and responsive customization options.',
					),
					'progressbar'          => array(
						'label'        => 'Progress Bar',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'animated progress bar',
							'skill bar',
							'progress indicator',
							'percentage bar',
							'loading bar',
							'progress animation',
							'goal bar',
							'progress line',
							'completion bar',
							'progress tracker',
						),
						'order'        => 38,
						'icon'         => 'wcf-icon-Progress-Bar',
						'demo_url'     => 'https://animation-addons.com/aae-progress-bar',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/progress-bar/',
						'youtube_url'  => '',
						'description'  => 'Add a clean progress bar that reflects achievements using smooth transitions and clear text labels.',
					),
					'team'                 => array(
						'label'        => 'Team',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'team members',
							'staff showcase',
							'employee profiles',
							'team profile widget',
							'meet the team',
							'staff directory',
							'team photo gallery',
							'team bio section',
							'company team display',
							'team showcase slider',
						),
						'order'        => 48,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Team',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-team',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/team/',
						'youtube_url'  => '',
						'description'  => 'Help visitors meet your team with photos, job titles, and clickable social media icons.',
					),
					'notification'         => array(
						'label'        => 'Notification',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'alert widget',
							'notification bar',
							'message alert',
							'announcement bar',
							'site notification',
							'popup alert',
							'info bar',
							'web notification',
							'banner alert',
							'update notification',
						),
						'order'        => 58,
						'icon'         => 'wcf-icon-Notification',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-notification',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Inform users instantly with attention-grabbing notifications, designed to blend seamlessly with your site.',
					),
					'one-page-nav'         => array(
						'label'        => 'One Page Nav',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'single page menu',
							'one page scroll',
							'smooth scroll navigation',
							'one page menu bar',
							'scroll navigation',
							'one page anchor menu',
							'scrolling links',
							'one page website menu',
							'navigation dots',
							'one page header',
						),
						'order'        => 32,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-One-Page-Nav',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-one-page-nav',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/one-page-nav/',
						'youtube_url'  => '',
						'description'  => 'Hover to preview section names and smoothly swipe between sections on your one-page layout.',
					),
					'timeline'             => array(
						'label'        => 'Timeline',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'vertical timeline',
							'horizontal timeline',
							'event timeline',
							'history timeline',
							'animated timeline',
							'project timeline',
							'story timeline',
							'timeline with icons',
							'content timeline',
							'interactive timeline',
						),
						'order'        => 18,
						'icon'         => 'wcf-icon-Timeline',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-timeline',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/timeline/',
						'youtube_url'  => '',
						'description'  => 'Use animated timelines to present events or project stages in a clear, organized progression.',
					),
					'tabs'                 => array(
						'label'        => 'Tabs',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'tabbed content',
							'tabbed navigation',
							'content tabs',
							'tab menu',
							'tabbed interface',
							'tabs section',
							'tab layout',
							'tab switching',
							'tab design',
							'tabbed content block',
						),
						'order'        => 27,
						'icon'         => 'wcf-icon-Tabs',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-tabs',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/tabs/',
						'youtube_url'  => '',
						'description'  => 'Customize your tabs with various icons, titles, and styles for a tailored design approach.',
					),
					'services-tab'         => array(
						'label'        => 'Services Tabs',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'service showcase tabs',
							'service categories',
							'tabbed services',
							'services section',
							'services navigation',
							'service details tabs',
							'services list',
							'services content block',
							'service info tabs',
							'services display',
						),
						'order'        => 30,
						'icon'         => 'wcf-icon-Services-Tabs',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-services-tabs',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/services-tabs/',
						'youtube_url'  => '',
						'description'  => 'Display your services in an attractive, tabbed layout that keeps your visitors engaged.',
					),
					'floating-elements'    => array(
						'label'        => 'Floating Elements',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'floating animation',
							'float effect',
							'hover floating element',
							'floating object',
							'animated float',
							'float on scroll',
							'moving floating element',
							'floating icon',
							'floating image',
							'floating graphic animation',
						),
						'order'        => 15,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Floating-Elements',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-floating-elements',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/floating-elements/',
						'youtube_url'  => '',
						'description'  => 'Add floating items to your page, such as buttons or icons, that stay in view as users scroll',
					),
					'event-slider'         => array(
						'label'        => 'Event Slider',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'event showcase',
							'event carousel',
							'upcoming events slider',
							'event gallery',
							'event promotion slider',
							'event scrolling banner',
							'event highlight slider',
							'event photos slider',
							'events showcase carousel',
							'event announcement slider',
						),
						'order'        => 35,
						'icon'         => 'wcf-icon-Event-Slider',
						'demo_url'     => 'https://animation-addons.com/aae-event-slider',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/event-slider/',
						'youtube_url'  => '',
						'description'  => 'Organize your events beautifully with image, date, and text in a refined carousel format.',
					),
					'content-slider'       => array(
						'label'        => 'Content Slider',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'content carousel',
							'text slider',
							'image and text slider',
							'content rotator',
							'content showcase',
							'sliding content block',
							'featured content slider',
							'content banner',
							'rotating content',
							'dynamic content slider',
						),
						'order'        => 24,
						'icon'         => 'wcf-icon-Content-Slider',
						'demo_url'     => 'https://animation-addons.com/aae-content-slider',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/content-slider/',
						'youtube_url'  => '',
						'description'  => 'Showcase dynamic content in a responsive slider with full layout and animation.',
					),
					'countdown'            => array(
						'label'        => 'Countdown',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'countdown timer',
							'countdown clock',
							'event countdown',
							'countdown animation',
							'timer widget',
							'launch countdown',
							'sale countdown',
							'countdown display',
							'deadline countdown',
							'time left widget',
						),
						'order'        => 59,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Countdown',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-countdown/',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/countdown/',
						'youtube_url'  => '',
						'description'  => 'Create anticipation for your next event by adding a friendly and customizable countdown.',
					),
					'clickdrop'            => array(
						'label'        => 'Clickdrop',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'click dropdown',
							'click to reveal',
							'dropdown on click',
							'click menu',
							'click toggle',
							'click trigger dropdown',
							'expandable on click',
							'click content reveal',
							'click show hide',
							'click popup dropdown',
						),
						'order'        => 95,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Countdown',
						'demo_url'     => '',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Create anticipation for your next event by adding a friendly and customizable countdown.',
					),
				),
			),
			'animation-elements' => array(
				'title'     => 'Animations',
				'is_active' => false,
				'elements'  => array(
					'typewriter'       => array(
						'label'        => 'Typewriter',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'typewriter effect',
							'typing animation',
							'animated typing text',
							'text typing effect',
							'typing heading',
							'auto typing',
							'typewriter heading',
							'animated text typing',
							'typing title effect',
							'dynamic typing animation',
						),
						'order'        => 14,
						'icon'         => 'wcf-icon-Typewriter',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-typewriter/',
						'doc_url'      => 'https://animation-addons.com/docs/animations-widgets/typewriter/',
						'youtube_url'  => '',
						'description'  => 'Bring back the charm of typing, minus the clunky keys and ink ribbons.',
					),
					'animated-heading' => array(
						'label'        => 'Animated Heading',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'animated heading',
							'heading animation',
							'moving title',
							'headline effect',
							'scrolling heading',
							'fade-in heading',
							'dynamic title',
							'heading reveal',
							'stylish heading',
							'creative title animation',
						),
						'order'        => 6,
						'icon'         => 'wcf-icon-Animated-Heading',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-animated-heading/',
						'doc_url'      => 'https://animation-addons.com/docs/animations-widgets/animated-heading/',
						'youtube_url'  => '',
						'description'  => 'Add stunning movement to your headlines and capture attention in just a second.',
					),
					'animated-title'   => array(
						'label'        => 'Animated Title',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'title animation',
							'moving heading',
							'animated headline',
							'sliding title',
							'title reveal',
							'glowing title',
							'creative heading',
							'title transition',
							'animated text heading',
							'stylish title effect',
						),
						'order'        => 5,
						'icon'         => 'wcf-icon-Animated-Title',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-animated-title',
						'doc_url'      => 'https://animation-addons.com/docs/animations-widgets/animated-title/',
						'youtube_url'  => '',
						'description'  => 'Use this widget to animate titles by character, word, or full text block.',
					),
					'animated-text'    => array(
						'label'        => 'Animated Text',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'text animation',
							'moving text',
							'scrolling text',
							'typewriter effect',
							'text transition',
							'animated words',
							'text reveal',
							'kinetic typography',
							'bouncing text',
							'dynamic text effect',
						),
						'order'        => 4,
						'icon'         => 'wcf-icon-Animated-Text',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-animated-text',
						'doc_url'      => 'https://animation-addons.com/docs/animations-widgets/animated-text/',
						'youtube_url'  => '',
						'description'  => 'Explore text animation styles and transform static text into dynamic, engaging visual content.',
					),
					'lottie'           => array(
						'label'        => 'Lottie',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'lottie animation',
							'json animation',
							'lottie file',
							'animated icon',
							'lottie graphics',
							'vector animation',
							'lottie player',
							'web lottie animation',
							'lottie integration',
							'lottie motion graphics',
						),
						'order'        => 22,
						'icon'         => 'wcf-icon-Lottie',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-lottie',
						'doc_url'      => 'https://animation-addons.com/docs/animations-widgets/lottie/',
						'youtube_url'  => '',
						'description'  => 'Grab attention with elegant Lottie motion effects that boost engagement and brand appeal instantly.',
					),
					'draw-svg'         => array(
						'label'        => 'GSAP DrawSvg',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'svg line animation',
							'draw svg path',
							'gsap svg animation',
							'svg stroke animation',
							'svg outline effect',
							'svg drawing animation',
							'gsap draw path',
							'svg handwriting effect',
							'animate svg lines',
							'svg path reveal',
						),
						'order'        => 16,
						'icon'         => 'wcf-icon-GSAP-DrawSvg',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-gsap-drawsvg/',
						'doc_url'      => 'https://animation-addons.com/docs/animations-widgets/gsap-drawsvg/',
						'youtube_url'  => '',
						'description'  => 'Animate SVG paths with precision using GSAP’s smooth drawing effect, enhancing your web visuals.',
					),
					'cube-scroll-reveal'         => array(
						'label'        => 'Cube Scroll Reveal',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords' => [
							"cube scroll reveal",
							"scroll reveal",
							"cube",
							"reveal animation",
						],
						'order' => 16,
						'icon'         => 'wcf-icon-GSAP-DrawSvg',
						'demo_url'     => '',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Cube scroll reveal.',
					),
				),
			),
			'hf-elements'        => array(
				'title'     => 'Header & Footer Widgets',
				'is_active' => false,
				'elements'  => array(
					'animated-offcanvas' => array(
						'label'        => 'Animated Off-Canvas',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'off-canvas menu',
							'hidden menu',
							'slide-out panel',
							'sidebar menu',
							'mobile menu drawer',
							'offscreen navigation',
							'drawer menu',
							'slide-in widget',
							'off-canvas sidebar',
							'hidden content panel',
						),
						'order'        => 10,
						'icon'         => 'wcf-icon-Animated-Off-Canvas',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-animated-off-canvas/',
						'doc_url'      => 'https://animation-addons.com/docs/header-footer-widgets/animated-off-canvas/',
						'youtube_url'  => '',
						'description'  => 'Captivate your audience with stunning off-canvas reveals that keep users engaged longer on site!',
					),
					'site-logo'          => array(
						'label'        => 'Site Logo',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'website logo',
							'brand logo',
							'header logo',
							'logo image',
							'company logo',
							'site identity',
							'favicon logo',
							'logo display',
							'website branding',
							'logo element',
						),
						'order'        => 37,
						'icon'         => 'wcf-icon-Site-Logo',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-site-logo',
						'doc_url'      => 'https://animation-addons.com/docs/header-footer-widgets/site-logo/',
						'youtube_url'  => '',
						'description'  => 'Add your website logo with full customization options here and make your site instantly recognizable.',
					),
					'nav-menu'           => array(
						'label'        => 'Nav Menu',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'menu bar',
							'site menu',
							'website navigation',
							'nav menu',
							'page menu',
							'top menu',
							'responsive menu',
							'menu links',
							'website header menu',
							'navigation bar widget',
						),
						'order'        => 7,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Nav-Menu',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-nav-menu',
						'doc_url'      => 'https://animation-addons.com/docs/header-footer-widgets/nav-menu/',
						'youtube_url'  => '',
						'description'  => 'Enhance your site’s usability by creating responsive, stylish, and fully customizable navigation menus.',
					),
					'mega-menu'          => array(
						'label'        => 'Mega Menu',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => true,
						'keywords'     => array(
							'mega menu',
							'dropdown mega menu',
							'large navigation menu',
							'multi-column menu',
							'advanced menu',
							'full-width menu',
							'category menu',
							'ecommerce menu',
							'navigation mega menu',
							'expanded dropdown menu',
						),
						'order'        => 8,
						'icon'         => 'wcf-icon-Nav-Menu',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-nav-menu',
						'doc_url'      => 'https://animation-addons.com/docs/header-footer-widgets/nav-menu/',
						'youtube_url'  => '',
						'description'  => 'Enhance your site’s usability by creating responsive, stylish, and fully customizable navigation menus.',
					),
				),
			),
			'slider'             => array(
				'title'     => 'Slider',
				'is_active' => false,
				'elements'  => array(
					'posts-slider'         => array(
						'label'        => 'Posts Slider',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'blog post slider',
							'article carousel',
							'news slider',
							'post showcase',
							'post carousel',
							'recent posts slider',
							'featured posts slider',
							'blog slider',
							'post scrolling banner',
							'content post slider',
						),
						'order'        => 43,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Post-Slider',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-posts-slider',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/posts-slider/',
						'youtube_url'  => '',
						'description'  => 'Create a dynamic, engaging post slider with custom settings for a polished website experience.',
					),
					'breaking-news-slider' => array(
						'label'        => 'Breaking News Slider',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'news ticker',
							'latest news slider',
							'breaking news banner',
							'live news carousel',
							'scrolling news',
							'headline slider',
							'news flash slider',
							'news update banner',
							'top news slider',
							'news highlight slider',
						),
						'order'        => 45,
						'icon'         => 'wcf-icon-Brand-Slider',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-breaking-news-slider',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/breaking-news-slider/',
						'youtube_url'  => '',
						'description'  => 'Show updates in a sleek, customizable slider with dynamic animation effects.',
					),
					'category-slider'      => array(
						'label'        => 'Category Slider',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'category carousel',
							'category showcase',
							'product category slider',
							'category banner slider',
							'category image slider',
							'category scrolling banner',
							'ecommerce category slider',
							'category icon slider',
							'category gallery slider',
							'category section slider',
						),
						'order'        => 49,
						'icon'         => 'wcf-icon-Content-Slider',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-category-slider',
						'doc_url'      => 'https://animation-addons.com/docs/slider-widgets/category-slider/',
						'youtube_url'  => '',
						'description'  => 'Create an interactive category display with a stylish slider for improved user navigation.',
					),
					'video-box-slider'     => array(
						'label'        => 'Video Box Slider',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => true,
						'is_upcoming'  => false,
						'keywords'     => array(
							'ideo slider',
							'video carousel',
							'video showcase',
							'video gallery slider',
							'embedded video slider',
							'video playlist slider',
							'video showcase carousel',
							'video scrolling banner',
							'featured videos slider',
							'video content slider',
						),
						'order'        => 46,
						'icon'         => 'wcf-icon-Video-Box-Slider',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-video-box-slider',
						'doc_url'      => 'https://animation-addons.com/docs/slider-widgets/video-box-slider/',
						'youtube_url'  => '',
						'description'  => 'Create a visually appealing video slider that perfectly fits your site’s design with this widget.',
					),
					'filterable-slider'    => array(
						'label'        => 'Filterable Slider',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'filtered carousel',
							'filterable gallery slider',
							'category slider',
							'filter slider',
							'filtered product slider',
							'image filter slider',
							'portfolio filter slider',
							'filter content slider',
							'gallery with filters',
							'filtered showcase slider',
						),
						'order'        => 42,
						'icon'         => 'wcf-icon-Filterable-Slider',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-filterable-slider',
						'doc_url'      => 'https://animation-addons.com/docs/slider-widgets/filterable-slider/',
						'youtube_url'  => '',
						'description'  => 'Organize content effortlessly with a filterable slider that’s easy to customize and navigate.',
					),
				),
			),
			'dynamic-elements'   => array(
				'title'     => 'Dynamic Widgets',
				'is_active' => false,
				'elements'  => array(
					'post-title'         => array(
						'label'        => 'Post Title',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'article title',
							'blog heading',
							'post heading',
							'post name',
							'post headline',
							'title of post',
							'content title',
							'post caption',
							'blog title text',
							'post heading element',
						),
						'order'        => 86,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Post-Title',
						'demo_url'     => 'https://animation-addons.com/docs/dynamic-widgets/post-title',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/post-title/',
						'youtube_url'  => '',
						'description'  => 'Present your post titles with refined style, precise alignment, and fully customizable typography settings.',
					),
					'post-feature-image' => array(
						'label'        => 'Post Featured Image',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'blog featured image',
							'post thumbnail',
							'article image',
							'post cover image',
							'featured photo',
							'blog image header',
							'post banner image',
							'content thumbnail',
							'post main image',
							'featured picture',
						),
						'order'        => 87,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Post-Featured-Image',
						'demo_url'     => 'https://animation-addons.com/docs/dynamic-widgets/post-featured-image/',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/post-featured-image/',
						'youtube_url'  => '',
						'description'  => 'Customize the featured image of any post for a perfect fit across all device screens.',
					),
					'post-excerpt'       => array(
						'label'        => 'Post Excerpt',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'post summary',
							'article excerpt',
							'blog snippet',
							'content preview',
							'post intro text',
							'summary text',
							'blog preview',
							'post teaser',
							'content snippet',
							'short post description',
						),
						'order'        => 88,
						'icon'         => 'wcf-icon-Post-Excerpt',
						'demo_url'     => 'https://animation-addons.com/docs/dynamic-widgets/post-excerpt/',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/post-excerpt/',
						'youtube_url'  => '',
						'description'  => 'Use the Post Excerpt Widget to keep layouts clean and boost user engagement.',
					),
					'post-content'       => array(
						'label'        => 'Post Content',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'blog content',
							'article text',
							'post body',
							'post description',
							'content section',
							'post main content',
							'post text block',
							'blog article body',
							'written post content',
							'post paragraph text',
						),
						'order'        => 96,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Post-Content',
						'demo_url'     => '',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Showcase your blog’s latest posts with this widget, perfectly styled for Elementor.',
					),
					'post-comment'       => array(
						'label'        => 'Post Comments',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'comment section',
							'user comments',
							'blog discussion',
							'comment box',
							'article feedback',
							'leave a comment',
							'comment form',
							'post replies',
							'discussion thread',
							'comment widget',
						),
						'order'        => 97,
						'icon'         => 'wcf-icon-Post-Content',
						'demo_url'     => '',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Enable seamless comment integration, enhancing community interaction on your blog or articles.',
					),
					'post-reactions'     => array(
						'label'        => 'Post Reactions',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'reaction buttons',
							'like button',
							'emoji reactions',
							'post like dislike',
							'post rating',
							'user feedback buttons',
							'post vote',
							'quick reactions',
							'social reactions',
							'post emoji response',
						),
						'order'        => 63,
						'icon'         => 'wcf-icon-Post-Content',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-post-reactions/',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/post-reactions/',
						'youtube_url'  => '',
						'description'  => 'Customize reaction button styles and separator icons to seamlessly fit your website’s design.',
					),
					'post-meta-info'     => array(
						'label'        => 'Post Meta Info',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'post date',
							'post author',
							'blog meta',
							'article meta info',
							'post category',
							'post tags',
							'meta details',
							'blog post info',
							'post publish date',
							'post metadata',
						),
						'order'        => 89,
						'icon'         => 'wcf-icon-Post-Meta-Info',
						'demo_url'     => 'https://animation-addons.com/docs/dynamic-widgets/post-meta-info/',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/post-meta-info/',
						'youtube_url'  => '',
						'description'  => 'Use Post Meta Info to keep your readers informed without cluttering your beautiful layout.',
					),
					'post-paginate'      => array(
						'label'        => 'Post Pagination',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'post navigation',
							'next previous posts',
							'numbered pagination',
							'blog pagination',
							'post page links',
							'paginated posts',
							'content navigation',
							'post navigation links',
							'post page numbers',
							'pagination widget',
						),
						'order'        => 90,
						'icon'         => 'wcf-icon-Post-Paginate',
						'demo_url'     => 'https://animation-addons.com/docs/dynamic-widgets/post-pagination/',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/post-pagination/',
						'youtube_url'  => '',
						'description'  => 'Customize the pagination with icons, text, and animations to create a unique navigation experience.',
					),
					'post-social-share'  => array(
						'label'        => 'Social Share',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'share buttons',
							'social sharing',
							'share post',
							'share to social media',
							'share widget',
							'social icons share',
							'content share',
							'social media sharing',
							'share blog post',
							'share article buttons',
						),
						'order'        => 91,
						'icon'         => 'wcf-icon-Post-Social-Share',
						'demo_url'     => 'https://animation-addons.com/docs/dynamic-widgets/social-share/',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/social-share/',
						'youtube_url'  => '',
						'description'  => 'Customize social share icons to match your design and encourage content sharing with ease.',
					),
					'posts'              => array(
						'label'        => 'Posts',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'blog post block',
							'post element',
							'post display',
							'post section',
							'post card',
							'article widget',
							'content post block',
							'post listing',
							'post showcase',
							'post snippet',
						),
						'order'        => 82,
						'icon'         => 'wcf-icon-Posts',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-posts',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/posts/',
						'youtube_url'  => '',
						'description'  => 'Create a dynamic blog section by customizing the layout, images, and post metadata display.',
					),
					'posts-pro'          => array(
						'label'        => 'Advanced Posts',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'advanced post listing',
							'dynamic post widget',
							'filtered posts',
							'advanced blog posts',
							'custom post display',
							'post grid advanced',
							'advanced article showcase',
							'featured advanced posts',
							'styled post widget',
							'enhanced post display',
						),
						'order'        => 83,
						'icon'         => 'wcf-icon-Posts-Pro',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-advanced-posts',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/advanced-posts/',
						'youtube_url'  => '',
						'description'  => 'Add the Advanced Posts Widget to your Elementor page to showcase blog posts with rich filters.',
					),
					'post-timeline'      => array(
						'label'        => 'Posts Timeline',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'blog timeline',
							'post history',
							'chronological posts',
							'article timeline',
							'news timeline',
							'content timeline',
							'story timeline',
							'timeline view posts',
							'post archive timeline',
							'date-based posts',
						),
						'order'        => 64,
						'icon'         => 'wcf-icon-Posts-Pro',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-posts-timeline/',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => '',
					),
					'posts-read-later'   => array(
						'label'        => 'Posts Read Later',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'save post',
							'bookmark post',
							'read later list',
							'saved articles',
							'post bookmark widget',
							'reading list',
							'saved news',
							'save content',
							'bookmark blog post',
							'read later button',
						),
						'order'        => 75,
						'icon'         => 'wcf-icon-Posts',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-posts-read-later/',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/posts-read-later/',
						'youtube_url'  => '',
						'description'  => 'Embed trending TikTok videos on your website to keep your content fresh and engaging.',
					),
					'video-story'        => array(
						'label'        => 'Video Story',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'video highlights',
							'story video',
							'vertical video',
							'social media story video',
							'video reels',
							'short video story',
							'video status',
							'quick video showcase',
							'mobile story video',
							'animated story video',
						),
						'order'        => 47,
						'icon'         => 'wcf-icon-Video-Box',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-video-story',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/video-story/',
						'youtube_url'  => '',
						'description'  => 'Share engaging video content with smooth transitions to tell your story effectively.',
					),
					'video-posts-tab'    => array(
						'label'        => 'Video Posts Tab',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'video tabs',
							'tabbed video posts',
							'video gallery tabs',
							'video showcase tabs',
							'video category tabs',
							'video playlist tabs',
							'tabbed video content',
							'video navigation tabs',
							'video section tabs',
							'video tab widget',
						),
						'order'        => 76,
						'icon'         => 'wcf-icon-Posts-Tab',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-posts-tabs',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/video-posts-tab/',
						'youtube_url'  => '',
						'description'  => 'Enhance your site with organized video posts displayed in engaging, user-friendly tabbed format.',
					),
					'posts-filter'       => array(
						'label'        => 'Filterable Posts',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'post filters',
							'category post filter',
							'filter blog posts',
							'filtered news',
							'post sorting',
							'blog filter widget',
							'content filter posts',
							'tagged post filter',
							'custom filter posts',
							'filter article list',
						),
						'order'        => 73,
						'icon'         => 'wcf-icon-Filterable-Posts',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-filterable-posts',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/filterable-posts/',
						'youtube_url'  => '',
						'description'  => 'Display posts in filterable categories, offering visitors a seamless navigation and content sorting experience.',
					),
					'post-rating-form'   => array(
						'label'        => 'Post Rating Form',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'star rating form',
							'feedback form',
							'post rating submission',
							'review form',
							'score form',
							'rate content form',
							'rating submission',
							'post feedback form',
							'product rating form',
							'star review form',
						),
						'order'        => 81,
						'icon'         => 'wcf-icon-Post-Rating',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-posts-rating-form',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Integrate a user-friendly post rating form to gather valuable feedback from your audience.',
					),
					'post-rating'        => array(
						'label'        => 'Post Rating',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'post rating widget',
							'rate post',
							'star rating',
							'post feedback',
							'rating system',
							'like post rating',
							'post score',
							'review rating',
							'vote post',
							'rating element',
						),
						'order'        => 74,
						'icon'         => 'wcf-icon-Post-Rating',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-post-rating',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Add an intuitive rating system to your posts, allowing users to share their opinions easily.',
					),
					'grid-hover-posts'   => array(
						'label'        => 'Grid Hover Posts',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'hover post effect',
							'post hover animation',
							'post reveal on hover',
							'hover blog posts',
							'interactive post hover',
							'hover news block',
							'post hover transition',
							'animated hover posts',
							'hover article preview',
							'hover card posts',
						),
						'order'        => 54,
						'icon'         => 'wcf-icon-Grid-Hover-Posts',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-hover-posts',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/grid-hover-posts/',
						'youtube_url'  => '',
						'description'  => 'Use the Grid Hover Posts Widget to display posts in a visually appealing, interactive grid.',
					),
					'category-showcase'  => array(
						'label'        => 'Category Showcase',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'category display',
							'category highlight',
							'category gallery',
							'featured categories',
							'product categories showcase',
							'category section',
							'category images',
							'category spotlight',
							'ecommerce categories',
							'category grid',
						),
						'order'        => 67,
						'icon'         => 'wcf-icon-Category-Showcase',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-category-showcase',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/category-showcase/',
						'youtube_url'  => '',
						'description'  => 'Category Showcase helps create a professional layout for showcasing your post categories.',
					),
					'banner-posts'       => array(
						'label'        => 'Banner Posts',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'post banner',
							'featured post banner',
							'blog banner',
							'news banner',
							'post highlight banner',
							'post showcase banner',
							'top posts banner',
							'article banner',
							'banner for posts',
							'visual post banner',
						),
						'order'        => 69,
						'icon'         => 'wcf-icon-Banner-Posts',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-banner-posts',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/banner-posts/',
						'youtube_url'  => '',
						'description'  => 'Use the Banner Posts Widget to add styled, customizable banners to elevate your post visibility.',
					),
					'current-date'       => array(
						'label'        => 'Current Date',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'date display',
							'today’s date',
							'live date widget',
							'show current date',
							'date element',
							'date info',
							'website date display',
							'dynamic date',
							'date and time widget',
							'page date',
						),
						'order'        => 68,
						'icon'         => 'wcf-icon-Current-Date',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-current-date',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/current-date-widget/',
						'youtube_url'  => '',
						'description'  => 'The Current Date Widget helps keep your content relevant by displaying the live date.',
					),
					'feature-posts'      => array(
						'label'        => 'Featured Posts',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'highlighted posts',
							'popular posts',
							'top articles',
							'trending posts',
							'selected posts',
							'featured content',
							'spotlight posts',
							'blog highlights',
							'featured news',
							'promoted posts',
						),
						'order'        => 72,
						'icon'         => 'wcf-icon-Featured-Posts',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-featured-posts',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/featured-posts/',
						'youtube_url'  => '',
						'description'  => 'Featured Posts allows you to showcase important posts with fully customizable design options.',
					),
					'archive-title'      => array(
						'label'        => 'Archive Title',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'archive heading',
							'archive page title',
							'category title',
							'archive section title',
							'archive heading text',
							'archive label',
							'archive name',
							'archive display title',
							'archive page heading',
							'archive category heading',
						),
						'order'        => 92,
						'icon'         => 'wcf-icon-Archive-Title',
						'demo_url'     => 'https://animation-addons.com/docs/dynamic-widgets/archive-title/',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/archive-title/',
						'youtube_url'  => '',
						'description'  => 'The Archive Title Widget lets you tailor archive page titles, improving clarity and user experience.',
					),
					'portfolio'          => array(
						'label'        => 'Portfolio',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => true,
						'is_upcoming'  => false,
						'keywords'     => array(
							'portfolio showcase',
							'project gallery',
							'work portfolio',
							'creative portfolio',
							'portfolio slider',
							'portfolio grid',
							'design showcase',
							'project display',
							'portfolio lightbox',
							'portfolio section',
						),
						'order'        => 84,
						'icon'         => 'wcf-icon-Portfolio',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-portfolio',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/portfolio/',
						'youtube_url'  => '',
						'description'  => 'Enhance your website by featuring your work with the Portfolio Widget’s flexible layout and design options.',
					),
					'search-form'        => array(
						'label'        => 'Search Form',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'search bar',
							'site search',
							'search box',
							'content search',
							'search input',
							'website search field',
							'page search',
							'keyword search bar',
							'search widget',
							'find content form',
						),
						'order'        => 70,
						'icon'         => 'wcf-icon-Search-Form',
						'demo_url'     => 'https://animation-addons.com/wcf-template/search-form',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/search-form/',
						'youtube_url'  => '',
						'description'  => 'Add a search form widget for users to efficiently locate content across your website.',
					),
					'search-query'       => array(
						'label'        => 'Search Query',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'search results',
							'query search',
							'keyword query',
							'search keyword',
							'user search term',
							'query box',
							'search input query',
							'content search query',
							'query results',
							'search request',
						),
						'order'        => 80,
						'icon'         => 'wcf-icon-Search-Query',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-search-query',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/search-query/',
						'youtube_url'  => '',
						'description'  => 'Create a more intuitive search experience by customizing the Search Query Widgets content and style.',
					),
					'search-no-result'   => array(
						'label'        => 'Search No Result',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'no search results',
							'search empty',
							'nothing found',
							'no results page',
							'zero results',
							'no content found',
							'search not found',
							'empty search result',
							'search error message',
							'no matches found',
						),
						'order'        => 93,
						'icon'         => 'wcf-icon-Search-No-Result',
						'demo_url'     => 'https://animation-addons.com/docs/dynamic-widgets/search-no-result/',
						'doc_url'      => 'https://animation-addons.com/docs/dynamic-widgets/search-no-result/',
						'youtube_url'  => '',
						'description'  => 'Customize the "no results" message with rich text, media, or links for better user direction.',
					),
					'live-events'        => array(
						'label'        => 'Live Events',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'live streaming',
							'real-time events',
							'live broadcast',
							'live webinar',
							'live event schedule',
							'live coverage',
							'online live event',
							'live session',
							'event live stream',
							'virtual live event',
						),
						'order'        => 66,
						'icon'         => 'wcf-icon-Search-No-Result',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-live-events/',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => '',
					),
				),
			),
			'form-elements'      => array(
				'title'     => 'Form Widgets',
				'is_active' => false,
				'elements'  => array(
					'contact-form-7'     => array(
						'label'        => 'Contact Form 7',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'contact form widget',
							'form 7 integration',
							'contact us form',
							'inquiry form',
							'cf7 widget',
							'feedback form',
							'support form',
							'message form',
							'email contact form',
							'online form widget',
						),
						'order'        => 52,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Contact-Form-7',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-contact-form-7',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/contact-form-7/',
						'youtube_url'  => '',
						'description'  => 'With the Contact Form 7 Widget, you can create secure, user-friendly forms for your site.',
					),
					'mailchimp'          => array(
						'label'        => 'Mailchimp',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'keywords'     => array(
							'mailchimp signup',
							'email subscription',
							'newsletter form',
							'subscribe form',
							'mailchimp integration',
							'email list widget',
							'subscription box',
							'email opt-in',
							'mailchimp automation',
							'signup widget',
						),
						'order'        => 85,
						'icon'         => 'wcf-icon-Mailchimp',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-mailchimp',
						'doc_url'      => 'https://animation-addons.com/docs/general-widgets/mailchimp/',
						'youtube_url'  => '',
						'description'  => 'Grow your email list effortlessly by adding and customizing Mailchimp forms with this widget.',
					),
					'advanced-mailchimp' => array(
						'label'        => 'Advanced Mailchimp',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => true,
						'is_upcoming'  => false,
						'keywords'     => array(
							'mailchimp integration',
							'email subscription',
							'newsletter signup',
							'advanced mailchimp form',
							'email list signup',
							'mailchimp automation',
							'subscribe widget',
							'mailchimp opt-in',
							'email marketing form',
							'signup form widget',
						),
						'order'        => 78,
						'icon'         => 'wcf-icon-Mailchimp',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-advanced-mailchimp',
						'doc_url'      => 'https://animation-addons.com/docs/form-widgets/advanced-mailchimp/',
						'youtube_url'  => '',
						'description'  => 'Easily integrate and customize Mailchimp sign-up forms for a seamless email list growth experience.',
					),
				),
			),
			'video-elements'     => array(
				'title'     => 'Video Widgets',
				'is_active' => false,
				'elements'  => array(
					'video-popup'      => array(
						'label'        => 'Video Popup',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => true,
						'is_upcoming'  => false,
						'keywords'     => array(
							'video lightbox',
							'popup video player',
							'video overlay',
							'video modal',
							'play video popup',
							'video launch window',
							'fullscreen video popup',
							'click to play video',
							'video in popup',
							'embedded popup video',
						),
						'order'        => 50,
						'setup'        => array( 'basic' ),
						'icon'         => 'wcf-icon-Video-Popup',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-video-popup',
						'doc_url'      => 'https://animation-addons.com/docs/video-widgets/video-popup/',
						'youtube_url'  => '',
						'description'  => 'Use the Video Popup Widget to display videos in popups, making content more engaging.',
					),
					'video-box'        => array(
						'label'        => 'Video Box',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => true,
						'is_upcoming'  => false,
						'keywords'     => array(
							'video embed',
							'video player box',
							'video content block',
							'featured video',
							'video showcase',
							'embedded video widget',
							'video display',
							'video highlight',
							'video container',
							'video section',
						),
						'order'        => 55,
						'icon'         => 'wcf-icon-Video-Box',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-video-box',
						'doc_url'      => 'https://animation-addons.com/docs/video-widgets/video-box/',
						'youtube_url'  => '',
						'description'  => 'Elevate your website’s look by incorporating a video box that blends seamlessly with your style.',
					),
					'video-mask'       => array(
						'label'        => 'Video Mask',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => true,
						'is_upcoming'  => false,
						'keywords'     => array(
							'masked video',
							'shape video mask',
							'video overlay shape',
							'custom video mask',
							'video frame effect',
							'masked video effect',
							'video inside shape',
							'creative video mask',
							'shape overlay video',
							'styled video mask',
						),
						'order'        => 56,
						'icon'         => 'wcf-icon-Video-Mask',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-video-mask',
						'doc_url'      => 'https://animation-addons.com/docs/video-widgets/video-mask/',
						'youtube_url'  => '',
						'description'  => 'Use the Video Mask Widget to bring artistic, interactive flair to your sites videos.',
					),
					'youtube-video'    => array(
						'label'        => 'Youtube Video',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => true,
						'is_upcoming'  => false,
						'keywords'     => array(
							'youtube embed',
							'youtube player',
							'youtube video block',
							'youtube content',
							'youtube showcase',
							'youtube gallery',
							'video from youtube',
							'youtube section',
							'youtube feed widget',
							'youtube integration',
						),
						'order'        => 77,
						'icon'         => 'wcf-icon-Video-Mask',
						'demo_url'     => 'https://animation-addons.com/widgets/youtube-video-widget-for-elementor/',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Use the Youtube Video Widget to bring artistic, interactive flair to your sites videos.',
					),
					'scrollable-video' => array(
						'label'        => 'Scrollable Video',
						'location'     => array(
							'cTab' => 'all',
						),
						'is_active'    => false,
						'is_pro'       => true,
						'is_extension' => true,
						'is_upcoming'  => false,
						'keywords'     => array(
							'video on scroll',
							'scroll play video',
							'scrolling video effect',
							'video scroll animation',
							'scroll-triggered video',
							'video while scrolling',
							'interactive scroll video',
							'video reveal on scroll',
							'video scroll effect',
							'video scroll playback',
						),
						'order'        => 19,
						'icon'         => 'wcf-icon-Video-Box',
						'demo_url'     => '',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => '',
					),
				),
			),
			'advanced-elements'  => array(
				'title'     => 'Advanced Widgets',
				'is_active' => false,
				'elements'  => array(
					'loop-grid'             => array(
						'label'        => 'Loop Grid',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => true,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'loop grid',
							'loop grid widget',
							'builder',
						),
						'order'        => 102,
						'icon'         => 'wcf-icon2-loop-grid',
						'demo_url'     => 'https://animation-addons.com/widgets/loop-grid/',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/loop-grid/',
						'youtube_url'  => '',
						'description'  => 'Create a grid of content with the Loop Grid Widget.',
					),
					'loop-carousel'         => array(
						'label'        => 'Loop Carousel',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => true,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'loop grid carousel',
							'carousel',
							'loop grid widget',
							'builder',
						),
						'order'        => 103,
						'icon'         => 'wcf-icon2-loop-carousel',
						'demo_url'     => 'https://animation-addons.com/widgets/loop-carosel/',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/loop-carosel/',
						'youtube_url'  => '',
						'description'  => 'Create a grid of content with the Loop Carosel Widget.',
					),
					'toggle-switcher'       => array(
						'label'        => 'Toggle Switch',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'switch button',
							'on off toggle',
							'toggle button',
							'settings switch',
							'light dark mode switch',
							'toggle control',
							'toggle widget',
							'yes no switch',
							'custom toggle',
							'switcher element',
						),
						'order'        => 44,
						'icon'         => 'wcf-icon-Toggle-Switch',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-toggle-switch',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/toggle-switch/',
						'youtube_url'  => '',
						'description'  => 'Customize the Toggle Switcher to fit your design and create seamless user interactions.',
					),
					'advance-pricing-table' => array(
						'label'        => 'Advanced Pricing Table',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'icon'         => 'wcf-icon-Advanced-Pricing-Table',
						'keywords'     => array(
							'pricing plans',
							'pricing chart',
							'advanced price table',
							'product pricing',
							'service pricing table',
							'feature comparison table',
							'package pricing',
							'subscription table',
							'pricing showcase',
							'plan comparison',
						),
						'order'        => 60,
						'demo_url'     => 'https://animation-addons.com/widgets/aae-advanced-pricing-table',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/advanced-pricing-table/',
						'youtube_url'  => '',
						'description'  => 'Create bold, interactive pricing tables to present your services with clarity and professionalism.',
					),
					'scroll-elements'       => array(
						'label'        => 'Scroll Elements',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'scroll animation',
							'scroll effect',
							'parallax scroll',
							'on scroll animation',
							'scroll reveal',
							'scrolling elements',
							'scroll transition',
							'page scroll effect',
							'animated on scroll',
							'scroll-triggered elements',
						),
						'order'        => 9,
						'icon'         => 'wcf-icon-Scroll-Elements',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-scroll-elements/',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/scroll-elements/',
						'youtube_url'  => '',
						'description'  => 'Turn static content into a visual journey with smart, responsive scroll element animations.',
					),
					'advance-portfolio'     => array(
						'label'        => 'Advanced Portfolio',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'portfolio showcase',
							'project portfolio',
							'creative portfolio',
							'work gallery',
							'portfolio slider',
							'portfolio grid',
							'design showcase',
							'portfolio lightbox',
							'portfolio filter',
							'project showcase',
						),
						'order'        => 26,
						'icon'         => 'wcf-icon-Advanced-Portfolio',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-advanced-portfolio',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/advanced-portfolio/',
						'youtube_url'  => '',
						'description'  => 'Make your portfolio shine with tailored layouts, animated sliders, and customized design elements.',
					),
					'filterable-gallery'    => array(
						'label'        => 'Filterable Gallery',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'gallery with filters',
							'category gallery',
							'filter image gallery',
							'portfolio gallery filter',
							'gallery filter widget',
							'filterable photo gallery',
							'gallery sorting',
							'gallery filter navigation',
							'gallery with category filter',
							'filter image showcase',
						),
						'order'        => 53,
						'icon'         => 'wcf-icon-Filterable-Gallery',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-filterable-gallery',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/filterable-gallery/',
						'youtube_url'  => '',
						'description'  => 'Craft engaging galleries where visitors can filter, view, and enjoy your creative work.',
					),
					'breadcrumbs'           => array(
						'label'        => 'Breadcrumbs',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'navigation trail',
							'breadcrumb navigation',
							'page path',
							'site breadcrumbs',
							'location path',
							'website breadcrumbs',
							'navigation hierarchy',
							'breadcrumb links',
							'breadcrumb menu',
							'page navigation trail',
						),
						'order'        => 65,
						'icon'         => 'wcf-icon-Breadcrumbs',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-breadcrumbs',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/breadcrumbs/',
						'youtube_url'  => '',
						'description'  => 'Show users exactly where they are with minimal, modern breadcrumbs built for any layout.',
					),
					'table-of-contents'     => array(
						'label'        => 'Table Of Content',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'toc widget',
							'page outline',
							'content navigation',
							'heading index',
							'page contents list',
							'document outline',
							'article toc',
							'toc navigation',
							'anchor links menu',
							'section index',
						),
						'order'        => 61,
						'icon'         => 'wcf-icon-Table-Of-Content',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-table-of-content',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/table-of-content/',
						'youtube_url'  => '',
						'description'  => 'Structure your headings into a clear, clickable table and keep your readers engaged longer.',
					),
					'image-accordion'       => array(
						'label'        => 'Image Accordion',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'accordion gallery',
							'image toggle',
							'expanding image',
							'collapsible image section',
							'hover image accordion',
							'interactive image accordion',
							'image expand effect',
							'image stack accordion',
							'sliding image accordion',
							'image reveal accordion',
						),
						'order'        => 39,
						'icon'         => 'wcf-icon-Image-Accordion',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-image-accordion',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/image-accordion/',
						'youtube_url'  => '',
						'description'  => 'Present images creatively with collapsible sections, enhancing user experience and saving screen space.',
					),
					'author-box'            => array(
						'label'        => 'Author Box',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'author info',
							'post author section',
							'author profile',
							'about the author',
							'writer bio',
							'author details',
							'author image',
							'author description',
							'author widget',
							'post writer box',
						),
						'order'        => 79,
						'icon'         => 'wcf-icon-Author-Box',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-author-box',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/author-box/',
						'youtube_url'  => '',
						'description'  => 'Create a visually appealing author box with a photo, bio, and social media links.',
					),
					'flip-box'              => array(
						'label'        => 'Flip Box',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'flip card',
							'flipping box',
							'hover flip effect',
							'3d flip box',
							'front and back box',
							'flip animation',
							'flip content',
							'interactive flip card',
							'flip hover animation',
							'flip box widget',
						),
						'order'        => 33,
						'icon'         => 'wcf-icon-Flip-Box',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-flip-box',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/flip-box/',
						'youtube_url'  => '',
						'description'  => 'Create interactive, animated flip boxes that grab attention and highlight your key messages instantly',
					),
					'advance-accordion'     => array(
						'label'        => 'Advanced Accordion',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'animated accordion',
							'collapsible content',
							'accordion tabs',
							'advanced toggle section',
							'content accordion',
							'stylish accordion',
							'faq accordion',
							'expandable accordion',
							'interactive accordion',
							'accordion with icons',
						),
						'order'        => 41,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-advanced-accordion',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/advanced-accordion/',
						'youtube_url'  => '',
						'description'  => 'Keep your pages clean and visitors happy with smart, collapsible advanced accordion designs.',
					),
					'nested-slider'         => array(
						'label'        => 'Nested Slider',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => false,
						'is_extension' => false,
						'keywords'     => array(
							'slider inside slider',
							'nested carousel',
							'multiple sliders',
							'inner slider',
							'slider within slider',
							'sub slider',
							'embedded slider',
							'dual slider',
							'nested image carousel',
							'advanced slider layout',
						),
						'order'        => 34,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => 'https://animation-addons.com/widgets/nested-slider-widget-for-elementor/',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/nested-slider/',
						'youtube_url'  => '',
						'description'  => 'Design with the CMS Fill design with text, images, videos, more CMS.',
					),
					'weather'               => array(
						'label'        => 'Weather',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'live weather',
							'weather forecast',
							'weather display',
							'temperature widget',
							'weather update',
							'location weather',
							'weather information',
							'current weather',
							'weather panel',
							'weather app widget',
						),
						'order'        => 62,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => 'https://animation-addons.com/widgets/aae-weather-widget/',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/weather/',
						'youtube_url'  => '',
						'description'  => 'Display real-time weather information on your website using OpenWeather API',
					),
					'tiktok-feed'           => array(
						'label'        => 'TikTok Feed',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'tiktok video feed',
							'tiktok posts',
							'tiktok gallery',
							'tiktok embed',
							'tiktok showcase',
							'tiktok content widget',
							'tiktok profile feed',
							'tiktok video display',
							'tiktok section',
							'tiktok content block',
						),
						'order'        => 71,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => 'https://animation-addons.com/widgets/tiktok-feed-video-widget-for-elementor/',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => 'Embed trending TikTok videos on your website to keep your content fresh and engaging.',
					),
					'stacked-cards'         => array(
						'label'        => 'Stacked Cards',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'card stack',
							'stacked layout',
							'card slider',
							'swipeable cards',
							'card pile',
							'layered cards',
							'stacked card slider',
							'card animation',
							'stacked swipe cards',
							'card flip stack',
						),
						'order'        => 20,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => '',
						'doc_url'      => '',
						'youtube_url'  => '',
						'description'  => '',
					),
					'scrollmotion-cards'    => array(
						'label'        => 'Scrollmotion Cards',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => '',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/scrollmotion-cards/',
						'youtube_url'  => '',
						'description'  => '',
					),
					'nested-motion-card'    => array(
						'label'        => 'Nested Motion Card',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => '',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/scrollmotion-cards/',
						'youtube_url'  => '',
						'description'  => '',
					),
					'vertical-marquee'      => array(
						'label'        => 'Vertical Marquee',
						'is_active'    => false,
						'location'     => array(
							'cTab' => 'all',
						),
						'is_upcoming'  => false,
						'is_pro'       => true,
						'is_extension' => false,
						'keywords'     => array(
							'vertical scrolling text',
							'up down scroll',
							'vertical ticker',
							'text scroller',
							'vertical text animation',
							'vertical text ticker',
							'content marquee',
							'scrolling news vertical',
							'vertical text scroll',
							'up down marquee',
						),
						'order'        => 21,
						'icon'         => 'wcf-icon-Advanced-Accordion',
						'demo_url'     => 'https://animation-addons.com/widgets/vertical-marquee',
						'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/vertical-marquee/',
						'youtube_url'  => '',
						'description'  => '',
					),
				),
			),
		),
	),
	'extensions'         => array(
		'is_active' => false,
		'elements'  => array(
			'general-extensions' => array(
				'title'     => 'General Extensions',
				'is_active' => false,
				'elements'  => array(
					'custom-css'       => array(
						'label'        => 'Custom CSS',
						'location'     => array(
							'cTab' => 'general',
						),
						'is_pro'       => false,
						'is_active'    => false,
						'setup'        => array( 'basic' ),
						'is_extension' => false,
						'is_upcoming'  => false,
						'icon'         => 'wcf-icon-Custom-CSS',
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/custom-css/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/custom-css/',
						'youtube_url'  => '',
					),
					'dynamic-tags'     => array(
						'label'        => 'Dynamic Tags',
						'location'     => array(
							'cTab' => 'general',
						),
						'is_pro'       => true,
						'is_active'    => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'icon'         => 'wcf-icon-Dynamic-Tags',
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/dynamics-tags/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/dynamics-tags/',
						'youtube_url'  => '',
					),
					'template-library' => array(
						'label'        => 'Template library',
						'location'     => array(
							'cTab' => 'general',
						),
						'is_pro'       => false,
						'is_active'    => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'setup'        => array( 'basic', 'advance' ),
						'icon'         => 'wcf-icon-Template-library',
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/template-library/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/template-library/',
						'youtube_url'  => '',
					),
					'wrapper-link'     => array(
						'label'        => 'Wrapper Link',
						'location'     => array(
							'cTab' => 'general',
						),
						'is_pro'       => true,
						'is_active'    => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'icon'         => 'wcf-icon-Wrapper-Link',
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/wrapper-link/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/wrapper-link/',
						'youtube_url'  => '',
					),
					'popup'            => array(
						'label'        => 'Popup',
						'location'     => array(
							'cTab' => 'general',
						),
						'is_pro'       => false,
						'is_active'    => false,
						'is_extension' => true,
						'is_upcoming'  => false,
						'icon'         => 'wcf-icon-Popup',
						'demo_url'     => 'https://animation-addons.com/extensions/pop-up/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/pop-up/',
						'youtube_url'  => '',
					),
					'tilt-effect'      => array(
						'label'        => 'Tilt Effect',
						'location'     => array(
							'cTab' => 'general',
						),
						'is_pro'       => true,
						'is_active'    => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'icon'         => 'wcf-icon-Tilt-Effect',
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/tilt-effect/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/tilt-effect/',
						'youtube_url'  => '',
					),
					'advanced-tooltip' => array(
						'label'        => 'Advanced Tooltip',
						'location'     => array(
							'cTab' => 'general',
						),
						'is_pro'       => true,
						'is_active'    => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'icon'         => 'wcf-icon-Advanced-Tooltip',
						'demo_url'     => 'https://animation-addons.com/extensions/advanced-tooltip/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/advanced-tooltip-extensions/',
						'youtube_url'  => '',
					),
					'custom-fonts'     => array(
						'label'        => 'Custom Fonts',
						'is_pro'       => false,
						'location'     => array(
							'cTab' => 'general',
						),
						'is_extension' => false,
						'is_active'    => false,
						'is_upcoming'  => false,
						'setup'        => array( 'basic', 'advance' ),
						'icon'         => 'wcf-icon-Custom-Fonts',
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/custom-fonts/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/custom-fonts/',
						'youtube_url'  => '',
					),
					'custom-cpt'       => array(
						'label'        => 'Post Type Builder',
						'is_pro'       => false,
						'location'     => array(
							'cTab' => 'general',
						),
						'is_extension' => false,
						'is_active'    => false,
						'is_upcoming'  => false,
						'setup'        => array( 'basic', 'advance' ),
						'icon'         => 'wcf-icon-Custom-Post-Type',
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/post-type-builder/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/post-type-builder/',
						'youtube_url'  => '',
					),
					'custom-icon'      => array(
						'label'        => 'Custom Icon',
						'is_pro'       => false,
						'location'     => array(
							'cTab' => 'general',
						),
						'is_extension' => false,
						'is_active'    => false,
						'is_upcoming'  => false,
						'icon'         => 'wcf-icon-Custom-Icons',
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/custom-icon/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/custom-icon/',
						'youtube_url'  => '',
					),

					'restrict-content' => array(
						'label'        => 'Content Protection',
						'is_pro'       => true,
						'location'     => array(
							'cTab' => 'general',
						),
						'icon'         => 'wcf-icon-Content-Protection',
						'is_active'    => false,
						'is_extension' => false,
						'is_upcoming'  => false,
						'demo_url'     => '',
						'doc_url'      => '',
						'youtube_url'  => '',
					),

					'code-snippet'     => array(
						'label'        => 'Code Snippet',
						'is_pro'       => false,
						'location'     => array(
							'cTab' => 'general',
						),
						'icon'         => 'wcf-icon-Content-Protection',
						'is_active'    => false,
						'is_extension' => true,
						'is_upcoming'  => false,
						'demo_url'     => 'https://animation-addons.com/docs/general-extensions/code-snippet/',
						'doc_url'      => 'https://animation-addons.com/docs/general-extensions/code-snippet/',
						'youtube_url'  => '',
					),
				),
			),
			'gsap-extensions'    => array(
				'title'     => 'GSAP Extensions',
				'is_active' => false,
				'elements'  => array(
					'wcf-smooth-scroller' => array(
						'title'     => 'Scroll Smoother',
						'doc_url'   => 'https://support.crowdytheme.com/docs/advanced-settings/advanced-settings/wcf-custom-css/',
						'is_pro'    => true,
						'is_active' => false,
						'elements'  => array(
							'animation-effects'       => array(
								'label'        => 'Animation',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'wcf-smooth-scroller',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => true,
								'is_upcoming'  => false,
								'setup'        => array( 'basic', 'advance' ),
								'icon'         => 'wcf-icon-Animation',
								'demo_url'     => '',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/animation-extension-for-elementor/',
								'youtube_url'  => '',
							),
							'pin-element'             => array(
								'label'        => 'Sticky Elements',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'wcf-smooth-scroller',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => true,
								'is_upcoming'  => false,
								'setup'        => array( 'basic', 'advance' ),
								'icon'         => 'wcf-icon-Pin-Elements',
								'demo_url'     => 'https://animation-addons.com/extensions/sticky-elements/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/sticky-elements/',
								'youtube_url'  => '',
							),
							'text-animation-effects'  => array(
								'label'        => 'Text Animation',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'wcf-smooth-scroller',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => true,
								'is_upcoming'  => false,
								'icon'         => 'wcf-icon-Text-Animation',
								'demo_url'     => 'https://animation-addons.com/extensions/text-animation/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/text-animation/',
								'youtube_url'  => '',
							),
							'image-animation-effects' => array(
								'label'        => 'Image Animation',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'wcf-smooth-scroller',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => true,
								'is_upcoming'  => false,
								'icon'         => 'wcf-icon-Image-Animation',
								'demo_url'     => 'https://animation-addons.com/extensions/image-animation/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/image-animation/',
								'youtube_url'  => '',
							),
						),
					),
					'effect'              => array(
						'title'     => 'Effects',
						'doc_url'   => '#',
						'is_pro'    => true,
						'is_active' => false,
						'elements'  => array(
							'cursor-hover-effect' => array(
								'label'        => 'Cursor Hover Effect',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'effect',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => false,
								'is_upcoming'  => false,
								'setup'        => array( 'basic' ),
								'icon'         => 'wcf-icon-Cursor-Hover-Effect',
								'demo_url'     => 'https://animation-addons.com/extensions/cursor-hover-effect/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/cursor-hover-effect-extensions/',
								'youtube_url'  => '',
							),
							'hover-effect-image'  => array(
								'label'        => 'Image Hover Effect',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'effect',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => false,
								'is_upcoming'  => false,
								'setup'        => array( 'basic' ),
								'icon'         => 'wcf-icon-Image-Hover-Effect',
								'demo_url'     => 'https://animation-addons.com/extensions/image-hover-effect/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/image-hover-effect-extensions/',
								'youtube_url'  => '',
							),
							'cursor-move-effect'  => array(
								'label'        => 'Cursor Move Effect',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'effect',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => false,
								'is_upcoming'  => false,
								'setup'        => array( 'basic' ),
								'icon'         => 'wcf-icon-Cursor-Move-Effect',
								'demo_url'     => 'https://animation-addons.com/extensions/cursor-move-effect/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/cursor-move-effect/',
								'youtube_url'  => '',
							),
						),
					),
					'scroll-trigger'      => array(
						'title'     => 'ScrollTrigger',
						'doc_url'   => 'https://support.crowdytheme.com/docs/advanced-settings/advanced-settings/wcf-custom-css/',
						'is_pro'    => true,
						'is_active' => false,
						'elements'  => array(
							'horizontal-scroll' => array(
								'label'        => 'Horizontal',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'scroll-trigger',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => false,
								'is_upcoming'  => false,
								'setup'        => array( 'basic' ),
								'icon'         => 'wcf-icon-Horizontal',
								'demo_url'     => 'https://animation-addons.com/extensions/horizontal-scroll/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/horizontal-scroll/',
								'youtube_url'  => '',
							),
							'scrollto'          => array(
								'label'        => 'ScrollTo',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'scroll-trigger',
								),
								'is_pro'       => true,
								'is_active'    => false,
								'is_extension' => false,
								'is_upcoming'  => false,
								'setup'        => array( 'basic' ),
								'icon'         => 'wcf-icon-Horizontal',
								'demo_url'     => '',
								'doc_url'      => '',
								'youtube_url'  => '',
							),
						),
					),
					'draw-svg'            => array(
						'title'     => 'DrawSVG',
						'doc_url'   => 'https://support.crowdytheme.com/docs/advanced-settings/advanced-settings/wcf-custom-css/',
						'is_pro'    => true,
						'is_active' => false,
						'elements'  => array(),
					),
					'flip'                => array(
						'title'     => 'Flips',
						'doc_url'   => 'https://support.crowdytheme.com/docs/advanced-settings/advanced-settings/wcf-custom-css/',
						'is_pro'    => true,
						'is_active' => false,
						'elements'  => array(
							'portfolio-filter' => array(
								'label'        => 'Portfolio Filter',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'flip',
								),
								'is_pro'       => true,
								'is_active'    => true,
								'is_extension' => true,
								'is_upcoming'  => false,
								'icon'         => 'wcf-icon-Portfolio-Filter',
								'demo_url'     => 'https://animation-addons.com/docs/gsap-extensions/portfolio-filter/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/portfolio-filter/',
								'youtube_url'  => '',
							),
							'gallery-filter'   => array(
								'label'        => 'Gallery Filter',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'flip',
								),
								'is_pro'       => true,
								'is_active'    => true,
								'is_extension' => true,
								'is_upcoming'  => false,
								'icon'         => 'wcf-icon-Gallery-Filter',
								'demo_url'     => 'https://animation-addons.com/docs/gsap-extensions/gallery-filter/',
								'doc_url'      => 'https://animation-addons.com/docs/gsap-extensions/gallery-filter/',
								'youtube_url'  => '',
							),

						),
					),
					'gsap-builder'        => array(
						'title'     => 'Builders',
						'doc_url'   => 'https://support.crowdytheme.com/docs/advanced-settings/advanced-settings/wcf-custom-css/',
						'is_pro'    => true,
						'is_active' => false,
						'elements'  => array(
							'animation-builder' => array(
								'label'        => 'Animation Builder',
								'location'     => array(
									'cTab'     => 'gsap',
									'pluginId' => 'gsap-builder',
								),
								'is_pro'       => true,
								'pro_only'     => true,
								'is_active'    => false,
								'is_extension' => false,
								'is_upcoming'  => false,
								'icon'         => 'wcf-icon-Animation-Builder',
								'demo_url'     => '',
								'doc_url'      => '',
								'youtube_url'  => '',
							),
						),
					),
				),
			),
		),
	),
	'integrations'       => array(
		'plugins' => array(
			'title'    => 'Plugins',
			'elements' => array(
				'animation-addon-for-elementorpro' => array(
					'label'        => 'Animation Addon Pro',
					'basename'     => 'animation-addons-for-elementor-pro/animation-addons-for-elementor-pro.php',
					'source'       => 'custom',
					'is_pro'       => true,
					'slug'         => '',
					'download_url' => '',
				),
			),
		),
		'library' => array(
			'title'    => 'Library',
			'elements' => array(
				'gsap-library' => array(
					'title'     => 'GSAP Library',
					'is_pro'    => true,
					'is_active' => false,
					'elements'  => array(
						'draggable'          => array(
							'label'     => 'Draggable',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/Draggable',
						),
						'easel'              => array(
							'label'     => 'Easel',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/EaselPlugin',
						),
						'flip'               => array(
							'label'     => 'Flip',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/Flip',
						),
						'motion-path'        => array(
							'label'     => 'MotionPath',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/MotionPathPlugin',
						),
						'observer'           => array(
							'label'     => 'Observer',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/Observer',
						),
						'pixi'               => array(
							'label'     => 'Pixi',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/PixiPlugin',
						),
						'scroll-to'          => array(
							'label'     => 'ScrollTo',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/ScrollToPlugin',
						),
						'scroll-trigger'     => array(
							'label'     => 'ScrollTrigger',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/ScrollTrigger/?page=1',
						),
						'text'               => array(
							'label'     => 'Text',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/TextPlugin',
						),
						'draw-svg'           => array(
							'label'     => 'DrawSVG',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/DrawSVGPlugin',
						),
						'physics-2d'         => array(
							'label'     => 'Physics2D',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/Physics2DPlugin',
						),
						'physics-props'      => array(
							'label'     => 'PhysicsProps',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/PhysicsPropsPlugin',
						),
						'scramble-text'      => array(
							'label'     => 'ScrambleText',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/ScrambleTextPlugin',
						),
						'gs-dev-tools'       => array(
							'label'     => 'GSDevTools',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/GSDevTools',
						),
						'inertia'            => array(
							'label'     => 'Inertia',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/InertiaPlugin',
						),
						'morph-svg'          => array(
							'label'     => 'MorphSVG',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/MorphSVGPlugin',
						),
						'motion-path-helper' => array(
							'label'     => 'MotionPathHelper',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/MotionPathHelper',
						),
						'scroll-smoother'    => array(
							'label'     => 'ScrollSmoother',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/ScrollSmoother',
						),
						'split-text'         => array(
							'label'     => 'SplitText',
							'is_pro'    => true,
							'is_active' => false,
							'icon'      => 'wcf-icon-Animation-Builder',
							'doc_url'   => 'https://gsap.com/docs/v3/Plugins/SplitText',
						),
					),
				),
			),
		),
	),
	'dashboardProWidget' => array(
		'advance-portfolio'  => array(
			'label'        => 'Advanced Portfolio',
			'is_active'    => false,
			'location'     => array(
				'cTab' => 'all',
			),
			'is_upcoming'  => false,
			'is_pro'       => true,
			'is_extension' => false,
			'icon'         => 'wcf-icon-Advanced-Portfolio',
			'demo_url'     => 'https://animation-addons.com/widgets/aae-advanced-portfolio',
			'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/advanced-portfolio/',
			'youtube_url'  => '',
		),
		'filterable-gallery' => array(
			'label'        => 'Filterable Gallery',
			'is_active'    => false,
			'location'     => array(
				'cTab' => 'all',
			),
			'is_upcoming'  => false,
			'is_pro'       => true,
			'is_extension' => false,
			'icon'         => 'wcf-icon-Filterable-Gallery',
			'demo_url'     => 'https://animation-addons.com/widgets/aae-filterable-gallery',
			'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/filterable-gallery/',
			'youtube_url'  => '',
		),
		'breadcrumbs'        => array(
			'label'        => 'Breadcrumbs',
			'is_active'    => false,
			'location'     => array(
				'cTab' => 'all',
			),
			'is_upcoming'  => false,
			'is_pro'       => true,
			'is_extension' => false,
			'icon'         => 'wcf-icon-Breadcrumbs',
			'demo_url'     => 'https://animation-addons.com/widgets/aae-breadcrumbs',
			'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/breadcrumbs/',
			'youtube_url'  => '',
		),
		'table-of-contents'  => array(
			'label'        => 'Table Of Content',
			'is_active'    => false,
			'location'     => array(
				'cTab' => 'all',
			),
			'is_upcoming'  => false,
			'is_pro'       => true,
			'is_extension' => false,
			'icon'         => 'wcf-icon-Table-Of-Content',
			'demo_url'     => 'https://animation-addons.com/widgets/aae-table-of-content',
			'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/table-of-content/',
			'youtube_url'  => '',
		),
		'image-accordion'    => array(
			'label'        => 'Image Accordion',
			'is_active'    => false,
			'location'     => array(
				'cTab' => 'all',
			),
			'is_upcoming'  => false,
			'demo_url'     => '',
			'is_pro'       => true,
			'is_extension' => false,
			'icon'         => 'wcf-icon-Image-Accordion',
			'demo_url'     => 'https://animation-addons.com/widgets/aae-image-accordion',
			'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/image-accordion/',
			'youtube_url'  => '',
		),
		'author-box'         => array(
			'label'        => 'Author Box',
			'is_active'    => false,
			'location'     => array(
				'cTab' => 'all',
			),
			'is_upcoming'  => false,
			'demo_url'     => '',
			'is_pro'       => true,
			'is_extension' => false,
			'icon'         => 'wcf-icon-Author-Box',
			'demo_url'     => 'https://animation-addons.com/widgets/aae-author-box',
			'doc_url'      => 'https://animation-addons.com/docs/advanced-widgets/author-box/',
			'youtube_url'  => '',
		),

	),
);

$GLOBALS['wcf_addons_config'] = $config;
