/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-29 13:00:41 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=374 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=12059 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=117201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=32419 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=2936 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_jnews_post_like` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `date_time` datetime NOT NULL,
  `value` int(2) NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=228543 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_popularpostsdata` (
  `postid` bigint(20) NOT NULL,
  `day` datetime NOT NULL,
  `last_viewed` datetime NOT NULL,
  `pageviews` bigint(20) DEFAULT 1,
  PRIMARY KEY (`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_popularpostssummary` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `postid` bigint(20) NOT NULL,
  `pageviews` bigint(20) NOT NULL DEFAULT 1,
  `view_date` date NOT NULL,
  `view_datetime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `postid` (`postid`),
  KEY `view_date` (`view_date`),
  KEY `view_datetime` (`view_datetime`)
) ENGINE=InnoDB AUTO_INCREMENT=1978 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=16898 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=3316 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_404_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) NOT NULL,
  `accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `times_accessed` bigint(20) unsigned NOT NULL DEFAULT 1,
  `referer` varchar(255) NOT NULL DEFAULT '',
  `user_agent` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uri` (`uri`(191))
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_analytics_objects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `title` text NOT NULL,
  `page` varchar(500) NOT NULL,
  `object_type` varchar(100) NOT NULL,
  `object_subtype` varchar(100) NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `primary_key` varchar(255) NOT NULL,
  `seo_score` tinyint(4) NOT NULL DEFAULT 0,
  `page_score` tinyint(4) NOT NULL DEFAULT 0,
  `is_indexable` tinyint(1) NOT NULL DEFAULT 1,
  `schemas_in_use` varchar(500) DEFAULT NULL,
  `desktop_interactive` double DEFAULT 0,
  `desktop_pagescore` double DEFAULT 0,
  `mobile_interactive` double DEFAULT 0,
  `mobile_pagescore` double DEFAULT 0,
  `pagespeed_refreshed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190))
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_internal_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `target_post_id` (`target_post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19434 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_internal_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT 0,
  `external_link_count` int(10) unsigned DEFAULT 0,
  `incoming_link_count` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_redirections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sources` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_to` text NOT NULL,
  `header_code` smallint(4) unsigned NOT NULL,
  `hits` bigint(20) unsigned NOT NULL DEFAULT 0,
  `status` varchar(25) NOT NULL DEFAULT 'active',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_redirections_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `redirection_id` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `object_type` varchar(10) NOT NULL DEFAULT 'post',
  `is_redirected` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `redirection_id` (`redirection_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2438 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=370 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_above_the_fold` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `lcp` longtext DEFAULT '',
  `viewport` longtext DEFAULT '',
  `error_message` longtext DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_lazy_render_content` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `below_the_fold` longtext DEFAULT '',
  `error_message` longtext DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("3","farhood","$wp$2y$10$Tioo7sYnLQAV4iEc0WmAZuRFO161xN.6gmQqyDASXVm00KMrqECAG","farhood","sa.farhood1995@gmail.com","","2024-09-12 17:17:15","","0","farhood"),
("4","james","$wp$2y$10$i88ZEmZbhqid7WxDOopoU.k1P8AoHFvs26y2w93ESuUVYi1UkV3NK","james","jamesscottyara@gmail.com","","2024-10-20 17:53:20","","0","james scottyara");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("213","3","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("214","3","wp_user_level","10"),
("215","3","rich_editing","true"),
("216","3","admin_color","fresh"),
("217","3","nickname","farhood"),
("218","3","first_name",""),
("219","3","last_name",""),
("221","3","wc_last_active","1726099200"),
("223","3","_woocommerce_tracks_anon_id","woo:MEee3SgTVXzw7XVluoQx2BZO"),
("224","3","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("225","3","wp_user-settings","libraryContent=browse&editor=tinymce"),
("226","3","wp_user-settings-time","1731346207"),
("227","3","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("228","3","wp_dashboard_quick_press_last_post_id","3280"),
("229","3","elementor_introduction","a:4:{s:6:\"e-apps\";b:1;s:27:\"ai-get-started-announcement\";b:1;s:7:\"exit_to\";b:1;s:20:\"globals_introduction\";b:1;}"),
("230","3","elementor_admin_notices","a:3:{s:20:\"experiment_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:1:{s:7:\"version\";s:7:\"3.25.10\";}}s:31:\"elementor-pro-forms-submissions\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("231","3","user_session_a4b5d5a139909a10cfef","13"),
("232","3","wp_elementor_connect_common_data","a:3:{s:9:\"client_id\";s:32:\"BGqZ6oHFi7VcvzlXDAxDz6oQ31PJPBPY\";s:11:\"auth_secret\";s:32:\"2yIkkHvzavvQu7LbO3O1KHvBOp7GVYSW\";s:5:\"state\";s:12:\"zHg5A3bZbOHs\";}"),
("233","3","community-events-location","a:1:{s:2:\"ip\";s:10:\"86.57.11.0\";}"),
("234","3","nav_menu_recently_edited","64"),
("235","3","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("236","3","metaboxhidden_nav-menus","a:7:{i:0;s:28:\"add-post-type-e-landing-page\";i:1;s:30:\"add-post-type-archive-template\";i:2;s:30:\"add-post-type-custom-mega-menu\";i:3;s:20:\"add-post-type-footer\";i:4;s:34:\"add-post-type-custom-post-template\";i:5;s:12:\"add-post_tag\";i:6;s:15:\"add-post_format\";}"),
("237","3","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("238","3","manageedit-postcolumnshidden_default","1"),
("239","3","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("240","3","manageedit-pagecolumnshidden_default","1"),
("241","3","manageedit-e-landing-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("242","3","manageedit-e-landing-pagecolumnshidden_default","1"),
("243","3","manageedit-elementskit_contentcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("244","3","manageedit-elementskit_contentcolumnshidden_default","1"),
("245","3","manageedit-elementskit_templatecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("246","3","manageedit-elementskit_templatecolumnshidden_default","1"),
("247","3","manageedit-elementskit_widgetcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("248","3","manageedit-elementskit_widgetcolumnshidden_default","1"),
("249","3","manageedit-archive-templatecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("250","3","manageedit-archive-templatecolumnshidden_default","1"),
("251","3","manageedit-custom-mega-menucolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("252","3","manageedit-custom-mega-menucolumnshidden_default","1"),
("253","3","manageedit-footercolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("254","3","manageedit-footercolumnshidden_default","1"),
("255","3","manageedit-custom-post-templatecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("256","3","manageedit-custom-post-templatecolumnshidden_default","1"),
("257","3","last_update","1752097227"),
("258","3","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("259","3","elementor_dismissed_editor_notices","a:1:{i:0;s:20:\"image_optimizer_hint\";}"),
("260","3","meta-box-order_post","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("262","3","wp_tablepress_user_options","{\"user_options_db_version\":111,\"admin_menu_parent_page\":\"middle\",\"message_first_visit\":true,\"message_superseded_extensions\":true,\"table_editor_column_width\":\"170\",\"table_editor_line_clamp\":\"5\"}"),
("263","3","managetablepress_listcolumnshidden","a:1:{i:0;s:22:\"table_last_modified_by\";}"),
("264","3","dismissed_wp_pointers","tp20_edit_context_menu,theme_editor_notice,plugin_editor_notice"),
("265","4","nickname","james"),
("266","4","first_name","james"),
("267","4","last_name","scottyara"),
("268","4","description",""),
("269","4","rich_editing","true"),
("270","4","syntax_highlighting","true"),
("271","4","comment_shortcuts","false"),
("272","4","admin_color","fresh"),
("273","4","use_ssl","0"),
("274","4","show_admin_bar_front","true"),
("275","4","locale",""),
("276","4","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("277","4","wp_user_level","10"),
("278","4","last_update","1752097227"),
("279","4","dismissed_wp_pointers","theme_editor_notice"),
("280","4","facebook",""),
("281","4","tiktok",""),
("282","4","twitter",""),
("283","4","linkedin",""),
("284","4","pinterest",""),
("285","4","behance",""),
("286","4","github",""),
("287","4","flickr",""),
("288","4","tumblr",""),
("289","4","dribbble",""),
("290","4","soundcloud",""),
("291","4","instagram",""),
("292","4","vimeo",""),
("293","4","youtube",""),
("294","4","reddit",""),
("295","4","vk",""),
("296","4","weibo",""),
("297","4","twitch",""),
("298","4","rss",""),
("299","4","wordpress",""),
("300","4","additional_profile_urls",""),
("302","4","wp_dashboard_quick_press_last_post_id","3270"),
("303","4","manageedit-postcolumnshidden","a:6:{i:0;s:6:\"author\";i:1;s:4:\"tags\";i:2;s:10:\"view_count\";i:3;s:8:\"comments\";i:4;s:21:\"rank_math_description\";i:5;s:6:\"review\";}"),
("304","4","manageedit-postcolumnshidden_default","1"),
("305","4","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("306","4","manageedit-pagecolumnshidden_default","1"),
("307","4","manageedit-e-landing-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("308","4","manageedit-e-landing-pagecolumnshidden_default","1"),
("309","4","manageedit-elementskit_contentcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("310","4","manageedit-elementskit_contentcolumnshidden_default","1"),
("311","4","manageedit-elementskit_templatecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("312","4","manageedit-elementskit_templatecolumnshidden_default","1"),
("313","4","manageedit-elementskit_widgetcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("314","4","manageedit-elementskit_widgetcolumnshidden_default","1"),
("315","4","manageedit-archive-templatecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("316","4","manageedit-archive-templatecolumnshidden_default","1"),
("317","4","manageedit-custom-mega-menucolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("318","4","manageedit-custom-mega-menucolumnshidden_default","1"),
("319","4","manageedit-footercolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("320","4","manageedit-footercolumnshidden_default","1"),
("321","4","manageedit-custom-post-templatecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("322","4","manageedit-custom-post-templatecolumnshidden_default","1"),
("323","4","community-events-location","a:1:{s:2:\"ip\";s:21:\"2a09:bac5:27b8:246e::\";}"),
("324","4","elementor_introduction","a:3:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:6:\"e-apps\";b:1;}"),
("325","4","wp_user-settings","editor=tinymce&libraryContent=browse&posts_list_mode=list"),
("326","4","wp_user-settings-time","1731601325"),
("327","4","elementor_admin_notices","a:3:{s:20:\"experiment_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:7:\"3.25.10\";}}s:31:\"elementor-pro-forms-submissions\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("328","4","meta-box-order_page","a:3:{s:4:\"side\";s:100:\"submitdiv,rank_math_metabox_content_ai,pageparentdiv,rank_math_metabox_link_suggestions,postimagediv\";s:6:\"normal\";s:101:\"rank_math_metabox,revisionsdiv,postexcerpt,postcustom,commentstatusdiv,commentsdiv,slugdiv,authordiv,\";s:8:\"advanced\";s:0:\"\";}"),
("329","4","user_session_a4b5d5a139909a10cfef","14"),
("330","4","nav_menu_recently_edited","65"),
("331","4","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("332","4","metaboxhidden_nav-menus","a:7:{i:0;s:28:\"add-post-type-e-landing-page\";i:1;s:30:\"add-post-type-archive-template\";i:2;s:30:\"add-post-type-custom-mega-menu\";i:3;s:20:\"add-post-type-footer\";i:4;s:34:\"add-post-type-custom-post-template\";i:5;s:12:\"add-post_tag\";i:6;s:15:\"add-post_format\";}"),
("333","4","meta-box-order_post","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("334","3","description",""),
("335","3","syntax_highlighting","true"),
("336","3","comment_shortcuts","false"),
("337","3","use_ssl","0"),
("338","3","show_admin_bar_front","true"),
("339","3","locale",""),
("340","3","facebook",""),
("341","3","tiktok",""),
("342","3","twitter",""),
("343","3","linkedin",""),
("344","3","pinterest",""),
("345","3","behance",""),
("346","3","github",""),
("347","3","flickr",""),
("348","3","tumblr",""),
("349","3","dribbble",""),
("350","3","soundcloud",""),
("351","3","instagram",""),
("352","3","vimeo",""),
("353","3","youtube",""),
("354","3","reddit",""),
("355","3","vk",""),
("356","3","weibo",""),
("357","3","twitch",""),
("358","3","rss",""),
("359","3","wordpress",""),
("360","3","default_password_nag",""),
("362","3","closedpostboxes_dashboard","a:8:{i:0;s:20:\"e-dashboard-overview\";i:1;s:21:\"dashboard_quick_press\";i:2;s:17:\"dashboard_primary\";i:3;s:21:\"dashboard_site_health\";i:4;s:27:\"duplicator_dashboard_widget\";i:5;s:18:\"dashboard_activity\";i:6;s:19:\"dashboard_right_now\";i:7;s:22:\"bdt-dashboard-overview\";}"),
("363","3","metaboxhidden_dashboard","a:0:{}"),
("364","3","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:63:\"e-dashboard-overview,bdt-dashboard-overview,dashboard_right_now\";s:4:\"side\";s:39:\"dashboard_quick_press,dashboard_primary\";s:7:\"column3\";s:68:\"duplicator_dashboard_widget,dashboard_activity,dashboard_site_health\";s:7:\"column4\";s:0:\"\";}"),
("365","4","closedpostboxes_dashboard","a:10:{i:0;s:26:\"rank_math_dashboard_widget\";i:1;s:13:\"wpmet-stories\";i:2;s:20:\"e-dashboard-overview\";i:3;s:21:\"dashboard_site_health\";i:4;s:19:\"dashboard_right_now\";i:5;s:18:\"dashboard_activity\";i:6;s:27:\"duplicator_dashboard_widget\";i:7;s:21:\"dashboard_quick_press\";i:8;s:17:\"dashboard_primary\";i:9;s:26:\"bdt-upk-dashboard-overview\";}"),
("366","4","metaboxhidden_dashboard","a:0:{}"),
("367","4","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:61:\"rank_math_dashboard_widget,wpmet-stories,e-dashboard-overview\";s:4:\"side\";s:89:\"dashboard_quick_press,dashboard_primary,dashboard_site_health,duplicator_dashboard_widget\";s:7:\"column3\";s:65:\"dashboard_right_now,dashboard_activity,bdt-upk-dashboard-overview\";s:7:\"column4\";s:0:\"\";}"),
("368","4","edit_post_per_page","100"),
("369","4","screen_layout_page","2"),
("370","4","wp_tablepress_user_options","{\"user_options_db_version\":109,\"admin_menu_parent_page\":\"middle\",\"message_first_visit\":true,\"message_superseded_extensions\":true,\"table_editor_column_width\":\"170\",\"table_editor_line_clamp\":\"5\"}"),
("371","3","rocket_boxes","a:1:{i:0;s:34:\"rocket_warning_plugin_modification\";}"),
("372","4","rocket_boxes","a:1:{i:1;s:34:\"rocket_warning_plugin_modification\";}"),
("373","3","session_tokens","a:1:{s:64:\"fcd8895de7f27c148d7062f3431b5bb58371eefba5d567c2bf9048e18a1b27af\";a:4:{s:10:\"expiration\";i:1769864279;s:2:\"ip\";s:12:\"86.57.11.102\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1769691479;}}");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("10329","wc_admin_unsnooze_admin_notes","failed","2023-03-23 16:20:30","2023-03-23 19:50:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679588430;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679588430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-23 17:32:59","2023-03-23 21:02:59","0",NULL,"10"),
("10331","wc_admin_unsnooze_admin_notes","failed","2023-03-23 18:32:59","2023-03-23 22:02:59","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679596379;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679596379;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-23 18:45:58","2023-03-23 22:15:58","0",NULL,"10"),
("10333","wc_admin_unsnooze_admin_notes","failed","2023-03-23 19:45:58","2023-03-23 23:15:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679600758;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679600758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-23 21:45:47","2023-03-24 01:15:47","0",NULL,"10"),
("10334","wc_admin_unsnooze_admin_notes","failed","2023-03-23 22:45:47","2023-03-24 02:15:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679611547;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679611547;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-23 23:39:00","2023-03-24 03:09:00","0",NULL,"10"),
("10335","wc_admin_unsnooze_admin_notes","failed","2023-03-24 00:39:00","2023-03-24 04:09:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679618340;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679618340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-24 01:28:22","2023-03-24 04:58:22","0",NULL,"10"),
("10336","wc_admin_unsnooze_admin_notes","failed","2023-03-24 02:28:22","2023-03-24 05:58:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679624902;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679624902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-24 04:43:19","2023-03-24 08:13:19","0",NULL,"10"),
("10337","wc_admin_unsnooze_admin_notes","failed","2023-03-24 05:43:19","2023-03-24 09:13:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679636599;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679636599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-24 07:38:10","2023-03-24 11:08:10","0",NULL,"10"),
("10338","wc_admin_unsnooze_admin_notes","failed","2023-03-24 08:38:10","2023-03-24 12:08:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679647090;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679647090;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-24 08:45:40","2023-03-24 12:15:40","0",NULL,"10"),
("10339","wc_admin_unsnooze_admin_notes","failed","2023-03-24 09:45:40","2023-03-24 13:15:40","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679651140;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679651140;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-24 10:06:53","2023-03-24 13:36:53","0",NULL,"10"),
("10340","wc_admin_unsnooze_admin_notes","failed","2023-03-24 11:06:53","2023-03-24 14:36:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679656013;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679656013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-24 11:14:25","2023-03-24 14:44:25","0",NULL,"10"),
("10341","wc_admin_unsnooze_admin_notes","failed","2023-03-24 12:14:25","2023-03-24 15:44:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679660065;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679660065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-24 16:01:01","2023-03-24 19:31:01","0",NULL,"10"),
("10342","wc_admin_unsnooze_admin_notes","failed","2023-03-24 17:01:01","2023-03-24 20:31:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679677261;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679677261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-24 20:00:25","2023-03-24 23:30:25","0",NULL,"10"),
("10344","wc_admin_unsnooze_admin_notes","failed","2023-03-24 21:00:25","2023-03-25 00:30:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679691625;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679691625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 00:14:13","2023-03-25 03:44:13","0",NULL,"10"),
("10345","wc_admin_unsnooze_admin_notes","failed","2023-03-25 01:14:13","2023-03-25 04:44:13","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679706853;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679706853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 03:44:48","2023-03-25 07:14:48","0",NULL,"10"),
("10346","wc_admin_unsnooze_admin_notes","failed","2023-03-25 04:44:48","2023-03-25 08:14:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679719488;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679719488;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 08:28:34","2023-03-25 11:58:34","0",NULL,"10"),
("10347","wc_admin_unsnooze_admin_notes","failed","2023-03-25 09:28:34","2023-03-25 12:58:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679736514;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679736514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 10:57:00","2023-03-25 14:27:00","0",NULL,"10"),
("10348","wc_admin_unsnooze_admin_notes","failed","2023-03-25 11:57:00","2023-03-25 15:27:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679745420;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679745420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 13:13:51","2023-03-25 16:43:51","0",NULL,"10"),
("10349","wc_admin_unsnooze_admin_notes","failed","2023-03-25 14:13:51","2023-03-25 17:43:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679753631;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679753631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 17:08:33","2023-03-25 20:38:33","0",NULL,"10"),
("10350","wc_admin_unsnooze_admin_notes","failed","2023-03-25 18:08:33","2023-03-25 21:38:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679767713;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679767713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 21:06:49","2023-03-26 00:36:49","0",NULL,"10"),
("10351","wc_admin_unsnooze_admin_notes","failed","2023-03-25 22:06:49","2023-03-26 01:36:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679782009;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679782009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 22:06:58","2023-03-26 01:36:58","0",NULL,"10"),
("10353","wc_admin_unsnooze_admin_notes","failed","2023-03-25 23:06:58","2023-03-26 02:36:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679785618;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679785618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-25 23:45:48","2023-03-26 03:15:48","0",NULL,"10"),
("10354","wc_admin_unsnooze_admin_notes","failed","2023-03-26 00:45:48","2023-03-26 04:15:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679791548;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679791548;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 03:30:01","2023-03-26 07:00:01","0",NULL,"10"),
("10355","wc_admin_unsnooze_admin_notes","failed","2023-03-26 04:30:01","2023-03-26 08:00:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679805001;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679805001;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 07:40:52","2023-03-26 11:10:52","0",NULL,"10"),
("10356","wc_admin_unsnooze_admin_notes","failed","2023-03-26 08:40:52","2023-03-26 12:10:52","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679820052;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679820052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 08:46:02","2023-03-26 12:16:02","0",NULL,"10"),
("10357","wc_admin_unsnooze_admin_notes","failed","2023-03-26 09:46:02","2023-03-26 13:16:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679823962;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679823962;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 10:15:09","2023-03-26 13:45:09","0",NULL,"10"),
("10358","wc_admin_unsnooze_admin_notes","failed","2023-03-26 11:15:09","2023-03-26 14:45:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679829309;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679829309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 11:26:43","2023-03-26 14:56:43","0",NULL,"10"),
("10359","wc_admin_unsnooze_admin_notes","failed","2023-03-26 12:26:43","2023-03-26 15:56:43","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679833603;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679833603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 17:27:27","2023-03-26 20:57:27","0",NULL,"10"),
("10360","wc_admin_unsnooze_admin_notes","failed","2023-03-26 18:27:27","2023-03-26 21:57:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679855247;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679855247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 18:36:00","2023-03-26 22:06:00","0",NULL,"10"),
("10361","wc_admin_unsnooze_admin_notes","failed","2023-03-26 19:36:00","2023-03-26 23:06:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679859360;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679859360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 19:39:45","2023-03-26 23:09:45","0",NULL,"10"),
("10362","wc_admin_unsnooze_admin_notes","failed","2023-03-26 20:39:45","2023-03-27 00:09:45","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679863185;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679863185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-26 21:04:02","2023-03-27 00:34:02","0",NULL,"10"),
("10363","wc_admin_unsnooze_admin_notes","failed","2023-03-26 22:04:02","2023-03-27 01:34:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679868242;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679868242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 01:36:58","2023-03-27 05:06:58","0",NULL,"10"),
("10365","wc_admin_unsnooze_admin_notes","failed","2023-03-27 02:36:58","2023-03-27 06:06:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679884618;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679884618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 03:55:28","2023-03-27 07:25:28","0",NULL,"10"),
("10366","wc_admin_unsnooze_admin_notes","failed","2023-03-27 04:55:28","2023-03-27 08:25:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679892928;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679892928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 04:56:26","2023-03-27 08:26:26","0",NULL,"10"),
("10367","wc_admin_unsnooze_admin_notes","failed","2023-03-27 05:56:26","2023-03-27 09:26:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679896586;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679896586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 06:03:47","2023-03-27 09:33:47","0",NULL,"10"),
("10368","wc_admin_unsnooze_admin_notes","failed","2023-03-27 07:03:47","2023-03-27 10:33:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679900627;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679900627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 07:04:06","2023-03-27 10:34:06","0",NULL,"10"),
("10369","wc_admin_unsnooze_admin_notes","failed","2023-03-27 08:04:06","2023-03-27 11:34:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679904246;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679904246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 08:05:40","2023-03-27 11:35:40","0",NULL,"10"),
("10370","wc_admin_unsnooze_admin_notes","failed","2023-03-27 09:05:41","2023-03-27 12:35:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679907941;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679907941;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 09:06:54","2023-03-27 12:36:54","0",NULL,"10"),
("10371","wc_admin_unsnooze_admin_notes","failed","2023-03-27 10:06:54","2023-03-27 13:36:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679911614;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679911614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 10:08:07","2023-03-27 13:38:07","0",NULL,"10"),
("10372","wc_admin_unsnooze_admin_notes","failed","2023-03-27 11:08:07","2023-03-27 14:38:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679915287;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679915287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 11:11:03","2023-03-27 14:41:03","0",NULL,"10"),
("10373","wc_admin_unsnooze_admin_notes","failed","2023-03-27 12:11:03","2023-03-27 15:41:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679919063;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679919063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 12:13:41","2023-03-27 15:43:41","0",NULL,"10"),
("10374","wc_admin_unsnooze_admin_notes","failed","2023-03-27 13:13:41","2023-03-27 16:43:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679922821;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679922821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 13:14:34","2023-03-27 16:44:34","0",NULL,"10"),
("10375","wc_admin_unsnooze_admin_notes","failed","2023-03-27 14:14:34","2023-03-27 17:44:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679926474;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679926474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 14:15:53","2023-03-27 17:45:53","0",NULL,"10"),
("10376","wc_admin_unsnooze_admin_notes","failed","2023-03-27 15:15:53","2023-03-27 18:45:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679930153;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679930153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 15:16:04","2023-03-27 18:46:04","0",NULL,"10"),
("10377","wc_admin_unsnooze_admin_notes","failed","2023-03-27 16:16:04","2023-03-27 19:46:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679933764;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679933764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 16:31:03","2023-03-27 20:01:03","0",NULL,"10"),
("10378","wc_admin_unsnooze_admin_notes","failed","2023-03-27 17:31:03","2023-03-27 21:01:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679938263;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679938263;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 17:45:39","2023-03-27 21:15:39","0",NULL,"10"),
("10379","wc_admin_unsnooze_admin_notes","failed","2023-03-27 18:45:39","2023-03-27 22:15:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679942739;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679942739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 19:25:07","2023-03-27 22:55:07","0",NULL,"10"),
("10380","wc_admin_unsnooze_admin_notes","failed","2023-03-27 20:25:07","2023-03-27 23:55:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679948707;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679948707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 20:25:27","2023-03-27 23:55:27","0",NULL,"10"),
("10381","wc_admin_unsnooze_admin_notes","failed","2023-03-27 21:25:27","2023-03-28 00:55:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679952327;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679952327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 21:42:32","2023-03-28 01:12:32","0",NULL,"10"),
("10382","wc_admin_unsnooze_admin_notes","failed","2023-03-27 22:42:32","2023-03-28 02:12:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679956952;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679956952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 22:50:05","2023-03-28 02:20:05","0",NULL,"10"),
("10383","wc_admin_unsnooze_admin_notes","failed","2023-03-27 23:50:05","2023-03-28 03:20:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679961005;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679961005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-27 23:50:14","2023-03-28 03:20:14","0",NULL,"10"),
("10384","wc_admin_unsnooze_admin_notes","failed","2023-03-28 00:50:14","2023-03-28 04:20:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679964614;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679964614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 00:52:49","2023-03-28 04:22:49","0",NULL,"10"),
("10385","wc_admin_unsnooze_admin_notes","failed","2023-03-28 01:52:49","2023-03-28 05:22:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679968369;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679968369;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 01:57:27","2023-03-28 05:27:27","0",NULL,"10"),
("10387","wc_admin_unsnooze_admin_notes","failed","2023-03-28 02:57:27","2023-03-28 06:27:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679972247;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679972247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 03:06:17","2023-03-28 06:36:17","0",NULL,"10"),
("10388","wc_admin_unsnooze_admin_notes","failed","2023-03-28 04:06:17","2023-03-28 07:36:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679976377;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679976377;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 04:39:07","2023-03-28 08:09:07","0",NULL,"10"),
("10389","wc_admin_unsnooze_admin_notes","failed","2023-03-28 05:39:07","2023-03-28 09:09:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679981947;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679981947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 05:54:53","2023-03-28 09:24:53","0",NULL,"10"),
("10390","wc_admin_unsnooze_admin_notes","failed","2023-03-28 06:54:53","2023-03-28 10:24:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679986493;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679986493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 07:13:26","2023-03-28 10:43:26","0",NULL,"10"),
("10391","wc_admin_unsnooze_admin_notes","failed","2023-03-28 08:13:26","2023-03-28 11:43:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679991206;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679991206;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 08:16:34","2023-03-28 11:46:34","0",NULL,"10"),
("10392","wc_admin_unsnooze_admin_notes","failed","2023-03-28 09:16:34","2023-03-28 12:46:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679994994;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679994994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 09:42:52","2023-03-28 13:12:52","0",NULL,"10"),
("10393","wc_admin_unsnooze_admin_notes","failed","2023-03-28 10:42:52","2023-03-28 14:12:52","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680000172;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680000172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 11:05:58","2023-03-28 14:35:58","0",NULL,"10"),
("10394","wc_admin_unsnooze_admin_notes","failed","2023-03-28 12:05:58","2023-03-28 15:35:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680005158;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680005158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 12:19:50","2023-03-28 15:49:50","0",NULL,"10"),
("10395","wc_admin_unsnooze_admin_notes","failed","2023-03-28 13:19:50","2023-03-28 16:49:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680009590;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680009590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 13:24:02","2023-03-28 16:54:02","0",NULL,"10"),
("10396","wc_admin_unsnooze_admin_notes","failed","2023-03-28 14:24:02","2023-03-28 17:54:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680013442;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680013442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 14:44:41","2023-03-28 18:14:41","0",NULL,"10"),
("10397","wc_admin_unsnooze_admin_notes","failed","2023-03-28 15:44:41","2023-03-28 19:14:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680018281;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680018281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 15:56:50","2023-03-28 19:26:50","0",NULL,"10"),
("10398","wc_admin_unsnooze_admin_notes","failed","2023-03-28 16:56:50","2023-03-28 20:26:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680022610;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680022610;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 17:00:07","2023-03-28 20:30:07","0",NULL,"10"),
("10399","wc_admin_unsnooze_admin_notes","failed","2023-03-28 18:00:07","2023-03-28 21:30:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680026407;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680026407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 18:00:30","2023-03-28 21:30:30","0",NULL,"10"),
("10400","wc_admin_unsnooze_admin_notes","failed","2023-03-28 19:00:30","2023-03-28 22:30:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680030030;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680030030;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 19:23:39","2023-03-28 22:53:39","0",NULL,"10"),
("10401","wc_admin_unsnooze_admin_notes","failed","2023-03-28 20:23:39","2023-03-28 23:53:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680035019;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680035019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 20:30:26","2023-03-29 00:00:26","0",NULL,"10"),
("10402","wc_admin_unsnooze_admin_notes","failed","2023-03-28 21:30:26","2023-03-29 01:00:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680039026;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680039026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 21:38:32","2023-03-29 01:08:32","0",NULL,"10"),
("10403","wc_admin_unsnooze_admin_notes","failed","2023-03-28 22:38:32","2023-03-29 02:08:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680043112;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680043112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-28 23:35:21","2023-03-29 03:05:21","0",NULL,"10"),
("10404","wc_admin_unsnooze_admin_notes","failed","2023-03-29 00:35:21","2023-03-29 04:05:21","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680050121;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680050121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 00:50:00","2023-03-29 04:20:00","0",NULL,"10"),
("10405","wc_admin_unsnooze_admin_notes","failed","2023-03-29 01:50:00","2023-03-29 05:20:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680054600;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680054600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 02:16:54","2023-03-29 05:46:54","0",NULL,"10"),
("10407","wc_admin_unsnooze_admin_notes","failed","2023-03-29 03:16:54","2023-03-29 06:46:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680059814;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680059814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 04:03:35","2023-03-29 07:33:35","0",NULL,"10"),
("10408","wc_admin_unsnooze_admin_notes","failed","2023-03-29 05:03:35","2023-03-29 08:33:35","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680066215;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680066215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 06:18:53","2023-03-29 09:48:53","0",NULL,"10"),
("10409","wc_admin_unsnooze_admin_notes","failed","2023-03-29 07:18:53","2023-03-29 10:48:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680074333;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680074333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 07:36:25","2023-03-29 11:06:25","0",NULL,"10"),
("10410","wc_admin_unsnooze_admin_notes","failed","2023-03-29 08:36:25","2023-03-29 12:06:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680078985;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680078985;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 08:39:30","2023-03-29 12:09:30","0",NULL,"10"),
("10411","wc_admin_unsnooze_admin_notes","failed","2023-03-29 09:39:30","2023-03-29 13:09:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680082770;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680082770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 10:00:15","2023-03-29 13:30:15","0",NULL,"10"),
("10412","wc_admin_unsnooze_admin_notes","failed","2023-03-29 11:00:15","2023-03-29 14:30:15","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680087615;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680087615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 11:03:39","2023-03-29 14:33:39","0",NULL,"10"),
("10413","wc_admin_unsnooze_admin_notes","failed","2023-03-29 12:03:39","2023-03-29 15:33:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680091419;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680091419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 12:05:08","2023-03-29 15:35:08","0",NULL,"10"),
("10414","wc_admin_unsnooze_admin_notes","failed","2023-03-29 13:05:08","2023-03-29 16:35:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680095108;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680095108;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 13:14:59","2023-03-29 16:44:59","0",NULL,"10"),
("10415","wc_admin_unsnooze_admin_notes","failed","2023-03-29 14:14:59","2023-03-29 17:44:59","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680099299;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680099299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 14:33:12","2023-03-29 18:03:12","0",NULL,"10"),
("10416","wc_admin_unsnooze_admin_notes","failed","2023-03-29 15:33:12","2023-03-29 19:03:12","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680103992;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680103992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 15:56:40","2023-03-29 19:26:40","0",NULL,"10"),
("10417","wc_admin_unsnooze_admin_notes","failed","2023-03-29 16:56:40","2023-03-29 20:26:40","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680109000;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680109000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 17:24:59","2023-03-29 20:54:59","0",NULL,"10"),
("10418","wc_admin_unsnooze_admin_notes","failed","2023-03-29 18:24:59","2023-03-29 21:54:59","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680114299;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680114299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 19:38:01","2023-03-29 23:08:01","0",NULL,"10"),
("10419","wc_admin_unsnooze_admin_notes","failed","2023-03-29 20:38:01","2023-03-30 00:08:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680122281;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680122281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 20:40:07","2023-03-30 00:10:07","0",NULL,"10"),
("10420","wc_admin_unsnooze_admin_notes","failed","2023-03-29 21:40:07","2023-03-30 01:10:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680126007;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680126007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 22:37:16","2023-03-30 02:07:16","0",NULL,"10"),
("10421","wc_admin_unsnooze_admin_notes","failed","2023-03-29 23:37:16","2023-03-30 03:07:16","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680133036;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680133036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-29 23:43:24","2023-03-30 03:13:24","0",NULL,"10"),
("10422","wc_admin_unsnooze_admin_notes","failed","2023-03-30 00:43:24","2023-03-30 04:13:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680137004;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680137004;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 00:53:14","2023-03-30 04:23:14","0",NULL,"10"),
("10423","wc_admin_unsnooze_admin_notes","failed","2023-03-30 01:53:14","2023-03-30 05:23:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680141194;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680141194;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 01:59:10","2023-03-30 05:29:10","0",NULL,"10"),
("10424","wc_admin_unsnooze_admin_notes","failed","2023-03-30 02:59:10","2023-03-30 06:29:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680145150;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680145150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 03:06:27","2023-03-30 06:36:27","0",NULL,"10"),
("10426","wc_admin_unsnooze_admin_notes","failed","2023-03-30 04:06:27","2023-03-30 07:36:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680149187;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680149187;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 04:42:41","2023-03-30 08:12:41","0",NULL,"10"),
("10427","wc_admin_unsnooze_admin_notes","failed","2023-03-30 05:42:41","2023-03-30 09:12:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680154961;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680154961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 05:57:32","2023-03-30 09:27:32","0",NULL,"10"),
("10428","wc_admin_unsnooze_admin_notes","failed","2023-03-30 06:57:32","2023-03-30 10:27:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680159452;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680159452;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 07:16:55","2023-03-30 10:46:55","0",NULL,"10"),
("10429","wc_admin_unsnooze_admin_notes","failed","2023-03-30 08:16:55","2023-03-30 11:46:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680164215;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680164215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 08:45:54","2023-03-30 12:15:54","0",NULL,"10"),
("10430","wc_admin_unsnooze_admin_notes","failed","2023-03-30 09:45:54","2023-03-30 13:15:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680169554;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680169554;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 10:03:09","2023-03-30 13:33:09","0",NULL,"10"),
("10431","wc_admin_unsnooze_admin_notes","failed","2023-03-30 11:03:09","2023-03-30 14:33:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680174189;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680174189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 11:37:43","2023-03-30 15:07:43","0",NULL,"10"),
("10432","wc_admin_unsnooze_admin_notes","failed","2023-03-30 12:37:43","2023-03-30 16:07:43","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680179863;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680179863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 12:45:28","2023-03-30 16:15:28","0",NULL,"10"),
("10433","wc_admin_unsnooze_admin_notes","failed","2023-03-30 13:45:28","2023-03-30 17:15:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680183928;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680183928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 14:27:16","2023-03-30 17:57:16","0",NULL,"10"),
("10434","wc_admin_unsnooze_admin_notes","failed","2023-03-30 15:27:16","2023-03-30 18:57:16","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680190036;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680190036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 15:57:09","2023-03-30 19:27:09","0",NULL,"10"),
("10435","wc_admin_unsnooze_admin_notes","failed","2023-03-30 16:57:09","2023-03-30 20:27:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680195429;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680195429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 17:02:37","2023-03-30 20:32:37","0",NULL,"10"),
("10436","wc_admin_unsnooze_admin_notes","failed","2023-03-30 18:02:38","2023-03-30 21:32:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680199358;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680199358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 18:14:35","2023-03-30 21:44:35","0",NULL,"10"),
("10437","wc_admin_unsnooze_admin_notes","failed","2023-03-30 19:14:35","2023-03-30 22:44:35","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680203675;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680203675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 19:36:35","2023-03-30 23:06:35","0",NULL,"10"),
("10438","wc_admin_unsnooze_admin_notes","failed","2023-03-30 20:36:35","2023-03-31 00:06:35","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680208595;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680208595;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 21:41:11","2023-03-31 01:11:11","0",NULL,"10"),
("10439","wc_admin_unsnooze_admin_notes","failed","2023-03-30 22:41:11","2023-03-31 02:11:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680216071;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680216071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-30 23:56:20","2023-03-31 03:26:20","0",NULL,"10"),
("10440","wc_admin_unsnooze_admin_notes","failed","2023-03-31 00:56:20","2023-03-31 04:26:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680224180;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680224180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 01:30:55","2023-03-31 05:00:55","0",NULL,"10"),
("10441","wc_admin_unsnooze_admin_notes","failed","2023-03-31 02:30:55","2023-03-31 06:00:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680229855;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680229855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 03:11:14","2023-03-31 06:41:14","0",NULL,"10"),
("10443","wc_admin_unsnooze_admin_notes","failed","2023-03-31 04:11:14","2023-03-31 07:41:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680235874;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680235874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 06:05:51","2023-03-31 09:35:51","0",NULL,"10"),
("10444","wc_admin_unsnooze_admin_notes","failed","2023-03-31 07:05:51","2023-03-31 10:35:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680246351;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680246351;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 07:25:50","2023-03-31 10:55:50","0",NULL,"10"),
("10445","wc_admin_unsnooze_admin_notes","failed","2023-03-31 08:25:50","2023-03-31 11:55:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680251150;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680251150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 08:58:11","2023-03-31 12:28:11","0",NULL,"10"),
("10446","wc_admin_unsnooze_admin_notes","failed","2023-03-31 09:58:11","2023-03-31 13:28:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680256691;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680256691;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 10:11:18","2023-03-31 13:41:18","0",NULL,"10"),
("10447","wc_admin_unsnooze_admin_notes","failed","2023-03-31 11:11:18","2023-03-31 14:41:18","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680261078;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680261078;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 11:37:36","2023-03-31 15:07:36","0",NULL,"10"),
("10448","wc_admin_unsnooze_admin_notes","failed","2023-03-31 12:37:36","2023-03-31 16:07:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680266256;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680266256;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 13:33:32","2023-03-31 17:03:32","0",NULL,"10"),
("10449","wc_admin_unsnooze_admin_notes","failed","2023-03-31 14:33:32","2023-03-31 18:03:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680273212;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680273212;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 15:14:24","2023-03-31 18:44:24","0",NULL,"10"),
("10450","wc_admin_unsnooze_admin_notes","failed","2023-03-31 16:14:24","2023-03-31 19:44:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680279264;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680279264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 19:51:00","2023-03-31 23:21:00","0",NULL,"10"),
("10451","wc_admin_unsnooze_admin_notes","failed","2023-03-31 20:51:00","2023-04-01 00:21:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680295860;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680295860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-03-31 21:45:06","2023-04-01 01:15:06","0",NULL,"10"),
("10452","wc_admin_unsnooze_admin_notes","failed","2023-03-31 22:45:06","2023-04-01 02:15:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680302706;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680302706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 01:33:27","2023-04-01 05:03:27","0",NULL,"10"),
("10453","wc_admin_unsnooze_admin_notes","failed","2023-04-01 02:33:27","2023-04-01 06:03:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680316407;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680316407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 03:28:07","2023-04-01 06:58:07","0",NULL,"10"),
("10454","wc_admin_unsnooze_admin_notes","failed","2023-04-01 04:28:07","2023-04-01 07:58:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680323287;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680323287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 06:13:19","2023-04-01 09:43:19","0",NULL,"10"),
("10456","wc_admin_unsnooze_admin_notes","failed","2023-04-01 07:13:19","2023-04-01 10:43:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680333199;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680333199;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 08:22:20","2023-04-01 11:52:20","0",NULL,"10"),
("10457","wc_admin_unsnooze_admin_notes","failed","2023-04-01 09:22:20","2023-04-01 12:52:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680340940;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680340940;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 10:42:35","2023-04-01 14:12:35","0",NULL,"10"),
("10458","wc_admin_unsnooze_admin_notes","failed","2023-04-01 11:42:35","2023-04-01 15:12:35","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680349355;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680349355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 13:41:24","2023-04-01 17:11:24","0",NULL,"10"),
("10459","wc_admin_unsnooze_admin_notes","failed","2023-04-01 14:41:24","2023-04-01 18:11:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680360084;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680360084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 15:14:42","2023-04-01 18:44:42","0",NULL,"10"),
("10460","wc_admin_unsnooze_admin_notes","failed","2023-04-01 16:14:42","2023-04-01 19:44:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680365682;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680365682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 17:03:56","2023-04-01 20:33:56","0",NULL,"10"),
("10461","wc_admin_unsnooze_admin_notes","failed","2023-04-01 18:03:56","2023-04-01 21:33:56","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680372236;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680372236;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 20:31:46","2023-04-02 00:01:46","0",NULL,"10"),
("10462","wc_admin_unsnooze_admin_notes","failed","2023-04-01 21:31:46","2023-04-02 01:01:46","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680384706;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680384706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 21:33:26","2023-04-02 01:03:26","0",NULL,"10"),
("10463","wc_admin_unsnooze_admin_notes","failed","2023-04-01 22:33:26","2023-04-02 02:03:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680388406;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680388406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-01 23:35:39","2023-04-02 03:05:39","0",NULL,"10"),
("10464","wc_admin_unsnooze_admin_notes","failed","2023-04-02 00:35:39","2023-04-02 04:05:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680395739;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680395739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-02 00:40:48","2023-04-02 04:10:48","0",NULL,"10"),
("10465","wc_admin_unsnooze_admin_notes","failed","2023-04-02 01:40:48","2023-04-02 05:10:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680399648;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680399648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-02 03:33:20","2023-04-02 07:03:20","0",NULL,"10"),
("10466","wc_admin_unsnooze_admin_notes","failed","2023-04-02 04:33:20","2023-04-02 08:03:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680410000;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680410000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-02 06:11:42","2023-04-02 09:41:42","0",NULL,"10"),
("10468","wc_admin_unsnooze_admin_notes","failed","2023-04-02 07:11:42","2023-04-02 10:41:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680419502;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680419502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-02 09:22:28","2023-04-02 12:52:28","0",NULL,"10"),
("10469","wc_admin_unsnooze_admin_notes","failed","2023-04-02 10:22:28","2023-04-02 13:52:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680430948;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680430948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-02 13:40:17","2023-04-02 17:10:17","0",NULL,"10"),
("10470","wc_admin_unsnooze_admin_notes","failed","2023-04-02 14:40:17","2023-04-02 18:10:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680446417;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680446417;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-02 17:38:43","2023-04-02 21:08:43","0",NULL,"10"),
("10471","wc_admin_unsnooze_admin_notes","failed","2023-04-02 18:38:43","2023-04-02 22:08:43","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680460723;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680460723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-02 19:11:49","2023-04-02 22:41:49","0",NULL,"10"),
("10472","wc_admin_unsnooze_admin_notes","failed","2023-04-02 20:11:49","2023-04-02 23:41:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680466309;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680466309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-02 20:12:39","2023-04-02 23:42:39","0",NULL,"10"),
("10473","wc_admin_unsnooze_admin_notes","failed","2023-04-02 21:12:39","2023-04-03 00:42:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680469959;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680469959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 01:43:34","2023-04-03 05:13:34","0",NULL,"10"),
("10474","wc_admin_unsnooze_admin_notes","failed","2023-04-03 02:43:34","2023-04-03 06:13:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680489814;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680489814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 06:05:37","2023-04-03 09:35:37","0",NULL,"10"),
("10475","wc_admin_unsnooze_admin_notes","failed","2023-04-03 07:05:37","2023-04-03 10:35:37","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680505537;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680505537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 08:09:10","2023-04-03 11:39:10","0",NULL,"10"),
("10477","wc_admin_unsnooze_admin_notes","failed","2023-04-03 09:09:10","2023-04-03 12:39:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680512950;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680512950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 09:23:24","2023-04-03 12:53:24","0",NULL,"10"),
("10478","wc_admin_unsnooze_admin_notes","failed","2023-04-03 10:23:24","2023-04-03 13:53:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680517404;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680517404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 10:43:46","2023-04-03 14:13:46","0",NULL,"10"),
("10479","wc_admin_unsnooze_admin_notes","failed","2023-04-03 11:43:46","2023-04-03 15:13:46","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680522226;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680522226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 11:51:21","2023-04-03 15:21:21","0",NULL,"10"),
("10480","wc_admin_unsnooze_admin_notes","failed","2023-04-03 12:51:21","2023-04-03 16:21:21","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680526281;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680526281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 12:54:12","2023-04-03 16:24:12","0",NULL,"10"),
("10481","wc_admin_unsnooze_admin_notes","failed","2023-04-03 13:54:12","2023-04-03 17:24:12","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680530052;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680530052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 14:44:59","2023-04-03 18:14:59","0",NULL,"10"),
("10482","wc_admin_unsnooze_admin_notes","failed","2023-04-03 15:44:59","2023-04-03 19:14:59","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680536699;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680536699;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 16:58:23","2023-04-03 20:28:23","0",NULL,"10"),
("10483","wc_admin_unsnooze_admin_notes","failed","2023-04-03 17:58:23","2023-04-03 21:28:23","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680544703;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680544703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 18:09:53","2023-04-03 21:39:53","0",NULL,"10"),
("10484","wc_admin_unsnooze_admin_notes","failed","2023-04-03 19:09:53","2023-04-03 22:39:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680548993;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680548993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 22:20:01","2023-04-04 01:50:01","0",NULL,"10"),
("10485","wc_admin_unsnooze_admin_notes","failed","2023-04-03 23:20:01","2023-04-04 02:50:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680564001;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680564001;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-03 23:38:44","2023-04-04 03:08:44","0",NULL,"10"),
("10486","wc_admin_unsnooze_admin_notes","failed","2023-04-04 00:38:44","2023-04-04 04:08:44","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680568724;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680568724;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-04 10:59:03","2023-04-04 14:29:03","0",NULL,"10"),
("10487","wc_admin_unsnooze_admin_notes","failed","2023-04-04 11:59:03","2023-04-04 15:29:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680609543;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680609543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-04 14:05:34","2023-04-04 17:35:34","0",NULL,"10"),
("10489","wc_admin_unsnooze_admin_notes","failed","2023-04-04 15:05:34","2023-04-04 18:35:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680620734;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680620734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-04 16:31:57","2023-04-04 20:01:57","0",NULL,"10"),
("10490","wc_admin_unsnooze_admin_notes","failed","2023-04-04 17:31:57","2023-04-04 21:01:57","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680629517;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680629517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-04 19:34:42","2023-04-04 23:04:42","0",NULL,"10"),
("10491","wc_admin_unsnooze_admin_notes","failed","2023-04-04 20:34:42","2023-04-05 00:04:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680640482;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680640482;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-04 21:35:53","2023-04-05 01:05:53","0",NULL,"10"),
("10492","wc_admin_unsnooze_admin_notes","failed","2023-04-04 22:35:53","2023-04-05 02:05:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680647753;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680647753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-05 01:19:47","2023-04-05 04:49:47","0",NULL,"10"),
("10493","wc_admin_unsnooze_admin_notes","failed","2023-04-05 02:19:47","2023-04-05 05:49:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680661187;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680661187;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-05 05:58:34","2023-04-05 09:28:34","0",NULL,"10"),
("10494","wc_admin_unsnooze_admin_notes","failed","2023-04-05 06:58:34","2023-04-05 10:28:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680677914;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680677914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-05 07:31:39","2023-04-05 11:01:39","0",NULL,"10"),
("10495","wc_admin_unsnooze_admin_notes","failed","2023-04-05 08:31:39","2023-04-05 12:01:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680683499;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680683499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-05 09:25:30","2023-04-05 12:55:30","0",NULL,"10"),
("10496","wc_admin_unsnooze_admin_notes","failed","2023-04-05 10:25:30","2023-04-05 13:55:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680690330;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680690330;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-05 11:08:03","2023-04-05 14:38:03","0",NULL,"10"),
("10497","wc_admin_unsnooze_admin_notes","failed","2023-04-05 12:08:03","2023-04-05 15:38:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680696483;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680696483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-05 23:08:41","2023-04-06 02:38:41","0",NULL,"10"),
("10499","wc_admin_unsnooze_admin_notes","failed","2023-04-06 00:08:41","2023-04-06 03:38:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680739721;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680739721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-06 07:48:54","2023-04-06 11:18:54","0",NULL,"10"),
("10500","wc_admin_unsnooze_admin_notes","failed","2023-04-06 08:48:54","2023-04-06 12:18:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680770934;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680770934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-06 15:04:54","2023-04-06 18:34:54","0",NULL,"10"),
("10502","wc_admin_unsnooze_admin_notes","failed","2023-04-06 16:04:54","2023-04-06 19:34:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680797094;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680797094;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-06 17:21:57","2023-04-06 20:51:57","0",NULL,"10"),
("10503","wc_admin_unsnooze_admin_notes","failed","2023-04-06 18:21:57","2023-04-06 21:51:57","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680805317;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680805317;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-06 19:33:17","2023-04-06 23:03:17","0",NULL,"10"),
("10504","wc_admin_unsnooze_admin_notes","failed","2023-04-06 20:33:17","2023-04-07 00:03:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680813197;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680813197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-07 02:52:04","2023-04-07 06:22:04","0",NULL,"10"),
("10505","wc_admin_unsnooze_admin_notes","failed","2023-04-07 03:52:04","2023-04-07 07:22:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680839524;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680839524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-07 19:36:28","2023-04-07 23:06:28","0",NULL,"10"),
("10507","wc_admin_unsnooze_admin_notes","failed","2023-04-07 20:36:28","2023-04-08 00:06:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680899788;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680899788;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-07 20:49:38","2023-04-08 00:19:38","0",NULL,"10"),
("10508","wc_admin_unsnooze_admin_notes","failed","2023-04-07 21:49:38","2023-04-08 01:19:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680904178;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680904178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-08 02:48:56","2023-04-08 06:18:56","0",NULL,"10"),
("10509","wc_admin_unsnooze_admin_notes","failed","2023-04-08 03:48:56","2023-04-08 07:18:56","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680925736;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680925736;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-08 14:46:45","2023-04-08 18:16:45","0",NULL,"10"),
("10510","wc_admin_unsnooze_admin_notes","failed","2023-04-08 15:46:45","2023-04-08 19:16:45","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680968805;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680968805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-08 17:35:38","2023-04-08 21:05:38","0",NULL,"10"),
("10511","wc_admin_unsnooze_admin_notes","failed","2023-04-08 18:35:38","2023-04-08 22:05:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680978938;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680978938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-08 21:42:57","2023-04-09 01:12:57","0",NULL,"10"),
("10513","wc_admin_unsnooze_admin_notes","failed","2023-04-08 22:42:57","2023-04-09 02:12:57","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680993777;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680993777;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-08 23:21:01","2023-04-09 02:51:01","0",NULL,"10"),
("10514","wc_admin_unsnooze_admin_notes","failed","2023-04-09 00:21:01","2023-04-09 03:51:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680999661;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680999661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-09 03:12:05","2023-04-09 06:42:05","0",NULL,"10"),
("10515","wc_admin_unsnooze_admin_notes","failed","2023-04-09 04:12:05","2023-04-09 07:42:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681013525;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681013525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-09 08:27:48","2023-04-09 11:57:48","0",NULL,"10"),
("10516","wc_admin_unsnooze_admin_notes","failed","2023-04-09 09:27:48","2023-04-09 12:57:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681032468;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681032468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-09 09:29:08","2023-04-09 12:59:08","0",NULL,"10"),
("10517","wc_admin_unsnooze_admin_notes","failed","2023-04-09 10:29:08","2023-04-09 13:59:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681036148;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681036148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-09 11:23:49","2023-04-09 14:53:49","0",NULL,"10"),
("10518","wc_admin_unsnooze_admin_notes","failed","2023-04-09 12:23:49","2023-04-09 15:53:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681043029;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681043029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-09 12:31:39","2023-04-09 16:01:39","0",NULL,"10"),
("10519","wc_admin_unsnooze_admin_notes","failed","2023-04-09 13:31:39","2023-04-09 17:01:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681047099;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681047099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-09 19:02:37","2023-04-09 22:32:37","0",NULL,"10"),
("10520","wc_admin_unsnooze_admin_notes","failed","2023-04-09 20:02:37","2023-04-09 23:32:37","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681070557;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681070557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-10 02:03:49","2023-04-10 05:33:49","0",NULL,"10"),
("10522","wc_admin_unsnooze_admin_notes","failed","2023-04-10 03:03:49","2023-04-10 06:33:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681095829;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681095829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-10 09:15:22","2023-04-10 12:45:22","0",NULL,"10"),
("10523","wc_admin_unsnooze_admin_notes","failed","2023-04-10 10:15:22","2023-04-10 13:45:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681121722;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681121722;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-10 16:01:43","2023-04-10 19:31:43","0",NULL,"10"),
("10524","wc_admin_unsnooze_admin_notes","failed","2023-04-10 17:01:43","2023-04-10 20:31:43","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681146103;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681146103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-10 18:21:09","2023-04-10 21:51:09","0",NULL,"10"),
("10525","wc_admin_unsnooze_admin_notes","failed","2023-04-10 19:21:09","2023-04-10 22:51:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681154469;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681154469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 00:49:11","2023-04-11 04:19:11","0",NULL,"10"),
("10526","wc_admin_unsnooze_admin_notes","failed","2023-04-11 01:49:11","2023-04-11 05:19:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681177751;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681177751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 03:09:17","2023-04-11 06:39:17","0",NULL,"10"),
("10527","wc_admin_unsnooze_admin_notes","failed","2023-04-11 04:09:17","2023-04-11 07:39:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681186157;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681186157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 05:00:29","2023-04-11 08:30:29","0",NULL,"10"),
("10529","wc_admin_unsnooze_admin_notes","failed","2023-04-11 06:00:29","2023-04-11 09:30:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681192829;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681192829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 08:09:04","2023-04-11 11:39:04","0",NULL,"10"),
("10530","wc_admin_unsnooze_admin_notes","failed","2023-04-11 09:09:04","2023-04-11 12:39:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681204144;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681204144;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 09:22:26","2023-04-11 12:52:26","0",NULL,"10"),
("10532","wc_admin_unsnooze_admin_notes","failed","2023-04-11 10:22:26","2023-04-11 13:52:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681208546;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681208546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 10:28:59","2023-04-11 13:58:59","0",NULL,"10"),
("10533","wc_admin_unsnooze_admin_notes","failed","2023-04-11 11:28:59","2023-04-11 14:58:59","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681212539;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681212539;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 12:39:13","2023-04-11 16:09:13","0",NULL,"10"),
("10534","wc_admin_unsnooze_admin_notes","failed","2023-04-11 13:39:13","2023-04-11 17:09:13","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681220353;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681220353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 17:12:03","2023-04-11 20:42:03","0",NULL,"10"),
("10535","wc_admin_unsnooze_admin_notes","failed","2023-04-11 18:12:03","2023-04-11 21:42:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681236723;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681236723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 18:29:28","2023-04-11 21:59:28","0",NULL,"10"),
("10536","wc_admin_unsnooze_admin_notes","failed","2023-04-11 19:29:28","2023-04-11 22:59:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681241368;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681241368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 20:08:17","2023-04-11 23:38:17","0",NULL,"10"),
("10537","wc_admin_unsnooze_admin_notes","failed","2023-04-11 21:08:17","2023-04-12 00:38:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681247297;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681247297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-11 22:18:07","2023-04-12 01:48:07","0",NULL,"10"),
("10538","wc_admin_unsnooze_admin_notes","failed","2023-04-11 23:18:07","2023-04-12 02:48:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681255087;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681255087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-12 00:20:31","2023-04-12 03:50:31","0",NULL,"10"),
("10539","wc_admin_unsnooze_admin_notes","failed","2023-04-12 01:20:31","2023-04-12 04:50:31","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681262431;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681262431;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-12 11:09:58","2023-04-12 14:39:58","0",NULL,"10"),
("10541","wc_admin_unsnooze_admin_notes","failed","2023-04-12 12:09:58","2023-04-12 15:39:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681301398;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681301398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-12 19:32:30","2023-04-12 23:02:30","0",NULL,"10"),
("10542","wc_admin_unsnooze_admin_notes","failed","2023-04-12 20:32:30","2023-04-13 00:02:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681331550;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681331550;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-12 21:50:41","2023-04-13 01:20:41","0",NULL,"10"),
("10543","wc_admin_unsnooze_admin_notes","failed","2023-04-12 22:50:41","2023-04-13 02:20:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681339841;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681339841;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-12 23:02:28","2023-04-13 02:32:28","0",NULL,"10"),
("10544","wc_admin_unsnooze_admin_notes","failed","2023-04-13 00:02:28","2023-04-13 03:32:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681344148;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681344148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-13 05:39:19","2023-04-13 09:09:19","0",NULL,"10"),
("10545","wc_admin_unsnooze_admin_notes","failed","2023-04-13 06:39:19","2023-04-13 10:09:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681367959;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681367959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-13 06:44:06","2023-04-13 10:14:06","0",NULL,"10"),
("10546","wc_admin_unsnooze_admin_notes","failed","2023-04-13 07:44:06","2023-04-13 11:14:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681371846;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681371846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-13 11:23:30","2023-04-13 14:53:30","0",NULL,"10"),
("10547","wc_admin_unsnooze_admin_notes","failed","2023-04-13 12:23:30","2023-04-13 15:53:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681388610;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681388610;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-13 13:21:53","2023-04-13 16:51:53","0",NULL,"10"),
("10549","wc_admin_unsnooze_admin_notes","failed","2023-04-13 14:21:53","2023-04-13 17:51:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681395713;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681395713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-13 16:26:10","2023-04-13 19:56:10","0",NULL,"10"),
("10550","wc_admin_unsnooze_admin_notes","failed","2023-04-13 17:26:10","2023-04-13 20:56:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681406770;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681406770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-13 18:03:19","2023-04-13 21:33:19","0",NULL,"10"),
("10551","wc_admin_unsnooze_admin_notes","failed","2023-04-13 19:03:19","2023-04-13 22:33:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681412599;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681412599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-13 20:06:38","2023-04-13 23:36:38","0",NULL,"10"),
("10552","wc_admin_unsnooze_admin_notes","failed","2023-04-13 21:06:38","2023-04-14 00:36:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681419998;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681419998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-13 21:34:54","2023-04-14 01:04:54","0",NULL,"10"),
("10553","wc_admin_unsnooze_admin_notes","failed","2023-04-13 22:34:54","2023-04-14 02:04:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681425294;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681425294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-14 05:16:18","2023-04-14 08:46:18","0",NULL,"10"),
("10554","wc_admin_unsnooze_admin_notes","failed","2023-04-14 06:16:18","2023-04-14 09:46:18","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681452978;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681452978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-14 08:49:24","2023-04-14 12:19:24","0",NULL,"10"),
("10555","wc_admin_unsnooze_admin_notes","failed","2023-04-14 09:49:24","2023-04-14 13:19:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681465764;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681465764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-14 10:22:48","2023-04-14 13:52:48","0",NULL,"10"),
("10556","wc_admin_unsnooze_admin_notes","failed","2023-04-14 11:22:48","2023-04-14 14:52:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681471368;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681471368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-14 14:26:47","2023-04-14 17:56:47","0",NULL,"10"),
("10557","wc_admin_unsnooze_admin_notes","failed","2023-04-14 15:26:47","2023-04-14 18:56:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681486007;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681486007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-14 15:59:55","2023-04-14 19:29:55","0",NULL,"10"),
("10559","wc_admin_unsnooze_admin_notes","failed","2023-04-14 16:59:55","2023-04-14 20:29:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681491595;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681491595;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-14 22:07:09","2023-04-15 01:37:09","0",NULL,"10"),
("10560","wc_admin_unsnooze_admin_notes","failed","2023-04-14 23:07:09","2023-04-15 02:37:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681513629;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681513629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-14 23:35:11","2023-04-15 03:05:11","0",NULL,"10"),
("10561","wc_admin_unsnooze_admin_notes","failed","2023-04-15 00:35:11","2023-04-15 04:05:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681518911;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681518911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-15 07:52:06","2023-04-15 11:22:06","0",NULL,"10"),
("10562","wc_admin_unsnooze_admin_notes","failed","2023-04-15 08:52:06","2023-04-15 12:22:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681548726;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681548726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-15 09:12:38","2023-04-15 12:42:38","0",NULL,"10"),
("10563","wc_admin_unsnooze_admin_notes","failed","2023-04-15 10:12:38","2023-04-15 13:42:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681553558;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681553558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-15 10:35:49","2023-04-15 14:05:49","0",NULL,"10"),
("10564","wc_admin_unsnooze_admin_notes","failed","2023-04-15 11:35:49","2023-04-15 15:05:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681558549;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681558549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-15 11:50:04","2023-04-15 15:20:04","0",NULL,"10"),
("10565","wc_admin_unsnooze_admin_notes","failed","2023-04-15 12:50:04","2023-04-15 16:20:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681563004;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681563004;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-15 15:28:12","2023-04-15 18:58:12","0",NULL,"10"),
("10566","wc_admin_unsnooze_admin_notes","failed","2023-04-15 16:28:12","2023-04-15 19:58:12","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681576092;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681576092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-15 18:36:30","2023-04-15 22:06:30","0",NULL,"10"),
("10568","wc_admin_unsnooze_admin_notes","failed","2023-04-15 19:36:30","2023-04-15 23:06:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681587390;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681587390;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-16 00:00:05","2023-04-16 03:30:05","0",NULL,"10"),
("10569","wc_admin_unsnooze_admin_notes","failed","2023-04-16 01:00:05","2023-04-16 04:30:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681606805;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681606805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-16 10:17:52","2023-04-16 13:47:52","0",NULL,"10"),
("10570","wc_admin_unsnooze_admin_notes","failed","2023-04-16 11:17:52","2023-04-16 14:47:52","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681643872;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681643872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-16 13:04:42","2023-04-16 16:34:42","0",NULL,"10"),
("10571","wc_admin_unsnooze_admin_notes","failed","2023-04-16 14:04:42","2023-04-16 17:34:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681653882;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681653882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-16 15:37:11","2023-04-16 19:07:11","0",NULL,"10"),
("10572","wc_admin_unsnooze_admin_notes","failed","2023-04-16 16:37:11","2023-04-16 20:07:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681663031;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681663031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-17 04:30:33","2023-04-17 08:00:33","0",NULL,"10"),
("10574","wc_admin_unsnooze_admin_notes","failed","2023-04-17 05:30:33","2023-04-17 09:00:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681709433;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681709433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-17 08:28:53","2023-04-17 11:58:53","0",NULL,"10"),
("10575","wc_admin_unsnooze_admin_notes","failed","2023-04-17 09:28:53","2023-04-17 12:58:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681723733;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681723733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-17 10:34:14","2023-04-17 14:04:14","0",NULL,"10"),
("10576","wc_admin_unsnooze_admin_notes","failed","2023-04-17 11:34:14","2023-04-17 15:04:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681731254;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681731254;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-17 13:09:50","2023-04-17 16:39:50","0",NULL,"10"),
("10577","wc_admin_unsnooze_admin_notes","failed","2023-04-17 14:09:50","2023-04-17 17:39:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681740590;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681740590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-17 14:11:14","2023-04-17 17:41:14","0",NULL,"10"),
("10578","wc_admin_unsnooze_admin_notes","failed","2023-04-17 15:11:14","2023-04-17 18:41:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681744274;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681744274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-17 22:44:14","2023-04-18 02:14:14","0",NULL,"10"),
("10579","wc_admin_unsnooze_admin_notes","failed","2023-04-17 23:44:14","2023-04-18 03:14:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681775054;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681775054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-18 05:23:29","2023-04-18 08:53:29","0",NULL,"10"),
("10581","wc_admin_unsnooze_admin_notes","failed","2023-04-18 06:23:29","2023-04-18 09:53:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681799009;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681799009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-18 06:54:12","2023-04-18 10:24:12","0",NULL,"10"),
("10582","wc_admin_unsnooze_admin_notes","failed","2023-04-18 07:54:12","2023-04-18 11:24:12","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681804452;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681804452;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-18 09:23:40","2023-04-18 12:53:40","0",NULL,"10"),
("10583","wc_admin_unsnooze_admin_notes","failed","2023-04-18 10:23:40","2023-04-18 13:53:40","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681813420;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681813420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-18 11:23:07","2023-04-18 14:53:07","0",NULL,"10"),
("10584","wc_admin_unsnooze_admin_notes","failed","2023-04-18 12:23:07","2023-04-18 15:53:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681820587;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681820587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-18 13:13:39","2023-04-18 16:43:39","0",NULL,"10"),
("10585","wc_admin_unsnooze_admin_notes","failed","2023-04-18 14:13:39","2023-04-18 17:43:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681827219;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681827219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-18 14:16:59","2023-04-18 17:46:59","0",NULL,"10"),
("10586","wc_admin_unsnooze_admin_notes","failed","2023-04-18 15:16:59","2023-04-18 18:46:59","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681831019;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681831019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-18 18:51:43","2023-04-18 22:21:43","0",NULL,"10"),
("10587","wc_admin_unsnooze_admin_notes","failed","2023-04-18 19:51:43","2023-04-18 23:21:43","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681847503;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681847503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-19 03:36:16","2023-04-19 07:06:16","0",NULL,"10"),
("10588","wc_admin_unsnooze_admin_notes","failed","2023-04-19 04:36:16","2023-04-19 08:06:16","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681878976;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681878976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-19 05:22:21","2023-04-19 08:52:21","0",NULL,"10"),
("10590","wc_admin_unsnooze_admin_notes","failed","2023-04-19 06:22:21","2023-04-19 09:52:21","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681885341;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681885341;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-19 12:55:58","2023-04-19 16:25:58","0",NULL,"10"),
("10591","wc_admin_unsnooze_admin_notes","failed","2023-04-19 13:55:58","2023-04-19 17:25:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681912558;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681912558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-19 19:16:23","2023-04-19 22:46:23","0",NULL,"10"),
("10592","wc_admin_unsnooze_admin_notes","failed","2023-04-19 20:16:23","2023-04-19 23:46:23","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681935383;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681935383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-19 23:46:28","2023-04-20 03:16:28","0",NULL,"10"),
("10593","wc_admin_unsnooze_admin_notes","failed","2023-04-20 00:46:28","2023-04-20 04:16:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681951588;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681951588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 00:51:38","2023-04-20 04:21:38","0",NULL,"10"),
("10594","wc_admin_unsnooze_admin_notes","failed","2023-04-20 01:51:38","2023-04-20 05:21:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681955498;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681955498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 05:33:58","2023-04-20 09:03:58","0",NULL,"10"),
("10595","wc_admin_unsnooze_admin_notes","failed","2023-04-20 06:33:58","2023-04-20 10:03:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681972438;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681972438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 07:38:01","2023-04-20 11:08:01","0",NULL,"10"),
("10597","wc_admin_unsnooze_admin_notes","failed","2023-04-20 08:38:01","2023-04-20 12:08:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681979881;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681979881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 09:40:48","2023-04-20 13:10:48","0",NULL,"10"),
("10598","wc_admin_unsnooze_admin_notes","failed","2023-04-20 10:40:48","2023-04-20 14:10:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681987248;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681987248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 12:24:09","2023-04-20 15:54:09","0",NULL,"10"),
("10599","wc_admin_unsnooze_admin_notes","failed","2023-04-20 13:24:09","2023-04-20 16:54:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681997049;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681997049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 15:17:38","2023-04-20 18:47:38","0",NULL,"10"),
("10600","wc_admin_unsnooze_admin_notes","failed","2023-04-20 16:17:38","2023-04-20 19:47:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682007458;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682007458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 16:52:34","2023-04-20 20:22:34","0",NULL,"10"),
("10601","wc_admin_unsnooze_admin_notes","failed","2023-04-20 17:52:34","2023-04-20 21:22:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682013154;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682013154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 22:28:06","2023-04-21 01:58:06","0",NULL,"10"),
("10602","wc_admin_unsnooze_admin_notes","failed","2023-04-20 23:28:06","2023-04-21 02:58:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682033286;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682033286;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-20 23:43:01","2023-04-21 03:13:01","0",NULL,"10"),
("10603","wc_admin_unsnooze_admin_notes","failed","2023-04-21 00:43:01","2023-04-21 04:13:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682037781;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682037781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-21 03:33:05","2023-04-21 07:03:05","0",NULL,"10"),
("10604","wc_admin_unsnooze_admin_notes","failed","2023-04-21 04:33:05","2023-04-21 08:03:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682051585;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682051585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-21 05:24:10","2023-04-21 08:54:10","0",NULL,"10"),
("10605","wc_admin_unsnooze_admin_notes","failed","2023-04-21 06:24:10","2023-04-21 09:54:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682058250;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682058250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-21 09:44:36","2023-04-21 13:14:36","0",NULL,"10"),
("10607","wc_admin_unsnooze_admin_notes","failed","2023-04-21 10:44:36","2023-04-21 14:14:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682073876;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682073876;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-21 13:27:30","2023-04-21 16:57:30","0",NULL,"10"),
("10608","wc_admin_unsnooze_admin_notes","failed","2023-04-21 14:27:30","2023-04-21 17:57:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682087250;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682087250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-21 14:43:18","2023-04-21 18:13:18","0",NULL,"10"),
("10609","wc_admin_unsnooze_admin_notes","failed","2023-04-21 15:43:18","2023-04-21 19:13:18","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682091798;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682091798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-21 21:19:45","2023-04-22 00:49:45","0",NULL,"10"),
("10610","wc_admin_unsnooze_admin_notes","failed","2023-04-21 22:19:45","2023-04-22 01:49:45","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682115585;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682115585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 01:17:32","2023-04-22 04:47:32","0",NULL,"10"),
("10611","wc_admin_unsnooze_admin_notes","failed","2023-04-22 02:17:32","2023-04-22 05:47:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682129852;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682129852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 04:35:51","2023-04-22 08:05:51","0",NULL,"10"),
("10612","wc_admin_unsnooze_admin_notes","failed","2023-04-22 05:35:51","2023-04-22 09:05:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682141751;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682141751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 05:56:09","2023-04-22 09:26:09","0",NULL,"10"),
("10613","wc_admin_unsnooze_admin_notes","failed","2023-04-22 06:56:09","2023-04-22 10:26:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682146569;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682146569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 08:37:06","2023-04-22 12:07:06","0",NULL,"10"),
("10614","wc_admin_unsnooze_admin_notes","failed","2023-04-22 09:37:06","2023-04-22 13:07:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682156226;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682156226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 10:38:36","2023-04-22 14:08:36","0",NULL,"10"),
("10615","wc_admin_unsnooze_admin_notes","failed","2023-04-22 11:38:36","2023-04-22 15:08:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682163516;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682163516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 13:16:50","2023-04-22 16:46:50","0",NULL,"10"),
("10617","wc_admin_unsnooze_admin_notes","failed","2023-04-22 14:16:50","2023-04-22 17:46:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682173010;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682173010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 15:14:06","2023-04-22 18:44:06","0",NULL,"10"),
("10618","wc_admin_unsnooze_admin_notes","failed","2023-04-22 16:14:06","2023-04-22 19:44:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682180046;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682180046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 16:30:56","2023-04-22 20:00:56","0",NULL,"10"),
("10619","wc_admin_unsnooze_admin_notes","failed","2023-04-22 17:30:56","2023-04-22 21:00:56","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682184656;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682184656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 20:29:35","2023-04-22 23:59:35","0",NULL,"10"),
("10620","wc_admin_unsnooze_admin_notes","failed","2023-04-22 21:29:35","2023-04-23 00:59:35","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682198975;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682198975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-22 22:12:29","2023-04-23 01:42:29","0",NULL,"10"),
("10621","wc_admin_unsnooze_admin_notes","failed","2023-04-22 23:12:29","2023-04-23 02:42:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682205149;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682205149;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-23 03:41:21","2023-04-23 07:11:21","0",NULL,"10"),
("10622","wc_admin_unsnooze_admin_notes","failed","2023-04-23 04:41:21","2023-04-23 08:11:21","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682224881;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682224881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-23 07:28:56","2023-04-23 10:58:56","0",NULL,"10"),
("10623","wc_admin_unsnooze_admin_notes","failed","2023-04-23 08:28:56","2023-04-23 11:58:56","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682238536;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682238536;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-23 11:51:20","2023-04-23 15:21:20","0",NULL,"10"),
("10624","wc_admin_unsnooze_admin_notes","failed","2023-04-23 12:51:20","2023-04-23 16:21:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682254280;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682254280;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-23 14:23:30","2023-04-23 17:53:30","0",NULL,"10"),
("10626","wc_admin_unsnooze_admin_notes","failed","2023-04-23 15:23:30","2023-04-23 18:53:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1682263410;s:18:\"\0*\0first_timestamp\";i:1586244803;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1682263410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","2","1","2023-04-23 16:29:21","2023-04-23 19:59:21","0",NULL,"10"),
("11277","woocommerce_cleanup_draft_orders","failed","2024-09-13 17:17:22","2024-09-13 20:47:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726247842;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726247842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-13 17:37:55","2024-09-13 21:07:55","0",NULL,"10"),
("11280","woocommerce_cleanup_draft_orders","failed","2024-09-14 17:37:55","2024-09-14 21:07:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726335475;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726335475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-15 10:13:42","2024-09-15 13:43:42","0",NULL,"10"),
("11281","rank_math/analytics/workflow","failed","2024-09-13 17:39:02","2024-09-13 17:39:02","[\"analytics\",90,null,null]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2024-09-13 17:39:54","2024-09-13 21:09:54","0",NULL,"10"),
("11282","rank_math/analytics/workflow","failed","2024-09-13 17:39:02","2024-09-13 17:39:02","[\"adsense\",90,null,null]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2024-09-13 17:39:54","2024-09-13 21:09:54","0",NULL,"10"),
("11283","rank_math/analytics/data_fetch","failed","2024-09-14 08:31:00","2024-09-14 12:01:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726302660;s:18:\"\0*\0first_timestamp\";i:1726302660;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726302660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-09-14 12:43:04","2024-09-14 16:13:04","0",NULL,"10");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("11285","rank_math/analytics/workflow","failed","2024-09-13 18:20:53","2024-09-13 18:20:53","[\"analytics\",90,null,null]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2024-09-13 18:20:53","2024-09-13 21:50:53","0",NULL,"10"),
("11286","rank_math/analytics/workflow","failed","2024-09-13 18:20:53","2024-09-13 18:20:53","[\"adsense\",90,null,null]","O:28:\"ActionScheduler_NullSchedule\":0:{}","7","1","2024-09-13 18:20:53","2024-09-13 21:50:53","0",NULL,"10"),
("11288","rank_math/analytics/data_fetch","failed","2024-09-17 12:43:04","2024-09-17 16:13:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726576984;s:18:\"\0*\0first_timestamp\";i:1726302660;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726576984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-09-17 16:26:09","2024-09-17 19:56:09","0",NULL,"10"),
("11289","woocommerce_cleanup_draft_orders","failed","2024-09-16 10:13:42","2024-09-16 13:43:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726481622;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726481622;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-16 13:04:02","2024-09-16 16:34:02","0",NULL,"10"),
("11290","woocommerce_cleanup_draft_orders","failed","2024-09-17 13:04:02","2024-09-17 16:34:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726578242;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726578242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-17 16:26:09","2024-09-17 19:56:09","0",NULL,"10"),
("11291","rank_math/analytics/data_fetch","failed","2024-09-20 16:26:09","2024-09-20 19:56:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726849569;s:18:\"\0*\0first_timestamp\";i:1726302660;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726849569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-09-21 02:26:36","2024-09-21 05:56:36","0",NULL,"10"),
("11292","woocommerce_cleanup_draft_orders","failed","2024-09-18 16:26:09","2024-09-18 19:56:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726676769;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726676769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-18 21:09:53","2024-09-19 00:39:53","0",NULL,"10"),
("11293","woocommerce_cleanup_draft_orders","failed","2024-09-19 21:09:53","2024-09-20 00:39:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726780193;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726780193;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-20 01:35:29","2024-09-20 05:05:29","0",NULL,"10"),
("11294","woocommerce_cleanup_draft_orders","failed","2024-09-21 01:35:29","2024-09-21 05:05:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726882529;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726882529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-21 02:26:36","2024-09-21 05:56:36","0",NULL,"10"),
("11295","rank_math/analytics/data_fetch","failed","2024-09-24 02:26:36","2024-09-24 05:56:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727144796;s:18:\"\0*\0first_timestamp\";i:1726302660;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727144796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-09-24 07:12:52","2024-09-24 10:42:52","0",NULL,"10"),
("11296","woocommerce_cleanup_draft_orders","failed","2024-09-22 02:26:36","2024-09-22 05:56:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726971996;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726971996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-22 08:38:05","2024-09-22 12:08:05","0",NULL,"10"),
("11297","woocommerce_cleanup_draft_orders","failed","2024-09-23 08:38:05","2024-09-23 12:08:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727080685;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727080685;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-23 08:38:16","2024-09-23 12:08:16","0",NULL,"10"),
("11298","woocommerce_cleanup_draft_orders","failed","2024-09-24 08:38:16","2024-09-24 12:08:16","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727167096;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727167096;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-24 08:38:54","2024-09-24 12:08:54","0",NULL,"10"),
("11302","action_scheduler/migration_hook","failed","2024-09-23 18:56:56","2024-09-23 22:26:56","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727117816;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727117816;}","1","1","2024-09-23 18:56:56","2024-09-23 22:26:56","0",NULL,"10"),
("11304","woocommerce_cleanup_draft_orders","failed","2024-09-25 08:38:54","2024-09-25 12:08:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727253534;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727253534;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-25 09:32:58","2024-09-25 13:02:58","0",NULL,"10"),
("11305","woocommerce_cleanup_draft_orders","failed","2024-09-26 09:32:58","2024-09-26 13:02:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727343178;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727343178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-26 10:28:44","2024-09-26 13:58:44","0",NULL,"10"),
("11306","woocommerce_cleanup_draft_orders","failed","2024-09-27 10:28:44","2024-09-27 13:58:44","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727432924;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727432924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-27 13:04:35","2024-09-27 16:34:35","0",NULL,"10"),
("11308","woocommerce_cleanup_draft_orders","failed","2024-09-28 13:04:35","2024-09-28 16:34:35","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727528675;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727528675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-09-30 00:13:28","2024-09-30 03:43:28","0",NULL,"10"),
("11309","woocommerce_cleanup_draft_orders","failed","2024-10-01 00:13:28","2024-10-01 03:43:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727741608;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727741608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-01 03:00:29","2024-10-01 06:30:29","0",NULL,"10"),
("11311","woocommerce_cleanup_draft_orders","failed","2024-10-02 03:00:29","2024-10-02 06:30:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727838029;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727838029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-02 05:22:00","2024-10-02 08:52:00","0",NULL,"10"),
("11312","woocommerce_cleanup_draft_orders","failed","2024-10-03 05:22:00","2024-10-03 08:52:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727932920;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727932920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-03 07:22:09","2024-10-03 10:52:09","0",NULL,"10"),
("11313","woocommerce_cleanup_draft_orders","failed","2024-10-04 07:22:09","2024-10-04 10:52:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728026529;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728026529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-04 09:15:51","2024-10-04 12:45:51","0",NULL,"10"),
("11315","woocommerce_cleanup_draft_orders","failed","2024-10-05 09:15:51","2024-10-05 12:45:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728119751;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728119751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-05 15:34:04","2024-10-05 19:04:04","0",NULL,"10"),
("11316","woocommerce_cleanup_draft_orders","failed","2024-10-06 15:34:04","2024-10-06 19:04:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728228844;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728228844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-06 17:01:58","2024-10-06 20:31:58","0",NULL,"10"),
("11317","woocommerce_cleanup_draft_orders","failed","2024-10-07 17:01:58","2024-10-07 20:31:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728320518;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728320518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-07 17:52:40","2024-10-07 21:22:40","0",NULL,"10"),
("11319","woocommerce_cleanup_draft_orders","failed","2024-10-08 17:52:40","2024-10-08 21:22:40","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728409960;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728409960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-08 17:56:04","2024-10-08 21:26:04","0",NULL,"10"),
("11320","woocommerce_cleanup_draft_orders","failed","2024-10-09 17:56:04","2024-10-09 21:26:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728496564;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728496564;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-10 01:12:57","2024-10-10 04:42:57","0",NULL,"10"),
("11321","woocommerce_cleanup_draft_orders","failed","2024-10-11 01:12:57","2024-10-11 04:42:57","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728609177;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728609177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-11 02:46:30","2024-10-11 06:16:30","0",NULL,"10"),
("11322","rank_math/analytics/data_fetch","failed","2024-10-13 12:55:50","2024-10-13 16:25:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728824150;s:18:\"\0*\0first_timestamp\";i:1726302660;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728824150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-10-14 06:40:22","2024-10-14 10:10:22","0",NULL,"10"),
("11323","woocommerce_cleanup_draft_orders","failed","2024-10-12 02:46:30","2024-10-12 06:16:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728701190;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728701190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-12 02:59:50","2024-10-12 06:29:50","0",NULL,"10"),
("11324","woocommerce_cleanup_draft_orders","failed","2024-10-13 02:59:50","2024-10-13 06:29:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728788390;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728788390;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-13 03:37:10","2024-10-13 07:07:10","0",NULL,"10"),
("11325","woocommerce_cleanup_draft_orders","failed","2024-10-14 03:37:10","2024-10-14 07:07:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728877030;s:18:\"\0*\0first_timestamp\";i:1655691173;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728877030;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","6","1","2024-10-14 06:40:22","2024-10-14 10:10:22","0",NULL,"10"),
("11343","rank_math/analytics/data_fetch","failed","2024-12-07 22:32:08","2024-12-08 02:02:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733610728;s:18:\"\0*\0first_timestamp\";i:1726302660;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733610728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2024-12-08 00:29:05","2024-12-08 03:59:05","0",NULL,"10"),
("11353","action_scheduler/migration_hook","failed","2025-04-16 21:09:04","2025-04-17 01:39:04","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1744837744;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1744837744;}","1","1","2025-04-16 21:09:05","2025-04-17 01:39:05","0",NULL,"10"),
("11731","rank_math/analytics/data_fetch","failed","2025-07-28 09:49:26","2025-07-28 14:19:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753696166;s:18:\"\0*\0first_timestamp\";i:1744862400;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753696166;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2026-01-21 07:05:28","2026-01-21 10:35:28","0",NULL,"10"),
("11739","action_scheduler/migration_hook","complete","2026-01-21 07:08:38","2026-01-21 10:38:38","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768979318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768979318;}","1","1","2026-01-21 07:09:29","2026-01-21 10:39:29","0",NULL,"10"),
("11740","action_scheduler/migration_hook","failed","2026-01-21 07:10:36","2026-01-21 10:40:36","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768979436;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768979436;}","1","1","2026-01-21 07:11:16","2026-01-21 10:41:16","0",NULL,"10"),
("11742","rocket_job_warmup","complete","2026-01-21 07:09:53","2026-01-21 07:09:53","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:10:50","2026-01-21 10:40:50","0",NULL,"10"),
("11743","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/privacy-policy\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:11:37","2026-01-21 10:41:37","0",NULL,"10"),
("11744","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/sign-up\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:11:42","2026-01-21 10:41:42","0",NULL,"10"),
("11745","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/app\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:11:44","2026-01-21 10:41:44","0",NULL,"10"),
("11746","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:12:08","2026-01-21 10:42:08","0",NULL,"10"),
("11747","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/melbet.apk\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:12:10","2026-01-21 10:42:10","0",NULL,"10"),
("11748","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/contact\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:12:31","2026-01-21 10:42:31","0",NULL,"10"),
("11749","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/aboutus\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:12:33","2026-01-21 10:42:33","0",NULL,"10"),
("11750","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/champions-league\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:12:36","2026-01-21 10:42:36","0",NULL,"10"),
("11751","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/fast-game-wednesday\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:12:49","2026-01-21 10:42:49","0",NULL,"10"),
("11752","rocket_job_warmup_url","complete","2026-01-21 07:10:50","2026-01-21 07:10:50","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/deposit-series\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:12:59","2026-01-21 10:42:59","0",NULL,"10"),
("11753","action_scheduler/migration_hook","complete","2026-01-21 07:14:55","2026-01-21 10:44:55","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768979695;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768979695;}","1","1","2026-01-21 07:15:06","2026-01-21 10:45:06","0",NULL,"10"),
("11760","action_scheduler/migration_hook","complete","2026-01-21 07:16:13","2026-01-21 10:46:13","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768979773;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768979773;}","1","1","2026-01-21 07:17:31","2026-01-21 10:47:31","0",NULL,"10"),
("11772","rocket_job_warmup","complete","2026-01-21 07:18:41","2026-01-21 07:18:41","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:19:45","2026-01-21 10:49:45","0",NULL,"10"),
("11774","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/privacy-policy\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:19:50","2026-01-21 10:49:50","0",NULL,"10"),
("11775","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/sign-up\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:02","2026-01-21 10:50:02","0",NULL,"10"),
("11776","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/app\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:02","2026-01-21 10:50:02","0",NULL,"10"),
("11777","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:03","2026-01-21 10:50:03","0",NULL,"10"),
("11778","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/melbet.apk\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:04","2026-01-21 10:50:04","0",NULL,"10"),
("11779","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/contact\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:07","2026-01-21 10:50:07","0",NULL,"10"),
("11780","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/aboutus\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:07","2026-01-21 10:50:07","0",NULL,"10"),
("11781","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/champions-league\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:07","2026-01-21 10:50:07","0",NULL,"10"),
("11782","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/fast-game-wednesday\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:08","2026-01-21 10:50:08","0",NULL,"10"),
("11783","rocket_job_warmup_url","complete","2026-01-21 07:19:45","2026-01-21 07:19:45","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/deposit-series\\/\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","9","1","2026-01-21 07:20:09","2026-01-21 10:50:09","0",NULL,"10"),
("11824","action_scheduler/migration_hook","complete","2026-01-21 07:33:31","2026-01-21 11:03:31","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768980811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768980811;}","1","1","2026-01-21 07:33:58","2026-01-21 11:03:58","0",NULL,"10"),
("11885","action_scheduler/migration_hook","complete","2026-01-23 13:58:09","2026-01-23 17:28:09","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769176689;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769176689;}","1","1","2026-01-23 13:58:14","2026-01-23 17:28:14","0",NULL,"10"),
("11937","action_scheduler/migration_hook","complete","2026-01-23 14:33:12","2026-01-23 18:03:12","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769178792;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769178792;}","1","1","2026-01-23 14:34:05","2026-01-23 18:04:05","0",NULL,"10"),
("11950","action_scheduler/migration_hook","failed","2026-01-23 14:35:05","2026-01-23 18:05:05","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769178905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769178905;}","1","1","2026-01-23 14:35:11","2026-01-23 18:05:11","0",NULL,"10"),
("12046","rocket_preload_job_check_finished","pending","2026-01-29 13:00:31","2026-01-29 16:30:31","[1769691571]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769691631;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769691631;}","8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("12047","rocket_preload_job_preload_url","complete","2026-01-29 12:59:40","2026-01-29 12:59:40","[\"http:\\/\\/web102.sa-farhood.ir\\/privacy-policy\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","1","2026-01-29 13:00:07","2026-01-29 16:30:07","0",NULL,"10"),
("12048","rocket_preload_job_preload_url","complete","2026-01-29 12:59:40","2026-01-29 12:59:40","[\"http:\\/\\/web102.sa-farhood.ir\\/sign-up\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","1","2026-01-29 13:00:09","2026-01-29 16:30:09","0",NULL,"10"),
("12049","rocket_preload_job_preload_url","complete","2026-01-29 12:59:40","2026-01-29 12:59:40","[\"http:\\/\\/web102.sa-farhood.ir\\/app\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","1","2026-01-29 13:00:10","2026-01-29 16:30:10","0",NULL,"10"),
("12050","rocket_preload_job_preload_url","complete","2026-01-29 12:59:40","2026-01-29 12:59:40","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","1","2026-01-29 13:00:12","2026-01-29 16:30:12","0",NULL,"10"),
("12051","rocket_preload_job_preload_url","complete","2026-01-29 12:59:40","2026-01-29 12:59:40","[\"http:\\/\\/web102.sa-farhood.ir\\/contact\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","1","2026-01-29 13:00:13","2026-01-29 16:30:13","0",NULL,"10"),
("12052","rocket_preload_job_preload_url","pending","2026-01-29 13:00:22","2026-01-29 13:00:22","[\"http:\\/\\/web102.sa-farhood.ir\\/aboutus\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("12053","rocket_preload_job_preload_url","pending","2026-01-29 13:00:22","2026-01-29 13:00:22","[\"http:\\/\\/web102.sa-farhood.ir\\/bonus\\/first-deposit\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("12054","rocket_preload_job_preload_url","pending","2026-01-29 13:00:22","2026-01-29 13:00:22","[\"http:\\/\\/web102.sa-farhood.ir\\/aboutus\\/team\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("12055","rocket_preload_job_preload_url","pending","2026-01-29 13:00:22","2026-01-29 13:00:22","[\"http:\\/\\/web102.sa-farhood.ir\\/blog\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("12056","rocket_preload_job_preload_url","pending","2026-01-29 13:00:22","2026-01-29 13:00:22","[\"https:\\/\\/web102.sa-farhood.ir\\/app\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("12057","rocket_preload_job_preload_url","pending","2026-01-29 13:00:22","2026-01-29 13:00:22","[\"https:\\/\\/web102.sa-farhood.ir\\/privacy-policy\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("12058","rocket_preload_job_preload_url","pending","2026-01-29 13:00:22","2026-01-29 13:00:22","[\"https:\\/\\/web102.sa-farhood.ir\\/blog\\/author\\/farhood\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10");

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","wc-admin-notes"),
("3","woocommerce-db-updates"),
("4","wc_update_product_lookup_tables"),
("5","wc-admin-data"),
("6",""),
("7","rank-math"),
("8","rocket-preload"),
("9","rocket-performance-hints-warmup");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("27239","10329","ایجاد فعالیت","2023-03-23 15:20:30","2023-03-23 18:50:30"),
("27245","10329","عملیات توسط WP Cron شروع شد","2023-03-23 17:32:59","2023-03-23 21:02:59"),
("27246","10329","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-23 17:32:59","2023-03-23 21:02:59"),
("27247","10331","ایجاد فعالیت","2023-03-23 17:32:59","2023-03-23 21:02:59"),
("27251","10331","عملیات توسط WP Cron شروع شد","2023-03-23 18:45:58","2023-03-23 22:15:58"),
("27252","10331","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-23 18:45:58","2023-03-23 22:15:58"),
("27253","10333","ایجاد فعالیت","2023-03-23 18:45:58","2023-03-23 22:15:58"),
("27254","10333","عملیات توسط WP Cron شروع شد","2023-03-23 21:45:47","2023-03-24 01:15:47"),
("27255","10333","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-23 21:45:47","2023-03-24 01:15:47"),
("27256","10334","ایجاد فعالیت","2023-03-23 21:45:47","2023-03-24 01:15:47"),
("27257","10334","عملیات توسط WP Cron شروع شد","2023-03-23 23:39:00","2023-03-24 03:09:00"),
("27258","10334","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-23 23:39:00","2023-03-24 03:09:00"),
("27259","10335","ایجاد فعالیت","2023-03-23 23:39:00","2023-03-24 03:09:00"),
("27260","10335","عملیات توسط WP Cron شروع شد","2023-03-24 01:28:22","2023-03-24 04:58:22"),
("27261","10335","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-24 01:28:22","2023-03-24 04:58:22"),
("27262","10336","ایجاد فعالیت","2023-03-24 01:28:22","2023-03-24 04:58:22"),
("27263","10336","عملیات توسط WP Cron شروع شد","2023-03-24 04:43:19","2023-03-24 08:13:19"),
("27264","10336","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-24 04:43:19","2023-03-24 08:13:19"),
("27265","10337","ایجاد فعالیت","2023-03-24 04:43:19","2023-03-24 08:13:19"),
("27266","10337","عملیات توسط WP Cron شروع شد","2023-03-24 07:38:10","2023-03-24 11:08:10"),
("27267","10337","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-24 07:38:10","2023-03-24 11:08:10"),
("27268","10338","ایجاد فعالیت","2023-03-24 07:38:10","2023-03-24 11:08:10"),
("27269","10338","عملیات توسط WP Cron شروع شد","2023-03-24 08:45:40","2023-03-24 12:15:40"),
("27270","10338","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-24 08:45:40","2023-03-24 12:15:40"),
("27271","10339","ایجاد فعالیت","2023-03-24 08:45:40","2023-03-24 12:15:40"),
("27272","10339","عملیات توسط WP Cron شروع شد","2023-03-24 10:06:53","2023-03-24 13:36:53"),
("27273","10339","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-24 10:06:53","2023-03-24 13:36:53"),
("27274","10340","ایجاد فعالیت","2023-03-24 10:06:53","2023-03-24 13:36:53"),
("27275","10340","عملیات توسط WP Cron شروع شد","2023-03-24 11:14:25","2023-03-24 14:44:25"),
("27276","10340","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-24 11:14:25","2023-03-24 14:44:25"),
("27277","10341","ایجاد فعالیت","2023-03-24 11:14:25","2023-03-24 14:44:25"),
("27278","10341","عملیات توسط WP Cron شروع شد","2023-03-24 16:01:01","2023-03-24 19:31:01"),
("27279","10341","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-24 16:01:01","2023-03-24 19:31:01"),
("27280","10342","ایجاد فعالیت","2023-03-24 16:01:01","2023-03-24 19:31:01"),
("27284","10342","عملیات توسط WP Cron شروع شد","2023-03-24 20:00:25","2023-03-24 23:30:25"),
("27285","10342","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-24 20:00:25","2023-03-24 23:30:25"),
("27286","10344","ایجاد فعالیت","2023-03-24 20:00:25","2023-03-24 23:30:25"),
("27287","10344","عملیات توسط WP Cron شروع شد","2023-03-25 00:14:13","2023-03-25 03:44:13"),
("27288","10344","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 00:14:13","2023-03-25 03:44:13"),
("27289","10345","ایجاد فعالیت","2023-03-25 00:14:13","2023-03-25 03:44:13"),
("27290","10345","عملیات توسط WP Cron شروع شد","2023-03-25 03:44:48","2023-03-25 07:14:48"),
("27291","10345","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 03:44:48","2023-03-25 07:14:48"),
("27292","10346","ایجاد فعالیت","2023-03-25 03:44:48","2023-03-25 07:14:48"),
("27293","10346","عملیات توسط WP Cron شروع شد","2023-03-25 08:28:34","2023-03-25 11:58:34"),
("27294","10346","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 08:28:34","2023-03-25 11:58:34"),
("27295","10347","ایجاد فعالیت","2023-03-25 08:28:34","2023-03-25 11:58:34"),
("27296","10347","عملیات توسط WP Cron شروع شد","2023-03-25 10:57:00","2023-03-25 14:27:00"),
("27297","10347","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 10:57:00","2023-03-25 14:27:00"),
("27298","10348","ایجاد فعالیت","2023-03-25 10:57:00","2023-03-25 14:27:00"),
("27299","10348","عملیات توسط WP Cron شروع شد","2023-03-25 13:13:51","2023-03-25 16:43:51"),
("27300","10348","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 13:13:51","2023-03-25 16:43:51"),
("27301","10349","ایجاد فعالیت","2023-03-25 13:13:51","2023-03-25 16:43:51"),
("27302","10349","عملیات توسط WP Cron شروع شد","2023-03-25 17:08:33","2023-03-25 20:38:33"),
("27303","10349","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 17:08:33","2023-03-25 20:38:33"),
("27304","10350","ایجاد فعالیت","2023-03-25 17:08:33","2023-03-25 20:38:33"),
("27305","10350","عملیات توسط WP Cron شروع شد","2023-03-25 21:06:49","2023-03-26 00:36:49"),
("27306","10350","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 21:06:49","2023-03-26 00:36:49"),
("27307","10351","ایجاد فعالیت","2023-03-25 21:06:49","2023-03-26 00:36:49"),
("27311","10351","عملیات توسط WP Cron شروع شد","2023-03-25 22:06:58","2023-03-26 01:36:58"),
("27312","10351","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 22:06:58","2023-03-26 01:36:58"),
("27313","10353","ایجاد فعالیت","2023-03-25 22:06:58","2023-03-26 01:36:58"),
("27314","10353","عملیات توسط WP Cron شروع شد","2023-03-25 23:45:48","2023-03-26 03:15:48"),
("27315","10353","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-25 23:45:48","2023-03-26 03:15:48"),
("27316","10354","ایجاد فعالیت","2023-03-25 23:45:48","2023-03-26 03:15:48"),
("27317","10354","عملیات توسط WP Cron شروع شد","2023-03-26 03:30:01","2023-03-26 07:00:01"),
("27318","10354","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 03:30:01","2023-03-26 07:00:01"),
("27319","10355","ایجاد فعالیت","2023-03-26 03:30:01","2023-03-26 07:00:01"),
("27320","10355","عملیات توسط WP Cron شروع شد","2023-03-26 07:40:52","2023-03-26 11:10:52"),
("27321","10355","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 07:40:52","2023-03-26 11:10:52"),
("27322","10356","ایجاد فعالیت","2023-03-26 07:40:52","2023-03-26 11:10:52"),
("27323","10356","عملیات توسط WP Cron شروع شد","2023-03-26 08:46:02","2023-03-26 12:16:02"),
("27324","10356","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 08:46:02","2023-03-26 12:16:02"),
("27325","10357","ایجاد فعالیت","2023-03-26 08:46:02","2023-03-26 12:16:02"),
("27326","10357","عملیات توسط WP Cron شروع شد","2023-03-26 10:15:09","2023-03-26 13:45:09"),
("27327","10357","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 10:15:09","2023-03-26 13:45:09"),
("27328","10358","ایجاد فعالیت","2023-03-26 10:15:09","2023-03-26 13:45:09"),
("27329","10358","عملیات توسط WP Cron شروع شد","2023-03-26 11:26:43","2023-03-26 14:56:43"),
("27330","10358","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 11:26:43","2023-03-26 14:56:43"),
("27331","10359","ایجاد فعالیت","2023-03-26 11:26:43","2023-03-26 14:56:43"),
("27332","10359","عملیات توسط WP Cron شروع شد","2023-03-26 17:27:27","2023-03-26 20:57:27"),
("27333","10359","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 17:27:27","2023-03-26 20:57:27"),
("27334","10360","ایجاد فعالیت","2023-03-26 17:27:27","2023-03-26 20:57:27"),
("27335","10360","عملیات توسط WP Cron شروع شد","2023-03-26 18:36:00","2023-03-26 22:06:00"),
("27336","10360","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 18:36:00","2023-03-26 22:06:00"),
("27337","10361","ایجاد فعالیت","2023-03-26 18:36:00","2023-03-26 22:06:00"),
("27338","10361","عملیات توسط WP Cron شروع شد","2023-03-26 19:39:45","2023-03-26 23:09:45"),
("27339","10361","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 19:39:45","2023-03-26 23:09:45"),
("27340","10362","ایجاد فعالیت","2023-03-26 19:39:45","2023-03-26 23:09:45"),
("27341","10362","عملیات توسط WP Cron شروع شد","2023-03-26 21:04:02","2023-03-27 00:34:02"),
("27342","10362","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-26 21:04:02","2023-03-27 00:34:02"),
("27343","10363","ایجاد فعالیت","2023-03-26 21:04:02","2023-03-27 00:34:02"),
("27347","10363","عملیات توسط WP Cron شروع شد","2023-03-27 01:36:58","2023-03-27 05:06:58"),
("27348","10363","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 01:36:58","2023-03-27 05:06:58"),
("27349","10365","ایجاد فعالیت","2023-03-27 01:36:58","2023-03-27 05:06:58"),
("27350","10365","عملیات توسط WP Cron شروع شد","2023-03-27 03:55:28","2023-03-27 07:25:28"),
("27351","10365","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 03:55:28","2023-03-27 07:25:28"),
("27352","10366","ایجاد فعالیت","2023-03-27 03:55:28","2023-03-27 07:25:28"),
("27353","10366","عملیات توسط WP Cron شروع شد","2023-03-27 04:56:26","2023-03-27 08:26:26"),
("27354","10366","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 04:56:26","2023-03-27 08:26:26"),
("27355","10367","ایجاد فعالیت","2023-03-27 04:56:26","2023-03-27 08:26:26"),
("27356","10367","عملیات توسط WP Cron شروع شد","2023-03-27 06:03:47","2023-03-27 09:33:47"),
("27357","10367","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 06:03:47","2023-03-27 09:33:47"),
("27358","10368","ایجاد فعالیت","2023-03-27 06:03:47","2023-03-27 09:33:47"),
("27359","10368","عملیات توسط WP Cron شروع شد","2023-03-27 07:04:06","2023-03-27 10:34:06"),
("27360","10368","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 07:04:06","2023-03-27 10:34:06"),
("27361","10369","ایجاد فعالیت","2023-03-27 07:04:06","2023-03-27 10:34:06"),
("27362","10369","عملیات توسط WP Cron شروع شد","2023-03-27 08:05:40","2023-03-27 11:35:40"),
("27363","10369","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 08:05:41","2023-03-27 11:35:41"),
("27364","10370","ایجاد فعالیت","2023-03-27 08:05:41","2023-03-27 11:35:41"),
("27365","10370","عملیات توسط WP Cron شروع شد","2023-03-27 09:06:54","2023-03-27 12:36:54"),
("27366","10370","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 09:06:54","2023-03-27 12:36:54"),
("27367","10371","ایجاد فعالیت","2023-03-27 09:06:54","2023-03-27 12:36:54"),
("27368","10371","عملیات توسط WP Cron شروع شد","2023-03-27 10:08:07","2023-03-27 13:38:07"),
("27369","10371","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 10:08:07","2023-03-27 13:38:07"),
("27370","10372","ایجاد فعالیت","2023-03-27 10:08:07","2023-03-27 13:38:07"),
("27371","10372","عملیات توسط WP Cron شروع شد","2023-03-27 11:11:03","2023-03-27 14:41:03"),
("27372","10372","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 11:11:03","2023-03-27 14:41:03"),
("27373","10373","ایجاد فعالیت","2023-03-27 11:11:03","2023-03-27 14:41:03"),
("27374","10373","عملیات توسط WP Cron شروع شد","2023-03-27 12:13:41","2023-03-27 15:43:41"),
("27375","10373","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 12:13:41","2023-03-27 15:43:41"),
("27376","10374","ایجاد فعالیت","2023-03-27 12:13:41","2023-03-27 15:43:41"),
("27377","10374","عملیات توسط WP Cron شروع شد","2023-03-27 13:14:34","2023-03-27 16:44:34"),
("27378","10374","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 13:14:34","2023-03-27 16:44:34"),
("27379","10375","ایجاد فعالیت","2023-03-27 13:14:34","2023-03-27 16:44:34"),
("27380","10375","عملیات توسط WP Cron شروع شد","2023-03-27 14:15:53","2023-03-27 17:45:53"),
("27381","10375","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 14:15:53","2023-03-27 17:45:53"),
("27382","10376","ایجاد فعالیت","2023-03-27 14:15:53","2023-03-27 17:45:53"),
("27383","10376","عملیات توسط WP Cron شروع شد","2023-03-27 15:16:04","2023-03-27 18:46:04"),
("27384","10376","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 15:16:04","2023-03-27 18:46:04"),
("27385","10377","ایجاد فعالیت","2023-03-27 15:16:04","2023-03-27 18:46:04"),
("27386","10377","عملیات توسط WP Cron شروع شد","2023-03-27 16:31:03","2023-03-27 20:01:03"),
("27387","10377","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 16:31:03","2023-03-27 20:01:03"),
("27388","10378","ایجاد فعالیت","2023-03-27 16:31:03","2023-03-27 20:01:03"),
("27389","10378","عملیات توسط WP Cron شروع شد","2023-03-27 17:45:39","2023-03-27 21:15:39"),
("27390","10378","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 17:45:39","2023-03-27 21:15:39"),
("27391","10379","ایجاد فعالیت","2023-03-27 17:45:39","2023-03-27 21:15:39"),
("27392","10379","عملیات توسط WP Cron شروع شد","2023-03-27 19:25:07","2023-03-27 22:55:07"),
("27393","10379","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 19:25:07","2023-03-27 22:55:07"),
("27394","10380","ایجاد فعالیت","2023-03-27 19:25:07","2023-03-27 22:55:07"),
("27395","10380","عملیات توسط WP Cron شروع شد","2023-03-27 20:25:27","2023-03-27 23:55:27"),
("27396","10380","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 20:25:27","2023-03-27 23:55:27"),
("27397","10381","ایجاد فعالیت","2023-03-27 20:25:27","2023-03-27 23:55:27"),
("27398","10381","عملیات توسط WP Cron شروع شد","2023-03-27 21:42:32","2023-03-28 01:12:32"),
("27399","10381","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 21:42:32","2023-03-28 01:12:32"),
("27400","10382","ایجاد فعالیت","2023-03-27 21:42:32","2023-03-28 01:12:32"),
("27401","10382","عملیات توسط WP Cron شروع شد","2023-03-27 22:50:04","2023-03-28 02:20:04"),
("27402","10382","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 22:50:05","2023-03-28 02:20:05"),
("27403","10383","ایجاد فعالیت","2023-03-27 22:50:05","2023-03-28 02:20:05"),
("27404","10383","عملیات توسط WP Cron شروع شد","2023-03-27 23:50:14","2023-03-28 03:20:14"),
("27405","10383","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-27 23:50:14","2023-03-28 03:20:14"),
("27406","10384","ایجاد فعالیت","2023-03-27 23:50:14","2023-03-28 03:20:14"),
("27407","10384","عملیات توسط WP Cron شروع شد","2023-03-28 00:52:49","2023-03-28 04:22:49"),
("27408","10384","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 00:52:49","2023-03-28 04:22:49"),
("27409","10385","ایجاد فعالیت","2023-03-28 00:52:49","2023-03-28 04:22:49"),
("27413","10385","عملیات توسط WP Cron شروع شد","2023-03-28 01:57:27","2023-03-28 05:27:27"),
("27414","10385","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 01:57:27","2023-03-28 05:27:27"),
("27415","10387","ایجاد فعالیت","2023-03-28 01:57:27","2023-03-28 05:27:27"),
("27416","10387","عملیات توسط WP Cron شروع شد","2023-03-28 03:06:17","2023-03-28 06:36:17"),
("27417","10387","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 03:06:17","2023-03-28 06:36:17"),
("27418","10388","ایجاد فعالیت","2023-03-28 03:06:17","2023-03-28 06:36:17"),
("27419","10388","عملیات توسط WP Cron شروع شد","2023-03-28 04:39:07","2023-03-28 08:09:07"),
("27420","10388","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 04:39:07","2023-03-28 08:09:07"),
("27421","10389","ایجاد فعالیت","2023-03-28 04:39:07","2023-03-28 08:09:07"),
("27422","10389","عملیات توسط WP Cron شروع شد","2023-03-28 05:54:53","2023-03-28 09:24:53"),
("27423","10389","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 05:54:53","2023-03-28 09:24:53"),
("27424","10390","ایجاد فعالیت","2023-03-28 05:54:53","2023-03-28 09:24:53"),
("27425","10390","عملیات توسط WP Cron شروع شد","2023-03-28 07:13:26","2023-03-28 10:43:26"),
("27426","10390","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 07:13:26","2023-03-28 10:43:26"),
("27427","10391","ایجاد فعالیت","2023-03-28 07:13:26","2023-03-28 10:43:26"),
("27428","10391","عملیات توسط WP Cron شروع شد","2023-03-28 08:16:34","2023-03-28 11:46:34"),
("27429","10391","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 08:16:34","2023-03-28 11:46:34"),
("27430","10392","ایجاد فعالیت","2023-03-28 08:16:34","2023-03-28 11:46:34"),
("27431","10392","عملیات توسط WP Cron شروع شد","2023-03-28 09:42:52","2023-03-28 13:12:52"),
("27432","10392","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 09:42:52","2023-03-28 13:12:52"),
("27433","10393","ایجاد فعالیت","2023-03-28 09:42:52","2023-03-28 13:12:52"),
("27434","10393","عملیات توسط WP Cron شروع شد","2023-03-28 11:05:58","2023-03-28 14:35:58"),
("27435","10393","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 11:05:58","2023-03-28 14:35:58"),
("27436","10394","ایجاد فعالیت","2023-03-28 11:05:58","2023-03-28 14:35:58"),
("27437","10394","عملیات توسط WP Cron شروع شد","2023-03-28 12:19:50","2023-03-28 15:49:50"),
("27438","10394","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 12:19:50","2023-03-28 15:49:50"),
("27439","10395","ایجاد فعالیت","2023-03-28 12:19:50","2023-03-28 15:49:50"),
("27440","10395","عملیات توسط WP Cron شروع شد","2023-03-28 13:24:02","2023-03-28 16:54:02"),
("27441","10395","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 13:24:02","2023-03-28 16:54:02"),
("27442","10396","ایجاد فعالیت","2023-03-28 13:24:02","2023-03-28 16:54:02"),
("27443","10396","عملیات توسط WP Cron شروع شد","2023-03-28 14:44:41","2023-03-28 18:14:41"),
("27444","10396","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 14:44:41","2023-03-28 18:14:41"),
("27445","10397","ایجاد فعالیت","2023-03-28 14:44:41","2023-03-28 18:14:41"),
("27446","10397","عملیات توسط WP Cron شروع شد","2023-03-28 15:56:50","2023-03-28 19:26:50"),
("27447","10397","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 15:56:50","2023-03-28 19:26:50"),
("27448","10398","ایجاد فعالیت","2023-03-28 15:56:50","2023-03-28 19:26:50"),
("27449","10398","عملیات توسط WP Cron شروع شد","2023-03-28 17:00:07","2023-03-28 20:30:07"),
("27450","10398","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 17:00:07","2023-03-28 20:30:07"),
("27451","10399","ایجاد فعالیت","2023-03-28 17:00:07","2023-03-28 20:30:07"),
("27452","10399","عملیات توسط WP Cron شروع شد","2023-03-28 18:00:30","2023-03-28 21:30:30"),
("27453","10399","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 18:00:30","2023-03-28 21:30:30"),
("27454","10400","ایجاد فعالیت","2023-03-28 18:00:30","2023-03-28 21:30:30"),
("27455","10400","عملیات توسط WP Cron شروع شد","2023-03-28 19:23:39","2023-03-28 22:53:39"),
("27456","10400","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 19:23:39","2023-03-28 22:53:39"),
("27457","10401","ایجاد فعالیت","2023-03-28 19:23:39","2023-03-28 22:53:39"),
("27458","10401","عملیات توسط WP Cron شروع شد","2023-03-28 20:30:26","2023-03-29 00:00:26"),
("27459","10401","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 20:30:26","2023-03-29 00:00:26"),
("27460","10402","ایجاد فعالیت","2023-03-28 20:30:26","2023-03-29 00:00:26"),
("27461","10402","عملیات توسط WP Cron شروع شد","2023-03-28 21:38:32","2023-03-29 01:08:32"),
("27462","10402","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 21:38:32","2023-03-29 01:08:32"),
("27463","10403","ایجاد فعالیت","2023-03-28 21:38:32","2023-03-29 01:08:32"),
("27464","10403","عملیات توسط WP Cron شروع شد","2023-03-28 23:35:21","2023-03-29 03:05:21"),
("27465","10403","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-28 23:35:21","2023-03-29 03:05:21"),
("27466","10404","ایجاد فعالیت","2023-03-28 23:35:21","2023-03-29 03:05:21"),
("27467","10404","عملیات توسط WP Cron شروع شد","2023-03-29 00:50:00","2023-03-29 04:20:00"),
("27468","10404","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 00:50:00","2023-03-29 04:20:00"),
("27469","10405","ایجاد فعالیت","2023-03-29 00:50:00","2023-03-29 04:20:00"),
("27473","10405","عملیات توسط WP Cron شروع شد","2023-03-29 02:16:54","2023-03-29 05:46:54"),
("27474","10405","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 02:16:54","2023-03-29 05:46:54"),
("27475","10407","ایجاد فعالیت","2023-03-29 02:16:54","2023-03-29 05:46:54"),
("27476","10407","عملیات توسط WP Cron شروع شد","2023-03-29 04:03:35","2023-03-29 07:33:35"),
("27477","10407","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 04:03:35","2023-03-29 07:33:35"),
("27478","10408","ایجاد فعالیت","2023-03-29 04:03:35","2023-03-29 07:33:35"),
("27479","10408","عملیات توسط WP Cron شروع شد","2023-03-29 06:18:53","2023-03-29 09:48:53"),
("27480","10408","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 06:18:53","2023-03-29 09:48:53"),
("27481","10409","ایجاد فعالیت","2023-03-29 06:18:53","2023-03-29 09:48:53"),
("27482","10409","عملیات توسط WP Cron شروع شد","2023-03-29 07:36:25","2023-03-29 11:06:25"),
("27483","10409","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 07:36:25","2023-03-29 11:06:25"),
("27484","10410","ایجاد فعالیت","2023-03-29 07:36:25","2023-03-29 11:06:25"),
("27485","10410","عملیات توسط WP Cron شروع شد","2023-03-29 08:39:30","2023-03-29 12:09:30"),
("27486","10410","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 08:39:30","2023-03-29 12:09:30"),
("27487","10411","ایجاد فعالیت","2023-03-29 08:39:30","2023-03-29 12:09:30"),
("27488","10411","عملیات توسط WP Cron شروع شد","2023-03-29 10:00:15","2023-03-29 13:30:15"),
("27489","10411","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 10:00:15","2023-03-29 13:30:15"),
("27490","10412","ایجاد فعالیت","2023-03-29 10:00:15","2023-03-29 13:30:15"),
("27491","10412","عملیات توسط WP Cron شروع شد","2023-03-29 11:03:39","2023-03-29 14:33:39"),
("27492","10412","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 11:03:39","2023-03-29 14:33:39"),
("27493","10413","ایجاد فعالیت","2023-03-29 11:03:39","2023-03-29 14:33:39"),
("27494","10413","عملیات توسط WP Cron شروع شد","2023-03-29 12:05:08","2023-03-29 15:35:08"),
("27495","10413","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 12:05:08","2023-03-29 15:35:08"),
("27496","10414","ایجاد فعالیت","2023-03-29 12:05:08","2023-03-29 15:35:08"),
("27497","10414","عملیات توسط WP Cron شروع شد","2023-03-29 13:14:59","2023-03-29 16:44:59"),
("27498","10414","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 13:14:59","2023-03-29 16:44:59"),
("27499","10415","ایجاد فعالیت","2023-03-29 13:14:59","2023-03-29 16:44:59"),
("27500","10415","عملیات توسط WP Cron شروع شد","2023-03-29 14:33:12","2023-03-29 18:03:12"),
("27501","10415","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 14:33:12","2023-03-29 18:03:12"),
("27502","10416","ایجاد فعالیت","2023-03-29 14:33:12","2023-03-29 18:03:12"),
("27503","10416","عملیات توسط WP Cron شروع شد","2023-03-29 15:56:40","2023-03-29 19:26:40"),
("27504","10416","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 15:56:40","2023-03-29 19:26:40"),
("27505","10417","ایجاد فعالیت","2023-03-29 15:56:40","2023-03-29 19:26:40"),
("27506","10417","عملیات توسط WP Cron شروع شد","2023-03-29 17:24:59","2023-03-29 20:54:59"),
("27507","10417","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 17:24:59","2023-03-29 20:54:59"),
("27508","10418","ایجاد فعالیت","2023-03-29 17:24:59","2023-03-29 20:54:59"),
("27509","10418","عملیات توسط WP Cron شروع شد","2023-03-29 19:38:01","2023-03-29 23:08:01"),
("27510","10418","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 19:38:01","2023-03-29 23:08:01"),
("27511","10419","ایجاد فعالیت","2023-03-29 19:38:01","2023-03-29 23:08:01"),
("27512","10419","عملیات توسط WP Cron شروع شد","2023-03-29 20:40:07","2023-03-30 00:10:07"),
("27513","10419","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 20:40:07","2023-03-30 00:10:07"),
("27514","10420","ایجاد فعالیت","2023-03-29 20:40:07","2023-03-30 00:10:07"),
("27515","10420","عملیات توسط WP Cron شروع شد","2023-03-29 22:37:16","2023-03-30 02:07:16"),
("27516","10420","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 22:37:16","2023-03-30 02:07:16"),
("27517","10421","ایجاد فعالیت","2023-03-29 22:37:16","2023-03-30 02:07:16"),
("27518","10421","عملیات توسط WP Cron شروع شد","2023-03-29 23:43:24","2023-03-30 03:13:24"),
("27519","10421","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-29 23:43:24","2023-03-30 03:13:24"),
("27520","10422","ایجاد فعالیت","2023-03-29 23:43:24","2023-03-30 03:13:24"),
("27521","10422","عملیات توسط WP Cron شروع شد","2023-03-30 00:53:13","2023-03-30 04:23:13"),
("27522","10422","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 00:53:14","2023-03-30 04:23:14"),
("27523","10423","ایجاد فعالیت","2023-03-30 00:53:14","2023-03-30 04:23:14"),
("27524","10423","عملیات توسط WP Cron شروع شد","2023-03-30 01:59:10","2023-03-30 05:29:10"),
("27525","10423","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 01:59:10","2023-03-30 05:29:10"),
("27526","10424","ایجاد فعالیت","2023-03-30 01:59:10","2023-03-30 05:29:10"),
("27530","10424","عملیات توسط WP Cron شروع شد","2023-03-30 03:06:27","2023-03-30 06:36:27"),
("27531","10424","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 03:06:27","2023-03-30 06:36:27"),
("27532","10426","ایجاد فعالیت","2023-03-30 03:06:27","2023-03-30 06:36:27"),
("27533","10426","عملیات توسط WP Cron شروع شد","2023-03-30 04:42:41","2023-03-30 08:12:41"),
("27534","10426","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 04:42:41","2023-03-30 08:12:41"),
("27535","10427","ایجاد فعالیت","2023-03-30 04:42:41","2023-03-30 08:12:41"),
("27536","10427","عملیات توسط WP Cron شروع شد","2023-03-30 05:57:32","2023-03-30 09:27:32"),
("27537","10427","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 05:57:32","2023-03-30 09:27:32"),
("27538","10428","ایجاد فعالیت","2023-03-30 05:57:32","2023-03-30 09:27:32"),
("27539","10428","عملیات توسط WP Cron شروع شد","2023-03-30 07:16:55","2023-03-30 10:46:55"),
("27540","10428","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 07:16:55","2023-03-30 10:46:55"),
("27541","10429","ایجاد فعالیت","2023-03-30 07:16:55","2023-03-30 10:46:55"),
("27542","10429","عملیات توسط WP Cron شروع شد","2023-03-30 08:45:54","2023-03-30 12:15:54"),
("27543","10429","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 08:45:54","2023-03-30 12:15:54"),
("27544","10430","ایجاد فعالیت","2023-03-30 08:45:54","2023-03-30 12:15:54"),
("27545","10430","عملیات توسط WP Cron شروع شد","2023-03-30 10:03:09","2023-03-30 13:33:09"),
("27546","10430","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 10:03:09","2023-03-30 13:33:09"),
("27547","10431","ایجاد فعالیت","2023-03-30 10:03:09","2023-03-30 13:33:09"),
("27548","10431","عملیات توسط WP Cron شروع شد","2023-03-30 11:37:43","2023-03-30 15:07:43"),
("27549","10431","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 11:37:43","2023-03-30 15:07:43"),
("27550","10432","ایجاد فعالیت","2023-03-30 11:37:43","2023-03-30 15:07:43"),
("27551","10432","عملیات توسط WP Cron شروع شد","2023-03-30 12:45:28","2023-03-30 16:15:28"),
("27552","10432","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 12:45:28","2023-03-30 16:15:28"),
("27553","10433","ایجاد فعالیت","2023-03-30 12:45:28","2023-03-30 16:15:28"),
("27554","10433","عملیات توسط WP Cron شروع شد","2023-03-30 14:27:16","2023-03-30 17:57:16"),
("27555","10433","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 14:27:16","2023-03-30 17:57:16"),
("27556","10434","ایجاد فعالیت","2023-03-30 14:27:16","2023-03-30 17:57:16"),
("27557","10434","عملیات توسط WP Cron شروع شد","2023-03-30 15:57:09","2023-03-30 19:27:09"),
("27558","10434","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 15:57:09","2023-03-30 19:27:09"),
("27559","10435","ایجاد فعالیت","2023-03-30 15:57:09","2023-03-30 19:27:09"),
("27560","10435","عملیات توسط WP Cron شروع شد","2023-03-30 17:02:37","2023-03-30 20:32:37"),
("27561","10435","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 17:02:38","2023-03-30 20:32:38"),
("27562","10436","ایجاد فعالیت","2023-03-30 17:02:38","2023-03-30 20:32:38"),
("27563","10436","عملیات توسط WP Cron شروع شد","2023-03-30 18:14:35","2023-03-30 21:44:35"),
("27564","10436","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 18:14:35","2023-03-30 21:44:35"),
("27565","10437","ایجاد فعالیت","2023-03-30 18:14:35","2023-03-30 21:44:35"),
("27566","10437","عملیات توسط WP Cron شروع شد","2023-03-30 19:36:35","2023-03-30 23:06:35"),
("27567","10437","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 19:36:35","2023-03-30 23:06:35"),
("27568","10438","ایجاد فعالیت","2023-03-30 19:36:35","2023-03-30 23:06:35"),
("27569","10438","عملیات توسط WP Cron شروع شد","2023-03-30 21:41:11","2023-03-31 01:11:11"),
("27570","10438","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 21:41:11","2023-03-31 01:11:11"),
("27571","10439","ایجاد فعالیت","2023-03-30 21:41:11","2023-03-31 01:11:11"),
("27572","10439","عملیات توسط WP Cron شروع شد","2023-03-30 23:56:20","2023-03-31 03:26:20"),
("27573","10439","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-30 23:56:20","2023-03-31 03:26:20"),
("27574","10440","ایجاد فعالیت","2023-03-30 23:56:20","2023-03-31 03:26:20"),
("27575","10440","عملیات توسط WP Cron شروع شد","2023-03-31 01:30:55","2023-03-31 05:00:55"),
("27576","10440","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 01:30:55","2023-03-31 05:00:55"),
("27577","10441","ایجاد فعالیت","2023-03-31 01:30:55","2023-03-31 05:00:55"),
("27581","10441","عملیات توسط WP Cron شروع شد","2023-03-31 03:11:14","2023-03-31 06:41:14"),
("27582","10441","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 03:11:14","2023-03-31 06:41:14"),
("27583","10443","ایجاد فعالیت","2023-03-31 03:11:14","2023-03-31 06:41:14"),
("27584","10443","عملیات توسط WP Cron شروع شد","2023-03-31 06:05:51","2023-03-31 09:35:51"),
("27585","10443","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 06:05:51","2023-03-31 09:35:51"),
("27586","10444","ایجاد فعالیت","2023-03-31 06:05:51","2023-03-31 09:35:51"),
("27587","10444","عملیات توسط WP Cron شروع شد","2023-03-31 07:25:50","2023-03-31 10:55:50"),
("27588","10444","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 07:25:50","2023-03-31 10:55:50"),
("27589","10445","ایجاد فعالیت","2023-03-31 07:25:50","2023-03-31 10:55:50"),
("27590","10445","عملیات توسط WP Cron شروع شد","2023-03-31 08:58:11","2023-03-31 12:28:11"),
("27591","10445","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 08:58:11","2023-03-31 12:28:11"),
("27592","10446","ایجاد فعالیت","2023-03-31 08:58:11","2023-03-31 12:28:11"),
("27593","10446","عملیات توسط WP Cron شروع شد","2023-03-31 10:11:18","2023-03-31 13:41:18"),
("27594","10446","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 10:11:18","2023-03-31 13:41:18"),
("27595","10447","ایجاد فعالیت","2023-03-31 10:11:18","2023-03-31 13:41:18"),
("27596","10447","عملیات توسط WP Cron شروع شد","2023-03-31 11:37:36","2023-03-31 15:07:36"),
("27597","10447","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 11:37:36","2023-03-31 15:07:36"),
("27598","10448","ایجاد فعالیت","2023-03-31 11:37:36","2023-03-31 15:07:36"),
("27599","10448","عملیات توسط WP Cron شروع شد","2023-03-31 13:33:32","2023-03-31 17:03:32"),
("27600","10448","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 13:33:32","2023-03-31 17:03:32"),
("27601","10449","ایجاد فعالیت","2023-03-31 13:33:32","2023-03-31 17:03:32"),
("27602","10449","عملیات توسط WP Cron شروع شد","2023-03-31 15:14:24","2023-03-31 18:44:24"),
("27603","10449","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 15:14:24","2023-03-31 18:44:24"),
("27604","10450","ایجاد فعالیت","2023-03-31 15:14:24","2023-03-31 18:44:24"),
("27605","10450","عملیات توسط WP Cron شروع شد","2023-03-31 19:51:00","2023-03-31 23:21:00"),
("27606","10450","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 19:51:00","2023-03-31 23:21:00"),
("27607","10451","ایجاد فعالیت","2023-03-31 19:51:00","2023-03-31 23:21:00"),
("27608","10451","عملیات توسط WP Cron شروع شد","2023-03-31 21:45:06","2023-04-01 01:15:06"),
("27609","10451","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-03-31 21:45:06","2023-04-01 01:15:06"),
("27610","10452","ایجاد فعالیت","2023-03-31 21:45:06","2023-04-01 01:15:06"),
("27611","10452","عملیات توسط WP Cron شروع شد","2023-04-01 01:33:27","2023-04-01 05:03:27"),
("27612","10452","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 01:33:27","2023-04-01 05:03:27"),
("27613","10453","ایجاد فعالیت","2023-04-01 01:33:27","2023-04-01 05:03:27"),
("27614","10453","عملیات توسط WP Cron شروع شد","2023-04-01 03:28:07","2023-04-01 06:58:07"),
("27615","10453","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 03:28:07","2023-04-01 06:58:07"),
("27616","10454","ایجاد فعالیت","2023-04-01 03:28:07","2023-04-01 06:58:07"),
("27620","10454","عملیات توسط WP Cron شروع شد","2023-04-01 06:13:19","2023-04-01 09:43:19"),
("27621","10454","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 06:13:19","2023-04-01 09:43:19"),
("27622","10456","ایجاد فعالیت","2023-04-01 06:13:19","2023-04-01 09:43:19"),
("27623","10456","عملیات توسط WP Cron شروع شد","2023-04-01 08:22:20","2023-04-01 11:52:20"),
("27624","10456","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 08:22:20","2023-04-01 11:52:20"),
("27625","10457","ایجاد فعالیت","2023-04-01 08:22:20","2023-04-01 11:52:20"),
("27626","10457","عملیات توسط WP Cron شروع شد","2023-04-01 10:42:35","2023-04-01 14:12:35"),
("27627","10457","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 10:42:35","2023-04-01 14:12:35"),
("27628","10458","ایجاد فعالیت","2023-04-01 10:42:35","2023-04-01 14:12:35"),
("27629","10458","عملیات توسط WP Cron شروع شد","2023-04-01 13:41:24","2023-04-01 17:11:24"),
("27630","10458","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 13:41:24","2023-04-01 17:11:24"),
("27631","10459","ایجاد فعالیت","2023-04-01 13:41:24","2023-04-01 17:11:24"),
("27632","10459","عملیات توسط WP Cron شروع شد","2023-04-01 15:14:42","2023-04-01 18:44:42"),
("27633","10459","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 15:14:42","2023-04-01 18:44:42"),
("27634","10460","ایجاد فعالیت","2023-04-01 15:14:42","2023-04-01 18:44:42"),
("27635","10460","عملیات توسط WP Cron شروع شد","2023-04-01 17:03:56","2023-04-01 20:33:56"),
("27636","10460","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 17:03:56","2023-04-01 20:33:56"),
("27637","10461","ایجاد فعالیت","2023-04-01 17:03:56","2023-04-01 20:33:56"),
("27638","10461","عملیات توسط WP Cron شروع شد","2023-04-01 20:31:46","2023-04-02 00:01:46"),
("27639","10461","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 20:31:46","2023-04-02 00:01:46"),
("27640","10462","ایجاد فعالیت","2023-04-01 20:31:46","2023-04-02 00:01:46"),
("27641","10462","عملیات توسط WP Cron شروع شد","2023-04-01 21:33:26","2023-04-02 01:03:26"),
("27642","10462","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 21:33:26","2023-04-02 01:03:26"),
("27643","10463","ایجاد فعالیت","2023-04-01 21:33:26","2023-04-02 01:03:26"),
("27644","10463","عملیات توسط WP Cron شروع شد","2023-04-01 23:35:39","2023-04-02 03:05:39"),
("27645","10463","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-01 23:35:39","2023-04-02 03:05:39"),
("27646","10464","ایجاد فعالیت","2023-04-01 23:35:39","2023-04-02 03:05:39"),
("27647","10464","عملیات توسط WP Cron شروع شد","2023-04-02 00:40:48","2023-04-02 04:10:48"),
("27648","10464","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-02 00:40:48","2023-04-02 04:10:48"),
("27649","10465","ایجاد فعالیت","2023-04-02 00:40:48","2023-04-02 04:10:48"),
("27650","10465","عملیات توسط WP Cron شروع شد","2023-04-02 03:33:19","2023-04-02 07:03:19"),
("27651","10465","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-02 03:33:20","2023-04-02 07:03:20"),
("27652","10466","ایجاد فعالیت","2023-04-02 03:33:20","2023-04-02 07:03:20"),
("27656","10466","عملیات توسط WP Cron شروع شد","2023-04-02 06:11:42","2023-04-02 09:41:42"),
("27657","10466","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-02 06:11:42","2023-04-02 09:41:42"),
("27658","10468","ایجاد فعالیت","2023-04-02 06:11:42","2023-04-02 09:41:42"),
("27659","10468","عملیات توسط WP Cron شروع شد","2023-04-02 09:22:28","2023-04-02 12:52:28"),
("27660","10468","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-02 09:22:28","2023-04-02 12:52:28"),
("27661","10469","ایجاد فعالیت","2023-04-02 09:22:28","2023-04-02 12:52:28"),
("27662","10469","عملیات توسط WP Cron شروع شد","2023-04-02 13:40:17","2023-04-02 17:10:17"),
("27663","10469","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-02 13:40:17","2023-04-02 17:10:17"),
("27664","10470","ایجاد فعالیت","2023-04-02 13:40:17","2023-04-02 17:10:17"),
("27665","10470","عملیات توسط WP Cron شروع شد","2023-04-02 17:38:43","2023-04-02 21:08:43"),
("27666","10470","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-02 17:38:43","2023-04-02 21:08:43"),
("27667","10471","ایجاد فعالیت","2023-04-02 17:38:43","2023-04-02 21:08:43"),
("27668","10471","عملیات توسط WP Cron شروع شد","2023-04-02 19:11:49","2023-04-02 22:41:49"),
("27669","10471","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-02 19:11:49","2023-04-02 22:41:49"),
("27670","10472","ایجاد فعالیت","2023-04-02 19:11:49","2023-04-02 22:41:49"),
("27671","10472","عملیات توسط WP Cron شروع شد","2023-04-02 20:12:39","2023-04-02 23:42:39"),
("27672","10472","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-02 20:12:39","2023-04-02 23:42:39"),
("27673","10473","ایجاد فعالیت","2023-04-02 20:12:39","2023-04-02 23:42:39"),
("27674","10473","عملیات توسط WP Cron شروع شد","2023-04-03 01:43:34","2023-04-03 05:13:34"),
("27675","10473","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 01:43:34","2023-04-03 05:13:34"),
("27676","10474","ایجاد فعالیت","2023-04-03 01:43:34","2023-04-03 05:13:34"),
("27677","10474","عملیات توسط WP Cron شروع شد","2023-04-03 06:05:36","2023-04-03 09:35:36"),
("27678","10474","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 06:05:37","2023-04-03 09:35:37"),
("27679","10475","ایجاد فعالیت","2023-04-03 06:05:37","2023-04-03 09:35:37"),
("27683","10475","عملیات توسط WP Cron شروع شد","2023-04-03 08:09:10","2023-04-03 11:39:10"),
("27684","10475","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 08:09:10","2023-04-03 11:39:10"),
("27685","10477","ایجاد فعالیت","2023-04-03 08:09:10","2023-04-03 11:39:10"),
("27686","10477","عملیات توسط WP Cron شروع شد","2023-04-03 09:23:24","2023-04-03 12:53:24"),
("27687","10477","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 09:23:24","2023-04-03 12:53:24"),
("27688","10478","ایجاد فعالیت","2023-04-03 09:23:24","2023-04-03 12:53:24"),
("27689","10478","عملیات توسط WP Cron شروع شد","2023-04-03 10:43:46","2023-04-03 14:13:46"),
("27690","10478","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 10:43:46","2023-04-03 14:13:46"),
("27691","10479","ایجاد فعالیت","2023-04-03 10:43:46","2023-04-03 14:13:46"),
("27692","10479","عملیات توسط WP Cron شروع شد","2023-04-03 11:51:21","2023-04-03 15:21:21"),
("27693","10479","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 11:51:21","2023-04-03 15:21:21"),
("27694","10480","ایجاد فعالیت","2023-04-03 11:51:21","2023-04-03 15:21:21"),
("27695","10480","عملیات توسط WP Cron شروع شد","2023-04-03 12:54:12","2023-04-03 16:24:12"),
("27696","10480","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 12:54:12","2023-04-03 16:24:12"),
("27697","10481","ایجاد فعالیت","2023-04-03 12:54:12","2023-04-03 16:24:12"),
("27698","10481","عملیات توسط WP Cron شروع شد","2023-04-03 14:44:59","2023-04-03 18:14:59"),
("27699","10481","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 14:44:59","2023-04-03 18:14:59"),
("27700","10482","ایجاد فعالیت","2023-04-03 14:44:59","2023-04-03 18:14:59"),
("27701","10482","عملیات توسط WP Cron شروع شد","2023-04-03 16:58:23","2023-04-03 20:28:23"),
("27702","10482","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 16:58:23","2023-04-03 20:28:23"),
("27703","10483","ایجاد فعالیت","2023-04-03 16:58:23","2023-04-03 20:28:23"),
("27704","10483","عملیات توسط WP Cron شروع شد","2023-04-03 18:09:53","2023-04-03 21:39:53"),
("27705","10483","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 18:09:53","2023-04-03 21:39:53"),
("27706","10484","ایجاد فعالیت","2023-04-03 18:09:53","2023-04-03 21:39:53"),
("27707","10484","عملیات توسط WP Cron شروع شد","2023-04-03 22:20:01","2023-04-04 01:50:01"),
("27708","10484","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 22:20:01","2023-04-04 01:50:01"),
("27709","10485","ایجاد فعالیت","2023-04-03 22:20:01","2023-04-04 01:50:01"),
("27710","10485","عملیات توسط WP Cron شروع شد","2023-04-03 23:38:44","2023-04-04 03:08:44"),
("27711","10485","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-03 23:38:44","2023-04-04 03:08:44"),
("27712","10486","ایجاد فعالیت","2023-04-03 23:38:44","2023-04-04 03:08:44"),
("27713","10486","عملیات توسط WP Cron شروع شد","2023-04-04 10:59:03","2023-04-04 14:29:03"),
("27714","10486","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-04 10:59:03","2023-04-04 14:29:03"),
("27715","10487","ایجاد فعالیت","2023-04-04 10:59:03","2023-04-04 14:29:03"),
("27719","10487","عملیات توسط WP Cron شروع شد","2023-04-04 14:05:34","2023-04-04 17:35:34"),
("27720","10487","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-04 14:05:34","2023-04-04 17:35:34"),
("27721","10489","ایجاد فعالیت","2023-04-04 14:05:34","2023-04-04 17:35:34"),
("27722","10489","عملیات توسط WP Cron شروع شد","2023-04-04 16:31:57","2023-04-04 20:01:57"),
("27723","10489","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-04 16:31:57","2023-04-04 20:01:57"),
("27724","10490","ایجاد فعالیت","2023-04-04 16:31:57","2023-04-04 20:01:57"),
("27725","10490","عملیات توسط WP Cron شروع شد","2023-04-04 19:34:42","2023-04-04 23:04:42"),
("27726","10490","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-04 19:34:42","2023-04-04 23:04:42"),
("27727","10491","ایجاد فعالیت","2023-04-04 19:34:42","2023-04-04 23:04:42"),
("27728","10491","عملیات توسط WP Cron شروع شد","2023-04-04 21:35:53","2023-04-05 01:05:53"),
("27729","10491","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-04 21:35:53","2023-04-05 01:05:53"),
("27730","10492","ایجاد فعالیت","2023-04-04 21:35:53","2023-04-05 01:05:53"),
("27731","10492","عملیات توسط WP Cron شروع شد","2023-04-05 01:19:47","2023-04-05 04:49:47"),
("27732","10492","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-05 01:19:47","2023-04-05 04:49:47"),
("27733","10493","ایجاد فعالیت","2023-04-05 01:19:47","2023-04-05 04:49:47"),
("27734","10493","عملیات توسط WP Cron شروع شد","2023-04-05 05:58:34","2023-04-05 09:28:34"),
("27735","10493","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-05 05:58:34","2023-04-05 09:28:34"),
("27736","10494","ایجاد فعالیت","2023-04-05 05:58:34","2023-04-05 09:28:34"),
("27737","10494","عملیات توسط WP Cron شروع شد","2023-04-05 07:31:39","2023-04-05 11:01:39"),
("27738","10494","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-05 07:31:39","2023-04-05 11:01:39"),
("27739","10495","ایجاد فعالیت","2023-04-05 07:31:39","2023-04-05 11:01:39"),
("27740","10495","عملیات توسط WP Cron شروع شد","2023-04-05 09:25:30","2023-04-05 12:55:30"),
("27741","10495","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-05 09:25:30","2023-04-05 12:55:30"),
("27742","10496","ایجاد فعالیت","2023-04-05 09:25:30","2023-04-05 12:55:30"),
("27743","10496","عملیات توسط WP Cron شروع شد","2023-04-05 11:08:03","2023-04-05 14:38:03"),
("27744","10496","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-05 11:08:03","2023-04-05 14:38:03"),
("27745","10497","ایجاد فعالیت","2023-04-05 11:08:03","2023-04-05 14:38:03"),
("27749","10497","عملیات توسط WP Cron شروع شد","2023-04-05 23:08:41","2023-04-06 02:38:41"),
("27750","10497","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-05 23:08:41","2023-04-06 02:38:41"),
("27751","10499","ایجاد فعالیت","2023-04-05 23:08:41","2023-04-06 02:38:41"),
("27752","10499","عملیات توسط WP Cron شروع شد","2023-04-06 07:48:54","2023-04-06 11:18:54"),
("27753","10499","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-06 07:48:54","2023-04-06 11:18:54"),
("27754","10500","ایجاد فعالیت","2023-04-06 07:48:54","2023-04-06 11:18:54"),
("27758","10500","عملیات توسط WP Cron شروع شد","2023-04-06 15:04:54","2023-04-06 18:34:54"),
("27759","10500","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-06 15:04:54","2023-04-06 18:34:54"),
("27760","10502","ایجاد فعالیت","2023-04-06 15:04:54","2023-04-06 18:34:54"),
("27761","10502","عملیات توسط WP Cron شروع شد","2023-04-06 17:21:57","2023-04-06 20:51:57"),
("27762","10502","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-06 17:21:57","2023-04-06 20:51:57"),
("27763","10503","ایجاد فعالیت","2023-04-06 17:21:57","2023-04-06 20:51:57"),
("27764","10503","عملیات توسط WP Cron شروع شد","2023-04-06 19:33:17","2023-04-06 23:03:17"),
("27765","10503","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-06 19:33:17","2023-04-06 23:03:17"),
("27766","10504","ایجاد فعالیت","2023-04-06 19:33:17","2023-04-06 23:03:17"),
("27767","10504","عملیات توسط WP Cron شروع شد","2023-04-07 02:52:04","2023-04-07 06:22:04"),
("27768","10504","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-07 02:52:04","2023-04-07 06:22:04"),
("27769","10505","ایجاد فعالیت","2023-04-07 02:52:04","2023-04-07 06:22:04"),
("27773","10505","عملیات توسط WP Cron شروع شد","2023-04-07 19:36:28","2023-04-07 23:06:28"),
("27774","10505","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-07 19:36:28","2023-04-07 23:06:28"),
("27775","10507","ایجاد فعالیت","2023-04-07 19:36:28","2023-04-07 23:06:28"),
("27776","10507","عملیات توسط WP Cron شروع شد","2023-04-07 20:49:38","2023-04-08 00:19:38"),
("27777","10507","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-07 20:49:38","2023-04-08 00:19:38"),
("27778","10508","ایجاد فعالیت","2023-04-07 20:49:38","2023-04-08 00:19:38"),
("27779","10508","عملیات توسط WP Cron شروع شد","2023-04-08 02:48:56","2023-04-08 06:18:56"),
("27780","10508","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-08 02:48:56","2023-04-08 06:18:56"),
("27781","10509","ایجاد فعالیت","2023-04-08 02:48:56","2023-04-08 06:18:56"),
("27782","10509","عملیات توسط WP Cron شروع شد","2023-04-08 14:46:45","2023-04-08 18:16:45"),
("27783","10509","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-08 14:46:45","2023-04-08 18:16:45"),
("27784","10510","ایجاد فعالیت","2023-04-08 14:46:45","2023-04-08 18:16:45"),
("27785","10510","عملیات توسط WP Cron شروع شد","2023-04-08 17:35:38","2023-04-08 21:05:38"),
("27786","10510","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-08 17:35:38","2023-04-08 21:05:38"),
("27787","10511","ایجاد فعالیت","2023-04-08 17:35:38","2023-04-08 21:05:38"),
("27791","10511","عملیات توسط WP Cron شروع شد","2023-04-08 21:42:57","2023-04-09 01:12:57"),
("27792","10511","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-08 21:42:57","2023-04-09 01:12:57"),
("27793","10513","ایجاد فعالیت","2023-04-08 21:42:57","2023-04-09 01:12:57"),
("27794","10513","عملیات توسط WP Cron شروع شد","2023-04-08 23:21:01","2023-04-09 02:51:01"),
("27795","10513","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-08 23:21:01","2023-04-09 02:51:01"),
("27796","10514","ایجاد فعالیت","2023-04-08 23:21:01","2023-04-09 02:51:01"),
("27797","10514","عملیات توسط WP Cron شروع شد","2023-04-09 03:12:05","2023-04-09 06:42:05"),
("27798","10514","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-09 03:12:05","2023-04-09 06:42:05"),
("27799","10515","ایجاد فعالیت","2023-04-09 03:12:05","2023-04-09 06:42:05"),
("27800","10515","عملیات توسط WP Cron شروع شد","2023-04-09 08:27:48","2023-04-09 11:57:48"),
("27801","10515","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-09 08:27:48","2023-04-09 11:57:48"),
("27802","10516","ایجاد فعالیت","2023-04-09 08:27:48","2023-04-09 11:57:48"),
("27803","10516","عملیات توسط WP Cron شروع شد","2023-04-09 09:29:08","2023-04-09 12:59:08"),
("27804","10516","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-09 09:29:08","2023-04-09 12:59:08"),
("27805","10517","ایجاد فعالیت","2023-04-09 09:29:08","2023-04-09 12:59:08"),
("27806","10517","عملیات توسط WP Cron شروع شد","2023-04-09 11:23:49","2023-04-09 14:53:49"),
("27807","10517","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-09 11:23:49","2023-04-09 14:53:49"),
("27808","10518","ایجاد فعالیت","2023-04-09 11:23:49","2023-04-09 14:53:49"),
("27809","10518","عملیات توسط WP Cron شروع شد","2023-04-09 12:31:39","2023-04-09 16:01:39"),
("27810","10518","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-09 12:31:39","2023-04-09 16:01:39"),
("27811","10519","ایجاد فعالیت","2023-04-09 12:31:39","2023-04-09 16:01:39"),
("27812","10519","عملیات توسط WP Cron شروع شد","2023-04-09 19:02:37","2023-04-09 22:32:37"),
("27813","10519","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-09 19:02:37","2023-04-09 22:32:37"),
("27814","10520","ایجاد فعالیت","2023-04-09 19:02:37","2023-04-09 22:32:37"),
("27818","10520","عملیات توسط WP Cron شروع شد","2023-04-10 02:03:49","2023-04-10 05:33:49"),
("27819","10520","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-10 02:03:49","2023-04-10 05:33:49"),
("27820","10522","ایجاد فعالیت","2023-04-10 02:03:49","2023-04-10 05:33:49"),
("27821","10522","عملیات توسط WP Cron شروع شد","2023-04-10 09:15:22","2023-04-10 12:45:22"),
("27822","10522","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-10 09:15:22","2023-04-10 12:45:22"),
("27823","10523","ایجاد فعالیت","2023-04-10 09:15:22","2023-04-10 12:45:22"),
("27824","10523","عملیات توسط WP Cron شروع شد","2023-04-10 16:01:43","2023-04-10 19:31:43"),
("27825","10523","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-10 16:01:43","2023-04-10 19:31:43"),
("27826","10524","ایجاد فعالیت","2023-04-10 16:01:43","2023-04-10 19:31:43"),
("27827","10524","عملیات توسط WP Cron شروع شد","2023-04-10 18:21:09","2023-04-10 21:51:09"),
("27828","10524","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-10 18:21:09","2023-04-10 21:51:09"),
("27829","10525","ایجاد فعالیت","2023-04-10 18:21:09","2023-04-10 21:51:09"),
("27830","10525","عملیات توسط WP Cron شروع شد","2023-04-11 00:49:11","2023-04-11 04:19:11"),
("27831","10525","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 00:49:11","2023-04-11 04:19:11"),
("27832","10526","ایجاد فعالیت","2023-04-11 00:49:11","2023-04-11 04:19:11"),
("27833","10526","عملیات توسط WP Cron شروع شد","2023-04-11 03:09:17","2023-04-11 06:39:17"),
("27834","10526","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 03:09:17","2023-04-11 06:39:17"),
("27835","10527","ایجاد فعالیت","2023-04-11 03:09:17","2023-04-11 06:39:17"),
("27839","10527","عملیات توسط WP Cron شروع شد","2023-04-11 05:00:29","2023-04-11 08:30:29"),
("27840","10527","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 05:00:29","2023-04-11 08:30:29"),
("27841","10529","ایجاد فعالیت","2023-04-11 05:00:29","2023-04-11 08:30:29"),
("27842","10529","عملیات توسط WP Cron شروع شد","2023-04-11 08:09:04","2023-04-11 11:39:04"),
("27843","10529","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 08:09:04","2023-04-11 11:39:04"),
("27844","10530","ایجاد فعالیت","2023-04-11 08:09:04","2023-04-11 11:39:04"),
("27848","10530","عملیات توسط WP Cron شروع شد","2023-04-11 09:22:26","2023-04-11 12:52:26"),
("27849","10530","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 09:22:26","2023-04-11 12:52:26"),
("27850","10532","ایجاد فعالیت","2023-04-11 09:22:26","2023-04-11 12:52:26"),
("27851","10532","عملیات توسط WP Cron شروع شد","2023-04-11 10:28:59","2023-04-11 13:58:59"),
("27852","10532","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 10:28:59","2023-04-11 13:58:59"),
("27853","10533","ایجاد فعالیت","2023-04-11 10:28:59","2023-04-11 13:58:59"),
("27854","10533","عملیات توسط WP Cron شروع شد","2023-04-11 12:39:13","2023-04-11 16:09:13"),
("27855","10533","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 12:39:13","2023-04-11 16:09:13"),
("27856","10534","ایجاد فعالیت","2023-04-11 12:39:13","2023-04-11 16:09:13"),
("27857","10534","عملیات توسط WP Cron شروع شد","2023-04-11 17:12:03","2023-04-11 20:42:03"),
("27858","10534","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 17:12:03","2023-04-11 20:42:03"),
("27859","10535","ایجاد فعالیت","2023-04-11 17:12:03","2023-04-11 20:42:03"),
("27860","10535","عملیات توسط WP Cron شروع شد","2023-04-11 18:29:28","2023-04-11 21:59:28"),
("27861","10535","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 18:29:28","2023-04-11 21:59:28"),
("27862","10536","ایجاد فعالیت","2023-04-11 18:29:28","2023-04-11 21:59:28"),
("27863","10536","عملیات توسط WP Cron شروع شد","2023-04-11 20:08:17","2023-04-11 23:38:17"),
("27864","10536","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 20:08:17","2023-04-11 23:38:17"),
("27865","10537","ایجاد فعالیت","2023-04-11 20:08:17","2023-04-11 23:38:17"),
("27866","10537","عملیات توسط WP Cron شروع شد","2023-04-11 22:18:07","2023-04-12 01:48:07"),
("27867","10537","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-11 22:18:07","2023-04-12 01:48:07"),
("27868","10538","ایجاد فعالیت","2023-04-11 22:18:07","2023-04-12 01:48:07"),
("27869","10538","عملیات توسط WP Cron شروع شد","2023-04-12 00:20:31","2023-04-12 03:50:31"),
("27870","10538","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-12 00:20:31","2023-04-12 03:50:31"),
("27871","10539","ایجاد فعالیت","2023-04-12 00:20:31","2023-04-12 03:50:31"),
("27875","10539","عملیات توسط WP Cron شروع شد","2023-04-12 11:09:58","2023-04-12 14:39:58"),
("27876","10539","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-12 11:09:58","2023-04-12 14:39:58"),
("27877","10541","ایجاد فعالیت","2023-04-12 11:09:58","2023-04-12 14:39:58"),
("27878","10541","عملیات توسط WP Cron شروع شد","2023-04-12 19:32:30","2023-04-12 23:02:30"),
("27879","10541","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-12 19:32:30","2023-04-12 23:02:30"),
("27880","10542","ایجاد فعالیت","2023-04-12 19:32:30","2023-04-12 23:02:30"),
("27881","10542","عملیات توسط WP Cron شروع شد","2023-04-12 21:50:41","2023-04-13 01:20:41"),
("27882","10542","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-12 21:50:41","2023-04-13 01:20:41"),
("27883","10543","ایجاد فعالیت","2023-04-12 21:50:41","2023-04-13 01:20:41"),
("27884","10543","عملیات توسط WP Cron شروع شد","2023-04-12 23:02:28","2023-04-13 02:32:28"),
("27885","10543","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-12 23:02:28","2023-04-13 02:32:28"),
("27886","10544","ایجاد فعالیت","2023-04-12 23:02:28","2023-04-13 02:32:28"),
("27887","10544","عملیات توسط WP Cron شروع شد","2023-04-13 05:39:19","2023-04-13 09:09:19"),
("27888","10544","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-13 05:39:19","2023-04-13 09:09:19"),
("27889","10545","ایجاد فعالیت","2023-04-13 05:39:19","2023-04-13 09:09:19"),
("27890","10545","عملیات توسط WP Cron شروع شد","2023-04-13 06:44:06","2023-04-13 10:14:06"),
("27891","10545","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-13 06:44:06","2023-04-13 10:14:06"),
("27892","10546","ایجاد فعالیت","2023-04-13 06:44:06","2023-04-13 10:14:06"),
("27893","10546","عملیات توسط WP Cron شروع شد","2023-04-13 11:23:30","2023-04-13 14:53:30"),
("27894","10546","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-13 11:23:30","2023-04-13 14:53:30"),
("27895","10547","ایجاد فعالیت","2023-04-13 11:23:30","2023-04-13 14:53:30"),
("27899","10547","عملیات توسط WP Cron شروع شد","2023-04-13 13:21:53","2023-04-13 16:51:53"),
("27900","10547","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-13 13:21:53","2023-04-13 16:51:53"),
("27901","10549","ایجاد فعالیت","2023-04-13 13:21:53","2023-04-13 16:51:53"),
("27902","10549","عملیات توسط WP Cron شروع شد","2023-04-13 16:26:10","2023-04-13 19:56:10"),
("27903","10549","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-13 16:26:10","2023-04-13 19:56:10"),
("27904","10550","ایجاد فعالیت","2023-04-13 16:26:10","2023-04-13 19:56:10"),
("27905","10550","عملیات توسط WP Cron شروع شد","2023-04-13 18:03:19","2023-04-13 21:33:19"),
("27906","10550","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-13 18:03:19","2023-04-13 21:33:19"),
("27907","10551","ایجاد فعالیت","2023-04-13 18:03:19","2023-04-13 21:33:19"),
("27908","10551","عملیات توسط WP Cron شروع شد","2023-04-13 20:06:38","2023-04-13 23:36:38"),
("27909","10551","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-13 20:06:38","2023-04-13 23:36:38"),
("27910","10552","ایجاد فعالیت","2023-04-13 20:06:38","2023-04-13 23:36:38"),
("27911","10552","عملیات توسط WP Cron شروع شد","2023-04-13 21:34:54","2023-04-14 01:04:54"),
("27912","10552","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-13 21:34:54","2023-04-14 01:04:54"),
("27913","10553","ایجاد فعالیت","2023-04-13 21:34:54","2023-04-14 01:04:54"),
("27914","10553","عملیات توسط WP Cron شروع شد","2023-04-14 05:16:18","2023-04-14 08:46:18"),
("27915","10553","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-14 05:16:18","2023-04-14 08:46:18"),
("27916","10554","ایجاد فعالیت","2023-04-14 05:16:18","2023-04-14 08:46:18"),
("27917","10554","عملیات توسط WP Cron شروع شد","2023-04-14 08:49:24","2023-04-14 12:19:24"),
("27918","10554","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-14 08:49:24","2023-04-14 12:19:24"),
("27919","10555","ایجاد فعالیت","2023-04-14 08:49:24","2023-04-14 12:19:24"),
("27920","10555","عملیات توسط WP Cron شروع شد","2023-04-14 10:22:48","2023-04-14 13:52:48"),
("27921","10555","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-14 10:22:48","2023-04-14 13:52:48"),
("27922","10556","ایجاد فعالیت","2023-04-14 10:22:48","2023-04-14 13:52:48"),
("27923","10556","عملیات توسط WP Cron شروع شد","2023-04-14 14:26:47","2023-04-14 17:56:47"),
("27924","10556","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-14 14:26:47","2023-04-14 17:56:47"),
("27925","10557","ایجاد فعالیت","2023-04-14 14:26:47","2023-04-14 17:56:47"),
("27929","10557","عملیات توسط WP Cron شروع شد","2023-04-14 15:59:55","2023-04-14 19:29:55"),
("27930","10557","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-14 15:59:55","2023-04-14 19:29:55"),
("27931","10559","ایجاد فعالیت","2023-04-14 15:59:55","2023-04-14 19:29:55"),
("27932","10559","عملیات توسط WP Cron شروع شد","2023-04-14 22:07:09","2023-04-15 01:37:09"),
("27933","10559","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-14 22:07:09","2023-04-15 01:37:09"),
("27934","10560","ایجاد فعالیت","2023-04-14 22:07:09","2023-04-15 01:37:09"),
("27935","10560","عملیات توسط WP Cron شروع شد","2023-04-14 23:35:11","2023-04-15 03:05:11"),
("27936","10560","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-14 23:35:11","2023-04-15 03:05:11"),
("27937","10561","ایجاد فعالیت","2023-04-14 23:35:11","2023-04-15 03:05:11"),
("27938","10561","عملیات توسط WP Cron شروع شد","2023-04-15 07:52:06","2023-04-15 11:22:06"),
("27939","10561","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-15 07:52:06","2023-04-15 11:22:06"),
("27940","10562","ایجاد فعالیت","2023-04-15 07:52:06","2023-04-15 11:22:06"),
("27941","10562","عملیات توسط WP Cron شروع شد","2023-04-15 09:12:38","2023-04-15 12:42:38"),
("27942","10562","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-15 09:12:38","2023-04-15 12:42:38"),
("27943","10563","ایجاد فعالیت","2023-04-15 09:12:38","2023-04-15 12:42:38"),
("27944","10563","عملیات توسط WP Cron شروع شد","2023-04-15 10:35:49","2023-04-15 14:05:49"),
("27945","10563","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-15 10:35:49","2023-04-15 14:05:49"),
("27946","10564","ایجاد فعالیت","2023-04-15 10:35:49","2023-04-15 14:05:49"),
("27947","10564","عملیات توسط WP Cron شروع شد","2023-04-15 11:50:04","2023-04-15 15:20:04"),
("27948","10564","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-15 11:50:04","2023-04-15 15:20:04"),
("27949","10565","ایجاد فعالیت","2023-04-15 11:50:04","2023-04-15 15:20:04"),
("27950","10565","عملیات توسط WP Cron شروع شد","2023-04-15 15:28:12","2023-04-15 18:58:12"),
("27951","10565","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-15 15:28:12","2023-04-15 18:58:12"),
("27952","10566","ایجاد فعالیت","2023-04-15 15:28:12","2023-04-15 18:58:12"),
("27956","10566","عملیات توسط WP Cron شروع شد","2023-04-15 18:36:30","2023-04-15 22:06:30"),
("27957","10566","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-15 18:36:30","2023-04-15 22:06:30"),
("27958","10568","ایجاد فعالیت","2023-04-15 18:36:30","2023-04-15 22:06:30"),
("27959","10568","عملیات توسط WP Cron شروع شد","2023-04-16 00:00:05","2023-04-16 03:30:05"),
("27960","10568","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-16 00:00:05","2023-04-16 03:30:05"),
("27961","10569","ایجاد فعالیت","2023-04-16 00:00:05","2023-04-16 03:30:05"),
("27962","10569","عملیات توسط WP Cron شروع شد","2023-04-16 10:17:52","2023-04-16 13:47:52"),
("27963","10569","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-16 10:17:52","2023-04-16 13:47:52"),
("27964","10570","ایجاد فعالیت","2023-04-16 10:17:52","2023-04-16 13:47:52"),
("27965","10570","عملیات توسط WP Cron شروع شد","2023-04-16 13:04:42","2023-04-16 16:34:42"),
("27966","10570","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-16 13:04:42","2023-04-16 16:34:42"),
("27967","10571","ایجاد فعالیت","2023-04-16 13:04:42","2023-04-16 16:34:42"),
("27968","10571","عملیات توسط WP Cron شروع شد","2023-04-16 15:37:11","2023-04-16 19:07:11"),
("27969","10571","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-16 15:37:11","2023-04-16 19:07:11"),
("27970","10572","ایجاد فعالیت","2023-04-16 15:37:11","2023-04-16 19:07:11"),
("27974","10572","عملیات توسط WP Cron شروع شد","2023-04-17 04:30:33","2023-04-17 08:00:33"),
("27975","10572","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-17 04:30:33","2023-04-17 08:00:33"),
("27976","10574","ایجاد فعالیت","2023-04-17 04:30:33","2023-04-17 08:00:33"),
("27977","10574","عملیات توسط WP Cron شروع شد","2023-04-17 08:28:53","2023-04-17 11:58:53"),
("27978","10574","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-17 08:28:53","2023-04-17 11:58:53"),
("27979","10575","ایجاد فعالیت","2023-04-17 08:28:53","2023-04-17 11:58:53"),
("27980","10575","عملیات توسط WP Cron شروع شد","2023-04-17 10:34:14","2023-04-17 14:04:14"),
("27981","10575","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-17 10:34:14","2023-04-17 14:04:14"),
("27982","10576","ایجاد فعالیت","2023-04-17 10:34:14","2023-04-17 14:04:14"),
("27983","10576","عملیات توسط WP Cron شروع شد","2023-04-17 13:09:50","2023-04-17 16:39:50"),
("27984","10576","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-17 13:09:50","2023-04-17 16:39:50"),
("27985","10577","ایجاد فعالیت","2023-04-17 13:09:50","2023-04-17 16:39:50"),
("27986","10577","عملیات توسط WP Cron شروع شد","2023-04-17 14:11:14","2023-04-17 17:41:14"),
("27987","10577","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-17 14:11:14","2023-04-17 17:41:14"),
("27988","10578","ایجاد فعالیت","2023-04-17 14:11:14","2023-04-17 17:41:14"),
("27989","10578","عملیات توسط WP Cron شروع شد","2023-04-17 22:44:14","2023-04-18 02:14:14"),
("27990","10578","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-17 22:44:14","2023-04-18 02:14:14"),
("27991","10579","ایجاد فعالیت","2023-04-17 22:44:14","2023-04-18 02:14:14"),
("27995","10579","عملیات توسط WP Cron شروع شد","2023-04-18 05:23:29","2023-04-18 08:53:29"),
("27996","10579","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-18 05:23:29","2023-04-18 08:53:29"),
("27997","10581","ایجاد فعالیت","2023-04-18 05:23:29","2023-04-18 08:53:29"),
("27998","10581","عملیات توسط WP Cron شروع شد","2023-04-18 06:54:12","2023-04-18 10:24:12"),
("27999","10581","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-18 06:54:12","2023-04-18 10:24:12"),
("28000","10582","ایجاد فعالیت","2023-04-18 06:54:12","2023-04-18 10:24:12"),
("28001","10582","عملیات توسط WP Cron شروع شد","2023-04-18 09:23:40","2023-04-18 12:53:40"),
("28002","10582","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-18 09:23:40","2023-04-18 12:53:40"),
("28003","10583","ایجاد فعالیت","2023-04-18 09:23:40","2023-04-18 12:53:40"),
("28004","10583","عملیات توسط WP Cron شروع شد","2023-04-18 11:23:07","2023-04-18 14:53:07"),
("28005","10583","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-18 11:23:07","2023-04-18 14:53:07"),
("28006","10584","ایجاد فعالیت","2023-04-18 11:23:07","2023-04-18 14:53:07"),
("28007","10584","عملیات توسط WP Cron شروع شد","2023-04-18 13:13:39","2023-04-18 16:43:39"),
("28008","10584","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-18 13:13:39","2023-04-18 16:43:39"),
("28009","10585","ایجاد فعالیت","2023-04-18 13:13:39","2023-04-18 16:43:39"),
("28010","10585","عملیات توسط WP Cron شروع شد","2023-04-18 14:16:59","2023-04-18 17:46:59"),
("28011","10585","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-18 14:16:59","2023-04-18 17:46:59"),
("28012","10586","ایجاد فعالیت","2023-04-18 14:16:59","2023-04-18 17:46:59"),
("28013","10586","عملیات توسط WP Cron شروع شد","2023-04-18 18:51:43","2023-04-18 22:21:43"),
("28014","10586","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-18 18:51:43","2023-04-18 22:21:43"),
("28015","10587","ایجاد فعالیت","2023-04-18 18:51:43","2023-04-18 22:21:43"),
("28016","10587","عملیات توسط WP Cron شروع شد","2023-04-19 03:36:16","2023-04-19 07:06:16"),
("28017","10587","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-19 03:36:16","2023-04-19 07:06:16"),
("28018","10588","ایجاد فعالیت","2023-04-19 03:36:16","2023-04-19 07:06:16"),
("28022","10588","عملیات توسط WP Cron شروع شد","2023-04-19 05:22:21","2023-04-19 08:52:21"),
("28023","10588","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-19 05:22:21","2023-04-19 08:52:21"),
("28024","10590","ایجاد فعالیت","2023-04-19 05:22:21","2023-04-19 08:52:21"),
("28025","10590","عملیات توسط WP Cron شروع شد","2023-04-19 12:55:58","2023-04-19 16:25:58"),
("28026","10590","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-19 12:55:58","2023-04-19 16:25:58"),
("28027","10591","ایجاد فعالیت","2023-04-19 12:55:58","2023-04-19 16:25:58"),
("28028","10591","عملیات توسط WP Cron شروع شد","2023-04-19 19:16:23","2023-04-19 22:46:23"),
("28029","10591","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-19 19:16:23","2023-04-19 22:46:23"),
("28030","10592","ایجاد فعالیت","2023-04-19 19:16:23","2023-04-19 22:46:23"),
("28031","10592","عملیات توسط WP Cron شروع شد","2023-04-19 23:46:28","2023-04-20 03:16:28"),
("28032","10592","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-19 23:46:28","2023-04-20 03:16:28"),
("28033","10593","ایجاد فعالیت","2023-04-19 23:46:28","2023-04-20 03:16:28"),
("28034","10593","عملیات توسط WP Cron شروع شد","2023-04-20 00:51:38","2023-04-20 04:21:38"),
("28035","10593","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 00:51:38","2023-04-20 04:21:38"),
("28036","10594","ایجاد فعالیت","2023-04-20 00:51:38","2023-04-20 04:21:38"),
("28037","10594","عملیات توسط WP Cron شروع شد","2023-04-20 05:33:58","2023-04-20 09:03:58"),
("28038","10594","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 05:33:58","2023-04-20 09:03:58"),
("28039","10595","ایجاد فعالیت","2023-04-20 05:33:58","2023-04-20 09:03:58"),
("28043","10595","عملیات توسط WP Cron شروع شد","2023-04-20 07:38:01","2023-04-20 11:08:01"),
("28044","10595","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 07:38:01","2023-04-20 11:08:01"),
("28045","10597","ایجاد فعالیت","2023-04-20 07:38:01","2023-04-20 11:08:01"),
("28046","10597","عملیات توسط WP Cron شروع شد","2023-04-20 09:40:48","2023-04-20 13:10:48"),
("28047","10597","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 09:40:48","2023-04-20 13:10:48"),
("28048","10598","ایجاد فعالیت","2023-04-20 09:40:48","2023-04-20 13:10:48"),
("28049","10598","عملیات توسط WP Cron شروع شد","2023-04-20 12:24:09","2023-04-20 15:54:09"),
("28050","10598","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 12:24:09","2023-04-20 15:54:09"),
("28051","10599","ایجاد فعالیت","2023-04-20 12:24:09","2023-04-20 15:54:09"),
("28052","10599","عملیات توسط WP Cron شروع شد","2023-04-20 15:17:38","2023-04-20 18:47:38"),
("28053","10599","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 15:17:38","2023-04-20 18:47:38"),
("28054","10600","ایجاد فعالیت","2023-04-20 15:17:38","2023-04-20 18:47:38"),
("28055","10600","عملیات توسط WP Cron شروع شد","2023-04-20 16:52:34","2023-04-20 20:22:34"),
("28056","10600","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 16:52:34","2023-04-20 20:22:34"),
("28057","10601","ایجاد فعالیت","2023-04-20 16:52:34","2023-04-20 20:22:34"),
("28058","10601","عملیات توسط WP Cron شروع شد","2023-04-20 22:28:06","2023-04-21 01:58:06"),
("28059","10601","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 22:28:06","2023-04-21 01:58:06"),
("28060","10602","ایجاد فعالیت","2023-04-20 22:28:06","2023-04-21 01:58:06"),
("28061","10602","عملیات توسط WP Cron شروع شد","2023-04-20 23:43:01","2023-04-21 03:13:01"),
("28062","10602","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-20 23:43:01","2023-04-21 03:13:01"),
("28063","10603","ایجاد فعالیت","2023-04-20 23:43:01","2023-04-21 03:13:01"),
("28064","10603","عملیات توسط WP Cron شروع شد","2023-04-21 03:33:05","2023-04-21 07:03:05"),
("28065","10603","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-21 03:33:05","2023-04-21 07:03:05"),
("28066","10604","ایجاد فعالیت","2023-04-21 03:33:05","2023-04-21 07:03:05"),
("28067","10604","عملیات توسط WP Cron شروع شد","2023-04-21 05:24:10","2023-04-21 08:54:10"),
("28068","10604","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-21 05:24:10","2023-04-21 08:54:10"),
("28069","10605","ایجاد فعالیت","2023-04-21 05:24:10","2023-04-21 08:54:10"),
("28073","10605","عملیات توسط WP Cron شروع شد","2023-04-21 09:44:36","2023-04-21 13:14:36"),
("28074","10605","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-21 09:44:36","2023-04-21 13:14:36"),
("28075","10607","ایجاد فعالیت","2023-04-21 09:44:36","2023-04-21 13:14:36"),
("28076","10607","عملیات توسط WP Cron شروع شد","2023-04-21 13:27:30","2023-04-21 16:57:30"),
("28077","10607","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-21 13:27:30","2023-04-21 16:57:30"),
("28078","10608","ایجاد فعالیت","2023-04-21 13:27:30","2023-04-21 16:57:30"),
("28079","10608","عملیات توسط WP Cron شروع شد","2023-04-21 14:43:18","2023-04-21 18:13:18"),
("28080","10608","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-21 14:43:18","2023-04-21 18:13:18"),
("28081","10609","ایجاد فعالیت","2023-04-21 14:43:18","2023-04-21 18:13:18"),
("28082","10609","عملیات توسط WP Cron شروع شد","2023-04-21 21:19:45","2023-04-22 00:49:45"),
("28083","10609","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-21 21:19:45","2023-04-22 00:49:45"),
("28084","10610","ایجاد فعالیت","2023-04-21 21:19:45","2023-04-22 00:49:45"),
("28085","10610","عملیات توسط WP Cron شروع شد","2023-04-22 01:17:32","2023-04-22 04:47:32"),
("28086","10610","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 01:17:32","2023-04-22 04:47:32"),
("28087","10611","ایجاد فعالیت","2023-04-22 01:17:32","2023-04-22 04:47:32"),
("28088","10611","عملیات توسط WP Cron شروع شد","2023-04-22 04:35:51","2023-04-22 08:05:51"),
("28089","10611","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 04:35:51","2023-04-22 08:05:51"),
("28090","10612","ایجاد فعالیت","2023-04-22 04:35:51","2023-04-22 08:05:51"),
("28091","10612","عملیات توسط WP Cron شروع شد","2023-04-22 05:56:09","2023-04-22 09:26:09"),
("28092","10612","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 05:56:09","2023-04-22 09:26:09"),
("28093","10613","ایجاد فعالیت","2023-04-22 05:56:09","2023-04-22 09:26:09"),
("28094","10613","عملیات توسط WP Cron شروع شد","2023-04-22 08:37:06","2023-04-22 12:07:06"),
("28095","10613","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 08:37:06","2023-04-22 12:07:06"),
("28096","10614","ایجاد فعالیت","2023-04-22 08:37:06","2023-04-22 12:07:06"),
("28097","10614","عملیات توسط WP Cron شروع شد","2023-04-22 10:38:36","2023-04-22 14:08:36"),
("28098","10614","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 10:38:36","2023-04-22 14:08:36"),
("28099","10615","ایجاد فعالیت","2023-04-22 10:38:36","2023-04-22 14:08:36"),
("28103","10615","عملیات توسط WP Cron شروع شد","2023-04-22 13:16:50","2023-04-22 16:46:50"),
("28104","10615","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 13:16:50","2023-04-22 16:46:50"),
("28105","10617","ایجاد فعالیت","2023-04-22 13:16:50","2023-04-22 16:46:50"),
("28106","10617","عملیات توسط WP Cron شروع شد","2023-04-22 15:14:06","2023-04-22 18:44:06"),
("28107","10617","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 15:14:06","2023-04-22 18:44:06"),
("28108","10618","ایجاد فعالیت","2023-04-22 15:14:06","2023-04-22 18:44:06"),
("28109","10618","عملیات توسط WP Cron شروع شد","2023-04-22 16:30:56","2023-04-22 20:00:56"),
("28110","10618","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 16:30:56","2023-04-22 20:00:56"),
("28111","10619","ایجاد فعالیت","2023-04-22 16:30:56","2023-04-22 20:00:56"),
("28112","10619","عملیات توسط WP Cron شروع شد","2023-04-22 20:29:35","2023-04-22 23:59:35"),
("28113","10619","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 20:29:35","2023-04-22 23:59:35"),
("28114","10620","ایجاد فعالیت","2023-04-22 20:29:35","2023-04-22 23:59:35"),
("28115","10620","عملیات توسط WP Cron شروع شد","2023-04-22 22:12:29","2023-04-23 01:42:29"),
("28116","10620","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-22 22:12:29","2023-04-23 01:42:29"),
("28117","10621","ایجاد فعالیت","2023-04-22 22:12:29","2023-04-23 01:42:29"),
("28118","10621","عملیات توسط WP Cron شروع شد","2023-04-23 03:41:21","2023-04-23 07:11:21"),
("28119","10621","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-23 03:41:21","2023-04-23 07:11:21"),
("28120","10622","ایجاد فعالیت","2023-04-23 03:41:21","2023-04-23 07:11:21"),
("28121","10622","عملیات توسط WP Cron شروع شد","2023-04-23 07:28:56","2023-04-23 10:58:56"),
("28122","10622","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-23 07:28:56","2023-04-23 10:58:56"),
("28123","10623","ایجاد فعالیت","2023-04-23 07:28:56","2023-04-23 10:58:56"),
("28124","10623","عملیات توسط WP Cron شروع شد","2023-04-23 11:51:20","2023-04-23 15:21:20"),
("28125","10623","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-23 11:51:20","2023-04-23 15:21:20"),
("28126","10624","ایجاد فعالیت","2023-04-23 11:51:20","2023-04-23 15:21:20"),
("28130","10624","عملیات توسط WP Cron شروع شد","2023-04-23 14:23:30","2023-04-23 17:53:30"),
("28131","10624","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-23 14:23:30","2023-04-23 17:53:30"),
("28132","10626","ایجاد فعالیت","2023-04-23 14:23:30","2023-04-23 17:53:30"),
("28133","10626","عملیات توسط WP Cron شروع شد","2023-04-23 16:29:21","2023-04-23 19:59:21"),
("28134","10626","اقدام از طریق WP Cron انجام نشد: Scheduled action for wc_admin_unsnooze_admin_notes will not be executed as no callbacks are registered.","2023-04-23 16:29:21","2023-04-23 19:59:21"),
("28135","10626","This action appears to be consistently failing. A new instance will not be scheduled.","2023-04-23 16:29:21","2023-04-23 19:59:21"),
("30087","11277","ایجاد فعالیت","2024-09-12 17:17:22","2024-09-12 20:47:22"),
("30092","11277","action started via WP Cron","2024-09-13 17:37:55","2024-09-13 21:07:55"),
("30093","11277","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-13 17:37:55","2024-09-13 21:07:55"),
("30094","11280","action created","2024-09-13 17:37:55","2024-09-13 21:07:55"),
("30097","11281","action created","2024-09-13 17:39:02","2024-09-13 21:09:02"),
("30098","11282","action created","2024-09-13 17:39:02","2024-09-13 21:09:02"),
("30099","11283","action created","2024-09-13 17:39:02","2024-09-13 21:09:02"),
("30100","11281","action started via WP Cron","2024-09-13 17:39:54","2024-09-13 21:09:54"),
("30101","11281","action failed via WP Cron: Scheduled action for rank_math/analytics/workflow will not be executed as no callbacks are registered.","2024-09-13 17:39:54","2024-09-13 21:09:54"),
("30102","11282","action started via WP Cron","2024-09-13 17:39:54","2024-09-13 21:09:54"),
("30103","11282","action failed via WP Cron: Scheduled action for rank_math/analytics/workflow will not be executed as no callbacks are registered.","2024-09-13 17:39:54","2024-09-13 21:09:54"),
("30105","11285","action created","2024-09-13 18:20:53","2024-09-13 21:50:53"),
("30106","11286","action created","2024-09-13 18:20:53","2024-09-13 21:50:53"),
("30107","11285","action started via WP Cron","2024-09-13 18:20:53","2024-09-13 21:50:53"),
("30108","11285","action failed via WP Cron: Scheduled action for rank_math/analytics/workflow will not be executed as no callbacks are registered.","2024-09-13 18:20:53","2024-09-13 21:50:53"),
("30109","11286","action started via WP Cron","2024-09-13 18:20:53","2024-09-13 21:50:53"),
("30110","11286","action failed via WP Cron: Scheduled action for rank_math/analytics/workflow will not be executed as no callbacks are registered.","2024-09-13 18:20:53","2024-09-13 21:50:53"),
("30116","11283","action started via WP Cron","2024-09-14 12:43:04","2024-09-14 16:13:04"),
("30117","11283","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-09-14 12:43:04","2024-09-14 16:13:04"),
("30118","11288","action created","2024-09-14 12:43:04","2024-09-14 16:13:04"),
("30119","11280","action started via WP Cron","2024-09-15 10:13:42","2024-09-15 13:43:42"),
("30120","11280","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-15 10:13:42","2024-09-15 13:43:42"),
("30121","11289","action created","2024-09-15 10:13:42","2024-09-15 13:43:42"),
("30122","11289","action started via WP Cron","2024-09-16 13:04:02","2024-09-16 16:34:02"),
("30123","11289","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-16 13:04:02","2024-09-16 16:34:02"),
("30124","11290","action created","2024-09-16 13:04:02","2024-09-16 16:34:02"),
("30125","11288","action started via WP Cron","2024-09-17 16:26:09","2024-09-17 19:56:09"),
("30126","11288","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-09-17 16:26:09","2024-09-17 19:56:09"),
("30127","11291","action created","2024-09-17 16:26:09","2024-09-17 19:56:09"),
("30128","11290","action started via WP Cron","2024-09-17 16:26:09","2024-09-17 19:56:09"),
("30129","11290","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-17 16:26:09","2024-09-17 19:56:09"),
("30130","11292","action created","2024-09-17 16:26:09","2024-09-17 19:56:09"),
("30131","11292","action started via WP Cron","2024-09-18 21:09:53","2024-09-19 00:39:53"),
("30132","11292","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-18 21:09:53","2024-09-19 00:39:53"),
("30133","11293","action created","2024-09-18 21:09:53","2024-09-19 00:39:53"),
("30134","11293","action started via WP Cron","2024-09-20 01:35:28","2024-09-20 05:05:28"),
("30135","11293","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-20 01:35:29","2024-09-20 05:05:29"),
("30136","11294","action created","2024-09-20 01:35:29","2024-09-20 05:05:29"),
("30137","11291","action started via WP Cron","2024-09-21 02:26:36","2024-09-21 05:56:36"),
("30138","11291","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-09-21 02:26:36","2024-09-21 05:56:36"),
("30139","11295","action created","2024-09-21 02:26:36","2024-09-21 05:56:36"),
("30140","11294","action started via WP Cron","2024-09-21 02:26:36","2024-09-21 05:56:36"),
("30141","11294","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-21 02:26:36","2024-09-21 05:56:36"),
("30142","11296","action created","2024-09-21 02:26:36","2024-09-21 05:56:36"),
("30143","11296","action started via WP Cron","2024-09-22 08:38:05","2024-09-22 12:08:05"),
("30144","11296","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-22 08:38:05","2024-09-22 12:08:05"),
("30145","11297","action created","2024-09-22 08:38:05","2024-09-22 12:08:05"),
("30146","11297","action started via WP Cron","2024-09-23 08:38:16","2024-09-23 12:08:16"),
("30147","11297","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-23 08:38:16","2024-09-23 12:08:16"),
("30148","11298","action created","2024-09-23 08:38:16","2024-09-23 12:08:16"),
("30158","11302","action created","2024-09-23 18:55:56","2024-09-23 22:25:56"),
("30159","11302","action started via WP Cron","2024-09-23 18:56:56","2024-09-23 22:26:56"),
("30160","11302","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-09-23 18:56:56","2024-09-23 22:26:56"),
("30161","11295","action started via WP Cron","2024-09-24 07:12:52","2024-09-24 10:42:52"),
("30162","11295","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-09-24 07:12:52","2024-09-24 10:42:52"),
("30164","11298","action started via WP Cron","2024-09-24 08:38:54","2024-09-24 12:08:54"),
("30165","11298","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-24 08:38:54","2024-09-24 12:08:54"),
("30166","11304","action created","2024-09-24 08:38:54","2024-09-24 12:08:54"),
("30167","11304","action started via WP Cron","2024-09-25 09:32:58","2024-09-25 13:02:58"),
("30168","11304","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-25 09:32:58","2024-09-25 13:02:58"),
("30169","11305","action created","2024-09-25 09:32:58","2024-09-25 13:02:58"),
("30170","11305","action started via WP Cron","2024-09-26 10:28:44","2024-09-26 13:58:44"),
("30171","11305","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-26 10:28:44","2024-09-26 13:58:44"),
("30172","11306","action created","2024-09-26 10:28:44","2024-09-26 13:58:44"),
("30176","11306","action started via WP Cron","2024-09-27 13:04:35","2024-09-27 16:34:35"),
("30177","11306","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-27 13:04:35","2024-09-27 16:34:35"),
("30178","11308","action created","2024-09-27 13:04:35","2024-09-27 16:34:35"),
("30179","11308","action started via WP Cron","2024-09-30 00:13:28","2024-09-30 03:43:28"),
("30180","11308","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-09-30 00:13:28","2024-09-30 03:43:28"),
("30181","11309","action created","2024-09-30 00:13:28","2024-09-30 03:43:28"),
("30185","11309","action started via WP Cron","2024-10-01 03:00:29","2024-10-01 06:30:29"),
("30186","11309","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-01 03:00:29","2024-10-01 06:30:29"),
("30187","11311","action created","2024-10-01 03:00:29","2024-10-01 06:30:29"),
("30188","11311","action started via WP Cron","2024-10-02 05:22:00","2024-10-02 08:52:00"),
("30189","11311","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-02 05:22:00","2024-10-02 08:52:00"),
("30190","11312","action created","2024-10-02 05:22:00","2024-10-02 08:52:00"),
("30191","11312","action started via WP Cron","2024-10-03 07:22:09","2024-10-03 10:52:09"),
("30192","11312","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-03 07:22:09","2024-10-03 10:52:09"),
("30193","11313","action created","2024-10-03 07:22:09","2024-10-03 10:52:09"),
("30197","11313","action started via WP Cron","2024-10-04 09:15:51","2024-10-04 12:45:51"),
("30198","11313","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-04 09:15:51","2024-10-04 12:45:51"),
("30199","11315","action created","2024-10-04 09:15:51","2024-10-04 12:45:51"),
("30200","11315","action started via WP Cron","2024-10-05 15:34:04","2024-10-05 19:04:04"),
("30201","11315","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-05 15:34:04","2024-10-05 19:04:04"),
("30202","11316","action created","2024-10-05 15:34:04","2024-10-05 19:04:04"),
("30203","11316","action started via WP Cron","2024-10-06 17:01:58","2024-10-06 20:31:58"),
("30204","11316","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-06 17:01:58","2024-10-06 20:31:58"),
("30205","11317","action created","2024-10-06 17:01:58","2024-10-06 20:31:58"),
("30209","11317","action started via WP Cron","2024-10-07 17:52:40","2024-10-07 21:22:40"),
("30210","11317","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-07 17:52:40","2024-10-07 21:22:40"),
("30211","11319","action created","2024-10-07 17:52:40","2024-10-07 21:22:40"),
("30212","11319","action started via WP Cron","2024-10-08 17:56:04","2024-10-08 21:26:04"),
("30213","11319","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-08 17:56:04","2024-10-08 21:26:04"),
("30214","11320","action created","2024-10-08 17:56:04","2024-10-08 21:26:04"),
("30215","11320","action started via WP Cron","2024-10-10 01:12:57","2024-10-10 04:42:57"),
("30216","11320","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-10 01:12:57","2024-10-10 04:42:57"),
("30217","11321","action created","2024-10-10 01:12:57","2024-10-10 04:42:57"),
("30220","11322","action created","2024-10-10 12:55:50","2024-10-10 16:25:50"),
("30221","11321","action started via WP Cron","2024-10-11 02:46:30","2024-10-11 06:16:30"),
("30222","11321","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-11 02:46:30","2024-10-11 06:16:30"),
("30223","11323","action created","2024-10-11 02:46:30","2024-10-11 06:16:30"),
("30224","11323","action started via WP Cron","2024-10-12 02:59:50","2024-10-12 06:29:50"),
("30225","11323","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-12 02:59:50","2024-10-12 06:29:50"),
("30226","11324","action created","2024-10-12 02:59:50","2024-10-12 06:29:50"),
("30227","11324","action started via WP Cron","2024-10-13 03:37:10","2024-10-13 07:07:10"),
("30228","11324","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-13 03:37:10","2024-10-13 07:07:10"),
("30229","11325","action created","2024-10-13 03:37:10","2024-10-13 07:07:10"),
("30230","11322","action started via WP Cron","2024-10-14 06:40:22","2024-10-14 10:10:22"),
("30231","11322","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-10-14 06:40:22","2024-10-14 10:10:22"),
("30233","11325","action started via WP Cron","2024-10-14 06:40:22","2024-10-14 10:10:22"),
("30234","11325","action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.","2024-10-14 06:40:22","2024-10-14 10:10:22"),
("30235","11325","This action appears to be consistently failing. A new instance will not be scheduled.","2024-10-14 06:40:22","2024-10-14 10:10:22"),
("30286","11343","action created","2024-12-04 22:32:08","2024-12-05 02:02:08"),
("30287","11343","action started via WP Cron","2024-12-08 00:29:05","2024-12-08 03:59:05"),
("30288","11343","action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2024-12-08 00:29:05","2024-12-08 03:59:05"),
("30289","11343","This action appears to be consistently failing. A new instance will not be scheduled.","2024-12-08 00:29:05","2024-12-08 03:59:05"),
("30314","11353","action created","2025-04-16 21:08:04","2025-04-17 01:38:04"),
("30315","11353","action started via Async Request","2025-04-16 21:09:05","2025-04-17 01:39:05"),
("30316","11353","action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-04-16 21:09:05","2025-04-17 01:39:05"),
("31450","11731","action created","2025-07-25 09:49:26","2025-07-25 14:19:26"),
("31472","11731","action started via Async Request","2026-01-21 07:05:28","2026-01-21 10:35:28"),
("31473","11731","action failed via Async Request: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.","2026-01-21 07:05:28","2026-01-21 10:35:28"),
("31474","11731","This action appears to be consistently failing. A new instance will not be scheduled.","2026-01-21 07:05:28","2026-01-21 10:35:28"),
("31475","11739","action created","2026-01-21 07:07:38","2026-01-21 10:37:38"),
("31476","11739","action started via Async Request","2026-01-21 07:09:29","2026-01-21 10:39:29"),
("31477","11739","action complete via Async Request","2026-01-21 07:09:29","2026-01-21 10:39:29"),
("31478","11740","action created","2026-01-21 07:09:36","2026-01-21 10:39:36"),
("31480","11742","action created","2026-01-21 07:09:53","2026-01-21 10:39:53"),
("31483","11742","action started via Async Request","2026-01-21 07:10:20","2026-01-21 10:40:20"),
("31484","11743","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31485","11744","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31486","11745","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31487","11746","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31488","11747","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31489","11748","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31490","11749","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31491","11750","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31492","11751","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31493","11752","action created","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31494","11742","action complete via Async Request","2026-01-21 07:10:50","2026-01-21 10:40:50"),
("31495","11740","action started via Async Request","2026-01-21 07:11:16","2026-01-21 10:41:16"),
("31496","11740","action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2026-01-21 07:11:16","2026-01-21 10:41:16"),
("31497","11743","action started via WP Cron","2026-01-21 07:11:37","2026-01-21 10:41:37"),
("31498","11743","action complete via WP Cron","2026-01-21 07:11:37","2026-01-21 10:41:37"),
("31499","11744","action started via Async Request","2026-01-21 07:11:42","2026-01-21 10:41:42"),
("31500","11744","action complete via Async Request","2026-01-21 07:11:42","2026-01-21 10:41:42"),
("31501","11745","action started via Async Request","2026-01-21 07:11:44","2026-01-21 10:41:44"),
("31502","11745","action complete via Async Request","2026-01-21 07:11:44","2026-01-21 10:41:44"),
("31503","11746","action started via Async Request","2026-01-21 07:12:08","2026-01-21 10:42:08"),
("31504","11746","action complete via Async Request","2026-01-21 07:12:08","2026-01-21 10:42:08"),
("31505","11747","action started via Async Request","2026-01-21 07:12:10","2026-01-21 10:42:10"),
("31506","11747","action complete via Async Request","2026-01-21 07:12:10","2026-01-21 10:42:10"),
("31507","11748","action started via WP Cron","2026-01-21 07:12:31","2026-01-21 10:42:31"),
("31508","11748","action complete via WP Cron","2026-01-21 07:12:31","2026-01-21 10:42:31"),
("31509","11749","action started via Async Request","2026-01-21 07:12:33","2026-01-21 10:42:33"),
("31510","11749","action complete via Async Request","2026-01-21 07:12:33","2026-01-21 10:42:33"),
("31511","11750","action started via Async Request","2026-01-21 07:12:36","2026-01-21 10:42:36"),
("31512","11750","action complete via Async Request","2026-01-21 07:12:36","2026-01-21 10:42:36"),
("31513","11751","action started via Async Request","2026-01-21 07:12:49","2026-01-21 10:42:49"),
("31514","11751","action complete via Async Request","2026-01-21 07:12:49","2026-01-21 10:42:49"),
("31515","11752","action started via Async Request","2026-01-21 07:12:59","2026-01-21 10:42:59"),
("31516","11752","action complete via Async Request","2026-01-21 07:12:59","2026-01-21 10:42:59"),
("31517","11753","action created","2026-01-21 07:13:55","2026-01-21 10:43:55");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("31519","11753","action started via WP Cron","2026-01-21 07:15:06","2026-01-21 10:45:06"),
("31520","11753","action complete via WP Cron","2026-01-21 07:15:06","2026-01-21 10:45:06"),
("31526","11760","action created","2026-01-21 07:15:13","2026-01-21 10:45:13"),
("31540","11760","action started via WP Cron","2026-01-21 07:17:31","2026-01-21 10:47:31"),
("31541","11760","action complete via WP Cron","2026-01-21 07:17:31","2026-01-21 10:47:31"),
("31562","11772","action created","2026-01-21 07:18:41","2026-01-21 10:48:41"),
("31576","11772","action started via WP Cron","2026-01-21 07:19:34","2026-01-21 10:49:34"),
("31577","11774","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31578","11775","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31579","11776","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31580","11777","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31581","11778","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31582","11779","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31583","11780","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31584","11781","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31585","11782","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31586","11783","action created","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31587","11772","action complete via WP Cron","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31588","11774","action started via WP Cron","2026-01-21 07:19:45","2026-01-21 10:49:45"),
("31589","11774","action complete via WP Cron","2026-01-21 07:19:50","2026-01-21 10:49:50"),
("31595","11775","action started via WP Cron","2026-01-21 07:19:57","2026-01-21 10:49:57"),
("31596","11775","action complete via WP Cron","2026-01-21 07:20:02","2026-01-21 10:50:02"),
("31597","11776","action started via WP Cron","2026-01-21 07:20:02","2026-01-21 10:50:02"),
("31598","11776","action complete via WP Cron","2026-01-21 07:20:02","2026-01-21 10:50:02"),
("31599","11777","action started via WP Cron","2026-01-21 07:20:02","2026-01-21 10:50:02"),
("31600","11777","action complete via WP Cron","2026-01-21 07:20:03","2026-01-21 10:50:03"),
("31601","11778","action started via WP Cron","2026-01-21 07:20:03","2026-01-21 10:50:03"),
("31602","11778","action complete via WP Cron","2026-01-21 07:20:04","2026-01-21 10:50:04"),
("31603","11779","action started via WP Cron","2026-01-21 07:20:04","2026-01-21 10:50:04"),
("31604","11779","action complete via WP Cron","2026-01-21 07:20:07","2026-01-21 10:50:07"),
("31605","11780","action started via WP Cron","2026-01-21 07:20:07","2026-01-21 10:50:07"),
("31606","11780","action complete via WP Cron","2026-01-21 07:20:07","2026-01-21 10:50:07"),
("31607","11781","action started via WP Cron","2026-01-21 07:20:07","2026-01-21 10:50:07"),
("31608","11781","action complete via WP Cron","2026-01-21 07:20:07","2026-01-21 10:50:07"),
("31609","11782","action started via WP Cron","2026-01-21 07:20:07","2026-01-21 10:50:07"),
("31610","11782","action complete via WP Cron","2026-01-21 07:20:08","2026-01-21 10:50:08"),
("31611","11783","action started via WP Cron","2026-01-21 07:20:08","2026-01-21 10:50:08"),
("31612","11783","action complete via WP Cron","2026-01-21 07:20:09","2026-01-21 10:50:09"),
("31728","11824","action created","2026-01-21 07:32:31","2026-01-21 11:02:31"),
("31842","11824","action started via Async Request","2026-01-21 07:33:58","2026-01-21 11:03:58"),
("31843","11824","action complete via Async Request","2026-01-21 07:33:58","2026-01-21 11:03:58"),
("31913","11885","action created","2026-01-23 13:57:09","2026-01-23 17:27:09"),
("31969","11885","action started via Async Request","2026-01-23 13:58:14","2026-01-23 17:28:14"),
("31970","11885","action complete via Async Request","2026-01-23 13:58:14","2026-01-23 17:28:14"),
("32069","11937","action created","2026-01-23 14:32:12","2026-01-23 18:02:12"),
("32091","11937","action started via WP Cron","2026-01-23 14:34:05","2026-01-23 18:04:05"),
("32092","11937","action complete via WP Cron","2026-01-23 14:34:05","2026-01-23 18:04:05"),
("32097","11950","action created","2026-01-23 14:34:05","2026-01-23 18:04:05"),
("32109","11950","action started via Async Request","2026-01-23 14:35:11","2026-01-23 18:05:11"),
("32110","11950","action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2026-01-23 14:35:11","2026-01-23 18:05:11"),
("32396","12046","action created","2026-01-29 12:59:31","2026-01-29 16:29:31"),
("32397","12047","action created","2026-01-29 12:59:40","2026-01-29 16:29:40"),
("32398","12048","action created","2026-01-29 12:59:40","2026-01-29 16:29:40"),
("32399","12049","action created","2026-01-29 12:59:40","2026-01-29 16:29:40"),
("32400","12050","action created","2026-01-29 12:59:40","2026-01-29 16:29:40"),
("32401","12051","action created","2026-01-29 12:59:40","2026-01-29 16:29:40"),
("32402","12047","action started via WP Cron","2026-01-29 13:00:03","2026-01-29 16:30:03"),
("32403","12047","action complete via WP Cron","2026-01-29 13:00:07","2026-01-29 16:30:07"),
("32404","12048","action started via WP Cron","2026-01-29 13:00:07","2026-01-29 16:30:07"),
("32405","12048","action complete via WP Cron","2026-01-29 13:00:09","2026-01-29 16:30:09"),
("32406","12049","action started via WP Cron","2026-01-29 13:00:09","2026-01-29 16:30:09"),
("32407","12049","action complete via WP Cron","2026-01-29 13:00:10","2026-01-29 16:30:10"),
("32408","12050","action started via WP Cron","2026-01-29 13:00:10","2026-01-29 16:30:10"),
("32409","12050","action complete via WP Cron","2026-01-29 13:00:12","2026-01-29 16:30:12"),
("32410","12051","action started via WP Cron","2026-01-29 13:00:12","2026-01-29 16:30:12"),
("32411","12051","action complete via WP Cron","2026-01-29 13:00:13","2026-01-29 16:30:13"),
("32412","12052","action created","2026-01-29 13:00:22","2026-01-29 16:30:22"),
("32413","12053","action created","2026-01-29 13:00:22","2026-01-29 16:30:22"),
("32414","12054","action created","2026-01-29 13:00:22","2026-01-29 16:30:22"),
("32415","12055","action created","2026-01-29 13:00:22","2026-01-29 16:30:22"),
("32416","12056","action created","2026-01-29 13:00:22","2026-01-29 16:30:22"),
("32417","12057","action created","2026-01-29 13:00:22","2026-01-29 16:30:22"),
("32418","12058","action created","2026-01-29 13:00:22","2026-01-29 16:30:22");

INSERT IGNORE INTO `wp_duplicator_activity_logs` VALUES 
("5","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 3,\n    \"packageName\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0\n}","0","4.5.22","2026-01-29 13:00:14","2026-01-29 13:00:14"),
("6","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 3,\n    \"packageName\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 24992,\n    \"dirCount\": 3639,\n    \"size\": 523896573\n}","5","4.5.22","2026-01-29 13:00:21","2026-01-29 13:00:21"),
("7","backup_create","start","10","Backup create: 20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa","{\n    \"packageId\": 4,\n    \"packageName\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 24992,\n    \"dirCount\": 3639,\n    \"size\": 523896573,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22","2026-01-29 13:00:39","2026-01-29 13:00:39"),
("8","backup_create","db_dump","10","Backup create: 20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa - DB Dump","{\n    \"packageId\": 4,\n    \"packageName\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 24992,\n    \"dirCount\": 3639,\n    \"size\": 523896573,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","7","4.5.22","2026-01-29 13:00:39","2026-01-29 13:00:39");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("3","Standard","20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa","e3e102cbe8995cb71526_20260129130012","20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 3,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.6.24\",\n    \"VersionPHP\": \"8.1.30\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa\",\n    \"hash\": \"e3e102cbe8995cb71526_20260129130012\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/web102.sa-farhood.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.opcache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.tmb\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.htaccess\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.user.ini\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/php.ini\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/web.config\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-config.php\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/\",\n        \"Size\": 523896573,\n        \"Dirs\": [],\n        \"DirCount\": 3639,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 24992,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 242181737,\n                        \"bytes\": \"230.96MB\",\n                        \"nodes\": 16040,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 107337372,\n                        \"bytes\": \"102.36MB\",\n                        \"nodes\": 7346,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 389032993,\n                        \"bytes\": \"371.01MB\",\n                        \"nodes\": 25537,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-snapshots\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.opcache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.tmb\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/old-cache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/updraft\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wfcache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/cache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 74516998,\n                        \"bytes\": \"71.06MB\",\n                        \"nodes\": 1,\n                        \"name\": \"melbet.apk\",\n                        \"dir\": \".\",\n                        \"path\": \"melbet.apk\"\n                    },\n                    {\n                        \"ubytes\": 4556642,\n                        \"bytes\": \"4.35MB\",\n                        \"nodes\": 1,\n                        \"name\": \"ui.js\",\n                        \"dir\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\",\n                        \"path\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\\/ui.js\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.htaccess\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.user.ini\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/php.ini\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/web.config\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/debug.log\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html <span class=\\\"size\\\" >499.63MB<\\/span> <span class=\\\"nodes\\\" >28631<\\/span>\",\n                \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >371.01MB<\\/span> <span class=\\\"nodes\\\" >25537<\\/span>\",\n                        \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >230.96MB<\\/span> <span class=\\\"nodes\\\" >16040<\\/span>\",\n                                \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"elementor-pro <span class=\\\"size\\\" >56.36MB<\\/span> <span class=\\\"nodes\\\" >2135<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/elementor-pro\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"assets <span class=\\\"size\\\" >13.7MB<\\/span> <span class=\\\"nodes\\\" >392<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/elementor-pro\\/assets\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"js <span class=\\\"size\\\" >10.3MB<\\/span> <span class=\\\"nodes\\\" >170<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/elementor-pro\\/assets\\/js\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"packages <span class=\\\"size\\\" >5.14MB<\\/span> <span class=\\\"nodes\\\" >22<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"ui <span class=\\\"size\\\" >5.1MB<\\/span> <span class=\\\"nodes\\\" >6<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"ui.js <span class=\\\"size\\\" >4.35MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\\/ui.js\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-childs\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-childs\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"uploads <span class=\\\"size\\\" >102.36MB<\\/span> <span class=\\\"nodes\\\" >7346<\\/span>\",\n                                \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": true,\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    },\n                    {\n                        \"text\": \"melbet.apk <span class=\\\"size\\\" >71.06MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                        \"fullPath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/melbet.apk\",\n                        \"type\": \"file\",\n                        \"state\": {\n                            \"opened\": false,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": null,\n                        \"li_attr\": {\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"ppmCT3Yt0rYmX1r\\/yWXduo\\/9XX1c8mEYFZcj3xs\\/8CGzgyvDw\\/Z\\/fse79DJ+OOcwGv+Ez6iPLHTJTzVV\\/SWosA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"arkakato_web102\",\n            \"tablesBaseCount\": 84,\n            \"tablesFinalCount\": 84,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 7781,\n            \"tablesSizeOnDisk\": 16205961,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"343\",\n                    \"insertedRows\": 0,\n                    \"size\": 177212\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 9508\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"1031\",\n                    \"insertedRows\": 0,\n                    \"size\": 151440\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_jnews_post_like\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 3098\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"676\",\n                    \"insertedRows\": 0,\n                    \"size\": 2715648\n                },\n                \"wp_popularpostsdata\": {\n                    \"inaccurateRows\": \"53\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_popularpostssummary\": {\n                    \"inaccurateRows\": \"1840\",\n                    \"insertedRows\": 0,\n                    \"size\": 311296\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"2232\",\n                    \"insertedRows\": 0,\n                    \"size\": 8291276\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"541\",\n                    \"insertedRows\": 0,\n                    \"size\": 2910684\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"46\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_analytics_objects\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"343\",\n                    \"insertedRows\": 0,\n                    \"size\": 47636\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 0,\n                    \"size\": 3350\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 95152\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 95152\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 10452\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 0,\n                    \"size\": 15048\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 0,\n                    \"size\": 3513\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 0,\n                    \"size\": 6656\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"156\",\n                    \"insertedRows\": 0,\n                    \"size\": 31252\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 8460\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 0,\n                    \"size\": 10076\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 0,\n                    \"size\": 6528\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 2082\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 11488\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 9576\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 4484\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.24\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"progressPercent\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22\",\n    \"created\": \"2026-01-29 13:00:12\",\n    \"updated\": \"2026-01-29 13:00:21\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 5,\n    \"mainActivityLogId\": 0\n}","4.5.22","2026-01-29 13:00:12","2026-01-29 13:00:21"),
("4","Standard","20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa","e3e102cbe8995cb71526_20260129130012","20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 4,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.6.24\",\n    \"VersionPHP\": \"8.1.30\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa\",\n    \"hash\": \"e3e102cbe8995cb71526_20260129130012\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/web102.sa-farhood.ir\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_scan.json\",\n    \"timer_start\": 1769691639.5591271,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.opcache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.tmb\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.htaccess\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.user.ini\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/php.ini\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/web.config\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-config.php\",\n            \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/\",\n        \"Size\": 523896573,\n        \"Dirs\": [],\n        \"DirCount\": 3639,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 24992,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 242181737,\n                        \"bytes\": \"230.96MB\",\n                        \"nodes\": 16040,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 107337372,\n                        \"bytes\": \"102.36MB\",\n                        \"nodes\": 7346,\n                        \"name\": \"uploads\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/uploads\"\n                    },\n                    {\n                        \"ubytes\": 389032993,\n                        \"bytes\": \"371.01MB\",\n                        \"nodes\": 25537,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-snapshots\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.opcache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.tmb\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/old-cache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/updraft\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/wfcache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/cache\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 74516998,\n                        \"bytes\": \"71.06MB\",\n                        \"nodes\": 1,\n                        \"name\": \"melbet.apk\",\n                        \"dir\": \".\",\n                        \"path\": \"melbet.apk\"\n                    },\n                    {\n                        \"ubytes\": 4556642,\n                        \"bytes\": \"4.35MB\",\n                        \"nodes\": 1,\n                        \"name\": \"ui.js\",\n                        \"dir\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\",\n                        \"path\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\\/ui.js\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.htaccess\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/.user.ini\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/php.ini\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/web.config\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/debug.log\",\n                    \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Lf7swWpuVTCWXQq3zInDajsjuUZkH\\/SfThpQISgJrclRr04xjrStj3wSgG6wpv2g7blJ5+FTlwjFggfdu\\/lQlg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"arkakato_web102\",\n            \"tablesBaseCount\": 84,\n            \"tablesFinalCount\": 84,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 7781,\n            \"tablesSizeOnDisk\": 16205961,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"343\",\n                    \"insertedRows\": 0,\n                    \"size\": 177212\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 9508\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"1031\",\n                    \"insertedRows\": 0,\n                    \"size\": 151440\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_jnews_post_like\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 3098\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"676\",\n                    \"insertedRows\": 0,\n                    \"size\": 2715648\n                },\n                \"wp_popularpostsdata\": {\n                    \"inaccurateRows\": \"53\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_popularpostssummary\": {\n                    \"inaccurateRows\": \"1840\",\n                    \"insertedRows\": 0,\n                    \"size\": 311296\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"2232\",\n                    \"insertedRows\": 0,\n                    \"size\": 8291276\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"541\",\n                    \"insertedRows\": 0,\n                    \"size\": 2910684\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"46\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_analytics_objects\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"343\",\n                    \"insertedRows\": 0,\n                    \"size\": 47636\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 0,\n                    \"size\": 3350\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 95152\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 95152\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 10452\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 0,\n                    \"size\": 15048\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 0,\n                    \"size\": 3513\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 0,\n                    \"size\": 6656\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"156\",\n                    \"insertedRows\": 0,\n                    \"size\": 31252\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 8460\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 0,\n                    \"size\": 10076\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 0,\n                    \"size\": 6528\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 2082\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 11488\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 9576\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 4484\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.24\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/arkakato\\/domains\\/web102.sa-farhood.ir\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\\/20260129_d988d8a7d986d8a7db8cdaa9d8b3d8a8d8aa_e3e102cbe8995cb71526_20260129130012_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"progressPercent\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1769691641,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_activity_logs\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_e_events\",\n            \"wp_e_notes\",\n            \"wp_e_notes_users_relations\",\n            \"wp_e_submissions\",\n            \"wp_e_submissions_actions_log\",\n            \"wp_e_submissions_values\",\n            \"wp_jnews_post_like\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_popularpostsdata\",\n            \"wp_popularpostssummary\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_rank_math_404_logs\",\n            \"wp_rank_math_analytics_objects\",\n            \"wp_rank_math_internal_links\",\n            \"wp_rank_math_internal_meta\",\n            \"wp_rank_math_redirections\",\n            \"wp_rank_math_redirections_cache\",\n            \"wp_revslider_css\",\n            \"wp_revslider_css_bkp\",\n            \"wp_revslider_layer_animations\",\n            \"wp_revslider_layer_animations_bkp\",\n            \"wp_revslider_navigations\",\n            \"wp_revslider_navigations_bkp\",\n            \"wp_revslider_sliders\",\n            \"wp_revslider_sliders_bkp\",\n            \"wp_revslider_slides\",\n            \"wp_revslider_slides_bkp\",\n            \"wp_revslider_static_slides\",\n            \"wp_revslider_static_slides_bkp\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_orders\",\n            \"wp_wc_orders_meta\",\n            \"wp_wc_order_addresses\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_operational_data\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_tax_rates\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_wpr_above_the_fold\",\n            \"wp_wpr_lazy_render_content\",\n            \"wp_wpr_rocket_cache\",\n            \"wp_wpr_rucss_used_css\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1769691639.584168,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 7798,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"2\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_jnews_post_like\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_popularpostsdata\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_popularpostssummary\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_analytics_objects\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_redirections\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_css_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_layer_animations_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_navigations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_navigations_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_sliders_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_slides_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_static_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_revslider_static_slides_bkp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_above_the_fold\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_lazy_render_content\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22\",\n    \"created\": \"2026-01-29 13:00:12\",\n    \"updated\": \"2026-01-29 13:00:41\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 5,\n    \"mainActivityLogId\": 7\n}","4.5.22","2026-01-29 13:00:12","2026-01-29 13:00:41");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"iranmlbt.com@gmail.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"iranmlbt.com@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"http:\\/\\/web102.sa-farhood.ir\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1753464178,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.22\",\n    \"created\": \"2025-07-25 17:22:57\",\n    \"updated\": \"2026-01-29 13:00:12\"\n}","4.5.22","2025-07-25 17:22:57","2026-01-29 13:00:12"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"AnC35VXgROuwDfgbG3S0+WwY56pa0+4Ws7pSM1e4WQ8yUkwmP0KOoGNr0YT8m\\/6nP0lG0i1bO1kzMtmL45WWFcc0NDkq3Q8D\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.22\",\n    \"created\": \"2025-07-25 17:22:57\",\n    \"updated\": \"2026-01-21 07:04:57\",\n    \"dataIsEncrypted\": true\n}","4.5.22","2025-07-25 17:22:57","2026-01-21 07:04:57"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"p7Ng3PChDDNvUHkQo1CUUYCWMbfVOP2s1RJfkBN+YY05nI69HNQdqk8vHThOSpXuPamqHApSsS98cLe9AP5\\/feGuu1hRAjMogwPGk+rGw7ieKXcdR+CuO177ge8JOYUtS7yJ\\/sP1RlVkLSvYuanCJmIu50VXeC94cSlZv\\/QTDelLs6os4eYjzastPc7UUv6z5nEH8erYhzDaWmMpynI3dRQaISoMSVnUUuW7rXS3VwAcC3Um2SMdFrPo1Cn1WKOcKv\\/q\\/tAtnqbWi\\/tCHJYuSj82GcClWO46rSQyOGwyvzI=\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.22\",\n    \"created\": \"2025-07-25 17:22:57\",\n    \"updated\": \"2026-01-21 07:04:57\"\n}","4.5.22","2025-07-25 17:22:57","2026-01-21 07:04:57"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.22\",\n    \"created\": \"\",\n    \"updated\": \"2026-01-21 07:05:11\"\n}","4.5.22","2025-07-25 17:22:57","2026-01-21 07:05:11"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"22fk6DIrHJ+EzVmtd663ErJ6DVPLPad6OjBuqOmnLLn3EWEDAQ0lBFPW9q6GaQEKGkxsRGuuYC5og7oSqmCkGw==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.22\",\n    \"created\": \"2025-07-25 17:22:57\",\n    \"updated\": \"2025-07-25 17:22:57\"\n}","4.5.22","2025-07-25 17:22:57","2025-07-25 17:22:57"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"bZmOo9D6waGjI\\/+ukrEvCRnLzWr7blJQu42+oORliB9cDvc2gU8\\/neNS4O2wZYWvAgpHNvj85iPuqHwFZ0xKmA==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.22\",\n    \"created\": \"2025-07-25 17:22:57\",\n    \"updated\": \"2026-01-29 13:00:12\"\n}","4.5.22","2025-07-25 17:22:57","2026-01-29 13:00:12"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"CR3xtinz0u5ghQ7MPWKQxw+Yy\\/jcCeeocKdKtK1sioUf2HkRLskc0IU3iiWY5Jj1Qu6dZeWPRTtb5K1PYuJ79w==\",\n    \"status\": \"olijret7ZgTrNyBeZxKgG2S9XzQsO76RSW7IxkPeKOYGCoSUJMJ7w2tcNiC1aleiHff892lQiWAILCNOszSZdFTsPAF7OxcN\",\n    \"type\": \"wUS1bNxK1IAEZPka0rdHtI+Wujy5H\\/S2eMOH4uA\\/C7RVoa2XSlxO8l4AayIBtT6oR03UljSiq+zPro9o5incm7mfR8q\\/ENGW\",\n    \"data\": \"omIp+clmIdeBD\\/a\\/IexkZKEknSjZ8bkarn+o7+puUTO\\/vazAi6\\/VCmZTIc+6SJq1eWIoLxZrkp6DUqI2FB4FhpnuY6Dh0FQUeEX81lShj35t5z+NnWlntx5u7JY+RLJgaTQ7vB0ilQwreJPUYICRXa9wEfFbxP6Edsoz2S1dHiCY+qmDpXLtwhzzsEyLXk3DsYnxv\\/c3vPmsLaMyJ0dFdDO0GKXn4vzqIMk+1l2lnyqdCD6lZhko7nliKC8Wa5Ke1VYhn1F8Tgqi9wGGPBSTlEj01RY6hhl08FcNT6QhznWMuko4oUBcIXYksDPfZcceSdTqBGcKIrzkcWw1tYzKpZ2CNjRHFDOGqYcJblDBWW9asJr+r0buGrYOmjkplvdfSMQ80dYXG2f236m6q1Vu688LV69+dbsS0lbAS6U2TVw=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.22\",\n    \"created\": \"2025-07-25 17:22:57\",\n    \"updated\": \"2026-01-29 13:00:41\"\n}","4.5.22","2025-07-25 17:22:57","2026-01-29 13:00:41"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1769691638,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.22\",\n    \"created\": \"2025-07-25 17:22:59\",\n    \"updated\": \"2026-01-29 13:00:38\"\n}","4.5.22","2025-07-25 17:22:59","2026-01-29 13:00:38");

INSERT IGNORE INTO `wp_jnews_post_like` VALUES 
("1","29","2019-07-04 13:00:17","1","1");

INSERT IGNORE INTO `wp_options` VALUES 
("1","siteurl","http://web102.sa-farhood.ir","yes"),
("2","home","http://web102.sa-farhood.ir","yes"),
("3","blogname","وان ایکس بت","on"),
("4","blogdescription","مجله خبری وان ایکس","on"),
("5","users_can_register","0","yes"),
("6","admin_email","iranmlbt.com@gmail.com","yes"),
("7","start_of_week","6","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","1","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/blog/%category%/%postname%/","yes"),
("29","rewrite_rules","a:223:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:29:\"^account/page/?([0-9]{1,})/?$\";s:36:\"index.php?&paged=$matches[1]&account\";s:23:\"^social-token/([^/]*)/?\";s:34:\"index.php?social-token=$matches[1]\";s:52:\"blog/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:47:\"blog/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:28:\"blog/category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:40:\"blog/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:22:\"blog/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:49:\"blog/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:44:\"blog/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:25:\"blog/tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:37:\"blog/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:19:\"blog/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:50:\"blog/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:45:\"blog/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:26:\"blog/type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:38:\"blog/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:20:\"blog/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:50:\"blog/elementskit-content/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:60:\"blog/elementskit-content/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:80:\"blog/elementskit-content/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"blog/elementskit-content/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"blog/elementskit-content/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:56:\"blog/elementskit-content/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"blog/elementskit-content/(.+?)/embed/?$\";s:52:\"index.php?elementskit_content=$matches[1]&embed=true\";s:43:\"blog/elementskit-content/(.+?)/trackback/?$\";s:46:\"index.php?elementskit_content=$matches[1]&tb=1\";s:51:\"blog/elementskit-content/(.+?)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&paged=$matches[2]\";s:58:\"blog/elementskit-content/(.+?)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&cpage=$matches[2]\";s:47:\"blog/elementskit-content/(.+?)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementskit_content=$matches[1]&page=$matches[2]\";s:50:\"blog/amp_validated_url/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:60:\"blog/amp_validated_url/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:80:\"blog/amp_validated_url/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"blog/amp_validated_url/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"blog/amp_validated_url/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:56:\"blog/amp_validated_url/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"blog/amp_validated_url/([^/]+)/embed/?$\";s:50:\"index.php?amp_validated_url=$matches[1]&embed=true\";s:43:\"blog/amp_validated_url/([^/]+)/trackback/?$\";s:44:\"index.php?amp_validated_url=$matches[1]&tb=1\";s:51:\"blog/amp_validated_url/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?amp_validated_url=$matches[1]&paged=$matches[2]\";s:58:\"blog/amp_validated_url/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?amp_validated_url=$matches[1]&cpage=$matches[2]\";s:47:\"blog/amp_validated_url/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?amp_validated_url=$matches[1]&page=$matches[2]\";s:39:\"blog/amp_validated_url/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"blog/amp_validated_url/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"blog/amp_validated_url/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"blog/amp_validated_url/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"blog/amp_validated_url/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"blog/amp_validated_url/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:66:\"blog/amp_validation_error/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?amp_validation_error=$matches[1]&feed=$matches[2]\";s:61:\"blog/amp_validation_error/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?amp_validation_error=$matches[1]&feed=$matches[2]\";s:42:\"blog/amp_validation_error/([^/]+)/embed/?$\";s:53:\"index.php?amp_validation_error=$matches[1]&embed=true\";s:54:\"blog/amp_validation_error/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?amp_validation_error=$matches[1]&paged=$matches[2]\";s:36:\"blog/amp_validation_error/([^/]+)/?$\";s:42:\"index.php?amp_validation_error=$matches[1]\";s:49:\"blog/archive-template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:59:\"blog/archive-template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:79:\"blog/archive-template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:74:\"blog/archive-template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:74:\"blog/archive-template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:55:\"blog/archive-template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"blog/archive-template/([^/]+)/embed/?$\";s:49:\"index.php?archive-template=$matches[1]&embed=true\";s:42:\"blog/archive-template/([^/]+)/trackback/?$\";s:43:\"index.php?archive-template=$matches[1]&tb=1\";s:50:\"blog/archive-template/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?archive-template=$matches[1]&paged=$matches[2]\";s:57:\"blog/archive-template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?archive-template=$matches[1]&cpage=$matches[2]\";s:46:\"blog/archive-template/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?archive-template=$matches[1]&page=$matches[2]\";s:38:\"blog/archive-template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"blog/archive-template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"blog/archive-template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"blog/archive-template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"blog/archive-template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"blog/archive-template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"blog/mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"blog/mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"blog/mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"blog/mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"blog/mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"blog/mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"blog/mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:36:\"blog/mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:44:\"blog/mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:51:\"blog/mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:40:\"blog/mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:32:\"blog/mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"blog/mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"blog/mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blog/mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blog/mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"blog/mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"blog/mega-menu/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"blog/mega-menu/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"blog/mega-menu/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"blog/mega-menu/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"blog/mega-menu/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"blog/mega-menu/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"blog/mega-menu/([^/]+)/embed/?$\";s:49:\"index.php?custom-mega-menu=$matches[1]&embed=true\";s:35:\"blog/mega-menu/([^/]+)/trackback/?$\";s:43:\"index.php?custom-mega-menu=$matches[1]&tb=1\";s:43:\"blog/mega-menu/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?custom-mega-menu=$matches[1]&paged=$matches[2]\";s:50:\"blog/mega-menu/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?custom-mega-menu=$matches[1]&cpage=$matches[2]\";s:39:\"blog/mega-menu/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?custom-mega-menu=$matches[1]&page=$matches[2]\";s:31:\"blog/mega-menu/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"blog/mega-menu/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"blog/mega-menu/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"blog/mega-menu/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"blog/mega-menu/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"blog/mega-menu/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"blog/footer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"blog/footer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"blog/footer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"blog/footer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"blog/footer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"blog/footer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"blog/footer/([^/]+)/embed/?$\";s:39:\"index.php?footer=$matches[1]&embed=true\";s:32:\"blog/footer/([^/]+)/trackback/?$\";s:33:\"index.php?footer=$matches[1]&tb=1\";s:40:\"blog/footer/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?footer=$matches[1]&paged=$matches[2]\";s:47:\"blog/footer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?footer=$matches[1]&cpage=$matches[2]\";s:36:\"blog/footer/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?footer=$matches[1]&page=$matches[2]\";s:28:\"blog/footer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"blog/footer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"blog/footer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"blog/footer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"blog/footer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"blog/footer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"blog/post-template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"blog/post-template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"blog/post-template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"blog/post-template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"blog/post-template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"blog/post-template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"blog/post-template/([^/]+)/embed/?$\";s:53:\"index.php?custom-post-template=$matches[1]&embed=true\";s:39:\"blog/post-template/([^/]+)/trackback/?$\";s:47:\"index.php?custom-post-template=$matches[1]&tb=1\";s:47:\"blog/post-template/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?custom-post-template=$matches[1]&paged=$matches[2]\";s:54:\"blog/post-template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:60:\"index.php?custom-post-template=$matches[1]&cpage=$matches[2]\";s:43:\"blog/post-template/([^/]+)(?:/([0-9]+))?/?$\";s:59:\"index.php?custom-post-template=$matches[1]&page=$matches[2]\";s:35:\"blog/post-template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"blog/post-template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"blog/post-template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"blog/post-template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"blog/post-template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"blog/post-template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1443&cpage=$matches[1]\";s:18:\"account(/(.*))?/?$\";s:30:\"index.php?&account=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:52:\"blog/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:47:\"blog/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:28:\"blog/author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:40:\"blog/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:22:\"blog/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:74:\"blog/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:69:\"blog/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:50:\"blog/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:62:\"blog/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:44:\"blog/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:61:\"blog/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:56:\"blog/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:37:\"blog/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:49:\"blog/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:31:\"blog/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:48:\"blog/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:43:\"blog/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:24:\"blog/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:36:\"blog/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:18:\"blog/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:26:\"(.?.+?)/account(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&account=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:36:\"blog/.+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"blog/.+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"blog/.+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"blog/.+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"blog/.+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"blog/.+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"blog/(.+?)/([^/]+)/embed/?$\";s:63:\"index.php?category_name=$matches[1]&name=$matches[2]&embed=true\";s:31:\"blog/(.+?)/([^/]+)/trackback/?$\";s:57:\"index.php?category_name=$matches[1]&name=$matches[2]&tb=1\";s:51:\"blog/(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:46:\"blog/(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:39:\"blog/(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:46:\"blog/(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:35:\"blog/(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]\";s:25:\"blog/.+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"blog/.+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"blog/.+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"blog/.+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"blog/.+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"blog/.+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"blog/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:38:\"blog/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:19:\"blog/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:31:\"blog/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:38:\"blog/(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&cpage=$matches[2]\";s:13:\"blog/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:29:{i:0;s:29:\"abzarwp-theme-jnews/index.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:11:\"amp/amp.php\";i:5;s:33:\"classic-editor/classic-editor.php\";i:6;s:36:\"contact-form-7/wp-contact-form-7.php\";i:7;s:32:\"duplicate-page/duplicatepage.php\";i:8;s:33:\"duplicator-pro/duplicator-pro.php\";i:9;s:31:\"elementor-pro/elementor-pro.php\";i:10;s:23:\"elementor/elementor.php\";i:11;s:37:\"elementskit-lite/elementskit-lite.php\";i:12;s:37:\"jnews-breadcrumb/jnews-breadcrumb.php\";i:13;s:55:\"jnews-customizer-category/jnews-customizer-category.php\";i:14;s:35:\"jnews-essential/jnews-essential.php\";i:15;s:51:\"jnews-front-translation/jnews-front-translation.php\";i:16;s:31:\"jnews-gallery/jnews-gallery.php\";i:17;s:29:\"jnews-jsonld/jnews-jsonld.php\";i:18;s:25:\"jnews-like/jnews-like.php\";i:19;s:39:\"jnews-meta-header/jnews-meta-header.php\";i:20;s:47:\"jnews-option-category/jnews-option-category.php\";i:21;s:29:\"jnews-review/jnews-review.php\";i:22;s:41:\"jnews-social-share/jnews-social-share.php\";i:23;s:27:\"jnews-split/jnews-split.php\";i:24;s:41:\"jnews-view-counter/jnews-view-counter.php\";i:25;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:26;s:25:\"timelentor/timelentor.php\";i:27;s:39:\"ultimate-post-kit/ultimate-post-kit.php\";i:28;s:69:\"vafpress-post-formats-ui-develop/vafpress-post-formats-ui-develop.php\";i:29;s:42:\"waspthemes-yellow-pencil/yellow-pencil.php\";i:30;s:23:\"wp-rocket/wp-rocket.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","https://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:5:{i:0;s:89:\"/home/arkakato/domains/web102.sa-farhood.ir/public_html/wp-content/themes/jnews/index.php\";i:1;s:100:\"/home/arkakato/domains/web102.sa-farhood.ir/public_html/wp-content/themes/jnews/template-builder.php\";i:2;s:96:\"/home/arkakato/domains/web102.sa-farhood.ir/public_html/wp-content/themes/jnews/page-default.php\";i:3;s:88:\"/home/arkakato/domains/web102.sa-farhood.ir/public_html/wp-content/themes/jnews/page.php\";i:5;s:90:\"/home/arkakato/domains/web102.sa-farhood.ir/public_html/wp-content/themes/jnews/header.php\";}","no"),
("40","template","jnews","yes"),
("41","stylesheet","jnews","yes"),
("44","comment_registration","0","yes"),
("45","html_type","text/html","yes"),
("46","use_trackback","0","yes"),
("47","default_role","subscriber","yes"),
("48","db_version","60421","yes"),
("49","uploads_use_yearmonth_folders","1","yes"),
("50","upload_path","","yes"),
("51","blog_public","0","yes"),
("52","default_link_category","2","yes"),
("53","show_on_front","page","on"),
("54","tag_base","/","yes"),
("55","show_avatars","1","yes"),
("56","avatar_rating","G","yes"),
("57","upload_url_path","","yes"),
("58","thumbnail_size_w","150","yes"),
("59","thumbnail_size_h","150","yes"),
("60","thumbnail_crop","1","yes"),
("61","medium_size_w","300","yes"),
("62","medium_size_h","300","yes"),
("63","avatar_default","mystery","yes"),
("64","large_size_w","1024","yes"),
("65","large_size_h","1024","yes"),
("66","image_default_link_type","none","yes"),
("67","image_default_size","","yes"),
("68","image_default_align","","yes"),
("69","close_comments_for_old_posts","0","yes"),
("70","close_comments_days_old","14","yes"),
("71","thread_comments","1","yes"),
("72","thread_comments_depth","5","yes"),
("73","page_comments","0","yes"),
("74","comments_per_page","50","yes"),
("75","default_comments_page","newest","yes"),
("76","comment_order","asc","yes"),
("77","sticky_posts","a:0:{}","yes"),
("78","widget_categories","a:4:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:5:{s:5:\"title\";s:0:\"\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";}i:4;a:7:{s:5:\"title\";s:17:\"دسته بندی\";s:12:\"second_title\";s:0:\"\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:12:\"widget_class\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("79","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("80","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("81","uninstall_plugins","a:7:{s:39:\"advanced-wp-reset/advanced-wp-reset.php\";s:13:\"DBR_uninstall\";s:65:\"remove-google-fonts-references/remove-google-fonts-references.php\";s:29:\"remove_google_fonts_uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:41:\"jnews-view-counter/jnews-view-counter.php\";a:2:{i:0;s:30:\"JNEWS_VIEW_COUNTER\\Deactivator\";i:1;s:10:\"deactivate\";}s:42:\"waspthemes-yellow-pencil/yellow-pencil.php\";s:23:\"uninstall_yellow_pencil\";s:25:\"tablepress/tablepress.php\";a:2:{i:0;s:8:\"Freemius\";i:1;s:22:\"_uninstall_plugin_hook\";}s:65:\"animation-addons-for-elementor/animation-addons-for-elementor.php\";a:2:{i:0;s:17:\"WCF_ADDONS_Plugin\";i:1;s:22:\"plugin_unregister_hook\";}}","no"),
("82","timezone_string","Asia/Tehran","yes"),
("83","page_for_posts","0","yes"),
("84","page_on_front","1443","on"),
("85","default_post_format","0","yes"),
("86","link_manager_enabled","0","yes"),
("87","finished_splitting_shared_terms","1","yes"),
("88","site_icon","3299","on"),
("89","medium_large_size_w","768","yes"),
("90","medium_large_size_h","0","yes"),
("91","wp_page_for_privacy_policy","3","yes"),
("92","show_comments_cookies_opt_in","1","yes"),
("93","initial_db_version","44719","yes"),
("94","wp_user_roles","a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:179:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:10:\"loco_admin\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:23:\"tablepress_edit_options\";b:1;s:28:\"tablepress_import_tables_url\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:58:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:28:\"tablepress_import_tables_url\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:32:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:14:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}","yes"),
("95","fresh_site","0","off"),
("96","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("97","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("98","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("99","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("100","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("101","sidebars_widgets","a:11:{s:19:\"wp_inactive_widgets\";a:14:{i:0;s:10:\"archives-2\";i:1;s:6:\"meta-2\";i:2;s:8:\"search-2\";i:3;s:12:\"categories-2\";i:4;s:12:\"categories-3\";i:5;s:12:\"categories-4\";i:6;s:14:\"recent-posts-2\";i:7;s:17:\"recent-comments-2\";i:8;s:15:\"jnews_popular-2\";i:9;s:22:\"jnews_social_counter-2\";i:10;s:23:\"jnews_module_block_21-2\";i:11;s:23:\"jnews_module_block_28-2\";i:12;s:26:\"jnews_module_element_ads-2\";i:13;s:26:\"jnews_module_element_ads-3\";}s:4:\"home\";a:2:{i:0;s:22:\"jnews_social_counter-4\";i:1;s:15:\"jnews_popular-3\";}s:9:\"home-loop\";a:1:{i:0;s:23:\"jnews_module_block_19-3\";}s:6:\"author\";a:0:{}s:6:\"home-2\";a:0:{}s:15:\"default-sidebar\";a:4:{i:0;s:26:\"jnews_module_element_ads-4\";i:1;s:22:\"jnews_social_counter-3\";i:2;s:16:\"jnews_tab_post-2\";i:3;s:23:\"jnews_module_block_19-2\";}s:15:\"footer-widget-1\";a:1:{i:0;s:13:\"jnews_about-2\";}s:15:\"footer-widget-2\";a:2:{i:0;s:13:\"custom_html-4\";i:1;s:23:\"jnews_module_block_28-4\";}s:15:\"footer-widget-3\";a:2:{i:0;s:13:\"custom_html-2\";i:1;s:23:\"jnews_module_block_28-3\";}s:15:\"footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;}","yes"),
("102","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("103","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("104","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("105","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("106","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("107","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_tag_cloud","a:2:{i:1;a:6:{s:5:\"title\";s:0:\"\";s:8:\"taxonomy\";s:8:\"post_tag\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_custom_html","a:3:{i:2;a:2:{s:5:\"title\";s:22:\"لینک های مهم\";s:7:\"content\";s:0:\"\";}i:4;a:2:{s:5:\"title\";s:23:\"آخرین مقالات\";s:7:\"content\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("111","cron","a:25:{i:1769691653;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1769691675;a:1:{s:30:\"rocket_preload_process_pending\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"rocket_preload_process_pending\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1769692038;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769692425;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769692795;a:2:{s:17:\"amp_validate_urls\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:31:\"amp_validated_url_stylesheet_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769693662;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1769695146;a:1:{s:20:\"jnews_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769695997;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769701857;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769702307;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769707518;a:1:{s:32:\"rocket_performance_hints_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769710795;a:2:{s:33:\"amp_monitor_css_transient_caching\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:22:\"amp_validation_data_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769713875;a:1:{s:37:\"rocket_preload_revert_old_failed_rows\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:29:\"rocket_revert_old_failed_rows\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769714025;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769714030;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769714468;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769717519;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769731200;a:2:{s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"rank_math/links/internal_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769740169;a:1:{s:35:\"rank_math/content-ai/update_prompts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769741040;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769834211;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770053118;a:1:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770053718;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770191988;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("112","theme_mods_twentynineteen","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1559502841;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}","no"),
("123","current_theme","JNews","yes"),
("125","theme_switched","","yes"),
("137","recently_activated","a:8:{s:65:\"animation-addons-for-elementor/animation-addons-for-elementor.php\";i:1769178731;s:25:\"tablepress/tablepress.php\";i:1769176629;s:41:\"jnews-social-login/jnews-social-login.php\";i:1768980815;s:33:\"duplicator-pro/duplicator-pro.php\";i:1768980750;s:30:\"seo-by-rank-math/rank-math.php\";i:1768979794;s:31:\"jnews-weather/jnews-weather.php\";i:1768979614;s:35:\"jnews-instagram/jnews-instagram.php\";i:1768979314;s:35:\"jnews-gutenberg/jnews-gutenberg.php\";i:1768979258;}","off"),
("143","jnews_import_backup","a:2:{s:6:\"widget\";a:1:{s:15:\"default-sidebar\";a:6:{s:8:\"search-2\";a:1:{s:5:\"title\";s:0:\"\";}s:14:\"recent-posts-2\";a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:17:\"recent-comments-2\";a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:10:\"archives-2\";a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"categories-2\";a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:6:\"meta-2\";a:1:{s:5:\"title\";s:0:\"\";}}}s:10:\"customizer\";a:2:{s:8:\"template\";s:5:\"jnews\";s:4:\"mods\";a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}}}","yes"),
("144","vc_version","7.8","yes"),
("145","widget_jnews_about","a:3:{i:1;a:14:{s:5:\"title\";s:0:\"\";s:8:\"aboutimg\";s:2:\"19\";s:14:\"aboutimgretina\";s:2:\"20\";s:9:\"aboutname\";s:0:\"\";s:15:\"aboutoccupation\";s:0:\"\";s:9:\"aboutdesc\";s:396:\"<p style=\"text-align: justify;\">قالب خبری مجله ای جی نیوز <span style=\"color: #ff0000;\"><a style=\"color: #ff0000;\" href=\"https://abzarwp.com/\" target=\"_blank\" rel=\"noopener\">ابزار وردپرس</a></span> بهترین قالب وردپرس در زمنیه خبری که امکان ایجاد مجله ، وبلاگ شخصی و هرچیزی را به شما می دهد</p>\";s:9:\"signature\";s:0:\"\";s:15:\"signatureretina\";s:0:\"\";s:12:\"second_title\";s:0:\"\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:12:\"widget_class\";s:0:\"\";}i:2;a:11:{s:5:\"title\";s:18:\"مجله مل بت\";s:8:\"aboutimg\";s:0:\"\";s:14:\"aboutimgretina\";s:0:\"\";s:16:\"aboutimgdarkmode\";s:0:\"\";s:22:\"aboutimgdarkmoderetina\";s:0:\"\";s:9:\"aboutname\";s:0:\"\";s:15:\"aboutoccupation\";s:0:\"\";s:9:\"aboutdesc\";s:2154:\"    \r\nاطلاعات ارائه‌شده در این وب‌سایت صرفاً برای اهداف سرگرمی و اطلاع‌رسانی است. مل بت با مجوز رسمی از Curacao (شماره مجوز: 8048/JAZ) فعالیت می‌کند و هیچ‌گونه وابستگی یا تأییدی از سوی لیگ‌ها، فدراسیون‌ها، یا تیم‌های ورزشی ندارد و به‌طور مستقل فعالیت می‌کند. لطفاً قوانین مرتبط با شرط‌بندی و قمار در کشور خود را به دقت مطالعه کنید. کاربران مسئول رعایت قوانین محلی و کشوری خود هستند و استفاده از این وب‌سایت برای نقض این قوانین ممنوع است. این وب‌سایت برای افراد زیر ۱۸ سال مناسب نیست.\r\n\r\nدر صورت نیاز به مشاوره در زمینه بازی مسئولانه، می‌توانید به وب‌سایت‌های معتبری مانند <a href=\"https://gambleaware.org/\">gambleaware.org</a> و <a href=\"https://www.gamcare.org.uk/\">gamcare.org.uk</a> مراجعه کنید. مسئولانه بازی کنید!\r\n<ul style=\"list-style-type: none; padding: 0; margin: 0; display: flex;\">\r\n    <li style=\"position: relative; padding: 0 15px;\">\r\n        <a href=\"https://www.gamcare.org.uk/\">\r\n            <img class=\"alignnone size-full wp-image-2591\" src=\"http://web102.sa-farhood.ir/wp-content/uploads/2024/11/2-1.png\" alt=\"\" width=\"68\" height=\"28\" />\r\n        </a> \r\n    </li>\r\n    <li style=\"position: relative; padding: 15px 15px;\">\r\n        <p>\r\n            <img class=\"alignnone size-full wp-image-2590\" src=\"http://web102.sa-farhood.ir/wp-content/uploads/2024/11/3-1.png\" alt=\"\" width=\"106\" height=\"28\" /> \r\n        </p> \r\n     \r\n    </li>\r\n    <li style=\"position: relative; padding: 0 15px;\">\r\n        <a href=\"https://www.begambleaware.org/\">\r\n            <img class=\"alignnone size-full wp-image-2589\" src=\"http://web102.sa-farhood.ir/wp-content/uploads/2024/11/1-1.png\" alt=\"\" width=\"109\" height=\"28\" />\r\n        </a>\r\n      \r\n    </li>\r\n    \r\n  </ul>\r\n\";s:9:\"signature\";s:0:\"\";s:15:\"signatureretina\";s:0:\"\";s:5:\"align\";s:1:\"0\";}s:12:\"_multiwidget\";i:1;}","yes"),
("146","widget_jnews_popular","a:4:{i:1;a:10:{s:5:\"title\";s:31:\"محبوب ترین پست ها\";s:5:\"limit\";s:1:\"5\";s:8:\"order_by\";s:5:\"views\";s:5:\"range\";s:3:\"all\";s:12:\"second_title\";s:0:\"\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:12:\"widget_class\";s:0:\"\";}i:2;a:10:{s:5:\"title\";s:31:\"محبوب ترین پست ها\";s:5:\"limit\";s:1:\"5\";s:8:\"order_by\";s:5:\"views\";s:5:\"range\";s:3:\"all\";s:12:\"second_title\";s:0:\"\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:12:\"widget_class\";s:0:\"\";}i:3;a:8:{s:5:\"title\";s:7:\"Popular\";s:5:\"limit\";s:1:\"5\";s:8:\"order_by\";s:5:\"views\";s:5:\"range\";s:3:\"all\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("147","widget_jnews_line","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("148","widget_jnews_recent_news","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("149","widget_jnews_tab_post","a:3:{i:1;a:7:{s:5:\"title\";s:0:\"\";s:5:\"limit\";s:1:\"4\";s:5:\"range\";s:3:\"all\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";}i:2;a:7:{s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:10:\"header_url\";s:0:\"\";s:5:\"limit\";s:1:\"4\";s:5:\"range\";s:3:\"all\";s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("150","widget_jnews_social","a:2:{i:1;a:13:{s:5:\"title\";s:0:\"\";s:11:\"widgetstyle\";s:6:\"square\";s:10:\"icon_color\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:12:\"beforesocial\";s:46:\"<strong>ما را دنبال کنید</strong>\";s:11:\"aftersocial\";s:0:\"\";s:7:\"account\";s:483:\"%5B%7B%22social_icon%22:%22facebook%22,%22social_url%22:%22https://www.facebook.com/jegtheme/%22%7D,%7B%22social_icon%22:%22twitter%22,%22social_url%22:%22https://twitter.com/jegtheme%22%7D,%7B%22social_icon%22:%22instagram%22,%22social_url%22:%22https://www.instagram.com/jegtheme/%22%7D,%7B%22social_icon%22:%22behance%22,%22social_url%22:%22https://www.behance.net/jegtheme%22%7D,%7B%22social_icon%22:%22googleplus%22,%22social_url%22:%22https://plus.google.com/+Jegtheme%22%7D%5D\";s:12:\"second_title\";s:0:\"\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:12:\"widget_class\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("151","widget_jnews_social_counter","a:5:{i:1;a:23:{s:5:\"title\";s:28:\"در ارتباط باشید\";s:6:\"column\";s:4:\"col3\";s:5:\"style\";s:5:\"light\";s:6:\"newtab\";s:1:\"1\";s:5:\"fb_id\";s:16:\"1708153456106457\";s:9:\"fb_secret\";s:32:\"ae408213fb9a2e29d3ad858e03ec5a75\";s:6:\"fb_key\";s:44:\"1708153456106457|LBeqPdQFTJXpeFL3sPex1LQBMVY\";s:15:\"tw_consumer_key\";s:0:\"\";s:18:\"tw_consumer_secret\";s:0:\"\";s:15:\"tw_access_token\";s:0:\"\";s:22:\"tw_access_token_secret\";s:0:\"\";s:6:\"gg_key\";s:39:\"AIzaSyCNRPgcByJDdhhZZRZ0AEyUnZ9lqmlBrvE\";s:6:\"bh_key\";s:32:\"t2wwIJCdYCWCdAdPHwef3hGvcx8ztA8o\";s:10:\"twitch_key\";s:0:\"\";s:5:\"vk_id\";s:0:\"\";s:9:\"rss_count\";s:0:\"\";s:7:\"account\";s:873:\"%5B%7B%22social_icon%22:%22facebook%22,%22social_url%22:%22https://www.facebook.com/jegtheme/%22%7D,%7B%22social_icon%22:%22twitter%22,%22social_url%22:%22https://twitter.com/jegtheme%22%7D,%7B%22social_icon%22:%22behance%22,%22social_url%22:%22https://www.behance.net/jegtheme%22%7D,%7B%22social_icon%22:%22google-plus%22,%22social_url%22:%22https://plus.google.com/+envato%22%7D,%7B%22social_icon%22:%22instagram%22,%22social_url%22:%22https://www.instagram.com/envato/%22%7D,%7B%22social_icon%22:%22dribbble%22,%22social_url%22:%22https://dribbble.com/envato%22%7D,%7B%22social_icon%22:%22soundcloud%22,%22social_url%22:%22https://soundcloud.com/dialogdinihari%22%7D,%7B%22social_icon%22:%22flickr%22,%22social_url%22:%22https://www.flickr.com/photos/we-are-envato/%22%7D,%7B%22social_icon%22:%22youtube%22,%22social_url%22:%22http://www.youtube.com/user/Envato%22%7D%5D\";s:12:\"second_title\";s:0:\"\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_1\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:12:\"widget_class\";s:0:\"\";}i:2;a:23:{s:5:\"title\";s:29:\"ما را دنبال کنید\";s:6:\"column\";s:4:\"col1\";s:5:\"style\";s:5:\"light\";s:6:\"newtab\";s:1:\"1\";s:5:\"fb_id\";s:16:\"1708153456106457\";s:9:\"fb_secret\";s:32:\"ae408213fb9a2e29d3ad858e03ec5a75\";s:6:\"fb_key\";s:44:\"1708153456106457|LBeqPdQFTJXpeFL3sPex1LQBMVY\";s:15:\"tw_consumer_key\";s:0:\"\";s:18:\"tw_consumer_secret\";s:0:\"\";s:15:\"tw_access_token\";s:0:\"\";s:22:\"tw_access_token_secret\";s:0:\"\";s:6:\"gg_key\";s:39:\"AIzaSyCNRPgcByJDdhhZZRZ0AEyUnZ9lqmlBrvE\";s:6:\"bh_key\";s:32:\"t2wwIJCdYCWCdAdPHwef3hGvcx8ztA8o\";s:10:\"twitch_key\";s:0:\"\";s:5:\"vk_id\";s:0:\"\";s:9:\"rss_count\";s:0:\"\";s:7:\"account\";s:873:\"%5B%7B%22social_icon%22:%22facebook%22,%22social_url%22:%22https://www.facebook.com/jegtheme/%22%7D,%7B%22social_icon%22:%22twitter%22,%22social_url%22:%22https://twitter.com/jegtheme%22%7D,%7B%22social_icon%22:%22behance%22,%22social_url%22:%22https://www.behance.net/jegtheme%22%7D,%7B%22social_icon%22:%22google-plus%22,%22social_url%22:%22https://plus.google.com/+envato%22%7D,%7B%22social_icon%22:%22instagram%22,%22social_url%22:%22https://www.instagram.com/envato/%22%7D,%7B%22social_icon%22:%22dribbble%22,%22social_url%22:%22https://dribbble.com/envato%22%7D,%7B%22social_icon%22:%22soundcloud%22,%22social_url%22:%22https://soundcloud.com/dialogdinihari%22%7D,%7B%22social_icon%22:%22flickr%22,%22social_url%22:%22https://www.flickr.com/photos/we-are-envato/%22%7D,%7B%22social_icon%22:%22youtube%22,%22social_url%22:%22http://www.youtube.com/user/Envato%22%7D%5D\";s:12:\"second_title\";s:0:\"\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:12:\"widget_class\";s:0:\"\";}i:3;a:20:{s:5:\"title\";s:15:\"Connect with us\";s:6:\"column\";s:4:\"col4\";s:5:\"style\";s:7:\"colored\";s:5:\"fb_id\";s:0:\"\";s:9:\"fb_secret\";s:0:\"\";s:6:\"fb_key\";s:0:\"\";s:6:\"gg_key\";s:0:\"\";s:6:\"bh_key\";s:0:\"\";s:10:\"twitch_key\";s:0:\"\";s:11:\"linkedin_id\";s:0:\"\";s:15:\"linkedin_secret\";s:0:\"\";s:13:\"linkedin_code\";s:0:\"\";s:12:\"linkedin_key\";s:0:\"\";s:5:\"vk_id\";s:0:\"\";s:9:\"rss_count\";s:0:\"\";s:7:\"account\";s:866:\"%5B%7B%22social_icon%22%3A%22facebook%22%2C%22social_url%22%3A%22jegtheme%22%7D%2C%7B%22social_icon%22%3A%22twitter%22%2C%22social_url%22%3A%22https%3A%2F%2Ftwitter.com%2Fjegtheme%22%7D%2C%7B%22social_icon%22%3A%22google-plus%22%2C%22social_url%22%3A%22https%3A%2F%2Fplus.google.com%2F%2Benvato%22%7D%2C%7B%22social_icon%22%3A%22behance%22%2C%22social_url%22%3A%22https%3A%2F%2Fwww.behance.net%2Fjegtheme%22%7D%2C%7B%22social_icon%22%3A%22instagram%22%2C%22social_url%22%3A%22https%3A%2F%2Fwww.instagram.com%2Fenvato%2F%22%7D%2C%7B%22social_icon%22%3A%22dribbble%22%2C%22social_url%22%3A%22https%3A%2F%2Fdribbble.com%2Fenvato%22%7D%2C%7B%22social_icon%22%3A%22youtube%22%2C%22social_url%22%3A%22http%3A%2F%2Fwww.youtube.com%2Fuser%2FEnvato%22%7D%2C%7B%22social_icon%22%3A%22soundcloud%22%2C%22social_url%22%3A%22https%3A%2F%2Fsoundcloud.com%2Fdialogdinihari%22%7D%5D\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";}i:4;a:20:{s:5:\"title\";s:14:\"Stay Connected\";s:6:\"column\";s:4:\"col4\";s:5:\"style\";s:5:\"light\";s:5:\"fb_id\";s:0:\"\";s:9:\"fb_secret\";s:0:\"\";s:6:\"fb_key\";s:0:\"\";s:6:\"gg_key\";s:0:\"\";s:6:\"bh_key\";s:0:\"\";s:10:\"twitch_key\";s:0:\"\";s:11:\"linkedin_id\";s:0:\"\";s:15:\"linkedin_secret\";s:0:\"\";s:13:\"linkedin_code\";s:0:\"\";s:12:\"linkedin_key\";s:0:\"\";s:5:\"vk_id\";s:0:\"\";s:9:\"rss_count\";s:0:\"\";s:7:\"account\";s:866:\"%5B%7B%22social_icon%22%3A%22facebook%22%2C%22social_url%22%3A%22jegtheme%22%7D%2C%7B%22social_icon%22%3A%22twitter%22%2C%22social_url%22%3A%22https%3A%2F%2Ftwitter.com%2Fjegtheme%22%7D%2C%7B%22social_icon%22%3A%22google-plus%22%2C%22social_url%22%3A%22https%3A%2F%2Fplus.google.com%2F%2Benvato%22%7D%2C%7B%22social_icon%22%3A%22behance%22%2C%22social_url%22%3A%22https%3A%2F%2Fwww.behance.net%2Fjegtheme%22%7D%2C%7B%22social_icon%22%3A%22instagram%22%2C%22social_url%22%3A%22https%3A%2F%2Fwww.instagram.com%2Fenvato%2F%22%7D%2C%7B%22social_icon%22%3A%22dribbble%22%2C%22social_url%22%3A%22https%3A%2F%2Fdribbble.com%2Fenvato%22%7D%2C%7B%22social_icon%22%3A%22youtube%22%2C%22social_url%22%3A%22http%3A%2F%2Fwww.youtube.com%2Fuser%2FEnvato%22%7D%2C%7B%22social_icon%22%3A%22soundcloud%22%2C%22social_url%22%3A%22https%3A%2F%2Fsoundcloud.com%2Fdialogdinihari%22%7D%5D\";s:10:\"header_url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("152","widget_jnews_facebook_page","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("153","widget_jnews_twitter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("154","widget_jnews_google_plus","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("155","widget_jnews_pinterest","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("156","widget_jnews_instagram","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("157","widget_jnews_flickr","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("158","widget_jnews_behance","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("159","widget_jnews_module_block_1","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("160","widget_jnews_module_block_2","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("161","widget_jnews_module_block_3","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("162","widget_jnews_module_block_4","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("163","widget_jnews_module_block_5","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("164","widget_jnews_module_block_6","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("165","widget_jnews_module_block_7","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("166","widget_jnews_module_block_8","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("167","widget_jnews_module_block_9","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("168","widget_jnews_module_block_10","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("169","widget_jnews_module_block_11","a:2:{i:1;a:41:{s:11:\"header_icon\";s:0:\"\";s:11:\"first_title\";s:11:\"اخبار \";s:12:\"second_title\";s:9:\" ترند\";s:3:\"url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:27:\"header_secondary_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:17:\"header_line_color\";s:0:\"\";s:19:\"header_accent_color\";s:0:\"\";s:22:\"header_filter_category\";s:0:\"\";s:20:\"header_filter_author\";s:0:\"\";s:17:\"header_filter_tag\";s:0:\"\";s:18:\"header_filter_text\";s:6:\"همه\";s:9:\"post_type\";s:4:\"post\";s:12:\"content_type\";s:3:\"all\";s:11:\"number_post\";s:1:\"3\";s:11:\"post_offset\";s:1:\"0\";s:14:\"unique_content\";s:7:\"disable\";s:12:\"include_post\";s:0:\"\";s:12:\"exclude_post\";s:0:\"\";s:16:\"include_category\";s:0:\"\";s:16:\"exclude_category\";s:1:\"9\";s:14:\"include_author\";s:0:\"\";s:11:\"include_tag\";s:0:\"\";s:11:\"exclude_tag\";s:0:\"\";s:7:\"sort_by\";s:6:\"latest\";s:11:\"date_format\";s:7:\"default\";s:18:\"date_format_custom\";s:5:\"Y/m/d\";s:15:\"pagination_mode\";s:7:\"disable\";s:22:\"pagination_number_post\";s:1:\"4\";s:23:\"pagination_scroll_limit\";s:1:\"0\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";s:11:\"title_color\";s:0:\"\";s:12:\"accent_color\";s:0:\"\";s:9:\"alt_color\";s:0:\"\";s:13:\"excerpt_color\";s:0:\"\";s:16:\"block_background\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("170","widget_jnews_module_block_12","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("171","widget_jnews_module_block_13","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("172","widget_jnews_module_block_14","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("173","widget_jnews_module_block_15","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("174","widget_jnews_module_block_16","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("175","widget_jnews_module_block_17","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("176","widget_jnews_module_block_18","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("177","widget_jnews_module_block_19","a:4:{i:1;a:40:{s:11:\"header_icon\";s:0:\"\";s:11:\"first_title\";s:18:\"محبوبترین\";s:12:\"second_title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_1\";s:17:\"header_background\";s:0:\"\";s:27:\"header_secondary_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:17:\"header_line_color\";s:0:\"\";s:19:\"header_accent_color\";s:0:\"\";s:22:\"header_filter_category\";s:0:\"\";s:20:\"header_filter_author\";s:0:\"\";s:17:\"header_filter_tag\";s:0:\"\";s:18:\"header_filter_text\";s:6:\"همه\";s:9:\"post_type\";s:4:\"post\";s:12:\"content_type\";s:3:\"all\";s:11:\"number_post\";s:1:\"4\";s:11:\"post_offset\";s:1:\"0\";s:14:\"unique_content\";s:7:\"disable\";s:12:\"include_post\";s:0:\"\";s:12:\"exclude_post\";s:0:\"\";s:16:\"include_category\";s:0:\"\";s:16:\"exclude_category\";s:1:\"9\";s:14:\"include_author\";s:0:\"\";s:11:\"include_tag\";s:0:\"\";s:11:\"exclude_tag\";s:0:\"\";s:7:\"sort_by\";s:12:\"popular_post\";s:11:\"date_format\";s:7:\"default\";s:18:\"date_format_custom\";s:5:\"Y/m/d\";s:15:\"pagination_mode\";s:7:\"disable\";s:22:\"pagination_number_post\";s:1:\"6\";s:23:\"pagination_scroll_limit\";s:1:\"0\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";s:11:\"title_color\";s:0:\"\";s:12:\"accent_color\";s:0:\"\";s:9:\"alt_color\";s:0:\"\";s:13:\"excerpt_color\";s:0:\"\";}i:2;a:28:{s:11:\"first_title\";s:11:\"Recommended\";s:12:\"second_title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:22:\"header_filter_category\";s:0:\"\";s:20:\"header_filter_author\";s:0:\"\";s:17:\"header_filter_tag\";s:0:\"\";s:18:\"header_filter_text\";s:3:\"All\";s:9:\"post_type\";s:4:\"post\";s:11:\"number_post\";s:1:\"4\";s:11:\"post_offset\";s:1:\"0\";s:14:\"unique_content\";s:7:\"disable\";s:12:\"include_post\";s:0:\"\";s:12:\"exclude_post\";s:0:\"\";s:16:\"include_category\";s:0:\"\";s:16:\"exclude_category\";s:0:\"\";s:14:\"include_author\";s:0:\"\";s:11:\"include_tag\";s:0:\"\";s:11:\"exclude_tag\";s:0:\"\";s:7:\"sort_by\";s:6:\"latest\";s:11:\"date_format\";s:7:\"default\";s:18:\"date_format_custom\";s:5:\"Y/m/d\";s:15:\"pagination_mode\";s:7:\"disable\";s:22:\"pagination_number_post\";s:1:\"6\";s:23:\"pagination_scroll_limit\";s:1:\"0\";s:12:\"column_width\";s:4:\"auto\";}i:3;a:28:{s:11:\"first_title\";s:12:\"Most Popular\";s:12:\"second_title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:22:\"header_filter_category\";s:0:\"\";s:20:\"header_filter_author\";s:0:\"\";s:17:\"header_filter_tag\";s:0:\"\";s:18:\"header_filter_text\";s:3:\"All\";s:9:\"post_type\";s:4:\"post\";s:11:\"number_post\";s:1:\"5\";s:11:\"post_offset\";s:1:\"0\";s:14:\"unique_content\";s:7:\"disable\";s:12:\"include_post\";s:0:\"\";s:12:\"exclude_post\";s:0:\"\";s:16:\"include_category\";s:0:\"\";s:16:\"exclude_category\";s:0:\"\";s:14:\"include_author\";s:0:\"\";s:11:\"include_tag\";s:0:\"\";s:11:\"exclude_tag\";s:0:\"\";s:7:\"sort_by\";s:6:\"latest\";s:11:\"date_format\";s:7:\"default\";s:18:\"date_format_custom\";s:5:\"Y/m/d\";s:15:\"pagination_mode\";s:8:\"loadmore\";s:22:\"pagination_number_post\";s:1:\"3\";s:23:\"pagination_scroll_limit\";s:1:\"0\";s:12:\"column_width\";s:4:\"auto\";}s:12:\"_multiwidget\";i:1;}","yes"),
("178","widget_jnews_module_block_20","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("179","widget_jnews_module_block_21","a:3:{i:1;a:40:{s:11:\"header_icon\";s:0:\"\";s:11:\"first_title\";s:17:\"توصیه شده\";s:12:\"second_title\";s:1:\".\";s:3:\"url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_5\";s:17:\"header_background\";s:0:\"\";s:27:\"header_secondary_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:17:\"header_line_color\";s:0:\"\";s:19:\"header_accent_color\";s:0:\"\";s:22:\"header_filter_category\";s:0:\"\";s:20:\"header_filter_author\";s:0:\"\";s:17:\"header_filter_tag\";s:0:\"\";s:18:\"header_filter_text\";s:6:\"همه\";s:9:\"post_type\";s:4:\"post\";s:12:\"content_type\";s:3:\"all\";s:11:\"number_post\";s:1:\"2\";s:11:\"post_offset\";s:1:\"0\";s:14:\"unique_content\";s:7:\"unique2\";s:12:\"include_post\";s:0:\"\";s:12:\"exclude_post\";s:0:\"\";s:16:\"include_category\";s:0:\"\";s:16:\"exclude_category\";s:1:\"9\";s:14:\"include_author\";s:0:\"\";s:11:\"include_tag\";s:0:\"\";s:11:\"exclude_tag\";s:0:\"\";s:7:\"sort_by\";s:6:\"random\";s:11:\"date_format\";s:7:\"default\";s:18:\"date_format_custom\";s:5:\"Y/m/d\";s:15:\"pagination_mode\";s:7:\"disable\";s:22:\"pagination_number_post\";s:1:\"6\";s:23:\"pagination_scroll_limit\";s:1:\"0\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";s:11:\"title_color\";s:0:\"\";s:12:\"accent_color\";s:0:\"\";s:9:\"alt_color\";s:0:\"\";s:13:\"excerpt_color\";s:0:\"\";}i:2;a:40:{s:11:\"header_icon\";s:0:\"\";s:11:\"first_title\";s:8:\"ترند\";s:12:\"second_title\";s:1:\".\";s:3:\"url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_5\";s:17:\"header_background\";s:0:\"\";s:27:\"header_secondary_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:17:\"header_line_color\";s:0:\"\";s:19:\"header_accent_color\";s:0:\"\";s:22:\"header_filter_category\";s:0:\"\";s:20:\"header_filter_author\";s:0:\"\";s:17:\"header_filter_tag\";s:0:\"\";s:18:\"header_filter_text\";s:6:\"همه\";s:9:\"post_type\";s:4:\"post\";s:12:\"content_type\";s:3:\"all\";s:11:\"number_post\";s:1:\"5\";s:11:\"post_offset\";s:1:\"0\";s:14:\"unique_content\";s:7:\"unique2\";s:12:\"include_post\";s:0:\"\";s:12:\"exclude_post\";s:0:\"\";s:16:\"include_category\";s:0:\"\";s:16:\"exclude_category\";s:1:\"9\";s:14:\"include_author\";s:0:\"\";s:11:\"include_tag\";s:0:\"\";s:11:\"exclude_tag\";s:0:\"\";s:7:\"sort_by\";s:18:\"popular_post_month\";s:11:\"date_format\";s:7:\"default\";s:18:\"date_format_custom\";s:5:\"Y/m/d\";s:15:\"pagination_mode\";s:7:\"disable\";s:22:\"pagination_number_post\";s:1:\"6\";s:23:\"pagination_scroll_limit\";s:1:\"0\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";s:11:\"title_color\";s:0:\"\";s:12:\"accent_color\";s:0:\"\";s:9:\"alt_color\";s:0:\"\";s:13:\"excerpt_color\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("180","widget_jnews_module_block_22","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("181","widget_jnews_module_block_23","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("182","widget_jnews_module_block_24","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("183","widget_jnews_module_block_25","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("184","widget_jnews_module_block_26","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("185","widget_jnews_module_block_27","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("186","widget_jnews_module_block_28","a:4:{i:2;a:53:{s:11:\"header_icon\";s:0:\"\";s:11:\"first_title\";s:0:\"\";s:12:\"second_title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:27:\"header_secondary_background\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:17:\"header_line_color\";s:0:\"\";s:19:\"header_accent_color\";s:0:\"\";s:22:\"header_filter_category\";s:0:\"\";s:20:\"header_filter_author\";s:0:\"\";s:17:\"header_filter_tag\";s:0:\"\";s:18:\"header_filter_text\";s:3:\"All\";s:9:\"post_type\";s:4:\"post\";s:12:\"content_type\";s:3:\"all\";s:11:\"number_post\";s:1:\"5\";s:11:\"post_offset\";s:1:\"0\";s:14:\"unique_content\";s:7:\"disable\";s:12:\"include_post\";s:0:\"\";s:12:\"exclude_post\";s:0:\"\";s:16:\"include_category\";s:0:\"\";s:16:\"exclude_category\";s:0:\"\";s:14:\"include_author\";s:0:\"\";s:11:\"include_tag\";s:0:\"\";s:11:\"exclude_tag\";s:0:\"\";s:7:\"sort_by\";s:6:\"latest\";s:11:\"date_format\";s:7:\"default\";s:18:\"date_format_custom\";s:5:\"Y/m/d\";s:15:\"pagination_mode\";s:7:\"disable\";s:22:\"pagination_number_post\";s:1:\"4\";s:23:\"pagination_scroll_limit\";s:1:\"0\";s:8:\"ads_type\";s:7:\"disable\";s:12:\"ads_position\";s:1:\"1\";s:9:\"ads_image\";s:0:\"\";s:16:\"ads_image_tablet\";s:0:\"\";s:15:\"ads_image_phone\";s:0:\"\";s:14:\"ads_image_link\";s:0:\"\";s:13:\"ads_image_alt\";s:0:\"\";s:19:\"google_publisher_id\";s:0:\"\";s:14:\"google_slot_id\";s:0:\"\";s:14:\"google_desktop\";s:4:\"auto\";s:10:\"google_tab\";s:4:\"auto\";s:12:\"google_phone\";s:4:\"auto\";s:7:\"content\";s:0:\"\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";s:11:\"title_color\";s:0:\"\";s:12:\"accent_color\";s:0:\"\";s:9:\"alt_color\";s:0:\"\";s:13:\"excerpt_color\";s:0:\"\";}i:3;a:64:{s:11:\"header_icon\";s:0:\"\";s:11:\"first_title\";s:0:\"\";s:12:\"second_title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"header_type\";s:9:\"heading_6\";s:17:\"header_background\";s:0:\"\";s:27:\"header_secondary_background\";s:0:\"\";s:17:\"header_text_color\";s:7:\"#0a0a0a\";s:17:\"header_line_color\";s:0:\"\";s:19:\"header_accent_color\";s:0:\"\";s:22:\"header_filter_category\";s:0:\"\";s:20:\"header_filter_author\";s:0:\"\";s:17:\"header_filter_tag\";s:0:\"\";s:18:\"header_filter_text\";s:3:\"All\";s:11:\"sticky_post\";s:1:\"0\";s:9:\"post_type\";s:4:\"page\";s:12:\"content_type\";s:3:\"all\";s:7:\"sponsor\";s:1:\"0\";s:11:\"number_post\";s:1:\"6\";s:11:\"post_offset\";s:1:\"0\";s:14:\"unique_content\";s:7:\"disable\";s:12:\"include_post\";s:21:\"2073,2211,2137,2242,3\";s:13:\"included_only\";s:1:\"0\";s:12:\"exclude_post\";s:0:\"\";s:16:\"include_category\";s:0:\"\";s:16:\"exclude_category\";s:0:\"\";s:14:\"include_author\";s:0:\"\";s:11:\"include_tag\";s:0:\"\";s:11:\"exclude_tag\";s:0:\"\";s:7:\"sort_by\";s:6:\"latest\";s:9:\"show_date\";s:1:\"0\";s:11:\"date_format\";s:7:\"default\";s:18:\"date_format_custom\";s:5:\"Y/m/d\";s:15:\"pagination_mode\";s:7:\"disable\";s:28:\"pagination_nextprev_showtext\";s:1:\"0\";s:22:\"pagination_number_post\";s:1:\"4\";s:23:\"pagination_scroll_limit\";s:1:\"0\";s:8:\"ads_type\";s:7:\"disable\";s:12:\"ads_position\";s:1:\"1\";s:10:\"ads_random\";s:1:\"0\";s:9:\"ads_image\";s:0:\"\";s:16:\"ads_image_tablet\";s:0:\"\";s:15:\"ads_image_phone\";s:0:\"\";s:14:\"ads_image_link\";s:0:\"\";s:13:\"ads_image_alt\";s:0:\"\";s:17:\"ads_image_new_tab\";s:1:\"0\";s:19:\"google_publisher_id\";s:0:\"\";s:14:\"google_slot_id\";s:0:\"\";s:14:\"google_desktop\";s:4:\"auto\";s:10:\"google_tab\";s:4:\"auto\";s:12:\"google_phone\";s:4:\"auto\";s:7:\"content\";s:0:\"\";s:15:\"ads_bottom_text\";s:1:\"0\";s:5:\"boxed\";s:1:\"0\";s:12:\"boxed_shadow\";s:1:\"0\";s:11:\"show_border\";s:1:\"0\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";s:11:\"title_color\";s:0:\"\";s:12:\"accent_color\";s:0:\"\";s:9:\"alt_color\";s:0:\"\";s:13:\"excerpt_color\";s:0:\"\";}i:4;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("187","widget_jnews_module_block_29","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("188","widget_jnews_module_block_31","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("189","widget_jnews_module_slider_3","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("190","widget_jnews_module_element_ads","a:5:{i:1;a:16:{s:8:\"ads_type\";s:5:\"image\";s:9:\"ads_image\";s:3:\"251\";s:16:\"ads_image_tablet\";s:0:\"\";s:15:\"ads_image_phone\";s:0:\"\";s:14:\"ads_image_link\";s:1:\"#\";s:13:\"ads_image_alt\";s:0:\"\";s:19:\"google_publisher_id\";s:0:\"\";s:14:\"google_slot_id\";s:0:\"\";s:14:\"google_desktop\";s:4:\"auto\";s:10:\"google_tab\";s:4:\"auto\";s:12:\"google_phone\";s:4:\"auto\";s:7:\"content\";s:0:\"\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";}i:2;a:17:{s:8:\"ads_type\";s:5:\"image\";s:9:\"ads_image\";s:3:\"255\";s:16:\"ads_image_tablet\";s:0:\"\";s:15:\"ads_image_phone\";s:0:\"\";s:14:\"ads_image_link\";s:1:\"#\";s:13:\"ads_image_alt\";s:0:\"\";s:17:\"ads_image_new_tab\";s:1:\"1\";s:19:\"google_publisher_id\";s:0:\"\";s:14:\"google_slot_id\";s:0:\"\";s:14:\"google_desktop\";s:4:\"auto\";s:10:\"google_tab\";s:4:\"auto\";s:12:\"google_phone\";s:4:\"auto\";s:7:\"content\";s:0:\"\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";}i:3;a:16:{s:8:\"ads_type\";s:5:\"image\";s:9:\"ads_image\";s:3:\"255\";s:16:\"ads_image_tablet\";s:0:\"\";s:15:\"ads_image_phone\";s:0:\"\";s:14:\"ads_image_link\";s:1:\"#\";s:13:\"ads_image_alt\";s:0:\"\";s:19:\"google_publisher_id\";s:0:\"\";s:14:\"google_slot_id\";s:0:\"\";s:14:\"google_desktop\";s:4:\"auto\";s:10:\"google_tab\";s:4:\"auto\";s:12:\"google_phone\";s:4:\"auto\";s:7:\"content\";s:0:\"\";s:5:\"el_id\";s:0:\"\";s:8:\"el_class\";s:0:\"\";s:6:\"scheme\";s:6:\"normal\";s:12:\"column_width\";s:4:\"auto\";}i:4;a:12:{s:8:\"ads_type\";s:5:\"image\";s:9:\"ads_image\";s:4:\"1406\";s:14:\"ads_image_link\";s:1:\"#\";s:13:\"ads_image_alt\";s:0:\"\";s:17:\"ads_image_new_tab\";s:1:\"1\";s:19:\"google_publisher_id\";s:0:\"\";s:14:\"google_slot_id\";s:0:\"\";s:14:\"google_desktop\";s:4:\"auto\";s:10:\"google_tab\";s:4:\"auto\";s:12:\"google_phone\";s:4:\"auto\";s:8:\"ads_code\";s:0:\"\";s:12:\"column_width\";s:4:\"auto\";}s:12:\"_multiwidget\";i:1;}","yes"),
("191","widget_jnews_module_element_header","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("192","widget_jnews_module_element_videoplaylist","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("193","widget_jnews_module_element_embedplaylist","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("195","widget_jnews_single_review","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("196","widget_jnews_review","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("197","jnews_social_login_url","a:0:{}","yes"),
("239","jnews-widget-list","a:4:{i:0;s:4:\"Home\";i:1;s:11:\"Home - Loop\";i:2;s:6:\"Author\";i:3;s:6:\"Home 2\";}","yes"),
("240","nav_menus_created_posts","a:0:{}","yes"),
("241","jnews_option","a:37:{s:21:\"preview_slider_toggle\";b:0;s:19:\"preview_slider_desc\";b:0;s:18:\"preview_slider_ads\";b:0;s:21:\"preview_slider_loader\";s:3:\"dot\";s:23:\"ads_preview_slider_type\";s:9:\"googleads\";s:24:\"ads_preview_slider_image\";s:0:\"\";s:23:\"ads_preview_slider_link\";s:0:\"\";s:23:\"ads_preview_slider_text\";s:0:\"\";s:35:\"ads_preview_slider_google_publisher\";s:0:\"\";s:28:\"ads_preview_slider_google_id\";s:0:\"\";s:33:\"ads_preview_slider_google_desktop\";s:4:\"auto\";s:23:\"ads_preview_slider_code\";s:0:\"\";s:28:\"ads_preview_slider_shortcode\";s:0:\"\";s:21:\"instagram_feed_enable\";s:4:\"hide\";s:25:\"footer_instagram_username\";s:0:\"\";s:20:\"footer_instagram_row\";i:1;s:23:\"footer_instagram_column\";i:8;s:26:\"footer_instagram_sort_type\";s:11:\"most_recent\";s:28:\"footer_instagram_hover_style\";s:4:\"zoom\";s:30:\"footer_instagram_follow_button\";s:0:\"\";s:23:\"footer_instagram_newtab\";s:0:\"\";s:11:\"price_front\";s:10:\"تومان\";s:12:\"price_behind\";s:0:\"\";s:20:\"price_float_position\";s:5:\"right\";s:18:\"single_view_option\";s:5:\"jnews\";s:24:\"single_social_share_main\";a:3:{i:0;a:2:{s:12:\"social_share\";s:8:\"facebook\";s:11:\"social_text\";s:17:\"Share on Facebook\";}i:1;a:2:{s:12:\"social_share\";s:7:\"twitter\";s:11:\"social_text\";s:16:\"Share on Twitter\";}i:2;a:2:{s:12:\"social_share\";s:10:\"googleplus\";s:11:\"social_text\";s:0:\"\";}}s:29:\"single_social_share_secondary\";a:5:{i:0;a:1:{s:12:\"social_share\";s:8:\"linkedin\";}i:1;a:1:{s:12:\"social_share\";s:9:\"pinterest\";}i:2;a:1:{s:12:\"social_share\";s:6:\"qrcode\";}i:3;a:1:{s:12:\"social_share\";s:8:\"whatsapp\";}i:4;a:1:{s:12:\"social_share\";s:6:\"wechat\";}}s:29:\"single_social_share_threshold\";i:0;s:31:\"single_social_share_via_twitter\";s:0:\"\";s:25:\"single_view_initial_value\";i:0;s:35:\"single_social_share_view_percentage\";i:0;s:27:\"single_like_view_percentage\";i:0;s:12:\"split_loader\";s:3:\"dot\";s:6:\"tm_exp\";i:1769777869;s:19:\"interval_validation\";i:1769777469;s:12:\"view_counter\";a:1:{s:7:\"general\";a:6:{s:13:\"strict_counts\";b:0;s:19:\"time_between_counts\";a:2:{s:6:\"number\";i:0;s:4:\"type\";s:5:\"hours\";}s:7:\"exclude\";a:2:{s:6:\"groups\";a:1:{i:0;s:6:\"robots\";}s:5:\"roles\";a:0:{}}s:3:\"log\";a:2:{s:5:\"limit\";b:0;s:13:\"expires_after\";i:180;}s:7:\"version\";s:6:\"11.0.2\";s:6:\"update\";b:0;}}s:16:\"single_show_like\";s:4:\"both\";}","on"),
("244","wpb_js_composer_license_activation_notified","yes","yes"),
("247","WPLANG","fa_IR","yes"),
("272","widget_akismet_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("273","widget_jnews_weather","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("283","jnews_social_counter_widget_cache","a:6:{i:0;a:4:{s:11:\"social_type\";s:8:\"facebook\";s:9:\"social_id\";s:8:\"jegtheme\";s:13:\"social_expire\";i:1590763210;s:11:\"social_data\";i:3362;}i:1;a:4:{s:11:\"social_type\";s:7:\"behance\";s:9:\"social_id\";s:8:\"jegtheme\";s:13:\"social_expire\";i:1644237411;s:11:\"social_data\";i:108;}i:2;a:4:{s:11:\"social_type\";s:9:\"instagram\";s:9:\"social_id\";s:6:\"envato\";s:13:\"social_expire\";i:1657812518;s:11:\"social_data\";i:86152;}i:3;a:4:{s:11:\"social_type\";s:10:\"soundcloud\";s:9:\"social_id\";s:14:\"dialogdinihari\";s:13:\"social_expire\";i:1753444634;s:11:\"social_data\";i:23892;}i:4;a:4:{s:11:\"social_type\";s:6:\"flickr\";s:9:\"social_id\";s:13:\"we-are-envato\";s:13:\"social_expire\";i:1590763213;s:11:\"social_data\";i:661;}i:5;a:4:{s:11:\"social_type\";s:7:\"youtube\";s:9:\"social_id\";s:6:\"Envato\";s:13:\"social_expire\";i:1590763213;s:11:\"social_data\";i:39000;}}","yes"),
("312","jnews_tag_tag_override","a:1:{s:0:\"\";b:0;}","yes"),
("313","jnews_tag_page_layout","a:1:{s:0:\"\";b:0;}","yes"),
("314","jnews_tag_tag_template","a:1:{s:0:\"\";b:0;}","yes"),
("315","jnews_tag_number_post","a:1:{s:0:\"\";b:0;}","yes"),
("316","jnews_tag_sidebar","a:1:{s:0:\"\";b:0;}","yes"),
("317","jnews_tag_second_sidebar","a:1:{s:0:\"\";b:0;}","yes"),
("318","jnews_tag_sticky_sidebar","a:1:{s:0:\"\";b:0;}","yes"),
("319","jnews_tag_content_layout","a:1:{s:0:\"\";b:0;}","yes"),
("320","jnews_tag_content_boxed","a:1:{s:0:\"\";b:0;}","yes"),
("321","jnews_tag_content_boxed_shadow","a:1:{s:0:\"\";b:0;}","yes"),
("322","jnews_tag_content_box_shadow","a:1:{s:0:\"\";b:0;}","yes"),
("323","jnews_tag_content_excerpt","a:1:{s:0:\"\";b:0;}","yes"),
("324","jnews_tag_content_date","a:1:{s:0:\"\";b:0;}","yes"),
("325","jnews_tag_content_date_custom","a:1:{s:0:\"\";b:0;}","yes"),
("326","jnews_tag_content_pagination","a:1:{s:0:\"\";b:0;}","yes"),
("327","jnews_tag_content_pagination_limit","a:1:{s:0:\"\";b:0;}","yes"),
("328","jnews_tag_content_pagination_align","a:1:{s:0:\"\";b:0;}","yes"),
("329","jnews_tag_content_pagination_text","a:1:{s:0:\"\";b:0;}","yes"),
("330","jnews_tag_content_pagination_page","a:1:{s:0:\"\";b:0;}","yes"),
("376","wpb_js_google_fonts_subsets","a:1:{i:0;s:5:\"latin\";}","yes"),
("377","wpb_js_gutenberg_disable","1","yes"),
("378","wpb_js_default_template_post_type","a:0:{}","yes"),
("386","wpb_js_not_responsive_css","","yes"),
("424","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","off"),
("756","jnews_dismiss_license_notice","1","yes"),
("766","loco_settings","a:4:{s:1:\"c\";s:18:\"Loco_data_Settings\";s:1:\"v\";i:0;s:1:\"d\";a:14:{s:7:\"version\";s:5:\"2.3.1\";s:8:\"gen_hash\";b:0;s:9:\"use_fuzzy\";b:1;s:11:\"num_backups\";i:1;s:9:\"pot_alias\";a:3:{i:0;s:10:\"default.po\";i:1;s:8:\"en_US.po\";i:2;s:5:\"en.po\";}s:9:\"php_alias\";a:2:{i:0;s:3:\"php\";i:1;s:4:\"twig\";}s:9:\"jsx_alias\";a:0:{}s:10:\"fs_persist\";b:0;s:10:\"fs_protect\";i:1;s:12:\"max_php_size\";s:4:\"100K\";s:11:\"po_utf8_bom\";b:0;s:8:\"po_width\";s:2:\"79\";s:10:\"jed_pretty\";b:0;s:10:\"ajax_files\";b:0;}s:1:\"t\";i:1581522863;}","yes"),
("775","loco_recent","a:4:{s:1:\"c\";s:21:\"Loco_data_RecentItems\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:6:\"bundle\";a:1:{s:11:\"theme.jnews\";i:1581523744;}}s:1:\"t\";i:1581523744;}","no"),
("778","jnews_translate","a:211:{s:18:\"enable_translation\";s:1:\"1\";s:4:\"home\";s:8:\"خانه\";s:6:\"author\";s:14:\"نویسنده\";s:6:\"search\";s:10:\"جستجو\";s:8:\"category\";s:17:\"دسته بندی\";s:3:\"tag\";s:10:\"برچسب\";s:2:\"of\";s:4:\"از\";s:5:\"views\";s:16:\"بازدیدها\";s:16:\"shares_uppercase\";s:23:\"اشتراک گذاری\";s:14:\"page_not_found\";s:15:\"یافت نشد\";s:11:\"back_to_top\";s:26:\"بازگشت به بالا\";s:20:\"sorry_page_not_found\";s:77:\"متاسفیم چیزی که به دنبال آن هستید یافت نشد.\";s:3:\"all\";s:6:\"همه\";s:7:\"reviews\";s:25:\"نقد و بررسی ها\";s:2:\"by\";s:8:\"توسط\";s:2:\"in\";s:4:\"در\";s:9:\"load_more\";s:25:\"بیشتر بخوانید\";s:14:\"end_of_content\";s:21:\"پایان محتوا\";s:7:\"loading\";s:32:\"در حال بارگذاری ...\";s:10:\"close_menu\";s:15:\"بستن منو\";s:4:\"cart\";s:15:\"سبد خرید\";s:9:\"next_post\";s:15:\"پست بعدی\";s:13:\"previous_post\";s:15:\"پست قبلی\";s:9:\"read_more\";s:23:\"جزئیات بیشتر\";s:8:\"previous\";s:8:\"قبلی\";s:4:\"prev\";s:6:\"قبل\";s:4:\"next\";s:6:\"بعد\";s:19:\"search_result_for_s\";s:35:\"نتیجه جستجو برای \'%s\'\";s:11:\"search_form\";s:14:\"جستجو ...\";s:9:\"no_result\";s:19:\"بدون نتیجه\";s:15:\"view_all_result\";s:28:\"نمایش همه نتایج\";s:3:\"ago\";s:6:\"قبل\";s:4:\"sago\";s:9:\"%s قبل\";s:5:\"login\";s:19:\"ورود کاربر\";s:7:\"account\";s:21:\"حساب کاربری\";s:6:\"logout\";s:8:\"خروج\";s:8:\"register\";s:13:\"ثبت نام\";s:10:\"order_list\";s:19:\"ترتیب لیست\";s:12:\"edit_profile\";s:27:\"ویرایش پروفایل\";s:15:\"latest_articles\";s:23:\"آخرین مقالات\";s:14:\"optimal_column\";s:19:\"ستون بهینه\";s:20:\"no_content_available\";s:34:\"محتوایی موجود نیست\";s:11:\"page_s_of_s\";s:19:\"صفحه %s از %s\";s:6:\"page_s\";s:11:\"صفحه %s\";s:17:\"currently_playing\";s:18:\"در حال پخش\";s:6:\"latest\";s:10:\"آخرین\";s:8:\"trending\";s:8:\"روند\";s:6:\"filter\";s:10:\"فیلتر\";s:4:\"tags\";s:11:\"برچسب:\";s:7:\"related\";s:10:\"مطالب\";s:15:\"related_content\";s:23:\"محتوای مرتبط\";s:16:\"continue_reading\";s:23:\"ادامه خواندن\";s:5:\"posts\";s:10:\"مرتبط\";s:6:\"shares\";s:28:\"اشتراک گذاری ها\";s:5:\"share\";s:23:\"اشتراک گذاری\";s:4:\"send\";s:10:\"ارسال\";s:4:\"scan\";s:8:\"اسکن\";s:5:\"tweet\";s:10:\"توییت\";s:8:\"bookmark\";s:15:\"بوک مارک\";s:3:\"pin\";s:6:\"پین\";s:3:\"fan\";s:4:\"فن\";s:8:\"follower\";s:12:\"فالوور\";s:10:\"subscriber\";s:6:\"عضو\";s:9:\"close_esc\";s:14:\"بستن (Esc)\";s:17:\"toggle_fullscreen\";s:15:\"تمام عرض\";s:11:\"zoom_in_out\";s:26:\"زوم بیشتر/کمتر\";s:19:\"previous_arrow_left\";s:29:\"قبلی (فلش سمت چپ)\";s:16:\"next_arrow_right\";s:33:\"بعدی (فلش سمت راست)\";s:15:\"jump_to_section\";s:18:\"پرش به بخش\";s:8:\"comments\";s:17:\"دیدگاه ها\";s:12:\"edit_comment\";s:14:\"(ویرایش)\";s:28:\"please_login_join_discussion\";s:90:\"لطفاً <a href=\'%s\' class=\'%s\'>وارد شوید</a> برای پیوستن به بحث\";s:21:\"discussion_about_this\";s:30:\"بحث در مورد این %s\";s:18:\"comment_moderation\";s:55:\"دیدگاه شما در انتظار بررسی است\";s:12:\"read-comment\";s:37:\"مطالعه همه دیدگاه ها\";s:13:\"leave-comment\";s:23:\"ارسال دیدگاه\";s:15:\"loading-comment\";s:29:\"بارگذاری دیدگاه\";s:13:\"advertisement\";s:14:\"تبلیغات\";s:18:\"view_shopping_cart\";s:35:\"مشاهده سبد خرید شما\";s:8:\"min_read\";s:21:\"زمان مطالعه\";s:11:\"source_text\";s:9:\"منبع:\";s:8:\"via_text\";s:9:\"توسط:\";s:16:\"review_breakdown\";s:26:\"مرور نقد بررسی\";s:5:\"score\";s:12:\"امتیاز\";s:4:\"pros\";s:16:\"طرفداران\";s:4:\"cons\";s:14:\"مخالفان\";s:4:\"view\";s:10:\"نمایش\";s:7:\"s_DEALS\";s:17:\"%s معاملات\";s:20:\"best_price_available\";s:122:\"برای کسب بهترین قیمت در فروشگاه های بسیاری اطلاعات جمع آوری می کنیم\";s:10:\"best_price\";s:21:\"بهترین قیمت\";s:10:\"the_review\";s:20:\"نقد و بررسی\";s:9:\"avg_score\";s:27:\"امتیاز میانگین\";s:7:\"buy_now\";s:19:\"خرید اکنون\";s:12:\"available_at\";s:15:\"موجود در\";s:13:\"search_review\";s:36:\"جستجوی نقد و بررسی...\";s:9:\"no_review\";s:36:\"نقد و بررسی یافت نشد\";s:12:\"all_category\";s:29:\"همه دسته بندی ها\";s:12:\"newest_first\";s:20:\"جدید تر اول\";s:12:\"oldest_first\";s:22:\"قدیمی تر اول\";s:13:\"highest_price\";s:25:\"بالاترین قیمت\";s:12:\"lowest_price\";s:21:\"کمترین قیمت\";s:14:\"highest_rating\";s:29:\"بالاترین امتیاز\";s:13:\"lowest_rating\";s:25:\"کمترین امتیاز\";s:11:\"ingredients\";s:10:\"اجزاء\";s:12:\"instructions\";s:25:\"دستورالعمل ها\";s:6:\"serves\";s:9:\"خدمت:\";s:9:\"cook_time\";s:30:\"زمان پخت: %s دقیقه\";s:5:\"level\";s:7:\"سطح:\";s:12:\"print_recipe\";s:28:\"دستور العمل چاپ\";s:10:\"liked_post\";s:26:\"دوست داشتن پست\";s:13:\"disliked_post\";s:28:\"دوست نداشتن پست\";s:10:\"must_login\";s:43:\"برای رای باید وارد شوید!\";s:20:\"thanks_for_your_vote\";s:34:\"از رای شما متشکریم!\";s:17:\"internal_db_error\";s:35:\"خطای داخلی دیتابیس!\";s:27:\"push_notification_subscribe\";s:10:\"عضویت\";s:29:\"push_notification_unsubscribe\";s:17:\"لغو عضویت\";s:28:\"push_notification_processing\";s:28:\"در حال عملیات ...\";s:8:\"facebook\";s:13:\"فیس بوک\";s:7:\"twitter\";s:12:\"توییتر\";s:8:\"linkedin\";s:14:\"لینکدین\";s:6:\"google\";s:9:\"گوگل+\";s:9:\"pinterest\";s:14:\"پینترست\";s:7:\"behance\";s:10:\"بیهنس\";s:6:\"github\";s:16:\"گیت‌ هاب\";s:6:\"flickr\";s:10:\"فلیکر\";s:6:\"tumblr\";s:12:\"تامبلر\";s:8:\"dribbble\";s:14:\"دریبببل\";s:10:\"soundcloud\";s:21:\"ساوند کلاود\";s:9:\"instagram\";s:20:\"اینستاگرام\";s:5:\"vimeo\";s:10:\"ویمیو\";s:7:\"youtube\";s:12:\"یوتیوب\";s:2:\"vk\";s:9:\"وی کی\";s:6:\"reddit\";s:8:\"ردیت\";s:5:\"weibo\";s:8:\"ویبو\";s:11:\"stumbleupon\";s:21:\"استامبل آپن\";s:8:\"telegram\";s:12:\"تلگرام\";s:3:\"rss\";s:3:\"RSS\";s:7:\"website\";s:12:\"وبسایت\";s:10:\"my_account\";s:13:\"حساب من\";s:12:\"edit_account\";s:21:\"ویرایش حساب\";s:15:\"change_password\";s:25:\"ویرایش پسوورد\";s:7:\"my_post\";s:11:\"پست من\";s:10:\"first_name\";s:15:\"نام کوچک\";s:15:\"first_name_desc\";s:49:\"نام کوچک خود را وارد نمایید\";s:9:\"last_name\";s:23:\"نام خانوادگی\";s:14:\"last_name_desc\";s:50:\"نام خانوادگی را وارد نمایید\";s:12:\"contact_info\";s:23:\"اطلاعات تماس\";s:14:\"about_yourself\";s:25:\"درباره خودتان\";s:17:\"biographical_info\";s:31:\"اطلاعات بیوگرافی\";s:15:\"profile_picture\";s:25:\"تصویر پروفایل\";s:12:\"choose_image\";s:19:\"انتخاب عکس\";s:9:\"add_media\";s:21:\"افزودن مدیا\";s:12:\"insert_media\";s:26:\"وارد کردن مدیا\";s:12:\"old_password\";s:23:\"رمزعبور قدیم\";s:12:\"new_password\";s:23:\"رمزعبور جدید\";s:16:\"confirm_password\";s:26:\"تکرار رمزعبور \";s:19:\"edit_account_button\";s:21:\"ویرایش حساب\";s:22:\"change_password_button\";s:28:\"ویرایش رمز عبور\";s:19:\"first_name_required\";s:51:\"نام کوچک نمی تواند خالی باشد\";s:18:\"last_name_required\";s:59:\"نام خانوادگی نمی تواند خالی باشد\";s:20:\"success_edit_account\";s:75:\"اطلاعات حساب کاربری شما با موفقیت بروز شد\";s:18:\"old_password_error\";s:50:\"رمزعبور قدیمی شما صحیح نیست\";s:18:\"new_password_empty\";s:50:\"رمزعبور جدید را وارد نمایید\";s:22:\"confirm_password_error\";s:54:\"رمز عبور و تکرار آن یکسان نیست\";s:23:\"success_change_password\";s:58:\"رمز عبور شما با موفقیت ویرایش شد\";s:18:\"old_password_empty\";s:53:\"رمز عبور قدیمی را وارد نمایید\";s:12:\"welcome_back\";s:18:\"خوش آمدید!\";s:16:\"login_to_account\";s:38:\"به حساب خود وارد شوید\";s:8:\"username\";s:19:\"نام کاربری\";s:10:\"username_s\";s:23:\"نام کاربری: %s\";s:8:\"password\";s:15:\"رمز عبور\";s:6:\"log_in\";s:15:\"وارد شدن\";s:10:\"processing\";s:26:\"در حال انجام ...\";s:18:\"forgotten_password\";s:33:\"فراموشی رمز عبور ؟\";s:18:\"create_new_account\";s:31:\"ساخت حساب کاربری!\";s:21:\"fill_form_to_register\";s:65:\"فرم زیر را برای ثبت نام تکمیل نمایید\";s:10:\"your_email\";s:17:\"ایمیل شما\";s:7:\"sign_up\";s:13:\"ثبت نام\";s:18:\"all_field_required\";s:38:\"همه فیلد ها ضروری اند\";s:17:\"retrieve_password\";s:51:\"رمز عبور خود را بازیابی کنید\";s:27:\"enter_detail_reset_password\";s:118:\"لطفاً ایمیل یا نام کاربری خود را جهت بازیابی رمز عبور وارد نمایید\";s:22:\"your_email_or_username\";s:35:\"ایمیل یا نام کاربری\";s:14:\"reset_password\";s:32:\"بازنشانی رمز عبور\";s:14:\"login_facebook\";s:26:\"ورود با فیسبوک\";s:12:\"login_google\";s:23:\"ورود با گوگل+\";s:13:\"login_twitter\";s:26:\"ورود با توییتر\";s:14:\"login_linkedin\";s:41:\"ورود با توییتر لینکدین\";s:17:\"register_facebook\";s:31:\"ثبت نام با فیسبوک\";s:15:\"register_google\";s:28:\"ثبت نام با گوگل+\";s:16:\"register_twitter\";s:31:\"ثبت نام با توییتر\";s:17:\"register_linkedin\";s:33:\"ثبت نام با لینکدین\";s:2:\"or\";s:4:\"یا\";s:23:\"username_email_required\";s:50:\"نام کاربری / ایمیل ضروری است\";s:17:\"password_required\";s:33:\"رمز عبور ضروری است\";s:25:\"user_with_email_not_found\";s:61:\"کاربری با این آدرس ایمیل یافت نشد.\";s:30:\"login_success_wait_redirecting\";s:54:\"ورود موفق بود ، کمی صبر کنید ...\";s:22:\"username_already_taken\";s:49:\"نام کاربری از قبل وجود دارد\";s:16:\"invalid_username\";s:32:\"نام کاربری اشتباه\";s:21:\"please_enter_username\";s:57:\"لطفاً یک نام کاربری وارد نمایید\";s:13:\"invalid_email\";s:23:\"ایمیل اشتباه\";s:24:\"email_already_registered\";s:42:\"ایمیل قبلاً ثبت شده است\";s:28:\"register_success_check_email\";s:172:\"ثبت نام موفق بود. لطفا ایمیل خود را (پوشه اینباکس یا هرزنامه) بررسی کنید، رمز عبور ارسال شده است.\";s:28:\"enter_username_email_address\";s:71:\"نام کاربری یا آدرس ایمیل را وارد نمایید\";s:29:\"email_username_not_registered\";s:69:\"نام کاربری یا ایمیل در سایت وجود ندارد\";s:41:\"email_not_sent_host_disable_mail_function\";s:137:\"ایمیل قابل ارسال نیست میزبان شما ممکن است عملکرد mail () را غیرفعال کرده باشد...\";s:29:\"check_email_confirmation_link\";s:100:\"لطفاً لینک فعال سازی ارسال شده به ایمیل را بررسی نمایید\";s:16:\"s_password_reset\";s:37:\"[%s] بازنشانی رمز عبور\";s:30:\"someone_request_password_reset\";s:116:\"کسی درخواست بازنشانی رمز عبور برای حساب زیر را درخواست کرده است:\";s:20:\"ignore_mistake_email\";s:144:\"اگر این یک اشتباه بود، فقط این ایمیل را نادیده بگیرید و هیچ اتفاقی نخواهد افتاد.\";s:28:\"reset_password_visit_address\";s:87:\"برای بازنشانی گذرواژه خود از آدرس زیر دیدن کنید:\";s:0:\"\";s:0:\"\";}","yes"),
("790","revslider_servers","a:7:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-b.tools\";i:3;s:22:\"themepunch-ext-b.tools\";i:4;s:16:\"themepunch.tools\";i:5;s:22:\"themepunch-ext-a.tools\";i:6;s:22:\"themepunch-ext-a.tools\";}","yes"),
("791","revslider_server_refresh","1581380641","yes"),
("792","revslider-update-check-short","1581455363","yes"),
("793","revslider-templates-check","1581455363","yes"),
("798","revslider-library-check","1581067655","yes"),
("799","rs-library","a:3:{s:4:\"hash\";s:32:\"38cf270bea2cb5bb7e100e0fd4e86d05\";s:7:\"objects\";a:417:{i:529;a:14:{s:2:\"id\";s:3:\"529\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:528;a:14:{s:2:\"id\";s:3:\"528\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:527;a:14:{s:2:\"id\";s:3:\"527\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:526;a:14:{s:2:\"id\";s:3:\"526\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:525;a:14:{s:2:\"id\";s:3:\"525\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:524;a:14:{s:2:\"id\";s:3:\"524\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";}i:523;a:14:{s:2:\"id\";s:3:\"523\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";}i:522;a:14:{s:2:\"id\";s:3:\"522\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";}i:521;a:14:{s:2:\"id\";s:3:\"521\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";}i:520;a:14:{s:2:\"id\";s:3:\"520\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:519;a:14:{s:2:\"id\";s:3:\"519\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:518;a:14:{s:2:\"id\";s:3:\"518\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:517;a:14:{s:2:\"id\";s:3:\"517\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:516;a:14:{s:2:\"id\";s:3:\"516\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:515;a:14:{s:2:\"id\";s:3:\"515\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:514;a:14:{s:2:\"id\";s:3:\"514\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:513;a:14:{s:2:\"id\";s:3:\"513\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:512;a:14:{s:2:\"id\";s:3:\"512\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:511;a:14:{s:2:\"id\";s:3:\"511\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:510;a:14:{s:2:\"id\";s:3:\"510\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:509;a:14:{s:2:\"id\";s:3:\"509\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:508;a:14:{s:2:\"id\";s:3:\"508\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:507;a:14:{s:2:\"id\";s:3:\"507\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:506;a:14:{s:2:\"id\";s:3:\"506\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:505;a:14:{s:2:\"id\";s:3:\"505\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";}i:504;a:14:{s:2:\"id\";s:3:\"504\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";}i:503;a:14:{s:2:\"id\";s:3:\"503\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";}i:502;a:14:{s:2:\"id\";s:3:\"502\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";}i:501;a:14:{s:2:\"id\";s:3:\"501\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:500;a:14:{s:2:\"id\";s:3:\"500\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:499;a:14:{s:2:\"id\";s:3:\"499\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:498;a:14:{s:2:\"id\";s:3:\"498\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:497;a:14:{s:2:\"id\";s:3:\"497\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:496;a:14:{s:2:\"id\";s:3:\"496\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:495;a:14:{s:2:\"id\";s:3:\"495\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:494;a:14:{s:2:\"id\";s:3:\"494\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:493;a:14:{s:2:\"id\";s:3:\"493\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:492;a:14:{s:2:\"id\";s:3:\"492\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:491;a:14:{s:2:\"id\";s:3:\"491\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";}i:490;a:14:{s:2:\"id\";s:3:\"490\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";}i:489;a:14:{s:2:\"id\";s:3:\"489\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";}i:488;a:14:{s:2:\"id\";s:3:\"488\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";}i:487;a:14:{s:2:\"id\";s:3:\"487\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:486;a:14:{s:2:\"id\";s:3:\"486\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:485;a:14:{s:2:\"id\";s:3:\"485\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:484;a:14:{s:2:\"id\";s:3:\"484\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:483;a:14:{s:2:\"id\";s:3:\"483\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:482;a:14:{s:2:\"id\";s:3:\"482\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:481;a:14:{s:2:\"id\";s:3:\"481\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:480;a:14:{s:2:\"id\";s:3:\"480\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:479;a:13:{s:2:\"id\";s:3:\"479\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";}i:478;a:13:{s:2:\"id\";s:3:\"478\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";}i:477;a:13:{s:2:\"id\";s:3:\"477\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";}i:476;a:13:{s:2:\"id\";s:3:\"476\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:475;a:13:{s:2:\"id\";s:3:\"475\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:474;a:13:{s:2:\"id\";s:3:\"474\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:473;a:13:{s:2:\"id\";s:3:\"473\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:472;a:13:{s:2:\"id\";s:3:\"472\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:471;a:13:{s:2:\"id\";s:3:\"471\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:470;a:13:{s:2:\"id\";s:3:\"470\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:469;a:13:{s:2:\"id\";s:3:\"469\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:468;a:13:{s:2:\"id\";s:3:\"468\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:467;a:13:{s:2:\"id\";s:3:\"467\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:466;a:13:{s:2:\"id\";s:3:\"466\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:465;a:13:{s:2:\"id\";s:3:\"465\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:464;a:13:{s:2:\"id\";s:3:\"464\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:463;a:13:{s:2:\"id\";s:3:\"463\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:462;a:13:{s:2:\"id\";s:3:\"462\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:461;a:13:{s:2:\"id\";s:3:\"461\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:460;a:13:{s:2:\"id\";s:3:\"460\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:459;a:13:{s:2:\"id\";s:3:\"459\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:458;a:13:{s:2:\"id\";s:3:\"458\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:457;a:13:{s:2:\"id\";s:3:\"457\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:456;a:13:{s:2:\"id\";s:3:\"456\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:455;a:13:{s:2:\"id\";s:3:\"455\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:454;a:13:{s:2:\"id\";s:3:\"454\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:453;a:13:{s:2:\"id\";s:3:\"453\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:452;a:13:{s:2:\"id\";s:3:\"452\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:451;a:13:{s:2:\"id\";s:3:\"451\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:450;a:13:{s:2:\"id\";s:3:\"450\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:449;a:13:{s:2:\"id\";s:3:\"449\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:448;a:13:{s:2:\"id\";s:3:\"448\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:447;a:13:{s:2:\"id\";s:3:\"447\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:446;a:13:{s:2:\"id\";s:3:\"446\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:445;a:13:{s:2:\"id\";s:3:\"445\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:444;a:13:{s:2:\"id\";s:3:\"444\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:443;a:13:{s:2:\"id\";s:3:\"443\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:442;a:13:{s:2:\"id\";s:3:\"442\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:441;a:13:{s:2:\"id\";s:3:\"441\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:440;a:13:{s:2:\"id\";s:3:\"440\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:439;a:13:{s:2:\"id\";s:3:\"439\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:438;a:13:{s:2:\"id\";s:3:\"438\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:437;a:13:{s:2:\"id\";s:3:\"437\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:436;a:13:{s:2:\"id\";s:3:\"436\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:435;a:13:{s:2:\"id\";s:3:\"435\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:434;a:13:{s:2:\"id\";s:3:\"434\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:433;a:13:{s:2:\"id\";s:3:\"433\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:432;a:13:{s:2:\"id\";s:3:\"432\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:431;a:13:{s:2:\"id\";s:3:\"431\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:430;a:13:{s:2:\"id\";s:3:\"430\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:429;a:13:{s:2:\"id\";s:3:\"429\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:428;a:13:{s:2:\"id\";s:3:\"428\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:427;a:13:{s:2:\"id\";s:3:\"427\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:426;a:13:{s:2:\"id\";s:3:\"426\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:425;a:13:{s:2:\"id\";s:3:\"425\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:424;a:13:{s:2:\"id\";s:3:\"424\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:423;a:13:{s:2:\"id\";s:3:\"423\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:422;a:13:{s:2:\"id\";s:3:\"422\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:421;a:13:{s:2:\"id\";s:3:\"421\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:420;a:13:{s:2:\"id\";s:3:\"420\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:419;a:13:{s:2:\"id\";s:3:\"419\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:418;a:13:{s:2:\"id\";s:3:\"418\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:417;a:13:{s:2:\"id\";s:3:\"417\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:416;a:13:{s:2:\"id\";s:3:\"416\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:415;a:13:{s:2:\"id\";s:3:\"415\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:414;a:13:{s:2:\"id\";s:3:\"414\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:413;a:13:{s:2:\"id\";s:3:\"413\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:412;a:13:{s:2:\"id\";s:3:\"412\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:411;a:13:{s:2:\"id\";s:3:\"411\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:410;a:13:{s:2:\"id\";s:3:\"410\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:409;a:13:{s:2:\"id\";s:3:\"409\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:408;a:13:{s:2:\"id\";s:3:\"408\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:407;a:13:{s:2:\"id\";s:3:\"407\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:406;a:13:{s:2:\"id\";s:3:\"406\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:405;a:13:{s:2:\"id\";s:3:\"405\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:404;a:13:{s:2:\"id\";s:3:\"404\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:403;a:13:{s:2:\"id\";s:3:\"403\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:402;a:13:{s:2:\"id\";s:3:\"402\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:401;a:13:{s:2:\"id\";s:3:\"401\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:400;a:13:{s:2:\"id\";s:3:\"400\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:399;a:13:{s:2:\"id\";s:3:\"399\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:398;a:13:{s:2:\"id\";s:3:\"398\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:397;a:13:{s:2:\"id\";s:3:\"397\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:396;a:13:{s:2:\"id\";s:3:\"396\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:395;a:13:{s:2:\"id\";s:3:\"395\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:394;a:13:{s:2:\"id\";s:3:\"394\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:393;a:13:{s:2:\"id\";s:3:\"393\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:392;a:13:{s:2:\"id\";s:3:\"392\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:391;a:13:{s:2:\"id\";s:3:\"391\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:390;a:13:{s:2:\"id\";s:3:\"390\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:389;a:13:{s:2:\"id\";s:3:\"389\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:388;a:13:{s:2:\"id\";s:3:\"388\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:387;a:13:{s:2:\"id\";s:3:\"387\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:386;a:13:{s:2:\"id\";s:3:\"386\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:385;a:13:{s:2:\"id\";s:3:\"385\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:384;a:13:{s:2:\"id\";s:3:\"384\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:383;a:13:{s:2:\"id\";s:3:\"383\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:382;a:13:{s:2:\"id\";s:3:\"382\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:381;a:13:{s:2:\"id\";s:3:\"381\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:380;a:13:{s:2:\"id\";s:3:\"380\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:379;a:13:{s:2:\"id\";s:3:\"379\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:378;a:13:{s:2:\"id\";s:3:\"378\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:377;a:13:{s:2:\"id\";s:3:\"377\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:376;a:13:{s:2:\"id\";s:3:\"376\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:375;a:13:{s:2:\"id\";s:3:\"375\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:374;a:13:{s:2:\"id\";s:3:\"374\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:373;a:13:{s:2:\"id\";s:3:\"373\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:372;a:13:{s:2:\"id\";s:3:\"372\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:371;a:13:{s:2:\"id\";s:3:\"371\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:370;a:13:{s:2:\"id\";s:3:\"370\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:369;a:13:{s:2:\"id\";s:3:\"369\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:368;a:13:{s:2:\"id\";s:3:\"368\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:367;a:13:{s:2:\"id\";s:3:\"367\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:366;a:13:{s:2:\"id\";s:3:\"366\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:365;a:13:{s:2:\"id\";s:3:\"365\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:364;a:13:{s:2:\"id\";s:3:\"364\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:363;a:13:{s:2:\"id\";s:3:\"363\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:362;a:13:{s:2:\"id\";s:3:\"362\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:361;a:13:{s:2:\"id\";s:3:\"361\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:360;a:13:{s:2:\"id\";s:3:\"360\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:359;a:13:{s:2:\"id\";s:3:\"359\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:358;a:13:{s:2:\"id\";s:3:\"358\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:357;a:13:{s:2:\"id\";s:3:\"357\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:356;a:13:{s:2:\"id\";s:3:\"356\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:355;a:13:{s:2:\"id\";s:3:\"355\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:354;a:13:{s:2:\"id\";s:3:\"354\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:353;a:13:{s:2:\"id\";s:3:\"353\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:352;a:13:{s:2:\"id\";s:3:\"352\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:351;a:13:{s:2:\"id\";s:3:\"351\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:350;a:13:{s:2:\"id\";s:3:\"350\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:349;a:13:{s:2:\"id\";s:3:\"349\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:348;a:13:{s:2:\"id\";s:3:\"348\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:347;a:13:{s:2:\"id\";s:3:\"347\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:346;a:13:{s:2:\"id\";s:3:\"346\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:345;a:13:{s:2:\"id\";s:3:\"345\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:344;a:13:{s:2:\"id\";s:3:\"344\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:343;a:13:{s:2:\"id\";s:3:\"343\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:342;a:13:{s:2:\"id\";s:3:\"342\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:341;a:13:{s:2:\"id\";s:3:\"341\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:340;a:13:{s:2:\"id\";s:3:\"340\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:339;a:13:{s:2:\"id\";s:3:\"339\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";}i:337;a:13:{s:2:\"id\";s:3:\"337\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";}i:336;a:13:{s:2:\"id\";s:3:\"336\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";}i:335;a:13:{s:2:\"id\";s:3:\"335\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";}i:334;a:13:{s:2:\"id\";s:3:\"334\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:333;a:13:{s:2:\"id\";s:3:\"333\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:332;a:13:{s:2:\"id\";s:3:\"332\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:331;a:13:{s:2:\"id\";s:3:\"331\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:330;a:13:{s:2:\"id\";s:3:\"330\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:329;a:13:{s:2:\"id\";s:3:\"329\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:328;a:13:{s:2:\"id\";s:3:\"328\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";}i:327;a:13:{s:2:\"id\";s:3:\"327\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:326;a:13:{s:2:\"id\";s:3:\"326\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:325;a:13:{s:2:\"id\";s:3:\"325\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:324;a:13:{s:2:\"id\";s:3:\"324\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:322;a:13:{s:2:\"id\";s:3:\"322\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:321;a:13:{s:2:\"id\";s:3:\"321\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:320;a:13:{s:2:\"id\";s:3:\"320\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:319;a:13:{s:2:\"id\";s:3:\"319\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:318;a:13:{s:2:\"id\";s:3:\"318\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:317;a:13:{s:2:\"id\";s:3:\"317\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:316;a:13:{s:2:\"id\";s:3:\"316\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:315;a:13:{s:2:\"id\";s:3:\"315\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:314;a:13:{s:2:\"id\";s:3:\"314\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:313;a:13:{s:2:\"id\";s:3:\"313\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:312;a:13:{s:2:\"id\";s:3:\"312\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";}i:311;a:13:{s:2:\"id\";s:3:\"311\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:310;a:13:{s:2:\"id\";s:3:\"310\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:309;a:13:{s:2:\"id\";s:3:\"309\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:308;a:13:{s:2:\"id\";s:3:\"308\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:307;a:13:{s:2:\"id\";s:3:\"307\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:306;a:13:{s:2:\"id\";s:3:\"306\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:305;a:13:{s:2:\"id\";s:3:\"305\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:304;a:13:{s:2:\"id\";s:3:\"304\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:303;a:13:{s:2:\"id\";s:3:\"303\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:302;a:13:{s:2:\"id\";s:3:\"302\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:301;a:13:{s:2:\"id\";s:3:\"301\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:300;a:13:{s:2:\"id\";s:3:\"300\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:299;a:13:{s:2:\"id\";s:3:\"299\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:298;a:13:{s:2:\"id\";s:3:\"298\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:297;a:13:{s:2:\"id\";s:3:\"297\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:296;a:13:{s:2:\"id\";s:3:\"296\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:295;a:13:{s:2:\"id\";s:3:\"295\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:294;a:13:{s:2:\"id\";s:3:\"294\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:293;a:13:{s:2:\"id\";s:3:\"293\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:292;a:13:{s:2:\"id\";s:3:\"292\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:291;a:13:{s:2:\"id\";s:3:\"291\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:290;a:13:{s:2:\"id\";s:3:\"290\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:238;a:14:{s:2:\"id\";s:3:\"238\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:237;a:14:{s:2:\"id\";s:3:\"237\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:236;a:14:{s:2:\"id\";s:3:\"236\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:235;a:14:{s:2:\"id\";s:3:\"235\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:234;a:14:{s:2:\"id\";s:3:\"234\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:233;a:14:{s:2:\"id\";s:3:\"233\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:232;a:14:{s:2:\"id\";s:3:\"232\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:231;a:14:{s:2:\"id\";s:3:\"231\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:230;a:14:{s:2:\"id\";s:3:\"230\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:229;a:14:{s:2:\"id\";s:3:\"229\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:198;a:13:{s:2:\"id\";s:3:\"198\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";}i:197;a:13:{s:2:\"id\";s:3:\"197\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:196;a:13:{s:2:\"id\";s:3:\"196\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:195;a:13:{s:2:\"id\";s:3:\"195\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:194;a:13:{s:2:\"id\";s:3:\"194\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:193;a:13:{s:2:\"id\";s:3:\"193\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:192;a:13:{s:2:\"id\";s:3:\"192\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:191;a:13:{s:2:\"id\";s:3:\"191\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:190;a:13:{s:2:\"id\";s:3:\"190\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:189;a:13:{s:2:\"id\";s:3:\"189\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:188;a:13:{s:2:\"id\";s:3:\"188\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:187;a:13:{s:2:\"id\";s:3:\"187\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:186;a:13:{s:2:\"id\";s:3:\"186\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:185;a:13:{s:2:\"id\";s:3:\"185\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:184;a:13:{s:2:\"id\";s:3:\"184\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:183;a:13:{s:2:\"id\";s:3:\"183\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:182;a:13:{s:2:\"id\";s:3:\"182\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:181;a:13:{s:2:\"id\";s:3:\"181\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:180;a:13:{s:2:\"id\";s:3:\"180\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:179;a:13:{s:2:\"id\";s:3:\"179\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:177;a:13:{s:2:\"id\";s:3:\"177\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:175;a:13:{s:2:\"id\";s:3:\"175\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:174;a:13:{s:2:\"id\";s:3:\"174\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:173;a:13:{s:2:\"id\";s:3:\"173\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:172;a:13:{s:2:\"id\";s:3:\"172\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:171;a:13:{s:2:\"id\";s:3:\"171\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:170;a:13:{s:2:\"id\";s:3:\"170\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:169;a:13:{s:2:\"id\";s:3:\"169\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:168;a:13:{s:2:\"id\";s:3:\"168\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:167;a:13:{s:2:\"id\";s:3:\"167\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:166;a:13:{s:2:\"id\";s:3:\"166\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:165;a:13:{s:2:\"id\";s:3:\"165\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:164;a:13:{s:2:\"id\";s:3:\"164\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:163;a:13:{s:2:\"id\";s:3:\"163\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:162;a:13:{s:2:\"id\";s:3:\"162\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:161;a:13:{s:2:\"id\";s:3:\"161\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:160;a:13:{s:2:\"id\";s:3:\"160\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:159;a:13:{s:2:\"id\";s:3:\"159\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:158;a:13:{s:2:\"id\";s:3:\"158\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:157;a:13:{s:2:\"id\";s:3:\"157\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:156;a:13:{s:2:\"id\";s:3:\"156\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:155;a:13:{s:2:\"id\";s:3:\"155\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:154;a:13:{s:2:\"id\";s:3:\"154\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:153;a:13:{s:2:\"id\";s:3:\"153\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:152;a:13:{s:2:\"id\";s:3:\"152\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:151;a:13:{s:2:\"id\";s:3:\"151\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:150;a:13:{s:2:\"id\";s:3:\"150\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:149;a:13:{s:2:\"id\";s:3:\"149\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:148;a:13:{s:2:\"id\";s:3:\"148\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:147;a:13:{s:2:\"id\";s:3:\"147\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:146;a:13:{s:2:\"id\";s:3:\"146\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:145;a:13:{s:2:\"id\";s:3:\"145\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:144;a:13:{s:2:\"id\";s:3:\"144\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:143;a:13:{s:2:\"id\";s:3:\"143\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:142;a:13:{s:2:\"id\";s:3:\"142\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:141;a:13:{s:2:\"id\";s:3:\"141\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:140;a:13:{s:2:\"id\";s:3:\"140\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:139;a:13:{s:2:\"id\";s:3:\"139\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:138;a:13:{s:2:\"id\";s:3:\"138\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:137;a:13:{s:2:\"id\";s:3:\"137\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:136;a:13:{s:2:\"id\";s:3:\"136\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:135;a:13:{s:2:\"id\";s:3:\"135\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:134;a:13:{s:2:\"id\";s:3:\"134\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:133;a:13:{s:2:\"id\";s:3:\"133\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:132;a:13:{s:2:\"id\";s:3:\"132\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:131;a:13:{s:2:\"id\";s:3:\"131\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:130;a:13:{s:2:\"id\";s:3:\"130\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:129;a:13:{s:2:\"id\";s:3:\"129\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:128;a:13:{s:2:\"id\";s:3:\"128\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:127;a:13:{s:2:\"id\";s:3:\"127\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:126;a:13:{s:2:\"id\";s:3:\"126\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:125;a:13:{s:2:\"id\";s:3:\"125\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:124;a:13:{s:2:\"id\";s:3:\"124\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:123;a:13:{s:2:\"id\";s:3:\"123\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:122;a:13:{s:2:\"id\";s:3:\"122\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:121;a:13:{s:2:\"id\";s:3:\"121\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:120;a:13:{s:2:\"id\";s:3:\"120\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:119;a:13:{s:2:\"id\";s:3:\"119\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:118;a:13:{s:2:\"id\";s:3:\"118\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:117;a:13:{s:2:\"id\";s:3:\"117\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:116;a:13:{s:2:\"id\";s:3:\"116\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:115;a:13:{s:2:\"id\";s:3:\"115\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:114;a:13:{s:2:\"id\";s:3:\"114\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:113;a:13:{s:2:\"id\";s:3:\"113\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:112;a:13:{s:2:\"id\";s:3:\"112\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:111;a:13:{s:2:\"id\";s:3:\"111\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:110;a:13:{s:2:\"id\";s:3:\"110\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:109;a:13:{s:2:\"id\";s:3:\"109\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:108;a:13:{s:2:\"id\";s:3:\"108\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:107;a:13:{s:2:\"id\";s:3:\"107\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:106;a:13:{s:2:\"id\";s:3:\"106\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:105;a:13:{s:2:\"id\";s:3:\"105\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:104;a:13:{s:2:\"id\";s:3:\"104\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:103;a:13:{s:2:\"id\";s:3:\"103\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:102;a:13:{s:2:\"id\";s:3:\"102\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:101;a:13:{s:2:\"id\";s:3:\"101\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:100;a:13:{s:2:\"id\";s:3:\"100\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:99;a:13:{s:2:\"id\";s:2:\"99\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:98;a:13:{s:2:\"id\";s:2:\"98\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:97;a:13:{s:2:\"id\";s:2:\"97\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:96;a:13:{s:2:\"id\";s:2:\"96\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:95;a:13:{s:2:\"id\";s:2:\"95\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:94;a:13:{s:2:\"id\";s:2:\"94\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:93;a:13:{s:2:\"id\";s:2:\"93\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:92;a:13:{s:2:\"id\";s:2:\"92\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:91;a:13:{s:2:\"id\";s:2:\"91\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:90;a:13:{s:2:\"id\";s:2:\"90\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:89;a:13:{s:2:\"id\";s:2:\"89\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:88;a:13:{s:2:\"id\";s:2:\"88\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:87;a:13:{s:2:\"id\";s:2:\"87\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:86;a:13:{s:2:\"id\";s:2:\"86\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:85;a:13:{s:2:\"id\";s:2:\"85\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:84;a:13:{s:2:\"id\";s:2:\"84\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:83;a:13:{s:2:\"id\";s:2:\"83\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:82;a:13:{s:2:\"id\";s:2:\"82\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:81;a:13:{s:2:\"id\";s:2:\"81\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:80;a:13:{s:2:\"id\";s:2:\"80\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:79;a:13:{s:2:\"id\";s:2:\"79\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:78;a:13:{s:2:\"id\";s:2:\"78\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:77;a:13:{s:2:\"id\";s:2:\"77\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:76;a:13:{s:2:\"id\";s:2:\"76\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:75;a:13:{s:2:\"id\";s:2:\"75\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:74;a:13:{s:2:\"id\";s:2:\"74\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:73;a:13:{s:2:\"id\";s:2:\"73\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:72;a:13:{s:2:\"id\";s:2:\"72\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:71;a:13:{s:2:\"id\";s:2:\"71\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:70;a:13:{s:2:\"id\";s:2:\"70\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:69;a:13:{s:2:\"id\";s:2:\"69\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:68;a:13:{s:2:\"id\";s:2:\"68\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:67;a:13:{s:2:\"id\";s:2:\"67\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:66;a:13:{s:2:\"id\";s:2:\"66\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:65;a:13:{s:2:\"id\";s:2:\"65\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:64;a:13:{s:2:\"id\";s:2:\"64\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:63;a:13:{s:2:\"id\";s:2:\"63\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:62;a:13:{s:2:\"id\";s:2:\"62\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:49;a:13:{s:2:\"id\";s:2:\"49\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:48;a:13:{s:2:\"id\";s:2:\"48\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:47;a:13:{s:2:\"id\";s:2:\"47\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:46;a:13:{s:2:\"id\";s:2:\"46\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:45;a:13:{s:2:\"id\";s:2:\"45\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:44;a:13:{s:2:\"id\";s:2:\"44\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:43;a:13:{s:2:\"id\";s:2:\"43\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:42;a:13:{s:2:\"id\";s:2:\"42\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:41;a:13:{s:2:\"id\";s:2:\"41\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:40;a:13:{s:2:\"id\";s:2:\"40\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:39;a:13:{s:2:\"id\";s:2:\"39\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:38;a:13:{s:2:\"id\";s:2:\"38\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:37;a:13:{s:2:\"id\";s:2:\"37\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:36;a:13:{s:2:\"id\";s:2:\"36\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:35;a:13:{s:2:\"id\";s:2:\"35\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:34;a:13:{s:2:\"id\";s:2:\"34\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:33;a:13:{s:2:\"id\";s:2:\"33\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:32;a:13:{s:2:\"id\";s:2:\"32\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:31;a:13:{s:2:\"id\";s:2:\"31\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:30;a:13:{s:2:\"id\";s:2:\"30\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:29;a:13:{s:2:\"id\";s:2:\"29\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:28;a:13:{s:2:\"id\";s:2:\"28\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:27;a:13:{s:2:\"id\";s:2:\"27\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:26;a:13:{s:2:\"id\";s:2:\"26\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:25;a:13:{s:2:\"id\";s:2:\"25\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:24;a:13:{s:2:\"id\";s:2:\"24\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:23;a:13:{s:2:\"id\";s:2:\"23\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:22;a:13:{s:2:\"id\";s:2:\"22\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:21;a:13:{s:2:\"id\";s:2:\"21\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:20;a:13:{s:2:\"id\";s:2:\"20\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:11;a:13:{s:2:\"id\";s:2:\"11\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:10;a:13:{s:2:\"id\";s:2:\"10\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:9;a:13:{s:2:\"id\";s:1:\"9\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:8;a:13:{s:2:\"id\";s:1:\"8\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}","no");

INSERT IGNORE INTO `wp_options` VALUES 
("801","rs_tables_created","1","yes"),
("803","revslider-global-settings","{\"version\":\"6.0.0\",\"permission\":\"admin\",\"includeids\":\"\",\"script\":{\"footer\":false,\"defer\":false,\"full\":false},\"fonturl\":\"\",\"size\":{\"desktop\":1240,\"notebook\":1024,\"tablet\":768,\"mobile\":480}}","yes"),
("804","amp-options","a:17:{s:13:\"theme_support\";s:6:\"reader\";s:20:\"supported_post_types\";a:1:{i:0;s:4:\"post\";}s:9:\"analytics\";a:0:{}s:23:\"all_templates_supported\";b:1;s:19:\"supported_templates\";a:1:{i:0;s:11:\"is_singular\";}s:7:\"version\";s:5:\"2.5.5\";s:12:\"reader_theme\";s:6:\"legacy\";s:20:\"paired_url_structure\";s:9:\"query_var\";s:17:\"plugin_configured\";b:1;s:24:\"delete_data_at_uninstall\";b:1;s:18:\"use_native_img_tag\";b:0;s:15:\"mobile_redirect\";b:1;s:17:\"late_defined_slug\";N;s:18:\"suppressed_plugins\";a:0:{}s:18:\"sandboxing_enabled\";b:0;s:16:\"sandboxing_level\";i:1;s:21:\"primary_theme_support\";N;}","off"),
("805","revslider_update_version","6.1.4","yes"),
("806","widget_rev-slider-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("811","heartbeat_control_settings","a:1:{s:5:\"rules\";a:1:{i:0;a:3:{s:26:\"heartbeat_control_behavior\";s:7:\"disable\";s:26:\"heartbeat_control_location\";a:3:{i:0;s:5:\"admin\";i:1;s:8:\"frontend\";i:2;s:18:\"/wp-admin/post.php\";}s:27:\"heartbeat_control_frequency\";s:2:\"15\";}}}","yes"),
("812","heartbeat_control_version","1.2.5","yes"),
("814","revslider-valid-notice","false","yes"),
("815","jnews_author_author_override","a:1:{i:1;s:1:\"0\";}","yes"),
("816","jnews_author_page_layout","a:1:{i:1;s:13:\"right-sidebar\";}","yes"),
("817","jnews_author_tag_template","a:1:{i:1;s:1:\"0\";}","yes"),
("818","jnews_author_number_post","a:1:{i:1;s:2:\"10\";}","yes"),
("819","jnews_author_sidebar","a:1:{i:1;s:15:\"default-sidebar\";}","yes"),
("820","jnews_author_second_sidebar","a:1:{i:1;s:15:\"default-sidebar\";}","yes"),
("821","jnews_author_sticky_sidebar","a:1:{i:1;s:1:\"1\";}","yes"),
("822","jnews_author_content_layout","a:1:{i:1;s:1:\"3\";}","yes"),
("823","jnews_author_content_boxed","a:1:{i:1;s:1:\"0\";}","yes"),
("824","jnews_author_content_boxed_shadow","a:1:{i:1;s:1:\"0\";}","yes"),
("825","jnews_author_content_box_shadow","a:1:{i:1;s:1:\"0\";}","yes"),
("826","jnews_author_content_excerpt","a:1:{i:1;s:2:\"20\";}","yes"),
("827","jnews_author_content_date","a:1:{i:1;s:7:\"default\";}","yes"),
("828","jnews_author_content_date_custom","a:1:{i:1;s:5:\"Y/m/d\";}","yes"),
("829","jnews_author_content_pagination","a:1:{i:1;s:5:\"nav_1\";}","yes"),
("830","jnews_author_content_pagination_limit","a:1:{i:1;s:1:\"0\";}","yes"),
("831","jnews_author_content_pagination_align","a:1:{i:1;s:6:\"center\";}","yes"),
("832","jnews_author_content_pagination_text","a:1:{i:1;s:1:\"0\";}","yes"),
("833","jnews_author_content_pagination_page","a:1:{i:1;s:1:\"0\";}","yes"),
("840","ztjalali_options","{\"force_timezone\":false,\"change_date_to_jalali\":true,\"change_jdate_number_to_persian\":true,\"change_url_date_to_jalali\":false,\"afghan_month_name\":false,\"disallow_month_short_name\":true,\"change_title_number_to_persian\":true,\"change_content_number_to_persian\":true,\"change_excerpt_number_to_persian\":true,\"change_comment_number_to_persian\":true,\"change_commentcount_number_to_persian\":false,\"change_category_number_to_persian\":false,\"change_point_to_persian\":true,\"change_arabic_to_persian\":false,\"change_archive_title\":true,\"save_changes_in_db\":false,\"ztjalali_admin_style\":false,\"persian_planet\":true}","yes"),
("841","ztjalali_version","5.0.1","yes"),
("842","ztjalali_do_activation","1","yes"),
("843","widget_ztjalali_archive","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("844","widget_ztjalali_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("846","jeg-style-hash","2l8SFsg7qk","yes"),
("849","recovery_keys","a:0:{}","off"),
("928","revslider-connection","1","yes"),
("929","revslider-latest-version","6.1.8","yes"),
("930","revslider-stable-version","4.2","yes"),
("931","revslider-notices","a:1:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"6.2.0\";s:4:\"text\";s:1246:\"<rs-module-wrap id=\"rev_slider_2516_1_wrapper\" data-alias=\"surveybanner\" data-source=\"gallery\" style=\"background:transparent;padding:0;float:left;margin-left:0;margin-right:0;margin-top:30px;max-width:1400px\"><rs-module id=\"rev_slider_2516_1\" style=\"display:none;\" data-version=\"6.2.0\"><rs-slides><rs-slide data-key=\"rs-5208\" data-title=\"Slide\" data-anim=\"ei:d;eo:d;s:1000;r:0;t:fade;sl:0;\"><img src=\"//updates.themepunch-ext-a.tools/banners/rs60/transparent.png\" title=\"pat\" class=\"rev-slidebg\" data-no-retina><!----><a id=\"slider-2516-slide-5208-layer-0\" class=\"rs-layer\" href=\"https://forms.gle/TQkCC2dVDZc95Fuk9\" target=\"_blank\" rel=\"nofollow\" data-type=\"image\" data-xy=\"x:c;y:c;\" data-text=\"w:normal;\" data-dim=\"w:1400px;h:250px;\" data-basealign=\"slide\" data-rsp_o=\"off\" data-rsp_bd=\"off\" data-frame_0=\"sX:0.8;sY:0.8;\" data-frame_1=\"e:power4.out;sp:1000;\" data-frame_999=\"o:0;st:w;sR:8550;\" style=\"z-index:5;\"><img src=\"//updates.themepunch-ext-a.tools/banners/rs60/surveybanner620.jpg\" width=\"1400\" height=\"250\" data-no-retina></a><!----></rs-slide></rs-slides><rs-progress class=\"rs-bottom\" style=\"visibility: hidden !important;\"></rs-progress></rs-module></rs-module-wrap><div style=\"clear:both;display:block;width:100%;height:0px\"></div>\";s:6:\"script\";s:316:\"{\"sliderType\":\"hero\",\"visibilityLevels\":\"1800,1500,778,480\",\"gridwidth\":1415,\"gridheight\":250,\"minHeight\":\"250px\",\"keepBPHeight\":true,\"editorheight\":\"250,768,960,720\",\"responsiveLevels\":\"1800,1500,778,480\",\"disableProgressBar\":\"on\",\"navigation\":{\"onHoverStop\":false},\"fallbacks\":{\"allowHTML5AutoPlayOnAndroid\":true}}\";s:4:\"code\";s:10:\"TPRS620-04\";s:4:\"type\";s:1:\"3\";s:4:\"icon\";s:0:\"\";s:10:\"additional\";a:0:{}}}","yes"),
("932","revslider-dashboard","a:0:{}","yes"),
("933","revslider-addons","O:8:\"stdClass\":27:{s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"2.1.0\";s:10:\"background\";s:71:\"//updates.themepunch-ext-a.tools/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-a.tools/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"2.1.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch-ext-a.tools/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"2.1.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch-ext-a.tools/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch-ext-a.tools/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch-ext-a.tools/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch-ext-a.tools/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch-ext-a.tools/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:23:\"Display images in 360°\";s:9:\"available\";s:5:\"2.1.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch-ext-a.tools/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch-ext-a.tools/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"2.1.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch-ext-a.tools/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"2.1.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"2.1.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}}","yes"),
("958","woocommerce_store_address","","yes"),
("959","woocommerce_store_address_2","","yes"),
("960","woocommerce_store_city","","yes"),
("961","woocommerce_default_country","IR:THR","yes"),
("962","woocommerce_store_postcode","","yes"),
("963","woocommerce_allowed_countries","all","yes"),
("964","woocommerce_all_except_countries","a:0:{}","yes"),
("965","woocommerce_specific_allowed_countries","a:0:{}","yes"),
("966","woocommerce_ship_to_countries","","yes"),
("967","woocommerce_specific_ship_to_countries","a:0:{}","yes"),
("968","woocommerce_default_customer_address","geolocation","yes"),
("969","woocommerce_calc_taxes","no","yes"),
("970","woocommerce_enable_coupons","yes","yes"),
("971","woocommerce_calc_discounts_sequentially","no","no"),
("972","woocommerce_currency","IRT","yes"),
("973","woocommerce_currency_pos","right_space","yes"),
("974","woocommerce_price_thousand_sep",",","yes"),
("975","woocommerce_price_decimal_sep",".","yes"),
("976","woocommerce_price_num_decimals","0","yes"),
("977","woocommerce_shop_page_id","313","yes"),
("978","woocommerce_cart_redirect_after_add","no","yes"),
("979","woocommerce_enable_ajax_add_to_cart","yes","yes"),
("980","woocommerce_placeholder_image","293","yes"),
("981","woocommerce_weight_unit","kg","yes"),
("982","woocommerce_dimension_unit","cm","yes"),
("983","woocommerce_enable_reviews","yes","yes"),
("984","woocommerce_review_rating_verification_label","yes","no"),
("985","woocommerce_review_rating_verification_required","no","no"),
("986","woocommerce_enable_review_rating","yes","yes"),
("987","woocommerce_review_rating_required","yes","no"),
("988","woocommerce_manage_stock","yes","yes"),
("989","woocommerce_hold_stock_minutes","60","no"),
("990","woocommerce_notify_low_stock","yes","no"),
("991","woocommerce_notify_no_stock","yes","no"),
("992","woocommerce_stock_email_recipient","mehdijabin@gmail.com","no"),
("993","woocommerce_notify_low_stock_amount","2","no"),
("994","woocommerce_notify_no_stock_amount","0","yes"),
("995","woocommerce_hide_out_of_stock_items","no","yes"),
("996","woocommerce_stock_format","","yes"),
("997","woocommerce_file_download_method","force","no"),
("998","woocommerce_downloads_require_login","no","no"),
("999","woocommerce_downloads_grant_access_after_payment","yes","no"),
("1000","woocommerce_prices_include_tax","no","yes"),
("1001","woocommerce_tax_based_on","shipping","yes"),
("1002","woocommerce_shipping_tax_class","inherit","yes"),
("1003","woocommerce_tax_round_at_subtotal","no","yes"),
("1005","woocommerce_tax_display_shop","excl","yes"),
("1006","woocommerce_tax_display_cart","excl","yes"),
("1007","woocommerce_price_display_suffix","","yes"),
("1008","woocommerce_tax_total_display","itemized","no"),
("1009","woocommerce_enable_shipping_calc","yes","no"),
("1010","woocommerce_shipping_cost_requires_address","no","yes"),
("1011","woocommerce_ship_to_destination","billing","no"),
("1012","woocommerce_shipping_debug_mode","no","yes"),
("1013","woocommerce_enable_guest_checkout","yes","no"),
("1014","woocommerce_enable_checkout_login_reminder","no","no"),
("1015","woocommerce_enable_signup_and_login_from_checkout","no","no"),
("1016","woocommerce_enable_myaccount_registration","no","no"),
("1017","woocommerce_registration_generate_username","yes","no"),
("1018","woocommerce_registration_generate_password","yes","no"),
("1019","woocommerce_erasure_request_removes_order_data","no","no"),
("1020","woocommerce_erasure_request_removes_download_data","no","no"),
("1021","woocommerce_allow_bulk_remove_personal_data","no","no"),
("1022","woocommerce_registration_privacy_policy_text","اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.","yes"),
("1023","woocommerce_checkout_privacy_policy_text","اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.","yes"),
("1024","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("1025","woocommerce_trash_pending_orders","","no"),
("1026","woocommerce_trash_failed_orders","","no"),
("1027","woocommerce_trash_cancelled_orders","","no"),
("1028","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("1029","woocommerce_email_from_name","قالب جی نیوز","no"),
("1030","woocommerce_email_from_address","mehdijabin@gmail.com","no"),
("1031","woocommerce_email_header_image","","no"),
("1032","woocommerce_email_footer_text","{site_title}<br/>Built with <a href=\"https://woocommerce.com/\">WooCommerce</a>","no"),
("1033","woocommerce_email_base_color","#96588a","no"),
("1034","woocommerce_email_background_color","#f7f7f7","no"),
("1035","woocommerce_email_body_background_color","#ffffff","no"),
("1036","woocommerce_email_text_color","#3c3c3c","no"),
("1037","woocommerce_cart_page_id","314","yes"),
("1038","woocommerce_checkout_page_id","315","yes"),
("1039","woocommerce_myaccount_page_id","316","yes"),
("1040","woocommerce_terms_page_id","","no"),
("1041","woocommerce_force_ssl_checkout","no","yes"),
("1042","woocommerce_unforce_ssl_checkout","no","yes"),
("1043","woocommerce_checkout_pay_endpoint","order-pay","yes"),
("1044","woocommerce_checkout_order_received_endpoint","order-received","yes"),
("1045","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes"),
("1046","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes"),
("1047","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes"),
("1048","woocommerce_myaccount_orders_endpoint","orders","yes"),
("1049","woocommerce_myaccount_view_order_endpoint","view-order","yes"),
("1050","woocommerce_myaccount_downloads_endpoint","downloads","yes"),
("1051","woocommerce_myaccount_edit_account_endpoint","edit-account","yes"),
("1052","woocommerce_myaccount_edit_address_endpoint","edit-address","yes"),
("1053","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes"),
("1054","woocommerce_myaccount_lost_password_endpoint","lost-password","yes"),
("1055","woocommerce_logout_endpoint","customer-logout","yes"),
("1056","woocommerce_api_enabled","no","yes"),
("1057","woocommerce_allow_tracking","no","no"),
("1058","woocommerce_show_marketplace_suggestions","no","no"),
("1059","woocommerce_single_image_width","600","yes"),
("1060","woocommerce_thumbnail_image_width","300","yes"),
("1061","woocommerce_checkout_highlight_required_fields","yes","yes"),
("1062","woocommerce_demo_store","no","no"),
("1063","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}","yes"),
("1064","current_theme_supports_woocommerce","yes","yes"),
("1065","woocommerce_queue_flush_rewrite_rules","no","yes"),
("1068","default_product_cat","42","yes"),
("1073","woocommerce_admin_notices","a:2:{i:0;s:6:\"update\";i:2;s:19:\"maxmind_license_key\";}","yes"),
("1075","widget_woocommerce_widget_cart","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1076","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1077","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1078","widget_woocommerce_price_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1079","widget_woocommerce_product_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1080","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1081","widget_woocommerce_product_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1082","widget_woocommerce_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1083","widget_woocommerce_recently_viewed_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1084","widget_woocommerce_top_rated_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1085","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1086","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("1093","woocommerce_meta_box_errors","a:0:{}","yes"),
("1298","product_cat_children","a:0:{}","yes"),
("2144","rs-templates-new","","no"),
("2145","rs-templates","a:3:{s:4:\"hash\";s:32:\"b75789b4e8007da4a017960ffb5efd3c\";s:6:\"slider\";a:442:{i:0;a:22:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:22:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:22:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:22:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:22:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:22:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:413:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:22:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:22:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:22:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:22:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:22:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:22:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:22:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:22:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:22:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:22:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:22:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:22:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:22:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:22:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:22:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:22:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:22:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:22:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:22:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:22:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:22:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:22:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:22:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:22:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:22:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:22:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:22:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:22:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:22:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:22:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:22:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:22:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:22:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:22:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:495:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:22:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:22:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:22:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:22:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:22:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:22:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:22:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:22:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:22:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:22:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:22:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:22:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:22:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:22:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:22:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:22:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:22:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:22:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:22:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:22:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:22:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:22:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:22:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:22:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:22:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:22:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:22:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:25:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:25:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:25:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:25:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:25:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:25:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:25:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:25:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:25:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:25:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:25:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:25:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:25:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:25:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:25:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:25:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:22:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:22:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:22:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:22:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:25:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:25:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:25:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:25:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:25:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:25:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:25:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:25:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:22:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:22:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:25:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:25:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:25:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:25:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:25:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:22:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:22:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:22:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:25:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:25:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:25:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:25:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:22:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:22:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:25:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:25:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:25:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:25:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:25:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:25:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:25:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:25:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:25:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.co